VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form frmAcquisizione 
   BorderStyle     =   1  'Fixed Single
   Caption         =   " Acquisizione dei segnali"
   ClientHeight    =   4065
   ClientLeft      =   3795
   ClientTop       =   1635
   ClientWidth     =   6750
   Icon            =   "frmAcquisizione.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MDIChild        =   -1  'True
   ScaleHeight     =   4065
   ScaleWidth      =   6750
   Begin VB.Timer tmrVolumeSld 
      Enabled         =   0   'False
      Interval        =   10000
      Left            =   3720
      Top             =   2040
   End
   Begin VB.Frame fraLineeWi 
      Caption         =   "Canale di acquisi&zione"
      Height          =   3060
      Left            =   3720
      TabIndex        =   10
      Top             =   270
      Width           =   2895
      Begin VB.PictureBox picCont 
         Height          =   2415
         Left            =   360
         ScaleHeight     =   2355
         ScaleWidth      =   2355
         TabIndex        =   33
         TabStop         =   0   'False
         Top             =   300
         Width           =   2415
         Begin VB.HScrollBar HScroll1 
            Height          =   255
            Left            =   120
            TabIndex        =   15
            Top             =   2040
            Visible         =   0   'False
            Width           =   1815
         End
         Begin VB.VScrollBar VScroll1 
            Height          =   1935
            Left            =   2040
            TabIndex        =   14
            Top             =   60
            Visible         =   0   'False
            Width           =   255
         End
         Begin VB.PictureBox picLineeWi 
            BorderStyle     =   0  'None
            Height          =   915
            Left            =   60
            ScaleHeight     =   915
            ScaleWidth      =   1935
            TabIndex        =   34
            TabStop         =   0   'False
            Top             =   60
            Width           =   1935
            Begin VB.CheckBox chkLineaSrcWi 
               Caption         =   "chkCanaleSrc"
               Height          =   330
               Index           =   0
               Left            =   120
               TabIndex        =   13
               Top             =   480
               Width           =   2400
            End
            Begin VB.CheckBox chkLineaDstWi 
               Caption         =   "chkCanaleDest"
               Height          =   330
               Left            =   120
               TabIndex        =   12
               Top             =   120
               Width           =   2400
            End
            Begin VB.Line zLine2 
               BorderColor     =   &H80000010&
               X1              =   0
               X2              =   2400
               Y1              =   450
               Y2              =   450
            End
         End
      End
      Begin MSComctlLib.Slider sldVolumeWi 
         Height          =   2535
         Left            =   60
         TabIndex        =   11
         Top             =   240
         Visible         =   0   'False
         Width           =   210
         _ExtentX        =   370
         _ExtentY        =   4471
         _Version        =   393216
         Orientation     =   1
         LargeChange     =   10
         Max             =   100
         SelStart        =   50
         TickFrequency   =   10
         Value           =   50
         TextPosition    =   1
      End
      Begin VB.Shape zShape2 
         BorderColor     =   &H80000010&
         Height          =   2295
         Left            =   90
         Top             =   360
         Width           =   165
      End
      Begin VB.Label lblVolumeWi 
         BackStyle       =   0  'Transparent
         Caption         =   " Volume"
         BeginProperty Font 
            Name            =   "Terminal"
            Size            =   6
            Charset         =   255
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         Left            =   120
         TabIndex        =   35
         Top             =   2805
         Visible         =   0   'False
         Width           =   2535
      End
   End
   Begin VB.CommandButton cmdEsci 
      Caption         =   "&Esci"
      Height          =   285
      Left            =   2910
      TabIndex        =   18
      Top             =   3600
      Width           =   675
   End
   Begin VB.Frame fraStrumenti 
      Caption         =   "Strumenti:"
      Height          =   675
      Left            =   120
      TabIndex        =   23
      Top             =   2640
      Width           =   3465
      Begin VB.CheckBox chkAnalizzatoreSpettro 
         Caption         =   "&Analizzatore di Spettro"
         Height          =   255
         Left            =   180
         TabIndex        =   8
         Top             =   300
         Width           =   1875
      End
      Begin VB.CheckBox chkOscilloscopio 
         Caption         =   "&Oscilloscopio"
         Height          =   255
         Left            =   2160
         TabIndex        =   9
         ToolTipText     =   " ""Click"" destro per Misuratore di Livelli "
         Top             =   300
         Width           =   1245
      End
      Begin VB.Label lblLivelliSuono 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         Caption         =   "| |"
         BeginProperty Font 
            Name            =   "Small Fonts"
            Size            =   6.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00FF0000&
         Height          =   240
         Left            =   3105
         TabIndex        =   31
         Top             =   0
         Visible         =   0   'False
         Width           =   240
      End
   End
   Begin VB.Frame fraParametri 
      Caption         =   "Parametri dell' acquisizione:"
      Height          =   1695
      Left            =   120
      TabIndex        =   19
      Top             =   840
      Width           =   3465
      Begin VB.TextBox txtNBuff 
         Height          =   315
         Left            =   180
         TabIndex        =   5
         ToolTipText     =   " Invio per confermare "
         Top             =   1200
         Width           =   795
      End
      Begin VB.ComboBox cboLunghCampionamento 
         Height          =   315
         Left            =   1260
         Style           =   2  'Dropdown List
         TabIndex        =   7
         Top             =   1200
         Width           =   1215
      End
      Begin VB.ComboBox cboFsWi 
         Height          =   315
         Left            =   180
         Style           =   2  'Dropdown List
         TabIndex        =   3
         Top             =   540
         Width           =   2295
      End
      Begin VB.Label zLabel09 
         Caption         =   "N &buffers:"
         Height          =   255
         Left            =   180
         TabIndex        =   4
         Top             =   960
         Width           =   795
      End
      Begin VB.Label zLabel05 
         BackStyle       =   0  'Transparent
         Caption         =   "&Dim. dei buffers:"
         Height          =   255
         Left            =   1260
         TabIndex        =   6
         Top             =   960
         Width           =   1215
      End
      Begin VB.Label zLabel04 
         BackStyle       =   0  'Transparent
         Caption         =   "campioni"
         Height          =   255
         Left            =   2520
         TabIndex        =   21
         Top             =   1245
         Width           =   735
      End
      Begin VB.Label zLabel03 
         BackStyle       =   0  'Transparent
         Caption         =   "Hz"
         Height          =   255
         Left            =   2520
         TabIndex        =   20
         Top             =   585
         Width           =   375
      End
      Begin VB.Label zLabel02 
         BackStyle       =   0  'Transparent
         Caption         =   "F&requenza di campionamento:"
         Height          =   255
         Left            =   180
         TabIndex        =   2
         Top             =   300
         Width           =   2475
      End
   End
   Begin VB.CommandButton cmdTerminaAcquisizione 
      Caption         =   "&Stop"
      Enabled         =   0   'False
      Height          =   285
      Left            =   1800
      Style           =   1  'Graphical
      TabIndex        =   17
      Top             =   3600
      Width           =   804
   End
   Begin VB.CommandButton cmdInizioAcquisizione 
      Caption         =   "Inizio Mi&sure"
      Height          =   285
      Left            =   120
      TabIndex        =   16
      Top             =   3600
      Width           =   1590
   End
   Begin VB.ComboBox cboMixersWi 
      Height          =   315
      Left            =   120
      Style           =   2  'Dropdown List
      TabIndex        =   1
      Top             =   360
      Width           =   3465
   End
   Begin VB.Label lblNbDone 
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   150
      Left            =   6210
      TabIndex        =   32
      Top             =   3900
      Width           =   300
   End
   Begin VB.Label lblTempoElabMedio 
      BackStyle       =   0  'Transparent
      Height          =   195
      Left            =   4680
      TabIndex        =   30
      Top             =   3870
      Width           =   675
   End
   Begin VB.Label zLabel10 
      BackStyle       =   0  'Transparent
      Caption         =   "t Elab:"
      Height          =   255
      Left            =   4680
      TabIndex        =   29
      Top             =   3360
      Width           =   675
   End
   Begin VB.Label zLabel08 
      BackStyle       =   0  'Transparent
      Caption         =   "Ib:"
      Height          =   255
      Left            =   6180
      TabIndex        =   28
      Top             =   3360
      Width           =   315
   End
   Begin VB.Label lblIb 
      BorderStyle     =   1  'Fixed Single
      Height          =   285
      Left            =   6180
      TabIndex        =   27
      Top             =   3600
      Width           =   375
   End
   Begin VB.Label lblTempoU 
      BackStyle       =   0  'Transparent
      Caption         =   "ms"
      Height          =   255
      Left            =   5430
      TabIndex        =   26
      Top             =   3630
      Width           =   315
   End
   Begin VB.Label lblTempoElab 
      BorderStyle     =   1  'Fixed Single
      Height          =   285
      Left            =   4680
      TabIndex        =   25
      Top             =   3600
      Width           =   675
   End
   Begin VB.Label zLabel06 
      BackStyle       =   0  'Transparent
      Caption         =   "t Buff: "
      Height          =   255
      Left            =   3900
      TabIndex        =   24
      Top             =   3360
      Width           =   615
   End
   Begin VB.Label lblTempoBuff 
      BorderStyle     =   1  'Fixed Single
      Height          =   285
      Left            =   3900
      TabIndex        =   22
      Top             =   3600
      Width           =   675
   End
   Begin VB.Label lblSchedaAudio 
      BackStyle       =   0  'Transparent
      Caption         =   "Sc&heda Audio:"
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   1815
   End
End
Attribute VB_Name = "frmAcquisizione"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'=======================================================================================
' Descrizione.....: Acquisisce i segnali provenienti dalla scheda audio
'                   e li invia agli strumenti di misura.
' Nome dei Files..: frmAcquisizione.frm, frmAcquisizione.frx,
'                   frmCalibrazione.frm, frmCalibrazione.frx,
'                   frmASpettro.frm, frmASpettro.frx,
'                   frmOScopio,frm, frmOScopio,frx,
'                   frmLivelli,frm, frmLivelli,frx,
'                   modFlexPB.bas, modUtilita.bas,
'                   modMixerControl.bas.
' Data............: 15/08/2003 (Ver. 1.0).
' Aggiornamento...: 22/08/2005 (Ver. 2.0, acquisizione con NBuff buffers).
' Revisione.......: 19/11/2007 (Ver. 2.0.r).
' Revisione.......: 16/01/2010 (Ver. 3.0).
' Aggiornamento...: 17/02/2010 (Ver. 3.1, aggiunto il riallineamento dei buffers).
' Versione........: 3.1 a 32 Bits.
' Sistema.........: VB6 (SP5) sotto Windows XP (SP2).
' Scritto da......: F. Languasco 
' E-Mail..........: MC7061@mclink.it
' DownLoads a.....: http://www.flanguasco.org
'=======================================================================================
'
Option Explicit
'
Dim NBuff&          ' N di buffers per l' acquisizione.
Dim NcBufferSize&   ' Dimensione dei vettori buffer [campioni].
'
Dim Titolo$         ' Titolo degli strumenti.
'
Dim TBuff&          ' Lunghezza totale dei buffers di acquisizione [ms].
'
Const BitsPerSample% = 16   ' Risoluzione del campionamento; in questa
                            ' versione e' sempre di 16 Bits.
Const NCanali& = 2          ' N di canali acquisiti dalla scheda audio;
                            ' in questa versione sono sempre 2.
'
Dim bFsWiOK As Boolean  ' Flag di frequenze di campionamento disponibili per WaveIn.
'
Dim IchSel&             ' Linea correntemente selezionata
                        ' per il controllo di volume.
Const IchDstSel& = -1   ' La linea correntemente selezionata
                        ' e' una "Destination line".
'
Const MaxVolume = 65535             ' Massimo valore di Volume.
Const TsldVolumeVisibile = 10000    ' Tempo di visibilita' del controllo Volume [ms].
'
Dim InData%()   ' Matrice dei dati da acquisire (Integer, per suono a 16 Bits) [DigVal].
Dim InDataC%()  ' Vettore dei dati da inviare agli strumenti [DigVal].
'
Dim phwi&                   ' handle del "waveform-audio input device".
Dim WaveInHdr() As WAVEHDR  ' Vettore dei "waveform-audio buffers".
Dim LenInHeaders&           ' = Len(WaveInHdr(1))
'
Dim bMeLoaded As Boolean            ' Flag di Form gia' caricato.
'
Dim bStatoScreenSaver As Boolean    ' Stato dello ScreenSaver prima dell' inizio
                                    ' delle misure.
'
'-- Variabili per prove e debug: -------------------------------------------------------
'
Dim Is1&, Is2&  ' Indici per i generatori di segnale di prova.
'
Dim NCicliAcq&  ' Variabili per il calcolo del tempo medio
Dim TElabSum&   ' di elaborazione.
'
'-- Dichiarazioni, costanti e tipi per API: --------------------------------------------
'
Private Declare Function GetTickCount Lib "kernel32" () As Long
Private Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)
'
Private uPeriod As Long ' Risoluzione del timer timeGetTime [ms].
Private Declare Function timeGetTime Lib "winmm.dll" () As Long
Private Declare Function timeBeginPeriod Lib "winmm.dll" (ByVal uPeriod As Long) As Long
Private Declare Function timeEndPeriod Lib "winmm.dll" (ByVal uPeriod As Long) As Long
Private Const TIMERR_BASE& = 96                     '  was 128, changed to match Win 31 Sonic
Private Const TIMERR_NOERROR& = 0                   '  no error
Private Const TIMERR_NOCANDO& = (TIMERR_BASE + 1)   '  request not completed
'
Private Type TIMECAPS
        wPeriodMin As Long
        wPeriodMax As Long
End Type
Private lpTimeCaps As TIMECAPS
Private Declare Function timeGetDevCaps Lib "winmm.dll" (lpTimeCaps As TIMECAPS, _
    ByVal uSize As Long) As Long
'
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" _
    (hpvDest As Any, hpvSource As Any, ByVal cbCopy As Long)
'
Private Const WAVE_FORMAT_PCM% = 1
'
Private Const WHDR_DONE& = &H1&             ' done bit
Private Const WHDR_PREPARED& = &H2          ' set if this header has been prepared
Private Const WHDR_BEGINLOOP& = &H4         ' loop start block
Private Const WHDR_ENDLOOP& = &H8           ' loop end block
Private Const WHDR_INQUEUE& = &H10          ' reserved for driver
Private Const WHDR_VALID& = &H1F            ' valid flags      / ;Internal /
'
Private Const MMSYSERR_NOERROR& = 0         ' no error
'
Private Type WAVEHDR
    lpData As Long
    dwBufferLength As Long
    dwBytesRecorded As Long
    dwUser As Long
    dwFlags As Long
    dwLoops As Long
    lpNext As Long  ' Reserved.
    Reserved As Long
End Type
'
Private Type WAVEFORMATEX
    wFormatTag As Integer
    nChannels As Integer
    nSamplesPerSec As Long
    nAvgBytesPerSec As Long
    nBlockAlign As Integer
    wBitsPerSample As Integer
    cbSize As Integer
End Type
'
Private Declare Function waveInOpen Lib "winmm" _
    (WaveDeviceInputHandle As Long, ByVal WhichDevice As Long, _
    ByVal WaveFormatExPointer As Long, ByVal CallBack As Long, _
    ByVal CallBackInstance As Long, ByVal Flags As Long) As Long
Private Declare Function waveInClose Lib "winmm" _
    (ByVal WaveDeviceInputHandle As Long) As Long
'
Private Declare Function waveInStart Lib "winmm" _
    (ByVal WaveDeviceInputHandle As Long) As Long
Private Declare Function waveInReset Lib "winmm" _
    (ByVal WaveDeviceInputHandle As Long) As Long
Private Declare Function waveInStop Lib "winmm" _
    (ByVal WaveDeviceInputHandle As Long) As Long
'
Private Declare Function waveInAddBuffer Lib "winmm" _
    (ByVal InputDeviceHandle As Long, ByVal WaveHdrPointer As Long, _
    ByVal WaveHdrStructSize As Long) As Long
Private Declare Function waveInPrepareHeader Lib "winmm" _
    (ByVal InputDeviceHandle As Long, ByVal WaveHdrPointer As Long, _
    ByVal WaveHdrStructSize As Long) As Long
Private Declare Function waveInUnprepareHeader Lib "winmm" _
    (ByVal InputDeviceHandle As Long, ByVal WaveHdrPointer As Long, _
    ByVal WaveHdrStructSize As Long) As Long
Private Sub ImpostaFsWi()
'
'
    Dim I&, NFs&, FsList&(), bFsOK As Boolean, M$
'
    NFs = CercaWaveInFs(MixerWi(MixerWiI), FsList(), NCanali, BitsPerSample)
    'If MixerWiI = 1 Then NFs = 0    ' Solo per prove.
'
    cboFsWi.Clear
    For I = 1 To NFs
        cboFsWi.AddItem Format$(FsList(I))
    Next I
'
    If (NFs = 0) Then
        bFsWiOK = False
        cboFsWi.BackColor = vbRed
'
        M$ = "La scheda audio selezionata non ha frequenze" & vbNewLine
        M$ = M$ & "di campionamento adatte a questa applicazione."
        MsgBox M$, vbCritical, " frmAcquisizione: ImpostaFsWi"
'
        cmdInizioAcquisizione.Enabled = False
        chkAnalizzatoreSpettro.Value = vbUnchecked
        chkAnalizzatoreSpettro.Enabled = False
        chkOscilloscopio.Value = vbUnchecked
        chkOscilloscopio.Enabled = False
'
    Else
        bFsWiOK = True
        cboFsWi.BackColor = vbWindowBackground
'
        ' Imposto, se esiste, l' Fs corrente:
        bFsOK = False
        For I = 1 To NFs
            If (cboFsWi.List(I - 1) = Format$(Fs)) Then
                bFsOK = True
                Exit For
            End If
        Next I

        If bFsOK Then
            cboFsWi.Text = Format$(Fs)
        Else
            cboFsWi.ListIndex = 0
        End If
'
        cmdInizioAcquisizione.Enabled = True
        chkAnalizzatoreSpettro.Enabled = True
        chkOscilloscopio.Enabled = True
    End If
'
'
'
End Sub
Private Sub cboFsWi_Click()
'
'
    Dim Mantissa$, Prefisso$
    Dim Mantissa1$, Prefisso1$, Mantissa2$, Prefisso2$
'
    Fs = CLng(cboFsWi.Text)
'
    ' Imposto una lunghezza di campionamento preferenziale:
    Select Case Fs
    Case 8000
        cboLunghCampionamento.Text = "1024"
    Case 11025, 16000
        cboLunghCampionamento.Text = "1024"
    Case 22050, 24000
        cboLunghCampionamento.Text = "2048"
    Case 32000
        cboLunghCampionamento.Text = "2048"
    Case 44100
        cboLunghCampionamento.Text = "4096"
'
    Case Else
        cboLunghCampionamento.Text = "4096"
    End Select
'
    If IsLoaded(frmCalibrazione) Then
        frmCalibrazione.Apri True
    End If
'
    If bAnalizzatoreSpettro And bFsWiOK Then
        frmASpettro.Apri Fs, NBuff, NcBufferSize, IIf(IsLoaded(frmASpettro), "", Titolo$)
    End If
'
    If bOscilloscopio And bFsWiOK Then
        frmOScopio.Apri Fs, NBuff, NcBufferSize, IIf(IsLoaded(frmOScopio), "", Titolo$)
    End If
'
    TBuff = 1000 * NcBufferSize / Fs   ' [ms].
    lblTempoBuff.Caption = Format$(TBuff, "#0.0")
'
    FormatPrf 1# / CDbl(Fs), Mantissa$, Prefisso$, "0.000000E+00"
    cboFsWi.ToolTipText = " T = " & Mantissa$ & " " & Prefisso$ & "s "
'
    FormatPrf NcBufferSize / Fs, Mantissa1$, Prefisso1$, "0.00E+00"
    FormatPrf NBuff * NcBufferSize / Fs, Mantissa2$, Prefisso2$, "0.00E+00"
    cboLunghCampionamento.ToolTipText = " Tb = " & Mantissa1$ & " " & Prefisso1$ & "s " _
                                      & " | " & " NTb = " & Mantissa2$ & " " & Prefisso2$ & "s "
'
'
'
End Sub
Private Sub cboMixersWi_Click()
'
'
    Dim I&, I1&, Volume&, X!, Y!, NomiLineeAttive$, M$
'
    On Error GoTo cboMixersWi_Click_ERR
'
    MixerWiI = cboMixersWi.ListIndex + 1
'
    ' Imposto le frequenze di campionamento ammesse per il WaveIn:
    Call ImpostaFsWi
'
    NomiLineeAttive$ = CercaNomiLineeAttive(MixerWi(MixerWiI), I1)
    If (NomiLineeAttive$ <> "") Then
        Titolo$ = cboMixersWi.Text & ": " & NomiLineeAttive$
    Else
        Titolo$ = cboMixersWi.Text
    End If
'
    If bMeLoaded And bFsWiOK Then
        If bAnalizzatoreSpettro Then
            ' Cambio il titolo dell' analizzatore di spettro:
            frmASpettro.Apri Fs, NBuff, NcBufferSize, Titolo$
        End If
        If bOscilloscopio Then
            ' Cambio il titolo dell' oscilloscopio:
            frmOScopio.Apri Fs, NBuff, NcBufferSize, Titolo$
        End If
        If bLivelliSuono Then
            ' Cambio il titolo del misuratore di livelli:
            frmLivelli.Apri Fs, NBuff, NcBufferSize, Titolo$
        End If
    End If
'
    If MixerWi(MixerWiI).bDstIsMUX Then
        fraLineeWi.Caption = "Linea di acquisi&zione  (MUX)"
    Else
        fraLineeWi.Caption = "Linee di acquisi&zione  (Mixer)"
    End If
'
'-- Destination line: ------------------------------------------------------------------
'
    'chkLineaDstWi.Caption = "&" & I & ":  " & MixerWi(MixerWiI).Dstline.Name
    'chkLineaDstWi.Caption = I & ":  " & MixerWi(MixerWiI).Dstline.Name
    chkLineaDstWi.Caption = MixerWi(MixerWiI).DstLine.Name
'
    If (0 <= MixerWi(MixerWiI).DstLine.Volume) Then
        Volume = 100 * MixerWi(MixerWiI).DstLine.Volume / MaxVolume
        sldVolumeWi.SmallChange = MixerWi(MixerWiI).DstLine.VolumeStep
        chkLineaDstWi.ToolTipText = " Volume = " & CLng(Volume) & " % "
    Else
        chkLineaDstWi.ToolTipText = " Volume control unavailable "
    End If
'
    chkLineaDstWi.Visible = True
    chkLineaDstWi.Value = Switch(Not MixerWi(MixerWiI).DstLine.bMuteOK, vbGrayed, _
                                 Not MixerWi(MixerWiI).DstLine.bNotMute, vbUnchecked, _
                                 MixerWi(MixerWiI).DstLine.bNotMute, vbChecked)
'
'-- Source lines: ----------------------------------------------------------------------
'
    ' Nascondo tutti i CheckBoxes che possono,
    ' precedentemente, essere stati creati.
    ' Non posso farne l' Unload perche' questa
    ' routine viene chiamata da un evento _Click
    ' di un ComboBox:
    For I = 0 To chkLineaSrcWi.Count - 1
        chkLineaSrcWi(I).Visible = False
    Next I
'
    picLineeWi.Height = 0
    For I = 0 To MixerWi(MixerWiI).NSrcLines - 1
        If ((chkLineaSrcWi.Count - 1) < I) Then
            Load chkLineaSrcWi(I)
            chkLineaSrcWi(I).Top = chkLineaSrcWi(I - 1).Top _
                                 + 24 * Screen.TwipsPerPixelY
            chkLineaSrcWi(I).TabIndex = chkLineaSrcWi(I - 1).TabIndex + 1
        End If
        picLineeWi.Height = chkLineaSrcWi(I).Top + 24 * Screen.TwipsPerPixelY
'
        'chkLineaSrcWi(I).Caption = "&" & I & ":  " & MixerWi(MixerWiI).srcLine(I).Name
        'chkLineaSrcWi(I).Caption = I & ":  " & MixerWi(MixerWiI).SrcLine(I).Name
        chkLineaSrcWi(I).Caption = MixerWi(MixerWiI).SrcLine(I).Name
'
        If (0 <= MixerWi(MixerWiI).SrcLine(I).Volume) Then
            Volume = 100 * MixerWi(MixerWiI).SrcLine(I).Volume / MaxVolume
            sldVolumeWi.SmallChange = MixerWi(MixerWiI).SrcLine(I).VolumeStep
            chkLineaSrcWi(I).ToolTipText = " Volume = " & CLng(Volume) & " % "
        Else
            chkLineaSrcWi(I).ToolTipText = " Volume control unavailable "
        End If
'
        chkLineaSrcWi(I).Visible = True
        chkLineaSrcWi(I).Value = Switch(Not MixerWi(MixerWiI).SrcLine(I).bMuteOK, vbGrayed, _
                                        Not MixerWi(MixerWiI).SrcLine(I).bNotMute, vbUnchecked, _
                                        MixerWi(MixerWiI).SrcLine(I).bNotMute, vbChecked)
    Next I
'
    If (-1 < I1) Then
        ' Centro verticalmente, per metterlo in posizione
        ' immediatamente visibile, il chkLineaSrcWi(I1):
        X = chkLineaSrcWi(I1).Left + 90
        Y = chkLineaSrcWi(I1).Top + chkLineaSrcWi(I1).Height / 2
'
        FlexPB_ImmOnXY picLineeWi, X, Y, , , , , True, False
    End If
'
'
cboMixersWi_Click_ERR:
    If (Err.Number <> 0) Then Err.Clear
'
'
'
End Sub
Private Sub chkAnalizzatoreSpettro_Click()
'
'
    bAnalizzatoreSpettro = (chkAnalizzatoreSpettro.Value = vbChecked)
'
    If bAnalizzatoreSpettro And bFsWiOK Then
        ' Apro l' analizzatore di spettro:
        frmASpettro.Apri Fs, NBuff, NcBufferSize, IIf(IsLoaded(frmASpettro), "", Titolo$)
    End If
'
'
'
End Sub
Private Sub chkLineaDstWi_Click()
'
'
    ' Reimposta, dopo una selezione con Alt + Index, il valore corretto:
    chkLineaDstWi.Value = Switch(Not MixerWi(MixerWiI).DstLine.bMuteOK, vbGrayed, _
                                 Not MixerWi(MixerWiI).DstLine.bNotMute, vbUnchecked, _
                                 MixerWi(MixerWiI).DstLine.bNotMute, vbChecked)
'
'
'
End Sub

Private Sub chkLineaDstWi_GotFocus()
'
'
    Dim X!, Y!
'
    X = chkLineaDstWi.Left + 90
    Y = chkLineaDstWi.Top + chkLineaDstWi.Height / 2
'
    ' Centro, verticalmente, il chkLineaDstWi:
    FlexPB_ImmOnXY picLineeWi, X, Y, , , , , True, False
'
'
'
End Sub
Private Sub chkLineaDstWi_KeyDown(KeyCode As Integer, Shift As Integer)
'
'
    If (KeyCode = vbKeySpace) Then
        chkLineaDstWi_MouseUp vbLeftButton, 0, 0, 0
'
    ElseIf (KeyCode = vbKeyV) Then
        chkLineaDstWi_MouseUp vbRightButton, 0, 0, 0
    End If
'
'
'
End Sub

Private Sub chkLineaDstWi_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
'
'
    If (Button = vbLeftButton) Then
        Call ImpostaAbilitazioneLinea(MixerWi(MixerWiI), , True)
'
        ' Aggiorno lo stato di chkLineaDstWi:
        chkLineaDstWi.Value = Switch(Not MixerWi(MixerWiI).DstLine.bMuteOK, vbGrayed, _
                                     Not MixerWi(MixerWiI).DstLine.bNotMute, vbUnchecked, _
                                     MixerWi(MixerWiI).DstLine.bNotMute, vbChecked)
'
    ElseIf (Button = vbRightButton) Then
        If (0 <= MixerWi(MixerWiI).DstLine.Volume) Then
            ' Il volume di questa linea e' modificabile:
            IchSel = IchDstSel
            sldVolumeWi.Value = MaxVolume - MixerWi(MixerWiI).DstLine.Volume
'
            sldVolumeWi.Visible = True
            sldVolumeWi.SetFocus
            tmrVolumeSld.Enabled = False: tmrVolumeSld.Enabled = True   ' Retrigger del timer.
'
            lblVolumeWi.Caption = " Volume: " _
                                & MixerWi(MixerWiI).DstLine.Name
            lblVolumeWi.Visible = True
        End If
    End If
'
'
'
End Sub

Private Sub chkLineaSrcWi_Click(Index As Integer)
'
'
    ' Reimposta, dopo una selezione con Alt + Index, il valore corretto:
    chkLineaSrcWi(Index).Value = Switch(Not MixerWi(MixerWiI).SrcLine(Index).bMuteOK, vbGrayed, _
                                        Not MixerWi(MixerWiI).SrcLine(Index).bNotMute, vbUnchecked, _
                                        MixerWi(MixerWiI).SrcLine(Index).bNotMute, vbChecked)
'
'
'
End Sub
Private Sub chkLineaSrcWi_GotFocus(Index As Integer)
'
'
    Dim X!, Y!
'
    X = chkLineaSrcWi(Index).Left + 90
    Y = chkLineaSrcWi(Index).Top + chkLineaSrcWi(Index).Height / 2
'
    ' Centro, verticalmente, il chkLineaSrcWi(Index):
    FlexPB_ImmOnXY picLineeWi, X, Y, , , , , True, False
'
'
'
End Sub
Private Sub chkLineaSrcWi_KeyDown(Index As Integer, KeyCode As Integer, Shift As Integer)
'
'
    If (KeyCode = vbKeySpace) Then
        chkLineaSrcWi_MouseUp Index, vbLeftButton, 0, 0, 0
'
    ElseIf (KeyCode = vbKeyV) Then
        chkLineaSrcWi_MouseUp Index, vbRightButton, 0, 0, 0
    End If
'
'
'
End Sub

Private Sub chkLineaSrcWi_MouseUp(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
'
'
    Dim I&, NomiLineeAttive$
'
    If (Button = vbLeftButton) Then
        Call ImpostaAbilitazioneLinea(MixerWi(MixerWiI), Index)
        NomiLineeAttive$ = CercaNomiLineeAttive(MixerWi(MixerWiI))
        If (NomiLineeAttive$ <> "") Then
            Titolo$ = cboMixersWi.Text & ": " & NomiLineeAttive$
        Else
            Titolo$ = cboMixersWi.Text
        End If
'
        If bMeLoaded And bFsWiOK Then
            If bAnalizzatoreSpettro Then
                ' Cambio il titolo dell' analizzatore di spettro:
                frmASpettro.Apri Fs, NBuff, NcBufferSize, Titolo$
            End If
            If bOscilloscopio Then
                ' Cambio il titolo dell' oscilloscopio:
                frmOScopio.Apri Fs, NBuff, NcBufferSize, Titolo$
            End If
            If bLivelliSuono Then
                ' Cambio il titolo del misuratore di livelli:
                frmLivelli.Apri Fs, NBuff, NcBufferSize, Titolo$
            End If
        End If
'
        ' Aggiorno lo stato dei chkLineaSrcWi():
        For I = 0 To MixerWi(MixerWiI).NSrcLines - 1
            chkLineaSrcWi(I).Value = Switch(Not MixerWi(MixerWiI).SrcLine(I).bMuteOK, vbGrayed, _
                                            Not MixerWi(MixerWiI).SrcLine(I).bNotMute, vbUnchecked, _
                                            MixerWi(MixerWiI).SrcLine(I).bNotMute, vbChecked)
        Next I
'
    ElseIf (Button = vbRightButton) Then
        If (0 <= MixerWi(MixerWiI).SrcLine(Index).Volume) Then
            ' Il volume di questa linea e' modificabile:
            IchSel = Index
            sldVolumeWi.Value = MaxVolume - MixerWi(MixerWiI).SrcLine(Index).Volume
'
            sldVolumeWi.Visible = True
            sldVolumeWi.SetFocus
            tmrVolumeSld.Enabled = False: tmrVolumeSld.Enabled = True   ' Retrigger del timer.
'
            lblVolumeWi.Caption = " Volume: " _
                                & MixerWi(MixerWiI).SrcLine(Index).Name
            lblVolumeWi.Visible = True
        End If
    End If
'
'
'
End Sub
Private Sub chkOscilloscopio_Click()
'
'
    bOscilloscopio = (chkOscilloscopio.Value = vbChecked)
'
    If bOscilloscopio And bFsWiOK Then
        ' Apro l' oscilloscopio:
        frmOScopio.Apri Fs, NBuff, NcBufferSize, IIf(IsLoaded(frmOScopio), "", Titolo$)
    End If
'
'
'
End Sub
Private Sub cboLunghCampionamento_Click()
'
'
    Dim Mantissa1$, Prefisso1$, Mantissa2$, Prefisso2$
'
    NcBufferSize = CLng(cboLunghCampionamento.Text)
'
    TBuff = 1000 * NcBufferSize / Fs  ' [ms].
    lblTempoBuff.Caption = Format$(TBuff, "#0.0")
'
    FormatPrf NcBufferSize / Fs, Mantissa1$, Prefisso1$, "0.00E+00"
    FormatPrf NBuff * NcBufferSize / Fs, Mantissa2$, Prefisso2$, "0.00E+00"
    cboLunghCampionamento.ToolTipText = " Tb = " & Mantissa1$ & " " & Prefisso1$ & "s " _
                                      & " | " & " NTb = " & Mantissa2$ & " " & Prefisso2$ & "s "
'
'
'
End Sub
Private Sub chkOscilloscopio_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
'
'
    If (Button = vbRightButton) Then
        bLivelliSuono = (Not bLivelliSuono)
        lblLivelliSuono.Visible = bLivelliSuono
'
        If bLivelliSuono And bFsWiOK Then
            ' Apro il misuratore di livelli:
            frmLivelli.Apri Fs, NBuff, NcBufferSize, IIf(IsLoaded(frmLivelli), "", Titolo$)
'
        Else
            Unload frmLivelli
        End If
    End If
'
'
'
End Sub
Private Sub cmdEsci_Click()
'
'
    Unload frmAudioCardDSP
'
'
'
End Sub
Private Sub Form_Load()
'
'
    Dim I&, Me_L&, Me_T&, lRet&, phwi&
'
    On Error GoTo Form_Load_ERR
'
    LeggiPosizioneFormINI FileINI$, Me, Me_L, Me_T
    Me.Move Me_L, Me_T
    Me.Show
'
    ' Operazione di sicurezza, nel caso il programma sia
    ' stato precedentemente terminato in modo non corretto:
    phwi = CLng(GetIniString(FileINI$, "Scheda audio:", "phwi", "0"))
    If (phwi <> 0) Then
        lRet = waveInClose(phwi)
        phwi = 0
        SaveIniString FileINI$, "Scheda audio:", "phwi", phwi
    End If
'
    ' Imposto la risoluzione del timer
    ' timeGetTime al minimo possibile:
    uPeriod = 1
    Do While (timeBeginPeriod(uPeriod) = TIMERR_NOCANDO)
        uPeriod = uPeriod + 1
        If (1000 < uPeriod) Then Exit Do
    Loop
'
    ' Solo per informazione:
    'lRet = timeGetDevCaps(lpTimeCaps, Len(lpTimeCaps))
    'frmInfo.lblInfo0.Caption = "timeGetTime: MinRes = " & lpTimeCaps.wPeriodMin & _
                                          "; MaxRes = " & lpTimeCaps.wPeriodMax & " [ms]"
'
    NBuff = 8
    txtNBuff_KeyPress vbKeyEscape
'
    ' Imposto le lunghezze dei buffers:
    cboLunghCampionamento.AddItem "128"
    cboLunghCampionamento.AddItem "256"
    cboLunghCampionamento.AddItem "512"
    cboLunghCampionamento.AddItem "1024"
    cboLunghCampionamento.AddItem "2048"
    cboLunghCampionamento.AddItem "4096"
    cboLunghCampionamento.AddItem "8192"
'
    For I = 1 To NMixWi
        cboMixersWi.AddItem MixerWi(I).Name
    Next I
    cboMixersWi.Text = MixerWi(MixerWiI).Name
'
    ' Apro, eventualmente, l' analizzatore di spettro ...:
    chkAnalizzatoreSpettro.Value = IIf(bAnalizzatoreSpettro And bFsWiOK, vbChecked, vbUnchecked)
    ' ... e l' oscilloscopio:
    chkOscilloscopio.Value = IIf(bOscilloscopio And bFsWiOK, vbChecked, vbUnchecked)
'
    If bLivelliSuono And bFsWiOK Then
        ' Apro il misuratore di livelli:
        frmLivelli.Apri Fs, NBuff, NcBufferSize, IIf(IsLoaded(frmLivelli), "", Titolo$)
    End If
    lblLivelliSuono.Visible = bLivelliSuono
'
    sldVolumeWi.MIN = 0
    sldVolumeWi.MAX = MaxVolume
    sldVolumeWi.TickFrequency = MaxVolume / 10
    sldVolumeWi.LargeChange = sldVolumeWi.TickFrequency
'
    tmrVolumeSld.Interval = TsldVolumeVisibile
'
    bMeLoaded = True
    cmdInizioAcquisizione.SetFocus
'
'
Form_Load_ERR:
    cmdInizioAcquisizione.Enabled = (Err.Number = 0)
'
'
'
End Sub
Private Sub Form_Unload(Cancel As Integer)
'
'
    Dim Ib&, lRet&, M$
'
    If bAcqOn Then
        M$ = "L' acquisizione e' in corso." & vbNewLine
        M$ = M$ & "Per poter chiudere: [Stop]"
        MsgBox M$, vbInformation
        Cancel = True
        Exit Sub
    End If
'
    If (phwi <> 0) Then
        lRet = waveInReset(phwi)
        For Ib = 1 To NBuff
            lRet = waveInUnprepareHeader(phwi, VarPtr(WaveInHdr(Ib)), Len(WaveInHdr(Ib)))
        Next Ib
        lRet = waveInClose(phwi)
        phwi = 0
        SaveIniString FileINI$, "Scheda audio:", "phwi", phwi
    End If
'
    lRet = timeEndPeriod(uPeriod)
'
    SalvaPosizioneFormINI FileINI$, Me
'
    SaveIniString FileINI$, "Impostazioni:", "MixerWiI", MixerWiI
    SaveIniString FileINI$, "Impostazioni:", "Fs", Fs
'
    SaveIniString FileINI$, "Preferenze A.S.:", "A. Spettro acceso", bAnalizzatoreSpettro
    SaveIniString FileINI$, "Preferenze O.S.:", "Oscilloscopio acceso", bOscilloscopio
    SaveIniString FileINI$, "Preferenze L.S.:", "Misura livelli acceso", bLivelliSuono
'
    bAnalizzatoreSpettro = False
    bOscilloscopio = False
    bLivelliSuono = False
'
    If IsLoaded(frmMisure) Then Unload frmMisure
    If IsLoaded(frmASpettro) Then Unload frmASpettro
    If IsLoaded(frmOScopio) Then Unload frmOScopio
    If IsLoaded(frmLivelli) Then Unload frmLivelli
'
    Set frmAcquisizione = Nothing
'
'
'
End Sub
Private Sub cmdInizioAcquisizione_Click()
'
'
    Dim bAcqOK As Boolean
'
    cmdInizioAcquisizione.Enabled = False
    cmdTerminaAcquisizione.Enabled = True
    cmdTerminaAcquisizione.BackColor = ColOn
    cmdEsci.Enabled = False
'
    lblSchedaAudio.Enabled = False
    cboMixersWi.Enabled = False
    ContainerEnabled fraParametri, False
'
    ' Blocco lo "screensaver" durante il
    ' funzionamento degli strumenti:
    bStatoScreenSaver = ScreenSaver(False)
'
    If bAnalizzatoreSpettro Then
        ' Apro l' analizzatore di spettro:
        frmASpettro.Apri Fs, NBuff, NcBufferSize, IIf(IsLoaded(frmASpettro), "", Titolo$)
    End If
    If bOscilloscopio Then
        ' Apro l' oscilloscopio:
        frmOScopio.Apri Fs, NBuff, NcBufferSize, IIf(IsLoaded(frmOScopio), "", Titolo$)
    End If
    If bLivelliSuono Then
        ' Apro il misuratore di livelli:
        frmLivelli.Apri Fs, NBuff, NcBufferSize, IIf(IsLoaded(frmLivelli), "", Titolo$)
    End If
'
    cmdTerminaAcquisizione.SetFocus
'
    ' Inizio il processo di acquisizione dei dati:
    If IniziaAcquisizione Then
        bAcqOK = Acquisizione   ' L' esecuzione resta bloccata in questa routine
                                ' finche' non viene premuto il pulsante [Stop].
    End If
'
    Call TerminaAcquisizione
'
    cmdInizioAcquisizione.Enabled = True
    cmdTerminaAcquisizione.Enabled = False
    cmdTerminaAcquisizione.BackColor = vbButtonFace
    cmdEsci.Enabled = True
'
    lblSchedaAudio.Enabled = True
    cboMixersWi.Enabled = True
    ContainerEnabled fraParametri, True
'
    ' Ripristino lo stato dello
    ' "screensaver":
    ScreenSaver bStatoScreenSaver
'
    If bAcqOK Then
        cmdInizioAcquisizione.SetFocus
    Else
        cmdEsci.SetFocus
    End If
'
'
'
End Sub
Private Sub cmdTerminaAcquisizione_Click()
'
'
    bAcqOn = False
'
'
'
End Sub
Private Function Acquisizione() As Boolean
'
'   Routine per l' acquisizione e la visualizzazione/analisi
'   dei dati.
'   Lavora con NBuff buffers alternati i.e., quando un buffer e'
'   completo viene copiato nel vettore InDataC() (che sara' inviato
'   alle routines di visualizzazione/analisi) e subito rimesso in
'   coda, mentre il successivo e' gia' in fase di di acquisizione.
'   Ver: 29/08/2005.
'   Rev: 28/07/2007.
'   Rev: 06/02/2010.
'   Rev: 17/02/2010.
'
    Dim I&, Ib&, NBuff1&, TBuffErr&, NBytes&, t0&, t1&, lRet&
'
    Dim K1&, K2&, TElabSM&, TElab&  ' Per il calcolo del
    ReDim TElabVM&(0 To NBuff)      ' tempo di elaborazione.
'
    On Error GoTo Acquisizione_ERR
'
    ' Solo per prove e debug:
    Is1 = 0         ' Indici per i generatori
    Is2 = 0         ' di segnale di prova.
    NCicliAcq = 0   ' Variabili per il calcolo del tempo medio
    TElabSum = 0    ' di elaborazione.
'
    bAcqOn = True   ' L' acquisizione e' in corso.
'
    Ib = 1
    TBuffErr = MAX0(10 * NBuff * TBuff, 500)    ' massimo tempo di attesa per
                                                ' il riempimento dei buffers [ms].
    NBuff1 = NBuff + 1
    NBytes = 2 * NcBufferSize * NCanali
'
    Do
        lblIb.Caption = Ib
'
        t0 = GetTickCount   ' [ms]; uso GetTickCount perche' e' piu' veloce,
                            ' anche se meno preciso, di timeGetTime.
        Do  ' Attendo il riempimento del buffer Ib.
            If (TBuffErr < (GetTickCount - t0)) Then
                Err.Raise 1001, " Acquisizione", "Il sistema non risponde."
            End If
        Loop Until (WaveInHdr(Ib).dwFlags And WHDR_DONE)
'
        t1 = timeGetTime                ' Solo per informazione/debug [ms].
'
        ' Conto il numero di buffer gia' pronti per essere
        ' passati agli strumenti. In condizioni normali, i.e.
        ' quando il il tempo di elaborazione e' inferiore al
        ' tempo di buffer, deve essere pronto solo il buffer
        ' Ib e quindi NbDone = 1:
        NbDone = 0
        For I = 1 To NBuff
            If (WaveInHdr(I).dwFlags And WHDR_DONE) Then NbDone = NbDone + 1
        Next I
'
        ' Generazione di segnali simulati
        ' per prove e debug:
        'GeneraSimSig
'
        ' Verifico che il numero di buffers in coda
        ' non sia superiore al massimo consentito:
        If (NbDone < NBuff) Then
            ' Copio il buffer Ib nel vettore InDataC() da passare agli strumenti:
            CopyMemory InDataC(1, 1), InData(1, 1, Ib), NBytes
'
            ' Rimetto in coda l' acquisizione nel buffer Ib:
            lRet = waveInAddBuffer(phwi, VarPtr(WaveInHdr(Ib)), LenInHeaders)
'
            If bAnalizzatoreSpettro Then
                ' Mando all' analizzatore di spettro i dati del buffer Ib:
                frmASpettro.Spettro InDataC()
            End If
            If bOscilloscopio Then
                ' Mando all' oscilloscopio i dati del buffer Ib:
                frmOScopio.Traccia InDataC()
            End If
            If bLivelliSuono Then
                ' Mando al misuratore di livelli i dati del buffer Ib:
                frmLivelli.Livelli InDataC()
            End If
'
        Else
            ' Per riallineare la sequenza dei buffers, re-inizializzo l' acquisizione
            ' con il buffer #1 e rimetto in coda tutti gli altri buffers:
            lRet = waveInReset(phwi)
            For I = 1 To NBuff
                lRet = waveInAddBuffer(phwi, VarPtr(WaveInHdr(I)), LenInHeaders)
                If (lRet <> MMSYSERR_NOERROR) Then _
                    Err.Raise 1001, , "waveInAddBuffer #" & I & " - Err: " & WaveERR(lRet)
            Next I
            lRet = waveInStart(phwi)
'
            Ib = 0
        End If
'
        ' Calcolo la media mobile dei tempi di
        ' elaborazione (solo per informazione/debug):
        K1 = (K1 + 1) Mod (NBuff1)
        K2 = (K1 + 1) Mod (NBuff1)
'
        TElabVM(K1) = timeGetTime - t1 ' [ms].
        TElabSM = TElabSM + TElabVM(K1) - TElabVM(K2)
        TElab = TElabSM / NBuff
        lblTempoElab.Caption = TElab
'
        ' Calcolo del tempo medio di elaborazione
        ' (solo per prove di ottimizzazione):
'        NCicliAcq = NCicliAcq + 1
'        TElabSum = TElabSum + TElab
'        lblTempoElabMedio.Caption = Format$(TElabSum / NCicliAcq, "#0.00")
'
        If (TBuff < TElab) Then
            ' Il tempo medio impiegato dagli
            ' strumenti ad elaborare il segnale
            ' e' superiore alla lunghezza (in ms)
            ' di un buffer:
            lblTempoElab.BackColor = vbRed
        Else
            lblTempoElab.BackColor = vbButtonFace
        End If
'
        If (1 < NbDone) Then
            ' Il numero dei buffers completi e
            ' pronti per l' elaborazione e' mag-
            ' giore di 1:
            lblNbDone.Caption = NbDone
            If (NbDone = NBuff) Then
                lblNbDone.BackColor = vbRed
            Else
                lblNbDone.BackColor = vbYellow
            End If
'
        Else
            lblNbDone.BackColor = vbButtonFace
            lblNbDone.Caption = ""
        End If
'
        ' Calcolo l' indice del buffer successivo:
        Ib = Ib + 1
        If (NBuff < Ib) Then Ib = 1
'
        DoEvents    ' Unico DoEvents nel ciclo di acquisizione/analisi.
    Loop While bAcqOn
'
'
Acquisizione_ERR:
    If (Err.Number <> 0) Then
        Dim M$
        M$ = "Errore " & Str$(Err.Number) & vbNewLine
        M$ = M$ & Err.Description
        MsgBox M$, vbCritical, " frmAcquisizione: Acquisizione"
        Acquisizione = False
'
    Else
        Acquisizione = True
    End If
'
'
'
End Function
Private Sub lblLivelliSuono_Click()
'
'
    chkOscilloscopio_MouseDown vbRightButton, 0, 0, 0
'
'
'
End Sub
Private Sub lblTempoBuff_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
'
'
    Dim FRoll!, Mantissa$, Prefisso$
'
    FRoll = Fs / NcBufferSize
    FormatPrf FRoll, Mantissa$, Prefisso$, "0.000E+00"
    lblTempoBuff.ToolTipText = " " & Mantissa$ & " " & Prefisso$ & "Hz "
'
'
'
End Sub
Private Sub picLineeWi_Resize()
'
'
    FlexPB_SetScroll picLineeWi
'
'
'
End Sub

Private Sub sldVolumeWi_Change()
'
'
    sldVolumeWi_Scroll
'
'
'
End Sub
Private Sub sldVolumeWi_Scroll()
'
'
    Dim Volume&
'
    Volume = MaxVolume - sldVolumeWi.Value
    If (IchSel = IchDstSel) Then
        MixerWi(MixerWiI).DstLine.Volume = Volume
        Call ImpostaVolumeLinea(MixerWi(MixerWiI), Volume, IchSel, True)
        chkLineaDstWi.ToolTipText = " Volume = " & CLng(100 * Volume / MaxVolume) & " % "
    Else
        MixerWi(MixerWiI).SrcLine(IchSel).Volume = Volume
        Call ImpostaVolumeLinea(MixerWi(MixerWiI), Volume, IchSel)
        chkLineaSrcWi(IchSel).ToolTipText = " Volume = " & CLng(100 * Volume / MaxVolume) & " % "
    End If
'
    sldVolumeWi.Text = Format$(100 * Volume / MaxVolume, "##0") & " % "
'
    tmrVolumeSld.Enabled = False: tmrVolumeSld.Enabled = True   ' Retrigger del timer.
'
'
'
End Sub
Private Sub tmrVolumeSld_Timer()
'
'
    sldVolumeWi.Visible = False
    lblVolumeWi.Visible = False
'
    tmrVolumeSld.Enabled = False
'
'
'
End Sub
Private Sub txtNBuff_Change()
'
'
    txtNBuff.BackColor = vbYellow
'
'
'
End Sub
Private Sub txtNBuff_KeyPress(KeyAscii As Integer)
'
'
    Dim M$, Mantissa1$, Prefisso1$, Mantissa2$, Prefisso2$
'
    On Error Resume Next
'
    If (KeyAscii = vbKeyEscape) Then
        KeyAscii = 0
        txtNBuff.Text = NBuff
        txtNBuff.BackColor = vbWindowBackground
'
    ElseIf (KeyAscii = vbKeyReturn) Then
        KeyAscii = 0
        ' Verifiche per il N di buffers:
        If (CLng(txtNBuff.Text) < 2) Then
            M$ = "Valore errato." & vbNewLine
            M$ = M$ & "Il numero dei buffers deve essere >= 2"
            MsgBox M$, vbInformation, " frmAcquisizione: NBuff"
            txtNBuff.Text = NBuff
'
        Else
            NBuff = CLng(txtNBuff.Text)
            TBuff = 1000 * NcBufferSize / Fs ' [ms].
            lblTempoBuff.Caption = Format$(TBuff, "#0.0")
'
            FormatPrf NcBufferSize / Fs, Mantissa1$, Prefisso1$, "0.00E+00"
            FormatPrf NBuff * NcBufferSize / Fs, Mantissa2$, Prefisso2$, "0.00E+00"
            cboLunghCampionamento.ToolTipText = " Tb = " & Mantissa1$ & " " & Prefisso1$ & "s " _
                                              & " | " & " NTb = " & Mantissa2$ & " " & Prefisso2$ & "s "
        End If
        txtNBuff.BackColor = vbWindowBackground
'
    Else
        KeyAscii = KAscNumInteri(KeyAscii)
    End If
'
'
    If (Err.Number <> 0) Then Err.Clear
'
'
'
End Sub
Private Sub VScroll1_Change()
'
'
    FlexPB_ImmScroll VScroll1
'
'
'
End Sub
Private Sub VScroll1_Scroll()
'
'
    FlexPB_ImmScroll VScroll1
'
'
'
End Sub
Public Function IniziaAcquisizione() As Boolean
'
'   Prepara variabili e strutture per l' acquisizione dei segnali.
'   Ver: 29/08/05.
'
    Dim Ib&, lRet&, M$
    Dim FormatWaveIn As WAVEFORMATEX
'
    On Error GoTo IniziaAcquisizione_ERR
'
    ' Imposto, inizialmente, lo
    ' stato della scheda audio:
    With FormatWaveIn
        .wFormatTag = WAVE_FORMAT_PCM
        .nChannels = NCanali
        .nSamplesPerSec = Fs ' [Hz]
        .wBitsPerSample = BitsPerSample
        .nBlockAlign = (.nChannels * .wBitsPerSample) \ 8
        .nAvgBytesPerSec = .nBlockAlign * .nSamplesPerSec
        .cbSize = 0
    End With
'
    ' Apro il collegamento con la scheda audio ...:
    lRet = waveInOpen(phwi, MixerWi(MixerWiI).SchedaAudioID, VarPtr(FormatWaveIn), 0, 0, 0)
    If (phwi = 0) Or (lRet <> MMSYSERR_NOERROR) Then
        M$ = "Il collegamento con la scheda audio non e' disponibile." & vbNewLine & vbNewLine
        M$ = M$ & "Si consiglia di chiudere tutti i programmi che potrebbero" & vbNewLine
        M$ = M$ & "usare la scheda audio o di riavviare il PC." & vbNewLine
        Err.Raise 1001, , M$ & vbNewLine & vbNewLine & "Err: " & WaveERR(lRet)
    End If
    ' ... e ne salvo l' handler per un eventuale tentativo
    ' di recupero in caso di forzata chiusura senza [Stop]:
    SaveIniString FileINI$, "Scheda audio:", "phwi", phwi
'
    ' Preparo i buffers per l' acquisizione dei dati:
    ReDim WaveInHdr(1 To NBuff) As WAVEHDR
    ReDim InData(1 To NCanali, 1 To NcBufferSize, 1 To NBuff) As Integer
    ReDim InDataC(1 To NCanali, 1 To NcBufferSize) As Integer
    For Ib = 1 To NBuff
        WaveInHdr(Ib).lpData = VarPtr(InData(1, 1, Ib))
        WaveInHdr(Ib).dwBufferLength = 2 * NcBufferSize * NCanali ' [Bytes].
        WaveInHdr(Ib).dwUser = Ib
        WaveInHdr(Ib).dwFlags = 0
        WaveInHdr(Ib).dwLoops = 0
'
        lRet = waveInPrepareHeader(phwi, VarPtr(WaveInHdr(Ib)), Len(WaveInHdr(Ib)))
        If (lRet <> MMSYSERR_NOERROR) Then _
            Err.Raise 1001, , "waveInPrepareHeader #" & Ib & " - Err: " & WaveERR(lRet)
    Next Ib
    LenInHeaders = Len(WaveInHdr(1))
'
    ' Inizio l' acquisizione con il buffer #1
    ' e metto in coda tutti gli altri buffers:
    For Ib = 1 To NBuff
        lRet = waveInAddBuffer(phwi, VarPtr(WaveInHdr(Ib)), LenInHeaders)
        If (lRet <> MMSYSERR_NOERROR) Then _
            Err.Raise 1001, , "waveInAddBuffer #" & Ib & " - Err: " & WaveERR(lRet)
    Next Ib
'
    lRet = waveInStart(phwi)
    If (lRet <> MMSYSERR_NOERROR) Then _
        Err.Raise 1001, , "waveInStart - Err: " & WaveERR(lRet)
    DoEvents
'
'
IniziaAcquisizione_ERR:
    If (Err.Number <> 0) Then
        M$ = "Errore " & Str$(Err.Number) & vbNewLine
        M$ = M$ & Err.Description
        MsgBox M$, vbCritical, " frmAcquisizione: IniziaAcquisizione"
'
        IniziaAcquisizione = False
    Else
        IniziaAcquisizione = True
    End If
'
'
'
End Function
Public Sub TerminaAcquisizione()
'
'   Chiude l' acquisione dalla scheda audio
'   e libera i buffers:
'   Ver: 29/08/05.
'
    Dim Ib&, TBuffN&, t0&, lRet&
'
    On Error Resume Next
'
    ' Fermo l' acquisizione:
    bAcqOn = False
    lRet = waveInReset(phwi)
'
    ' Libero i buffers di acquisizione dei dati:
    TBuffN = NBuff * TBuff  ' [ms].
    For Ib = 1 To NBuff
        t0 = GetTickCount
        Do  ' Attendo il rilascio del buffer Ib ...
        Loop Until ((WaveInHdr(Ib).dwFlags And WHDR_DONE) = WHDR_DONE) _
                   Or (TBuffN < (GetTickCount - t0))
        ' ... e ne libero le risorse:
        lRet = waveInUnprepareHeader(phwi, VarPtr(WaveInHdr(Ib)), Len(WaveInHdr(Ib)))
    Next Ib
'
    ' Chiudo il collegamento con la scheda audio:
    lRet = waveInClose(phwi)
    phwi = 0
    SaveIniString FileINI$, "Scheda audio:", "phwi", phwi
'
'
    If (Err.Number <> 0) Then Err.Clear
'
'
'
End Sub
Private Sub GeneraSimSig()
'
'   Routine per la generazione di segnali di prova:
'
    Dim I&
'
    For I = 1 To NcBufferSize
        ' Canale #1 (sinistro):
        'InDataC(1, I) = Impulso(Is1)
        'InDataC(1, I) = SigRand_BF(Is2)
        'InDataC(1, I) = Seno_AM(Is1)
        'InDataC(1, I) = Seno_FM(Is1)
        'InDataC(1, I) = Seno_SW(Is1)
        'InDataC(1, I) = Seno1(Is1)
        InDataC(1, I) = Seno2(Is1)
'
        ' Canale #2 (destro):
        'InDataC(2, I) = Impulso(Is2)
        InDataC(2, I) = SigRand_BF(Is2)
        'InDataC(2, I) = Seno_AM(Is2)
        'InDataC(2, I) = Seno_FM(Is2)
        'InDataC(2, I) = Seno_SW(Is2)
        'InDataC(2, I) = Seno1(Is2)
        'InDataC(2, I) = Seno2(Is2)
    Next I

'
'
'
End Sub

Private Sub lblTempoU_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
'
'
    If bPerfCounterOK Then
        lblTempoU.ToolTipText = " timeGetTime Res. = " & uPeriod & " ms;" _
                              & " tpc Freq. = " & Format$(lpFrequency * 10000, "#,##0") _
                              & " Hz "
    Else
        lblTempoU.ToolTipText = " timeGetTime Res. = " & uPeriod & " ms "
    End If
'
'
'
End Sub
