VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form frmCalibrazione 
   BorderStyle     =   1  'Fixed Single
   Caption         =   " Coefficienti di calibrazione"
   ClientHeight    =   6375
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   4050
   Icon            =   "frmCalibrazione.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MDIChild        =   -1  'True
   ScaleHeight     =   6375
   ScaleWidth      =   4050
   Begin VB.Timer tmrApplica 
      Enabled         =   0   'False
      Interval        =   500
      Left            =   3420
      Top             =   3000
   End
   Begin MSComctlLib.ProgressBar prgCalcolo 
      Height          =   195
      Left            =   120
      TabIndex        =   34
      Top             =   5580
      Visible         =   0   'False
      Width           =   3795
      _ExtentX        =   6694
      _ExtentY        =   344
      _Version        =   393216
      Appearance      =   1
   End
   Begin VB.Frame fraUnitaMisura 
      Caption         =   "Unita' di misura dei segnali:"
      Height          =   855
      Left            =   120
      TabIndex        =   15
      Top             =   3240
      Width           =   3795
      Begin VB.TextBox txtUi_Ch 
         Height          =   285
         Index           =   2
         Left            =   1920
         TabIndex        =   19
         Text            =   "Ui"
         Top             =   360
         Width           =   615
      End
      Begin VB.TextBox txtUi_Ch 
         Height          =   285
         Index           =   1
         Left            =   120
         TabIndex        =   17
         Text            =   "Ui"
         Top             =   360
         Width           =   615
      End
      Begin VB.Label zLabel10 
         BackStyle       =   0  'Transparent
         Caption         =   "Canale #&2"
         Height          =   255
         Left            =   2610
         TabIndex        =   18
         Top             =   420
         Width           =   795
      End
      Begin VB.Label zLabel06 
         BackStyle       =   0  'Transparent
         Caption         =   "Canale #&1"
         Height          =   255
         Left            =   810
         TabIndex        =   16
         Top             =   420
         Width           =   795
      End
   End
   Begin VB.Frame fraComandi 
      BorderStyle     =   0  'None
      Height          =   435
      Left            =   90
      TabIndex        =   31
      Top             =   5760
      Width           =   3885
      Begin VB.CommandButton cmdOK 
         Caption         =   "&OK"
         Height          =   315
         Left            =   45
         Style           =   1  'Graphical
         TabIndex        =   27
         ToolTipText     =   " Applica, salva e chiudi "
         Top             =   60
         Width           =   615
      End
      Begin VB.CommandButton cmdApplica 
         Caption         =   "&Applica"
         Enabled         =   0   'False
         Height          =   315
         Left            =   840
         Style           =   1  'Graphical
         TabIndex        =   28
         Top             =   60
         Width           =   795
      End
      Begin VB.CommandButton cmdPreset 
         Caption         =   "&Preset"
         Height          =   315
         Left            =   1920
         Style           =   1  'Graphical
         TabIndex        =   30
         ToolTipText     =   " Valori per Line In di SB Live! "
         Top             =   60
         Width           =   855
      End
      Begin VB.CommandButton cmdChiudi 
         Caption         =   "C&hiudi"
         Height          =   315
         Left            =   3150
         Style           =   1  'Graphical
         TabIndex        =   29
         Top             =   60
         Width           =   675
      End
   End
   Begin VB.Frame fraCompensazioneMUX 
      Caption         =   "Compensazione MU&X:"
      Height          =   1275
      Left            =   120
      TabIndex        =   20
      Top             =   4260
      Width           =   3795
      Begin VB.CommandButton cmdTrovaCompMUX 
         Caption         =   "T&rova"
         Height          =   285
         Left            =   2460
         TabIndex        =   25
         Top             =   180
         Width           =   855
      End
      Begin VB.TextBox txtCompMUX 
         Height          =   285
         Left            =   120
         TabIndex        =   22
         Top             =   360
         Width           =   1335
      End
      Begin VB.CommandButton cmdAiutoCompMUX 
         Caption         =   "?"
         Height          =   285
         Left            =   3420
         TabIndex        =   26
         Top             =   180
         Width           =   255
      End
      Begin VB.Label lblNMediaCompMUX 
         BackStyle       =   0  'Transparent
         Height          =   195
         Left            =   2460
         TabIndex        =   32
         Top             =   480
         Width           =   855
      End
      Begin VB.Label zLabel09 
         BackStyle       =   0  'Transparent
         Caption         =   "V2/V1"
         Height          =   255
         Left            =   1560
         TabIndex        =   23
         Top             =   840
         Width           =   555
      End
      Begin VB.Label lblAdcV2V1 
         BorderStyle     =   1  'Fixed Single
         Height          =   285
         Left            =   120
         TabIndex        =   24
         ToolTipText     =   " Rapporto di guadagno fra i canali "
         Top             =   780
         Width           =   1335
      End
      Begin VB.Label zLabel01 
         BackStyle       =   0  'Transparent
         Caption         =   "s"
         Height          =   255
         Left            =   1560
         TabIndex        =   21
         Top             =   420
         Width           =   195
      End
   End
   Begin VB.Frame fraKCal 
      Caption         =   "&KCal  (Vi/DigVal):"
      Height          =   2955
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   3795
      Begin VB.CommandButton cmdTrovaKCal 
         Caption         =   "T&rova"
         Height          =   285
         Left            =   2460
         TabIndex        =   13
         Top             =   180
         Width           =   855
      End
      Begin VB.TextBox txtKCal08k 
         Height          =   285
         Left            =   120
         TabIndex        =   2
         Top             =   360
         Width           =   1335
      End
      Begin VB.TextBox txtKCal11k 
         Height          =   285
         Left            =   120
         TabIndex        =   4
         Top             =   780
         Width           =   1335
      End
      Begin VB.TextBox txtKCal22k 
         Height          =   285
         Left            =   120
         TabIndex        =   6
         Top             =   1200
         Width           =   1335
      End
      Begin VB.TextBox txtKCal44k 
         Height          =   285
         Left            =   120
         TabIndex        =   10
         Top             =   2040
         Width           =   1335
      End
      Begin VB.TextBox txtKCal48k 
         Height          =   285
         Left            =   120
         TabIndex        =   12
         Top             =   2460
         Width           =   1335
      End
      Begin VB.TextBox txtKCal32k 
         Height          =   285
         Left            =   120
         TabIndex        =   8
         Top             =   1620
         Width           =   1335
      End
      Begin VB.CommandButton cmdAiutoCalibrazione 
         Caption         =   "?"
         Height          =   285
         Left            =   3420
         TabIndex        =   14
         Top             =   180
         Width           =   255
      End
      Begin VB.Label lblNMediaKCal 
         BackStyle       =   0  'Transparent
         Height          =   195
         Left            =   2460
         TabIndex        =   33
         Top             =   480
         Width           =   855
      End
      Begin VB.Label zLabel02 
         BackStyle       =   0  'Transparent
         Caption         =   "@ 8000 Hz"
         Height          =   255
         Left            =   1560
         TabIndex        =   1
         Top             =   420
         Width           =   1935
      End
      Begin VB.Label zLabel03 
         BackStyle       =   0  'Transparent
         Caption         =   "@ 11025, 16000  Hz"
         Height          =   255
         Left            =   1560
         TabIndex        =   3
         Top             =   840
         Width           =   2295
      End
      Begin VB.Label zLabel04 
         BackStyle       =   0  'Transparent
         Caption         =   "@ 22050, 24000 Hz"
         Height          =   255
         Left            =   1560
         TabIndex        =   5
         Top             =   1230
         Width           =   1935
      End
      Begin VB.Label zLabel05 
         BackStyle       =   0  'Transparent
         Caption         =   "@ 44100 Hz"
         Height          =   255
         Left            =   1560
         TabIndex        =   9
         Top             =   2100
         Width           =   1935
      End
      Begin VB.Label zLabel07 
         BackStyle       =   0  'Transparent
         Caption         =   "@ 48000 Hz e superiori"
         Height          =   255
         Left            =   1560
         TabIndex        =   11
         Top             =   2520
         Width           =   1935
      End
      Begin VB.Label zLabel08 
         BackStyle       =   0  'Transparent
         Caption         =   "@ 32000 Hz"
         Height          =   255
         Left            =   1560
         TabIndex        =   7
         Top             =   1650
         Width           =   1935
      End
   End
End
Attribute VB_Name = "frmCalibrazione"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'=======================================================================================
' Descrizione.....: Form per il calcolo e l' impostazione dei coefficienti di
'                   calibrazione.
' Nome dei Files..: frmCalibrazione.frm, frmCalibrazione.frx,
'                   frmASpettro.frm, frmASpettro.frx,
'                   frmOScopio.frm, frmOScopio.frx,
'                   frmCorrelatore.frm, frmCorrelatore.frx,
'                   frmLivelli.frm, frmLivelli.frx,
'                   modComplex, modUtilita.bas.
' Data............: 03/01/2005
' Aggiornamento...: 22/10/2006 (aggiunto il calcolo di CompMUX).
' Aggiornamento...: 28/08/2007 (aggiunto il calcolo di KCal).
' Revisione.......: 09/08/2008 (Ver. 1.1).
' Versione........: 1.1 a 32 Bits.
' Sistema.........: VB6 (SP5) sotto Windows XP (SP2).
' Scritto da......: F. Languasco 
' E-Mail..........: MC7061@mclink.it
' DownLoads a.....: http://www.flanguasco.org
'=======================================================================================
'
Option Explicit
'
Dim NBuff&          ' N di buffers per l' acquisizione.
Dim NcBufferSize&   ' Dimensione dei vettori buffer [campioni].
Dim TBuffMS&        '     "       "     "      "    [ms].
'
Const NVAL& = 16384 ' N di campioni su cui analizzare i segnali (2^14):
                    '  @ Fs =  8000 Hz -> 2000 cicli della sinusoide 1 kHz;
                    '  @ Fs = 96000 Hz ->  171   "     "       "     "  "
'
Const NMedieKc& = 5 ' N di medie per il calcolo di KCal.
Const NMedieHc& = 5 ' N di medie per il calcolo della media mobile di Hc.
'
Const BitsPerSample% = 16   ' Risoluzione del campionamento; in questa
                            ' versione e' sempre di 16 Bits.
Const NCanali& = 2          ' N di canali acquisiti dalla scheda audio;
                            ' in questa versione sono sempre 2.
'
Dim KCal_C#     ' KCal calcolato dalla funzione CalcolaKCal() [Vi/DigVal].
Dim V2V1_C#     ' Rapporto di guadagno fra i due canali calcolato dalla
                ' funzione CalcolaKCal(); quello calcolato dalla funzione
                ' CalcolaHc viene assegnato alla variabile pubblica AdcV2V1.
'
Dim RegMMHc() As SpPwr_Type     ' Registro a scorrimento per il calcolo
                                ' della media mobile degli spettri (per Hc).
Dim GammaQHc() As GammaQ_Type   ' Funzione di coerenza del calcolo di Hc().
'
Const TStab_SB# = 0.2   ' Tempo di stabilizzazione del filtro della scheda audio;
                        ' valore adatto per la Sound Blaster Live! [s].
'
Dim InData%()   ' Vettori dei dati da acquisire (Integer, per suono a 16 Bits).
Dim InDataC%()  ' Vettore temporaneo dei dati da acquisire.
'
Dim Hc() As Hc_Type ' Funzione di trasferimento della scheda audio;
                    '  Hc(1).Td: tempo di ritardo corrente del canale #2 (destro)
                    '            dal canale #1 (sinistro) [s].
                    '  Hc(1).Gd: rapporto di guadagno fra il canale #2 ed il canale #1.
'
Const V16Max% = 2 ^ 15 - 1  ' Massimo valore del segnale a 16 Bits [DigVal].
Const V16Min% = -2 ^ 15     ' Minimo valore del segnale a 16 Bits [DigVal].
'
Dim bMeLoaded As Boolean    ' Flag di Form gia' caricato.
'
Dim phwi&                   ' Handle del "waveform-audio input device".
Dim WaveInHdr() As WAVEHDR  ' Vettore dei "waveform-audio buffers".
Dim LenInHeaders&           ' = Len(WaveInHdr(1))
Dim bAcqCalOn As Boolean    ' Flag di acquisizione in corso per calibrazione.
'
Private Type SpPwr_Type
    Gxx As Double       ' Spettro di potenza del segnale in ingresso al canale #1 [DigVal].
    Gyy As Double       '    "    "     "     "    "     "      "    "  canale #2 [DigVal].
    Gxy As Complex      ' "Cross power spectrum" dei segnali in ingresso [DigVal].
End Type
'
Private Type Hc_Type
    Fm As Double        ' Frequenza di misura [Hz].
    Hc As Complex       ' Valore complesso della funzione di
                        ' trasferimento calcolata alla frequenza Fm.
    Gd As Double        ' Guadagno della funzione di trasferimento
                        ' alla frequenza Fm (solo calcolato, per ora).
    Td As Double        ' Tempo di ritardo della funzione di trasferimento
                        ' calcolato alla frequenza Fm [s].
End Type
'
Private Type GammaQ_Type
    Fm As Double        ' Frequenza di misura [Hz].
    GammaQ As Double    ' Funzione di coerenza calcolata alla frequenza Fm.
End Type
'
'-- Dichiarazioni, costanti e tipi per API: --------------------------------------------
'
Private Declare Function GetTickCount Lib "kernel32" () As Long
'
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" _
    (hpvDest As Any, hpvSource As Any, ByVal cbCopy As Long)
'
Private Const WAVE_FORMAT_PCM& = 1
Private Const WAVE_FORMAT_QUERY& = &H1
'
Private Const WHDR_DONE& = &H1&             ' done bit
Private Const WHDR_PREPARED& = &H2          ' set if this header has been prepared
Private Const WHDR_BEGINLOOP& = &H4         ' loop start block
Private Const WHDR_ENDLOOP& = &H8           ' loop end block
Private Const WHDR_INQUEUE& = &H10          ' reserved for driver
Private Const WHDR_VALID& = &H1F            ' valid flags      / ;Internal /
'
Private Const MMSYSERR_NOERROR& = 0         ' no error
'
Private Type WAVEHDR
    lpData As Long
    dwBufferLength As Long
    dwBytesRecorded As Long
    dwUser As Long
    dwFlags As Long
    dwLoops As Long
    lpNext As Long  ' Reserved.
    Reserved As Long
End Type
'
Private Type WAVEFORMATEX
    wFormatTag As Integer
    nChannels As Integer
    nSamplesPerSec As Long
    nAvgBytesPerSec As Long
    nBlockAlign As Integer
    wBitsPerSample As Integer
    cbSize As Integer
End Type
'
Private Declare Function waveInOpen Lib "winmm" _
    (WaveDeviceInputHandle As Long, ByVal WhichDevice As Long, _
    ByVal WaveFormatExPointer As Long, ByVal CallBack As Long, _
    ByVal CallBackInstance As Long, ByVal Flags As Long) As Long
Private Declare Function waveInClose Lib "winmm" _
    (ByVal WaveDeviceInputHandle As Long) As Long
'
Private Declare Function waveInStart Lib "winmm" _
    (ByVal WaveDeviceInputHandle As Long) As Long
Private Declare Function waveInReset Lib "winmm" _
    (ByVal WaveDeviceInputHandle As Long) As Long
Private Declare Function waveInStop Lib "winmm" _
    (ByVal WaveDeviceInputHandle As Long) As Long
'
Private Declare Function waveInAddBuffer Lib "winmm" _
    (ByVal InputDeviceHandle As Long, ByVal WaveHdrPointer As Long, _
    ByVal WaveHdrStructSize As Long) As Long
Private Declare Function waveInPrepareHeader Lib "winmm" _
    (ByVal InputDeviceHandle As Long, ByVal WaveHdrPointer As Long, _
    ByVal WaveHdrStructSize As Long) As Long
Private Declare Function waveInUnprepareHeader Lib "winmm" _
    (ByVal InputDeviceHandle As Long, ByVal WaveHdrPointer As Long, _
    ByVal WaveHdrStructSize As Long) As Long
Private Sub AbilitaApplica(ByVal bAbilita As Boolean, _
    Optional ByVal bSetFocus As Boolean = True)
'
'   Abilita/disabilita il pulsante [Applica] e la sua evidenziazione:
'
    cmdApplica.Enabled = bAbilita
    cmdApplica.Font.Bold = bAbilita
    cmdApplica.BackColor = IIf(bAbilita, ColEvi, vbButtonFace)
    If bAbilita And bSetFocus Then cmdApplica.SetFocus
'
    tmrApplica.Enabled = bAbilita
'
'
'
End Sub
Private Sub cmdAiutoCalibrazione_Click()
'
'
    frmIstruzioni.Apri App.Path & "\Calibrazione_KCal.rtf", " Procedura di calibrazione"
'
'
'
End Sub
Private Sub cmdAiutoCompMUX_Click()
'
'
    frmIstruzioni.Apri App.Path & "\Compensazione_MUX.rtf", " Compensazione del Multiplexer"
'
'
'
End Sub
Private Sub cmdApplica_Click()
'
'
    If (Val(ValC2D(txtKCal08k.Text)) = 0) Then txtKCal08k_KeyPress vbKeyEscape
    KCal08k = CSng(txtKCal08k.Text)
    If (Val(ValC2D(txtKCal11k.Text)) = 0) Then txtKCal11k_KeyPress vbKeyEscape
    KCal11k = CSng(txtKCal11k.Text)
    If (Val(ValC2D(txtKCal22k.Text)) = 0) Then txtKCal22k_KeyPress vbKeyEscape
    KCal22k = CSng(txtKCal22k.Text)
    If (Val(ValC2D(txtKCal32k.Text)) = 0) Then txtKCal32k_KeyPress vbKeyEscape
    KCal32k = CSng(txtKCal32k.Text)
    If (Val(ValC2D(txtKCal44k.Text)) = 0) Then txtKCal44k_KeyPress vbKeyEscape
    KCal44k = CSng(txtKCal44k.Text)
    If (Val(ValC2D(txtKCal48k.Text)) = 0) Then txtKCal48k_KeyPress vbKeyEscape
    KCal48k = CSng(txtKCal48k.Text)
'
    Ui_Ch$(1) = txtUi_Ch(1).Text
    Ui_Ch$(2) = txtUi_Ch(2).Text
'
    If (txtCompMUX.Text = "") Then txtCompMUX.Text = 0
    CompMUX = CSng(txtCompMUX.Text)
    AdcV2V1 = CSng(lblAdcV2V1.Caption)
'
    ' Applico, agli strumenti in funzione,
    ' le nuove calibrazioni/compensazioni:
    If IsLoaded(frmASpettro) Then
        frmASpettro.ApplicaCalibrazioni
    End If
    If IsLoaded(frmOScopio) Then
        frmOScopio.ApplicaCalibrazioni
    End If
    If IsLoaded(frmCorrelatore) Then
        frmCorrelatore.ApplicaCalibrazioni
    End If
    If IsLoaded(frmLivelli) Then
        frmLivelli.ApplicaCalibrazioni
    End If
'
    AbilitaApplica False
'
'
'
End Sub
Private Sub cmdChiudi_Click()
'
'
    Unload Me
'
'
'
End Sub
Private Sub cmdOK_Click()
'
'
    cmdApplica_Click
'
    SaveIniString FileINI$, "Calibrazioni:", "KCal08k", KCal08k
    SaveIniString FileINI$, "Calibrazioni:", "KCal11k", KCal11k
    SaveIniString FileINI$, "Calibrazioni:", "KCal22k", KCal22k
    SaveIniString FileINI$, "Calibrazioni:", "KCal32k", KCal32k
    SaveIniString FileINI$, "Calibrazioni:", "KCal44k", KCal44k
    SaveIniString FileINI$, "Calibrazioni:", "KCal48k", KCal48k
'
    SaveIniString FileINI$, "Calibrazioni:", "Unita' di misura Ch 1", Ui_Ch$(1)
    SaveIniString FileINI$, "Calibrazioni:", "Unita' di misura Ch 2", Ui_Ch$(2)
'
    SaveIniString FileINI$, "Calibrazioni:", "CompMUX", CompMUX
    SaveIniString FileINI$, "Calibrazioni:", "AdcV2V1", AdcV2V1
'
    Unload Me
'
'
'
End Sub
Private Sub cmdPreset_Click()
'
'   Valori per Line In di SB Live!:
'
    txtKCal08k.Text = 0.598 / 10000
    txtKCal11k.Text = 0.574 / 10000
    txtKCal22k.Text = 0.503 / 10000
    txtKCal32k.Text = 0.493 / 10000
    txtKCal44k.Text = 0.505 / 10000
    txtKCal48k.Text = 0.474 / 10000
'
    txtUi_Ch(1).Text = "Vi"
    txtUi_Ch(2).Text = "Vi"
'
    txtCompMUX.Text = Format$(1# / 48000, "#0.0#########")
'
    AbilitaApplica True
'
'
'
End Sub
Private Sub cmdTrovaCompMUX_Click()
'
'
    Dim bApplica_S As Boolean
'
    If bAcqOn Then
        Dim M$
        M$ = "L' acquisizione e' in corso." & vbNewLine & vbNewLine
        M$ = M$ & "Per poter usare questa funzione" & vbNewLine
        M$ = M$ & "occorre fermarla con [Stop]." & vbNewLine
        MsgBox M$, vbInformation, " TrovaCompMUX"
        Exit Sub
    End If
'
    bApplica_S = cmdApplica.Enabled
'
    Me.MousePointer = vbHourglass
    prgCalcolo.MAX = NMedieHc
    prgCalcolo.Value = 0
    prgCalcolo.Visible = True
    ContainerEnabled fraKCal, False
    ContainerEnabled fraUnitaMisura, False
    ContainerEnabled fraCompensazioneMUX, False
    ContainerEnabled fraComandi, False
'
    If CalcolaCompMUX Then
        ContainerEnabled fraComandi, True
'
        txtCompMUX.Text = Format$(Hc(1).Td, "#0.0#########")
        lblAdcV2V1.Caption = Format$(Hc(1).Gd, "#0.0#########")
'
        txtCompMUX.ToolTipText = " Fase = " _
                               & Format$(Hc(1).Td * 360 * Hc(1).Fm, "#0.00") & " Grd" _
                               & " @ " & Format$(Hc(1).Fm, "#0.000") & " Hz "
        cmdTrovaCompMUX.ToolTipText = " Funzione di coerenza = " _
                                    & Format$(GammaQHc(1).GammaQ, "#0.000000000") & " "
'
    Else
        txtCompMUX.ToolTipText = ""
        cmdTrovaCompMUX.ToolTipText = ""
'
        ContainerEnabled fraComandi, True
        AbilitaApplica bApplica_S
    End If
'
    ContainerEnabled fraKCal, True
    AbilitaKCalFs
    ContainerEnabled fraUnitaMisura, True
    ContainerEnabled fraCompensazioneMUX, True
    prgCalcolo.Visible = False
    Me.MousePointer = vbDefault
'
'
'
End Sub

Private Sub cmdTrovaKCal_Click()
'
'
    Dim bApplica_S As Boolean, Kc$, V2V1$
'
    If bAcqOn Then
        Dim M$
        M$ = "L' acquisizione e' in corso." & vbNewLine & vbNewLine
        M$ = M$ & "Per poter usare questa funzione" & vbNewLine
        M$ = M$ & "occorre fermarla con [Stop]." & vbNewLine
        MsgBox M$, vbInformation, " TrovaKCal"
        Exit Sub
    End If
'
    bApplica_S = cmdApplica.Enabled
'
    Me.MousePointer = vbHourglass
    prgCalcolo.MAX = NMedieKc
    prgCalcolo.Value = 0
    prgCalcolo.Visible = True
    ContainerEnabled fraKCal, False
    ContainerEnabled fraUnitaMisura, False
    ContainerEnabled fraCompensazioneMUX, False
    ContainerEnabled fraComandi, False
'
    If CalcolaKCal Then
        ContainerEnabled fraComandi, True
'
        Kc$ = Format$(KCal_C, "#0.0#########")
        V2V1$ = " V2/V1 = " & Format$(V2V1_C, "#0.0#########") & " "
'
        Select Case Fs
        Case 8000
            txtKCal08k.Text = Kc$
            txtKCal08k.ToolTipText = V2V1$
'
        Case 11025, 16000
            txtKCal11k.Text = Kc$
            txtKCal11k.ToolTipText = V2V1$
'
        Case 22050, 24000
            txtKCal22k.Text = Kc$
            txtKCal22k.ToolTipText = V2V1$
'
        Case 32000
            txtKCal32k.Text = Kc$
            txtKCal32k.ToolTipText = V2V1$
'
        Case 44100
            txtKCal44k.Text = Kc$
            txtKCal44k.ToolTipText = V2V1$
'
        Case Is >= 48000
            txtKCal48k.Text = Kc$
            txtKCal48k.ToolTipText = V2V1$
'
        Case Else
            txtKCal11k.Text = Kc$
            txtKCal11k.ToolTipText = V2V1$
        End Select
'
    Else
        ContainerEnabled fraComandi, True
        AbilitaApplica bApplica_S
    End If
'
    ContainerEnabled fraKCal, True
    AbilitaKCalFs
    ContainerEnabled fraUnitaMisura, True
    ContainerEnabled fraCompensazioneMUX, True
    prgCalcolo.Visible = False
    Me.MousePointer = vbDefault
'
'
'
End Sub
Private Sub Form_Load()
'
'
    Dim Me_L&, Me_T&, ITR&
'
    LeggiPosizioneFormINI FileINI$, Me, Me_L, Me_T
    Me.Move Me_L, Me_T
'
    ' Disabilito la [X] di chiusura Form:
    CloseButtonDisable Me
'
    bMeLoaded = True
'
'
'
End Sub
Private Function Acquisizione(ByVal NCampioni As Long, _
    ByRef Data() As Integer, ByVal Fs As Double, _
    Optional ByVal TrigFronte As Long = 0, _
    Optional ByVal TrigCh As Long = 1, _
    Optional ByVal TrigLiv As Integer = 0, _
    Optional ByVal TStab As Double = 0) As Boolean
'
'   Routine per leggere NCampioni dalla scheda audio.
'   Lavora con NBuff buffers alternati i.e., quando un buffer e'
'   completo viene copiato nel vettore InDataC() (che sara' analizzato
'   ed eventualmente copiato nel vettore Data()) e subito rimesso in
'   coda, mentre il successivo e' gia' in fase di di acquisizione.
'   Vengono scartati i primi NcStab campioni per permettere la stabiliz-
'   zazione del filtro della scheda audio.
'
'   Parametri:
'    NCampioni:     N di campioni da acquisire.
'    Data():        matrice con i dati acquisiti [DigVal].
'    Fs:            frequenza di campionamento [Hz].
'    TrigFronte:    fronte d' onda per il trigger; +1: salita, -1: discesa.
'                   Se TrigFronte = 0 il trigger non viene cercato.
'    TrigCh:        canale selezionato per "trigger source"; 1 <= TrigCh <= 2.
'    TrigLiv:       livello di trigger selezionato per TrigCh [DigVal].
'    TStab:         tempo di stabilizzazione del filtro della scheda audio [s].
'
'   Ver: 12/01/2006.
'   Agg: 30/08/2007.
'
    Dim I&, Ib&, K&, NcStab&, IcStab&, TBuffN&, NBytes&, t0&, lRet&
    Dim ITR&, VIn_1%, VIn%, bTriggerOK As Boolean
'
    On Error GoTo Acquisizione_ERR
'
    bAcqCalOn = True    ' L' acquisizione e' in corso.
'
    IcStab = 0
    K = 0
    NBuff = 10
    NcBufferSize = 5000
    TBuffMS = 1000 * NcBufferSize / Fs  ' [ms].
    TBuffN = 10 * NBuff * TBuffMS       ' [ms].
    NBytes = 2 * NcBufferSize * NCanali
'
    NcStab = CLng(TStab * Fs)
'
    ' Serve solo se NcStab = 0:
    If (0 < TrigFronte) Then
        VIn_1 = V16Max
    ElseIf (TrigFronte < 0) Then
        VIn_1 = V16Min
    End If
'
    ReDim Data(1 To NCanali, 1 To NCampioni)
'
    If (Not waveInInizia(Fs, NCanali)) Then
        Err.Raise 1001, " Acquisizione", "Errore di inizializzazione."
    End If
    Ib = 1
'
    Do
        t0 = GetTickCount   ' [ms].
        Do  ' Attendo il riempimento del buffer Ib ...:
            If (TBuffN < (GetTickCount - t0)) Then
                Err.Raise 1001, " Acquisizione", "Il sistema non risponde."
            End If
        Loop Until ((WaveInHdr(Ib).dwFlags And WHDR_DONE) = WHDR_DONE)
'
        ' ... e lo copio nel vettore InDataC() da analizzare:
        CopyMemory InDataC(1, 1), InData(1, 1, Ib), NBytes
'
        ' Rimetto in coda l' acquisizione nel buffer Ib:
        lRet = waveInAddBuffer(phwi, VarPtr(WaveInHdr(Ib)), LenInHeaders)
'
        ' Analizzo e salvo i dati di InDataC():
        For I = 1 To NcBufferSize
            IcStab = IcStab + 1
            If (NcStab < IcStab) Then
                If (Not bTriggerOK) Then
                    ITR = ITR + 1
                    VIn = InDataC(TrigCh, I)
                    bTriggerOK = Trigger(VIn_1, VIn, TrigFronte, TrigLiv)
                    VIn_1 = VIn
                End If
'
                If bTriggerOK Then
                    K = K + 1
                    Data(1, K) = InDataC(1, I)
                    Data(2, K) = InDataC(2, I)
'
                    If (NCampioni <= K) Then
                        bAcqCalOn = False
                        Exit For
                    End If
                End If
'
            Else
                VIn_1 = InDataC(TrigCh, I)
            End If
        Next I
'
        If (NCampioni < ITR) Then
            ' Non ho trovato il trigger su NCampioni:
            Err.Raise 1001, " Acquisizione", "Non c' e' segnale."
        End If
'
        ' Calcolo l' indice del buffer successivo:
        Ib = Ib + 1
        If (NBuff < Ib) Then Ib = 1
'
        DoEvents
    Loop While bAcqCalOn
'
'
Acquisizione_ERR:
    If (Err.Number <> 0) Then
        Dim M$
        M$ = "Errore " & Str$(Err.Number) & vbNewLine
        M$ = M$ & Err.Description
        MsgBox M$, vbCritical, " frmCalibrazione: Acquisizione"
        Acquisizione = False
'
    Else
        Acquisizione = True
    End If
'
    waveInTermina
'
'
'
End Function
Private Function waveInInizia(ByVal Fs As Double, ByVal NCanali As Long) As Boolean
'
'   Prepara variabili e strutture per l' acquisizione dei segnali.
'   Ver: 29/08/05.
'
    Dim Ib&, lRet&, M$
    Dim FormatWaveIn As WAVEFORMATEX
'
    On Error GoTo waveInInizia_ERR
'
    ' Imposto, inizialmente, lo stato
    ' della scheda audio:
    With FormatWaveIn
        .wFormatTag = WAVE_FORMAT_PCM
        .nChannels = NCanali
        .nSamplesPerSec = Fs ' [Hz]
        .wBitsPerSample = BitsPerSample
        .nBlockAlign = (.nChannels * .wBitsPerSample) \ 8
        .nAvgBytesPerSec = .nBlockAlign * .nSamplesPerSec
        .cbSize = 0
    End With
'
    ' Apro il collegamento con la scheda audio:
    lRet = waveInOpen(phwi, MixerWi(MixerWiI).SchedaAudioID, VarPtr(FormatWaveIn), 0, 0, 0)
    If (phwi = 0) Or (lRet <> 0) Then
        M$ = "Il collegamento con la scheda audio non e' disponibile." & vbNewLine & vbNewLine
        M$ = M$ & "Si consiglia di chiudere tutti i programmi che potrebbero" & vbNewLine
        M$ = M$ & "usare la scheda audio o di riavviare il PC." & vbNewLine
        Err.Raise 1001, , M$ & vbNewLine & vbNewLine & "Err: " & WaveERR(lRet)
    End If
'
    ' Preparo i buffers per l' acquisizione dei dati:
    ReDim WaveInHdr(1 To NBuff) As WAVEHDR
    ReDim InData(1 To NCanali, 1 To NcBufferSize, 1 To NBuff) As Integer
    ReDim InDataC(1 To NCanali, 1 To NcBufferSize) As Integer
    For Ib = 1 To NBuff
        WaveInHdr(Ib).lpData = VarPtr(InData(1, 1, Ib))
        WaveInHdr(Ib).dwBufferLength = 2 * NcBufferSize * NCanali ' [Bytes].
        WaveInHdr(Ib).dwUser = Ib
        WaveInHdr(Ib).dwFlags = 0
        WaveInHdr(Ib).dwLoops = 0
'
        lRet = waveInPrepareHeader(phwi, VarPtr(WaveInHdr(Ib)), Len(WaveInHdr(Ib)))
        If (lRet <> MMSYSERR_NOERROR) Then _
            Err.Raise 1001, , "waveInPrepareHeader #" & Ib & " - Err: " & WaveERR(lRet)
    Next Ib
    LenInHeaders = Len(WaveInHdr(1))
'
    ' Inizio l' acquisizione con il buffer #1 e metto
    ' in coda l' acquisizione con gli altri buffers:
    For Ib = 1 To NBuff
        lRet = waveInAddBuffer(phwi, VarPtr(WaveInHdr(Ib)), LenInHeaders)
        If (lRet <> MMSYSERR_NOERROR) Then _
            Err.Raise 1001, , "waveInAddBuffer #" & Ib & " - Err: " & WaveERR(lRet)
    Next Ib
'
    lRet = waveInStart(phwi)
    If (lRet <> MMSYSERR_NOERROR) Then _
        Err.Raise 1001, , "waveInStart - Err: " & WaveERR(lRet)
'
'
waveInInizia_ERR:
    waveInInizia = (Err.Number = 0)
'
    If (Err.Number <> 0) Then
        M$ = "Errore " & Str$(Err.Number) & vbNewLine
        M$ = M$ & Err.Description
        MsgBox M$, vbCritical, " frmCalibrazione: waveInInizia"
    End If
'
'
'
End Function
Private Sub waveInTermina()
'
'   Chiude l' acquisione dalla scheda audio
'   e libera i buffers:
'   Ver: 29/08/05.
'
    Dim Ib&, TBuffN&, t0&, lRet&
'
    On Error Resume Next
'
    ' Fermo l' acquisizione:
    bAcqCalOn = False
    lRet = waveInReset(phwi)
'
    ' Libero i buffers di acquisizione dei dati:
    TBuffN = NBuff * TBuffMS  ' [ms].
    For Ib = 1 To NBuff
        t0 = GetTickCount
        Do  ' Attendo il rilascio del buffer Ib ...:
        Loop Until ((WaveInHdr(Ib).dwFlags And WHDR_DONE) = WHDR_DONE) _
                   Or (TBuffN < (GetTickCount - t0))
        ' ... e ne libero le risorse:
        lRet = waveInUnprepareHeader(phwi, VarPtr(WaveInHdr(Ib)), Len(WaveInHdr(Ib)))
    Next Ib
'
    ' Chiudo il collegamento con la scheda audio:
    lRet = waveInClose(phwi)
    phwi = 0
'
'
    If (Err.Number <> 0) Then Err.Clear
'
'
'
End Sub
Private Function Trigger(VIn_1 As Integer, VIn As Integer, _
    ByVal TrigFronte As Long, ByVal TrigLiv As Integer) As Boolean
'
'   Ricerca il trigger intorno ai campioni VIn_1
'   e VIn.  Ritorna True quando l' ha trovato:
'
    Dim bTrig As Boolean
'
    ' Cerco il trigger:
    If (0 < TrigFronte) Then
        ' sul fronte positivo...:
        bTrig = (VIn_1 <= TrigLiv) _
            And (TrigLiv < VIn)
'
    ElseIf (TrigFronte < 0) Then
        ' ... o su quello negativo:
        bTrig = (VIn < TrigLiv) _
            And (TrigLiv <= VIn_1)
'
    Else
        bTrig = True
    End If
'
    Trigger = bTrig
'
'
'
End Function
Private Sub Form_Unload(Cancel As Integer)
'
'
    SalvaPosizioneFormINI FileINI$, Me
'
    bMeLoaded = False
'
    Set frmCalibrazione = Nothing
'
'
'
End Sub
Public Sub Apri(Optional ByVal bCambiaFs As Boolean = False)
'
'
    If (bMeLoaded And (Not bCambiaFs)) Then Exit Sub
'
    ' Recupero i coefficienti correnti:
    txtKCal08k.Text = Format$(KCal08k, "#0.0#########")
    txtKCal11k.Text = Format$(KCal11k, "#0.0#########")
    txtKCal22k.Text = Format$(KCal22k, "#0.0#########")
    txtKCal32k.Text = Format$(KCal32k, "#0.0#########")
    txtKCal44k.Text = Format$(KCal44k, "#0.0#########")
    txtKCal48k.Text = Format$(KCal48k, "#0.0#########")
'
    AbilitaKCalFs
'
    txtUi_Ch(1).Text = Ui_Ch$(1)
    txtUi_Ch(2).Text = Ui_Ch$(2)
'
    txtCompMUX.Text = Format$(CompMUX, "#0.0#########")
    lblAdcV2V1.Caption = Format$(AdcV2V1, "#0.0#########")
'
    AbilitaApplica False
'
'
'
End Sub

Private Sub tmrApplica_Timer()
'
'
    cmdApplica.BackColor = IIf(cmdApplica.BackColor = ColEvi, vbButtonFace, ColEvi)
'
'
'
End Sub
Private Sub txtCompMUX_Change()
'
'
    AbilitaApplica True, False
'
'
'
End Sub
Private Sub txtCompMUX_KeyPress(KeyAscii As Integer)
'
'
    Select Case KeyAscii
    Case vbKeyEscape
        KeyAscii = 0
'
        txtCompMUX.Text = CompMUX
'
    Case Else
        KeyAscii = KAscNumReali(KeyAscii, True)
    End Select
'
'
'
End Sub
Private Sub txtKCal08k_Change()
'
'
    AbilitaApplica True, False
'
'
'
End Sub
Private Sub txtKCal08k_KeyPress(KeyAscii As Integer)
'
'
    Select Case KeyAscii
    Case vbKeyEscape
        KeyAscii = 0
'
        txtKCal08k.Text = Format$(KCal08k, "#0.0#########")
'
    Case Else
        KeyAscii = KAscNumReali(KeyAscii, True)
    End Select
'
'
'
End Sub
Private Sub txtKCal11k_Change()
'
'
    AbilitaApplica True, False
'
'
'
End Sub
Private Sub txtKCal11k_KeyPress(KeyAscii As Integer)
'
'
    Select Case KeyAscii
    Case vbKeyEscape
        KeyAscii = 0
'
        txtKCal11k.Text = Format$(KCal11k, "#0.0#########")
'
    Case Else
        KeyAscii = KAscNumReali(KeyAscii, True)
    End Select
'
'
'
End Sub
Private Sub txtKCal22k_Change()
'
'
    AbilitaApplica True, False
'
'
'
End Sub
Private Sub txtKCal22k_KeyPress(KeyAscii As Integer)
'
'
    Select Case KeyAscii
    Case vbKeyEscape
        KeyAscii = 0
'
        txtKCal22k.Text = Format$(KCal22k, "#0.0#########")
'
    Case Else
        KeyAscii = KAscNumReali(KeyAscii, True)
    End Select
'
'
'
End Sub
Private Sub txtKCal32k_Change()
'
'
    AbilitaApplica True, False
'
'
'
End Sub
Private Sub txtKCal32k_KeyPress(KeyAscii As Integer)
'
'
    Select Case KeyAscii
    Case vbKeyEscape
        KeyAscii = 0
'
        txtKCal32k.Text = Format$(KCal32k, "#0.0#########")
'
    Case Else
        KeyAscii = KAscNumReali(KeyAscii, True)
    End Select
'
'
'
End Sub
Private Sub txtKCal44k_Change()
'
'
    AbilitaApplica True, False
'
'
'
End Sub
Private Sub txtKCal44k_KeyPress(KeyAscii As Integer)
'
'
    Select Case KeyAscii
    Case vbKeyEscape
        KeyAscii = 0
'
        txtKCal44k.Text = Format$(KCal44k, "#0.0#########")
'
    Case Else
        KeyAscii = KAscNumReali(KeyAscii, True)
    End Select
'
'
'
End Sub
Private Sub txtKCal48k_Change()
'
'
    AbilitaApplica True, False
'
'
'
End Sub
Private Sub txtKCal48k_KeyPress(KeyAscii As Integer)
'
'
    Select Case KeyAscii
    Case vbKeyEscape
        KeyAscii = 0
'
        txtKCal48k.Text = Format$(KCal48k, "#0.0#########")
'
    Case Else
        KeyAscii = KAscNumReali(KeyAscii, True)
    End Select
'
'
'
End Sub
Private Function CalcolaCompMUX() As Boolean
'
'   Calcola l' Hc di calibrazione per la sola frequenza F1 (1 kHz).
'
'   Versione per AudioCardDSP.
'
    Dim I&, IChS&, K&, NF&
    Dim IFm&, DFs#, Data%(), Win#()
    Dim Freq#(), SpMaxCh#(1 To 2)
    Dim D1#(), R1#(), X1#()
    Dim D2#(), R2#(), X2#()
'
    Const Ich& = 1  ' Canale del trigger (sinistro).
'
    On Error GoTo CalcolaCompMUX_ERR
'
    NF = 1  ' C' e' un solo punto di frequenza.
'
    DFs = Fs / CDbl(NVAL)   ' Risoluzione in frequenza degli spettri [Hz].
'
    ReDim Freq(0 To NVAL / 2)
    ReDim Hc(1 To NF) As Hc_Type
    ReDim D1(0 To NVAL - 1), R1(1 To NF), X1(1 To NF)
    ReDim D2(0 To NVAL - 1), R2(1 To NF), X2(1 To NF)
    ReDim RegMMHc(1 To NMedieHc, 1 To NF), GammaQHc(1 To NF)
'
    ' Calcolo il profilo di "Window":
    Win() = WinProf("Hanning", NVAL)
'
    For K = 1 To NMedieHc
        lblNMediaCompMUX.Caption = "N media: " & K
        ' Acquisisco i segnali di misura:
        If (Not Acquisizione(NVAL, Data(), Fs, 1, Ich, 0, TStab_SB)) Then
            Err.Raise 1001, , "Acquisizione"
        End If
'
        ' Sposto i dati acquisiti nei
        ' vettori da analizzare:
        For I = 1 To NVAL
            D1(I - 1) = CDbl(Data(1, I))
            D2(I - 1) = CDbl(Data(2, I))
        Next I
'
        ' Applico la "Window":
        For I = 0 To NVAL - 1
            D1(I) = Win(I) * D1(I)
            D2(I) = Win(I) * D2(I)
        Next I
'
        ' Calcolo gli spettri dei segnali in ingresso:
        FFT_D2 D1(), D2(), R1(), X1(), R2(), X2(), NVAL
'
        ' Trovo la frequenza di massima ampiezza
        ' da passare al calcolo di Hc:
        SpMaxCh(1) = 0#
        For I = 0 To NVAL / 2
            Freq(I) = CDbl(I) * DFs
'
            If (SpMaxCh(1) < (R1(I) * R1(I) + X1(I) * X1(I))) Then
                SpMaxCh(1) = (R1(I) * R1(I) + X1(I) * X1(I))
                SpMaxCh(2) = (R2(I) * R2(I) + X2(I) * X2(I))
                IFm = I
                Hc(1).Fm = Freq(I)
            End If
        Next I
'
        ' Solo per debug:
'        IChS = 2
'        frmCurve.DisegnaSpettroCalibrazione Freq(), R1(), X1(), R2(), X2(), _
'                                            NVAL / 2, IChS, SpMaxCh(IChS)
'
        ' Verifico la validita' dei segnali in ingresso:
        If (Hc(1).Fm < 900) Or (1100 < Hc(1).Fm) _
        Or (SpMaxCh(2) < 0.7 * SpMaxCh(1)) Or (1.3 * SpMaxCh(1) < SpMaxCh(2)) Then
            Err.Raise 1002, , "Segnali in ingresso con ampiezze" & vbNewLine _
                            & "e/o frequenze non valide."
        End If
'
        CalcolaHc 1, R1(IFm), X1(IFm), R2(IFm), X2(IFm), Hc()
'
        prgCalcolo.Value = K
        DoEvents
    Next K
'
'
CalcolaCompMUX_ERR:
    lblNMediaCompMUX.Caption = ""
    CalcolaCompMUX = (Err.Number = 0)
'
    If (Err.Number <> 0) Then
        Dim M$
        M$ = "Errore " & Str$(Err.Number) & vbNewLine
        M$ = M$ & Err.Description
        MsgBox M$, vbCritical, " frmCalibrazione: CalcolaCompMUX"
    End If
'
'
'
End Function
Private Sub CalcolaHc(ByVal JF As Long, _
    ByVal R1 As Double, ByVal X1 As Double, _
    ByVal R2 As Double, ByVal X2 As Double, _
    Hc() As Hc_Type)
'
'   Calcola la funzione di trasferimento Hc(JF).Hc
'   del convertitore A/D alla frequenza Hc(JF).Fm:
'
    Dim I&, si As Complex, Su As Complex
    Dim Gxx#, Gyy#, Gxy As Complex, GxxN#, GyyN#, GxyN As Complex
'
    si = CCmp(R1, X1)   ' Spettro del segnale del canale #1 (sinistro).
    Su = CCmp(R2, X2)   '    "     "    "      "    "    #2 (destro).
'
    ' Calcolo gli spettri di potenza:
    GxxN = si.Re * si.Re + si.Im * si.Im    ' CAbs(Si) ^ 2
    GyyN = Su.Re * Su.Re + Su.Im * Su.Im    ' CAbs(Su) ^ 2
    GxyN = CMol(CCon(si), Su)
'
    ' Calcolo la media mobile degli spettri:
    Gxx = GxxN
    Gyy = GyyN
    Gxy = GxyN
    For I = 1 To NMedieHc - 1
        RegMMHc(I, JF) = RegMMHc(I + 1, JF)
        Gxx = Gxx + RegMMHc(I, JF).Gxx
        Gyy = Gyy + RegMMHc(I, JF).Gyy
        Gxy = CSom(Gxy, RegMMHc(I, JF).Gxy)
    Next I
    RegMMHc(NMedieHc, JF).Gxx = GxxN
    RegMMHc(NMedieHc, JF).Gyy = GyyN
    RegMMHc(NMedieHc, JF).Gxy = GxyN
    Gxx = Gxx / CDbl(NMedieHc)
    Gyy = Gyy / CDbl(NMedieHc)
    Gxy = CDiv(Gxy, CCmp(CDbl(NMedieHc), 0#))
'
    ' Calcolo la funzione di trasferimento
    ' del convertitore A/D ...:
    Hc(JF).Hc = CDiv(Gxy, CCmp(Gxx, 0))
    ' ... e la sua funzione di coerenza:
    GammaQHc(JF).GammaQ = (CAbs(Gxy) ^ 2) / (Gxx * Gyy)
    GammaQHc(JF).Fm = Hc(JF).Fm
'
    ' Calcolo il ritardo fra i canali di ingresso ...:
    Hc(JF).Td = CArg(Hc(JF).Hc) / (PI2 * Hc(JF).Fm) ' [s].
    ' ... ed il rapporto di guadagno:
    Hc(JF).Gd = CAbs(Hc(JF).Hc)
'
'
'
End Sub
Private Sub AbilitaKCalFs()
'
'   Abilito solo il coefficiente corrispondente
'   alla frequenza di campionamento corrente:
'
    txtKCal08k.Enabled = False
    txtKCal11k.Enabled = False
    txtKCal22k.Enabled = False
    txtKCal32k.Enabled = False
    txtKCal44k.Enabled = False
    txtKCal48k.Enabled = False
'
    Select Case Fs
    Case 8000
        txtKCal08k.Enabled = True
    Case 11025, 16000
        txtKCal11k.Enabled = True
    Case 22050, 24000
        txtKCal22k.Enabled = True
    Case 32000
        txtKCal32k.Enabled = True
    Case 44100
        txtKCal44k.Enabled = True
    Case Is >= 48000
        txtKCal48k.Enabled = True
'
    Case Else
        txtKCal11k.Enabled = True
    End Select
'
'
'
End Sub
Private Sub txtUi_Ch_Change(Index As Integer)
'
'
    AbilitaApplica True, False
'
'
'
End Sub

Private Function CalcolaKCal() As Boolean
'
'   Calcola il KCal di calibrazione per la sola frequenza F1 (1 kHz).
'   Nota: il calcolo degli spettri dei segnali acquisiti serve solo
'         per verificare la validita' dei segnali in ingresso usati
'         per la calibrazione.
'
'   Versione per AudioCardDSP.
'
    Dim I&, IChS&, K&, NF&
    Dim DFs#, Data%(), Win#()
    Dim Freq#(), SpMaxCh#(1 To 2)
    Dim D1#(), R1#(), X1#()
    Dim D2#(), R2#(), X2#()
    Dim VMin1#, VMax1#, VMin2#, VMax2#
    Dim VAmp1#, VAmp2#
'
    Const Ich& = 1  ' Canale del trigger (sinistro).
'
    On Error GoTo CalcolaKCal_ERR
'
    NF = 1  ' C' e' un solo punto di frequenza.
'
    DFs = Fs / CDbl(NVAL)   ' Risoluzione in frequenza degli spettri [Hz].
'
    ReDim Freq(0 To NVAL / 2)
    ReDim Hc(1 To NF) As Hc_Type
    ReDim D1(0 To NVAL - 1), R1(1 To NF), X1(1 To NF)
    ReDim D2(0 To NVAL - 1), R2(1 To NF), X2(1 To NF)
'
    ' Calcolo il profilo di "Window":
    Win() = WinProf("Hanning", NVAL)
'
    For K = 1 To NMedieKc
        lblNMediaKCal.Caption = "N media: " & K
        ' Acquisisco i segnali di misura:
        If (Not Acquisizione(NVAL, Data(), Fs, 1, Ich, 0, TStab_SB)) Then
            Err.Raise 1001, , "Acquisizione"
        End If
'
        ' Sposto i dati acquisiti nei
        ' vettori da analizzare:
        For I = 1 To NVAL
            D1(I - 1) = CDbl(Data(1, I))
            D2(I - 1) = CDbl(Data(2, I))
        Next I
'
        ' Calcolo i valori massimi e minimi dei
        ' dati contenuti nel vettore Data():
        VMin1 = V16Max
        VMax1 = V16Min
        VMin2 = V16Max
        VMax2 = V16Min
'
        For I = 0 To NVAL - 1
            If (D1(I) < VMin1) Then VMin1 = D1(I)
            If (VMax1 < D1(I)) Then VMax1 = D1(I)
            If (D2(I) < VMin2) Then VMin2 = D2(I)
            If (VMax2 < D2(I)) Then VMax2 = D2(I)
        Next I
'
        ' Applico la "Window"; questo risultera' in
        ' un' ampiezza degli spettri pari circa alla
        ' meta' dei valori reali:
        For I = 0 To NVAL - 1
            D1(I) = Win(I) * D1(I)
            D2(I) = Win(I) * D2(I)
        Next I
'
        ' Calcolo gli spettri dei segnali in ingresso:
        FFT_D2 D1(), D2(), R1(), X1(), R2(), X2(), NVAL
'
        ' Trovo la frequenza di massima ampiezza per
        ' verificare la validita' dei segnali in ingresso:
        SpMaxCh(1) = 0#
        For I = 0 To NVAL / 2
            Freq(I) = CDbl(I) * DFs
'
            If (SpMaxCh(1) < (R1(I) * R1(I) + X1(I) * X1(I))) Then
                SpMaxCh(1) = (R1(I) * R1(I) + X1(I) * X1(I))
                SpMaxCh(2) = (R2(I) * R2(I) + X2(I) * X2(I))
                Hc(1).Fm = Freq(I)
            End If
        Next I
'
        ' Solo per debug:
'        IChS = 1
'        frmCurve.DisegnaSpettroCalibrazione Freq(), R1(), X1(), R2(), X2(), _
'                                            NVAL / 2, IChS, SpMaxCh(IChS)
'
        ' Verifico la validita' dei segnali in ingresso:
        If (Hc(1).Fm < 900) Or (1100 < Hc(1).Fm) _
        Or (SpMaxCh(2) < 0.7 * SpMaxCh(1)) Or (1.3 * SpMaxCh(1) < SpMaxCh(2)) Then
            Err.Raise 1002, , "Segnali in ingresso con ampiezze" & vbNewLine _
                            & "e/o frequenze non valide."
        End If
'
        ' Calcolo la sommatoria delle ampiezze dei segnali acquisiti:
        VAmp1 = VAmp1 + (VMax1 - VMin1) / 2#
        VAmp2 = VAmp2 + (VMax2 - VMin2) / 2#
'
        prgCalcolo.Value = K
        DoEvents
    Next K
'
    ' Calcolo il KCal del canale #1 ...:
    KCal_C = CDbl(NMedieKc) / VAmp1
    ' ... ed il rapporto di guadagno
    ' fra i due canali:
    V2V1_C = VAmp2 / VAmp1
'
'
CalcolaKCal_ERR:
    lblNMediaKCal.Caption = ""
    CalcolaKCal = (Err.Number = 0)
'
    If (Err.Number <> 0) Then
        Dim M$
        M$ = "Errore " & Str$(Err.Number) & vbNewLine
        M$ = M$ & Err.Description
        MsgBox M$, vbCritical, " frmCalibrazione: CalcolaKCal"
    End If
'
'
'
End Function
