VERSION 5.00
Object = "{FE0065C0-1B7B-11CF-9D53-00AA003C9CB6}#1.1#0"; "COMCT232.OCX"
Begin VB.Form frmCepstrum 
   BorderStyle     =   1  'Fixed Single
   Caption         =   " Cepstrum"
   ClientHeight    =   5820
   ClientLeft      =   45
   ClientTop       =   615
   ClientWidth     =   8835
   Icon            =   "frmCepstrum.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MDIChild        =   -1  'True
   ScaleHeight     =   388
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   589
   Begin VB.Frame fraCursori 
      Caption         =   "C&ursors:"
      Height          =   615
      Left            =   3660
      TabIndex        =   0
      Top             =   0
      Width           =   3075
      Begin VB.CheckBox chkCursori 
         Alignment       =   1  'Right Justify
         Caption         =   "    "
         Height          =   195
         Left            =   1290
         TabIndex        =   1
         Top             =   0
         Width           =   345
      End
      Begin VB.Label lblDeltaXC 
         Alignment       =   1  'Right Justify
         BackStyle       =   0  'Transparent
         Caption         =   "dT:"
         Height          =   255
         Left            =   15
         TabIndex        =   35
         Top             =   255
         Width           =   315
      End
      Begin VB.Label lblDeltaXU 
         BackStyle       =   0  'Transparent
         Caption         =   "s"
         Height          =   255
         Left            =   1095
         TabIndex        =   34
         Top             =   255
         Width           =   375
      End
      Begin VB.Label lblDeltaX 
         BorderStyle     =   1  'Fixed Single
         Caption         =   "--"
         Height          =   255
         Left            =   360
         TabIndex        =   33
         Top             =   240
         Width           =   675
      End
      Begin VB.Label lblDeltaY 
         BorderStyle     =   1  'Fixed Single
         Caption         =   "--"
         Height          =   255
         Left            =   1950
         TabIndex        =   32
         Top             =   240
         Width           =   675
      End
      Begin VB.Label lblDeltaYU 
         BackStyle       =   0  'Transparent
         Caption         =   "Vi"
         Height          =   255
         Left            =   2670
         TabIndex        =   31
         Top             =   255
         Width           =   375
      End
      Begin VB.Label lblDeltaYC 
         Alignment       =   1  'Right Justify
         BackStyle       =   0  'Transparent
         Caption         =   "dVi:"
         Height          =   255
         Left            =   1590
         TabIndex        =   30
         Top             =   255
         Width           =   315
      End
      Begin VB.Line zLine3 
         BorderColor     =   &H80000010&
         X1              =   1530
         X2              =   1530
         Y1              =   0
         Y2              =   540
      End
   End
   Begin VB.Frame zFrame2 
      Caption         =   "Display:"
      Height          =   615
      Left            =   6120
      TabIndex        =   11
      Top             =   5100
      Width           =   2535
      Begin VB.OptionButton optDisegnaLogSx 
         Caption         =   "&Log(Sx)"
         Height          =   255
         Left            =   1380
         TabIndex        =   13
         Top             =   240
         Width           =   915
      End
      Begin VB.OptionButton optDisegnaCepstrum 
         Caption         =   "&Cepstrum"
         Height          =   255
         Left            =   180
         TabIndex        =   12
         Top             =   240
         Width           =   975
      End
   End
   Begin VB.Frame fraTSoglia 
      Caption         =   "Pitch threshold:"
      Height          =   615
      Left            =   4020
      TabIndex        =   8
      Top             =   5100
      Width           =   1935
      Begin VB.TextBox txtTSoglia 
         Height          =   285
         Left            =   600
         TabIndex        =   10
         ToolTipText     =   " Invio per confermare "
         Top             =   240
         Width           =   1035
      End
      Begin VB.Label zLabel05 
         BackStyle       =   0  'Transparent
         Caption         =   "s"
         Height          =   255
         Left            =   1740
         TabIndex        =   26
         Top             =   255
         Width           =   210
      End
      Begin VB.Label lblTMin 
         BackStyle       =   0  'Transparent
         Caption         =   "T&min:"
         Height          =   255
         Left            =   120
         TabIndex        =   9
         Top             =   255
         Width           =   555
      End
   End
   Begin VB.PictureBox picCopia 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      BackColor       =   &H80000005&
      BorderStyle     =   0  'None
      ForeColor       =   &H80000008&
      Height          =   435
      Left            =   7920
      ScaleHeight     =   29
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   33
      TabIndex        =   24
      Top             =   960
      Visible         =   0   'False
      Width           =   495
   End
   Begin VB.Frame zFrame1 
      Caption         =   "Scales:"
      Height          =   615
      Left            =   180
      TabIndex        =   21
      Top             =   5100
      Width           =   3675
      Begin ComCtl2.UpDown updScaleX 
         Height          =   240
         Left            =   1050
         TabIndex        =   4
         TabStop         =   0   'False
         Top             =   240
         Width           =   300
         _ExtentX        =   529
         _ExtentY        =   423
         _Version        =   327681
         Orientation     =   1
         Enabled         =   -1  'True
      End
      Begin ComCtl2.UpDown updScaleY 
         Height          =   255
         Left            =   2670
         TabIndex        =   7
         TabStop         =   0   'False
         Top             =   240
         Width           =   240
         _ExtentX        =   423
         _ExtentY        =   450
         _Version        =   327681
         Enabled         =   -1  'True
      End
      Begin VB.Label lblScaleY 
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Left            =   2040
         TabIndex        =   6
         Top             =   240
         Width           =   615
      End
      Begin VB.Label zLabel03 
         Alignment       =   1  'Right Justify
         Caption         =   "Y:"
         Height          =   255
         Left            =   1680
         TabIndex        =   5
         Top             =   255
         Width           =   255
      End
      Begin VB.Label lblScaleYU 
         BackStyle       =   0  'Transparent
         Caption         =   "Vi"
         Height          =   255
         Left            =   3000
         TabIndex        =   23
         Top             =   255
         Width           =   630
      End
      Begin VB.Label lblScaleX 
         BorderStyle     =   1  'Fixed Single
         Height          =   255
         Left            =   420
         TabIndex        =   3
         Top             =   240
         Width           =   615
      End
      Begin VB.Label zLabel01 
         Alignment       =   1  'Right Justify
         Caption         =   "X:"
         Height          =   255
         Left            =   60
         TabIndex        =   2
         Top             =   255
         Width           =   255
      End
      Begin VB.Label lblScaleXU 
         BackStyle       =   0  'Transparent
         Caption         =   "s"
         Height          =   255
         Left            =   1425
         TabIndex        =   22
         Top             =   255
         Width           =   390
      End
   End
   Begin VB.PictureBox picSchermo 
      AutoRedraw      =   -1  'True
      BackColor       =   &H00000000&
      Height          =   4275
      Left            =   180
      MousePointer    =   2  'Cross
      ScaleHeight     =   4215
      ScaleWidth      =   8415
      TabIndex        =   14
      TabStop         =   0   'False
      Top             =   720
      Width           =   8475
      Begin VB.Label lblCursoreX 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         Caption         =   "0.000E-00"
         BeginProperty Font 
            Name            =   "Small Fonts"
            Size            =   6.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   210
         Index           =   1
         Left            =   3720
         MousePointer    =   1  'Arrow
         TabIndex        =   39
         Top             =   405
         Visible         =   0   'False
         Width           =   735
      End
      Begin VB.Label lblCursoreX 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         Caption         =   "0.000E-00"
         BeginProperty Font 
            Name            =   "Small Fonts"
            Size            =   6.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   210
         Index           =   2
         Left            =   4380
         MousePointer    =   1  'Arrow
         TabIndex        =   38
         Top             =   645
         Visible         =   0   'False
         Width           =   735
      End
      Begin VB.Label lblCursoreY 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         Caption         =   "0.000E-00"
         BeginProperty Font 
            Name            =   "Small Fonts"
            Size            =   6.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   210
         Index           =   1
         Left            =   7200
         MousePointer    =   1  'Arrow
         TabIndex        =   37
         Top             =   1725
         Visible         =   0   'False
         Width           =   735
      End
      Begin VB.Label lblCursoreY 
         Alignment       =   2  'Center
         BorderStyle     =   1  'Fixed Single
         Caption         =   "0.000E-00"
         BeginProperty Font 
            Name            =   "Small Fonts"
            Size            =   6.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   210
         Index           =   2
         Left            =   6420
         MousePointer    =   1  'Arrow
         TabIndex        =   36
         Top             =   2805
         Visible         =   0   'False
         Width           =   735
      End
      Begin VB.Line linCursoreX 
         BorderColor     =   &H00FF00FF&
         BorderStyle     =   2  'Dash
         Index           =   1
         Visible         =   0   'False
         X1              =   4080
         X2              =   4080
         Y1              =   0
         Y2              =   3840
      End
      Begin VB.Line linCursoreX 
         BorderColor     =   &H00FF00FF&
         BorderStyle     =   2  'Dash
         Index           =   2
         Visible         =   0   'False
         X1              =   4740
         X2              =   4740
         Y1              =   0
         Y2              =   3840
      End
      Begin VB.Line linCursoreY 
         BorderColor     =   &H00FF00FF&
         BorderStyle     =   2  'Dash
         Index           =   2
         Visible         =   0   'False
         X1              =   720
         X2              =   8340
         Y1              =   2925
         Y2              =   2925
      End
      Begin VB.Line linCursoreY 
         BorderColor     =   &H00FF00FF&
         BorderStyle     =   2  'Dash
         Index           =   1
         Visible         =   0   'False
         X1              =   720
         X2              =   8340
         Y1              =   1845
         Y2              =   1845
      End
      Begin VB.Shape shpEsclusione 
         BorderColor     =   &H000000FF&
         FillColor       =   &H000000FF&
         FillStyle       =   5  'Downward Diagonal
         Height          =   3795
         Left            =   480
         Top             =   240
         Width           =   615
      End
   End
   Begin VB.Label lblT 
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   360
      TabIndex        =   29
      Top             =   255
      Width           =   525
   End
   Begin VB.Label zLabel02 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "T:"
      Height          =   180
      Left            =   120
      TabIndex        =   28
      Top             =   240
      Width           =   195
   End
   Begin VB.Label lblTU 
      BackStyle       =   0  'Transparent
      Caption         =   "s"
      Height          =   180
      Left            =   960
      TabIndex        =   27
      Top             =   240
      Width           =   330
   End
   Begin VB.Label lblAutore 
      Alignment       =   2  'Center
      BackColor       =   &H00C08000&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "F. Languasco fecit - 2010"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   195
      Left            =   6840
      TabIndex        =   25
      Top             =   405
      Width           =   1815
   End
   Begin VB.Label lblFU 
      BackStyle       =   0  'Transparent
      Caption         =   "Hz"
      Height          =   180
      Left            =   2100
      TabIndex        =   20
      Top             =   210
      Width           =   450
   End
   Begin VB.Label zLabel04 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "F:"
      Height          =   180
      Left            =   1245
      TabIndex        =   19
      Top             =   240
      Width           =   195
   End
   Begin VB.Label lblF 
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   1500
      TabIndex        =   18
      Top             =   255
      Width           =   525
   End
   Begin VB.Label lblYU 
      BackStyle       =   0  'Transparent
      Caption         =   "Vi"
      Height          =   180
      Left            =   3300
      TabIndex        =   17
      Top             =   240
      Width           =   450
   End
   Begin VB.Label lblYC 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Y:"
      Height          =   180
      Left            =   2460
      TabIndex        =   16
      Top             =   240
      Width           =   195
   End
   Begin VB.Label lblY 
      BorderStyle     =   1  'Fixed Single
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   2700
      TabIndex        =   15
      Top             =   255
      Width           =   525
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File del Cepstrum"
      Begin VB.Menu mnuStampa 
         Caption         =   "Sta&mpa"
      End
      Begin VB.Menu mnuCopiaSchermoInAppunti 
         Caption         =   "Copia schermo negli &Appunti"
      End
      Begin VB.Menu mnuCopiaStrumentoInAppunti 
         Caption         =   "Copia strumento &negli Appunti"
      End
      Begin VB.Menu zSep01 
         Caption         =   "-"
      End
      Begin VB.Menu mnuCambiaTitolo 
         Caption         =   "Cambia &Titolo"
      End
      Begin VB.Menu zSep02 
         Caption         =   "-"
      End
      Begin VB.Menu mnuEsci 
         Caption         =   "&Esci"
      End
   End
   Begin VB.Menu mnuCalibrazione 
      Caption         =   "Calibrazione"
   End
   Begin VB.Menu mnuPreferenze 
      Caption         =   "Preferen&ze"
   End
   Begin VB.Menu mnuStrumenti 
      Caption         =   "Strumenti"
      WindowList      =   -1  'True
      Begin VB.Menu mnuHtCurveFitter 
         Caption         =   "&Ht(f) curve fitter"
      End
   End
   Begin VB.Menu mnuQM 
      Caption         =   "&?"
      Begin VB.Menu mnuIstruzioni 
         Caption         =   "&Istruzioni"
      End
      Begin VB.Menu zSep03 
         Caption         =   "-"
      End
      Begin VB.Menu mnuInformazioni 
         Caption         =   "Informazioni su &AudioCardDSP"
      End
   End
End
Attribute VB_Name = "frmCepstrum"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'=======================================================================================
' Descrizione.....: Form per il calcolo del Cepstrum con
'                   "Fundamental Frequency Estimation" (F0).
' Nome dei Files..: frmCepstrum.frm, frmCepstrum.frx,
'                   frmASpettro.frm, frmASpettro.frx,
'                   frmCalibrazione.frm, frmCalibrazione.frx,
'                   frmPreferenze.frm, frmPreferenze.frx,
'                   frmStampaFCPB.frm, frmStampaFCPB.frx,
'                   frmIstruzioni.frm, frmIstruzioni.frx,
'                   frmInfoCr.frm, frmInfoCr.frx,
'                   modDSP.bas, modUtilita.bas.
' Data............: 27/02/2010 (Ver. 1.0).
' Versione........: 1.0 a 32 Bits.
' Sistema.........: VB6 (SP5) sotto Windows XP (SP2).
' Scritto da......: F. Languasco 
' E-Mail..........: MC7061@mclink.it
' DownLoads a.....: http://www.flanguasco.org
'=======================================================================================
'
Option Explicit
'
Dim Fs#         ' Frequenza di campionamento del segnale Sxx() in ingresso [Hz].
Dim Fs_2#       ' Fs / 2.
Dim NFRQ&       ' N di frequenze nel vettore Sxx() in ingresso.
'
Dim Titolo$     ' Titolo dello schermo.
'
Dim AMaxCe#     ' Ampiezza massima sul grafico del Cepstrum [Vi].
Dim AMaxLg#     ' Ampiezza massima sul grafico del Log(Sx) [Log(Vi)].
Dim TMax#       ' Tempo massimo sul grafico del Cepstrum [s].
Dim FMax#       ' Frequenza massima sul grafico del Log(Sx) [Hz].
'
Dim TSoglia#    ' Tempo di soglia per la ricerca dell' F0 [s].
Dim IQSoglia&   ' Indice della "quefrency" corrispomdente al tempo di soglia [campioni].
'
Dim LogSx#()        ' Vettore del logaritmo dello spettro di ampiezza [Log(Vi)].
'
Dim CpstrmNQFR&     ' N di "quefrencies" nei vettori CpstrmRe(), CpstrmIm()
                    ' CpstrmAmp() e CpstrmPha().
'
Dim CpstrmRe#()     ' Vettore della componente reale del Cepstrum [s].
Dim CpstrmIm#()     '    "      "       "      immaginaria del Cepstrum [s]
'
Dim CpstrmAmp#()    ' Vettore delle ampiezze del Cepstrum [Log(Vi)].
Dim CpstrmPha#()    '    "      "   fasi del Cepstrum [rad].
'
Dim CpstrmNQ&                   ' N di "quefrencies" da disegnare per Cepstrum.
Dim CpstrmNQ1&                  ' CpstrmNQ + 1.
Dim LogSxNF&                    ' N di frequenze da disegnare per Log(Sx).
Dim LogSxNF1&                   ' LogSxNF + 1.
'
Dim IQF0&                       ' Indice della "quefrency" corispondente all' F0.
Dim CpstrmF0#                   ' Valore del Cepstrum a IQF0.
'
Dim bDisegnaCepstrum As Boolean ' True  = disegna il Cepstrum;
                                ' False = disegna il Log(Sx).
'
Dim bMeLoaded As Boolean        ' Flag di Form gia' caricato.
Dim bCursoriOn As Boolean       ' Flag di cursori di misura visibili.
'
Dim CePosPixXY() As POINTAPI    ' Vettore CePosPixXY(0 To CpstrmNQ) delle posizioni
                                ' orizzontali e verticali dei campioni del Cepstrum [Pixels].
Dim LgPosPixXY() As POINTAPI    ' Vettore LgPosPixXY(0 To LogSxNF) delle posizioni
                                ' orizzontali e verticali dei campioni del Log(Sx) [Pixels].
'
Dim XMinR!, XMaxR!  ' Ascisse min. e max. del reticolo [vbUser].
Dim YMinR!, YMaxR!  ' Ordinate "   "  "    "     "        "
'
Dim X_1Px!          ' Dimensioni in scala di un Pixel in orizzontale
Dim Y_1Px!          ' e verticale [vbUser].
'
Dim F0XPos&         ' Posizione orizzontale della scritta F0 [Pixels].
Dim F0YPos&         ' Posizione verticale della scritta F0 [Pixels].
'
Dim lblCursoreX_W2! ' Semilarghezza delle etichette di posizione dei cursori orizzontali [vbUser].
Dim lblCursoreY_H2! ' Semialtezza delle etichette di posizione dei cursori verticali [vbUser].
'
Const ColF0& = vbGreen  ' Colore dei riferimenti dell' F0.
'
Dim Mantissa$, Prefisso$    ' In (Declarations), per risparmiare tempo
                            ' nelle routines che usano la Sub FormatPrf.
'
'---------------------------------------------------------------------------------------
'
Dim Ax!, Bx!            ' Coefficienti di trasformazione delle scale
Dim Ay!, By!            ' per disegnare Cepstrum e Log(Sx) con API.
'
Dim picSchermo_PixW&    ' Larghezza di picSchermo [Pixels].
Dim picSchermo_PixH&    ' Altezza di picSchermo [Pixels].
'
Dim hDCh_Q&, hBmp_Q&    ' CompatibleDC e CompatibleBitmap del disegno del quadro.
Dim hDCh_S&, hBmp_S&    ' CompatibleDC e CompatibleBitmap del disegno di Cepstrum e Log(Sx).
'
Dim hVista_T&           ' Clip Region del rettangolo contenente tutto lo schermo.
Dim hVista_R&           ' Clip Region del rettangolo contenente solo il reticolo.
'
Dim Rect_CO As RECT     ' Rettangolo dei cursori orizzontali.
Dim Rect_CV As RECT     ' Rettangolo dei cursori verticali.
Dim Rect_MI As RECT     ' Rettangolo dell' area di misura.
Dim Rect_SO As RECT     ' Rettangolo dell' area esclusa dal calcolo dell' F0 .
'
Dim hPen_Mfn&           ' Handles delle "penne" per il disegno del Cepstrum.
Dim hPen_F0&            '    "      "      "     "  "     "   dell' F0.
Dim hFont&              ' Handle del Font delle scritte sullo schermo.
Dim hPen_Prof&          ' Handles delle "penne" per il disegno del Log(Sx).
Dim hBrush_F0&          ' Handle del "pennello" di disegno dell' F0.
'
'-- Dichiarazioni, costanti e tipi per API: --------------------------------------------
'
Private Declare Function GetTickCount Lib "kernel32" () As Long
'
Private uPeriod As Long ' Risoluzione del timer timeGetTime [ms].
Private Declare Function timeGetTime Lib "winmm.dll" () As Long
Private Declare Function timeBeginPeriod Lib "winmm.dll" (ByVal uPeriod As Long) As Long
Private Declare Function timeEndPeriod Lib "winmm.dll" (ByVal uPeriod As Long) As Long
Private Const TIMERR_BASE& = 96                     '  was 128, changed to match Win 31 Sonic
Private Const TIMERR_NOERROR& = 0                   '  no error
Private Const TIMERR_NOCANDO& = (TIMERR_BASE + 1)   '  request not completed
'
Private Const DRAFT_QUALITY& = 1
Private Const PROOF_QUALITY& = 2
Private Const LF_FACESIZE& = 32
'
Private Type LOGFONT
    lfHeight As Long
    lfWidth As Long
    lfEscapement As Long
    lfOrientation As Long
    lfWeight As Long
    lfItalic As Byte
    lfUnderline As Byte
    lfStrikeOut As Byte
    lfCharSet As Byte
    lfOutPrecision As Byte
    lfClipPrecision As Byte
    lfQuality As Byte
    lfPitchAndFamily As Byte
    lfFaceName As String * LF_FACESIZE
End Type
'
Private Type POINTAPI
     X As Long          ' [Pixels].
     Y As Long          '     "
End Type
'
Private Type RECT
    Left  As Long       ' [Pixels].
    Top  As Long        '     "
    Right  As Long      '     "
    Bottom  As Long     '     "
End Type
'
Private Type LOGBRUSH
        lbStyle As Long
        lbColor As Long
        lbHatch As Long
End Type
'
Private Declare Function DeleteDC Lib "gdi32" (ByVal hdc As Long) As Long
'
Private Declare Function CreateCompatibleDC Lib "gdi32" _
    (ByVal hdc As Long) As Long
'
Private Declare Function CreateCompatibleBitmap Lib "gdi32" (ByVal hdc As Long, _
    ByVal nWidth As Long, ByVal nHeight As Long) As Long
'
Private Const PS_SOLID& = 0
'
Private Declare Function CreatePen Lib "gdi32" (ByVal nPenStyle As Long, _
    ByVal nWidth As Long, ByVal crColor As Long) As Long
'
Private Const BS_NULL& = 1
'
Private Declare Function CreateBrushIndirect Lib "gdi32" (lpLogBrush As LOGBRUSH) As Long
'
Private Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long
'
Private Declare Function SelectObject Lib "gdi32" _
    (ByVal hdc As Long, _
    ByVal hObject As Long) As Long
'
Private Declare Function Rectangle Lib "gdi32" (ByVal hdc As Long, _
    ByVal X1 As Long, ByVal Y1 As Long, _
    ByVal X2 As Long, ByVal Y2 As Long) As Long
'
Private Declare Function Ellipse Lib "gdi32" (ByVal hdc As Long, _
    ByVal X1 As Long, ByVal Y1 As Long, _
    ByVal X2 As Long, ByVal Y2 As Long) As Long
'
Private Declare Function MoveToEx Lib "gdi32" (ByVal hdc As Long, _
    ByVal X As Long, ByVal Y As Long, ByVal lpPoint As Long) As Long
'
Private Declare Function LineTo Lib "gdi32" (ByVal hdc As Long, _
    ByVal X As Long, ByVal Y As Long) As Long
'
Private Declare Function Polyline Lib "gdi32" (ByVal hdc As Long, _
    lpPoint As POINTAPI, ByVal nCount As Long) As Long
'
Private Declare Function CreateFontIndirect Lib "gdi32" Alias "CreateFontIndirectA" _
    (lpLogFont As LOGFONT) As Long
'
Private Declare Function SetTextColor Lib "gdi32" _
    (ByVal hdc As Long, ByVal crColor As Long) As Long
Private Declare Function SetBkColor Lib "gdi32" _
    (ByVal hdc As Long, ByVal crColor As Long) As Long
'
Private Declare Function TextOut Lib "gdi32" Alias "TextOutA" _
    (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long, _
    ByVal lpString As String, ByVal nCount As Long) As Long
'
Private Const SRCCOPY& = &HCC0020   ' (DWORD) dest = source
'
Private Declare Function BitBlt Lib "gdi32" _
    (ByVal hDestDC As Long, ByVal X As Long, ByVal Y As Long, _
    ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, _
    ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
'
Private Declare Function GetCursorPos Lib "USER32" (lpPoint As POINTAPI) As Long
Private Declare Function ScreenToClient Lib "USER32" (ByVal hWnd As Long, _
    lpPoint As POINTAPI) As Long
Private Declare Function ClientToScreen Lib "USER32" (ByVal hWnd As Long, _
    lpPoint As POINTAPI) As Long
'
Private Declare Function PtInRect Lib "USER32" _
    (lpRECT As RECT, ByVal X As Long, ByVal Y As Long) As Long
'
Private Const RDW_UPDATENOW& = &H100
Private Const RDW_INVALIDATE& = &H1
Private Const fuRedraw& = RDW_UPDATENOW Or RDW_INVALIDATE
'
Private Declare Function RedrawWindow Lib "USER32" _
    (ByVal hWnd As Long, lprcUpdate As Any, ByVal hrgnUpdate As Long, _
    ByVal fuRedraw As Long) As Long
Private Function TrovaCursoreX(ByVal X As Single) As Long
'
'   Trova il cursore verticale piu' vicino a X:
'
    If (Abs(X - linCursoreX(1).X1) < Abs(X - linCursoreX(2).X1)) Then
        TrovaCursoreX = 1
    Else
        TrovaCursoreX = 2
    End If
'
'
'
End Function
Private Function TrovaCursoreY(ByVal Y As Single) As Long
'
'   Trova il cursore orizzontale piu' vicino a Y:
'
    If (Abs(Y - linCursoreY(1).Y1) < Abs(Y - linCursoreY(2).Y1)) Then
        TrovaCursoreY = 1
    Else
        TrovaCursoreY = 2
    End If
'
'
'
End Function
Private Sub CalcolaCursoriX()
'
'   Calcola la differenza ed i valori corrispondenti
'   alla posizione dei cursori verticali:
'
    Dim CX1!, CX2!
'
    On Error Resume Next    ' Per evitare l' errore di 1 / 0,
                            ' quando i due cursori coincidono.
'
    CX1 = linCursoreX(1).X1
    CX2 = linCursoreX(2).X1
'
    If bDisegnaCepstrum Then
        FormatPrf (CX2 - CX1), Mantissa$, Prefisso$, "0.00E+00"
        lblDeltaX.Caption = Mantissa$
        lblDeltaXU = Prefisso$ & "s"
'
        FormatPrf 1! / (CX2 - CX1), Mantissa$, Prefisso$, "0.00E+00"
        lblDeltaX.ToolTipText = " Freq. = " & Mantissa$ & " " & Prefisso$ & "Hz "
'
        FormatPrf CX1, Mantissa$, Prefisso$, "0.00E+00"
        lblCursoreX(1).Caption = Mantissa$ & " " & Prefisso$ & "s"
'
        FormatPrf CX2, Mantissa$, Prefisso$, "0.00E+00"
        lblCursoreX(2).Caption = Mantissa$ & " " & Prefisso$ & "s"
'
    Else
        FormatPrf (CX2 - CX1), Mantissa$, Prefisso$, "0.00E+00"
        lblDeltaX.Caption = Mantissa$
        lblDeltaXU = Prefisso$ & "Hz"
'
        FormatPrf 1! / (CX2 - CX1), Mantissa$, Prefisso$, "0.00E+00"
        lblDeltaX.ToolTipText = " T = " & Mantissa$ & " " & Prefisso$ & "s "
'
        FormatPrf CX1, Mantissa$, Prefisso$, "0.00E+00"
        lblCursoreX(1).Caption = Mantissa$ & " " & Prefisso$ & "Hz"
'
        FormatPrf CX2, Mantissa$, Prefisso$, "0.00E+00"
        lblCursoreX(2).Caption = Mantissa$ & " " & Prefisso$ & "Hz"
    End If
'
'
    If (Err.Number <> 0) Then Err.Clear
'
'
'
End Sub
Private Sub CalcolaCursoriY()
'
'   Calcola la differenza ed i valori corrispondenti
'   alla posizione dei cursori orizzontali:
'
    Dim CY1!, CY2!
'
    CY1 = linCursoreY(1).Y1
    CY2 = linCursoreY(2).Y1
'
    If bCepstrum Then
        FormatPrf (CY1 - CY2), Mantissa$, Prefisso$, "0.00E+00"
        lblDeltaY.Caption = Mantissa$
        lblDeltaYU.Caption = Prefisso$ & "Vi"
'
        FormatPrf CY1, Mantissa$, Prefisso$, "0.00E+00"
        lblCursoreY(1).Caption = Mantissa$ & " " & Prefisso$ & "Vi"
'
        FormatPrf CY2, Mantissa$, Prefisso$, "0.00E+00"
        lblCursoreY(2).Caption = Mantissa$ & " " & Prefisso$ & "Vi"
'
    Else
        FormatPrf (CY1 - CY2), Mantissa$, Prefisso$, "0.00E+00"
        lblDeltaY.Caption = Mantissa$
        lblDeltaYU.Caption = Prefisso$ & "Vi"
'
        FormatPrf CY1, Mantissa$, Prefisso$, "0.00E+00"
        lblCursoreY(1).Caption = Mantissa$ & " " & Prefisso$ & "Vi"
'
        FormatPrf CY2, Mantissa$, Prefisso$, "0.00E+00"
        lblCursoreY(2).Caption = Mantissa$ & " " & Prefisso$ & "Vi"
    End If
'
'
'
End Sub
Public Sub Apri(ByVal Fs_I As Double, ByVal NFRQ_I As Long)
'
'
    Fs = Fs_I
    Fs_2 = Fs / 2#
    NFRQ = NFRQ_I
    ReDim LogSx(0 To NFRQ)
'
    If Not bMeLoaded Then
        Me.Show
'
        TMax = NFRQ / Fs
        FMax = Fs_2
    End If
'
    If (NFRQ / Fs < TMax) Then
        TMax = NFRQ / Fs
    End If
    CpstrmNQ = TMax * Fs_2
'
    If (Fs_2 < FMax) Then
        FMax = Fs_2
    End If
    LogSxNF = NFRQ * FMax / Fs_2
'
    txtTSoglia_KeyPress vbKeyEscape
'
    If bDisegnaCepstrum Then
        FormatPrf TMax, Mantissa$, Prefisso$
        lblScaleX.Caption = Mantissa$
        lblScaleXU.Caption = Prefisso$ & "s"
'
        FormatPrf AMaxCe, Mantissa$, Prefisso$
        lblScaleY.Caption = Mantissa$
        lblScaleYU.Caption = Prefisso$ & "Log(Vi)"
'
        DisegnaQuadroCepstrum
        DisegnaCepstrum
    Else
        FormatPrf FMax, Mantissa$, Prefisso$
        lblScaleX.Caption = Mantissa$
        lblScaleXU.Caption = Prefisso$ & "Hz"
'
        FormatPrf AMaxLg, Mantissa$, Prefisso$
        lblScaleY.Caption = Mantissa$
        lblScaleYU.Caption = Prefisso$ & "Log(Vi)"
'
        DisegnaQuadroLogSx
        DisegnaLogSx
    End If
'
'
'
End Sub
Public Sub Cepstrum(Sxx() As Double)
'
'   Calcola il Cepstrum dello spettro di ampiezza Sqr(Sxx()):
'
    Dim I&
'
    On Error GoTo Cepstrum_ERR
'
    For I = 0 To NFRQ
        If (0 < Sxx(I)) Then
            LogSx(I) = Log(Sqr(Sxx(I)))
        Else
            LogSx(I) = -10
        End If
    Next I
'
    'LogSx() = EliminaCC(LogSx())    ' Per prove.
    FFT LogSx(), CpstrmRe(), CpstrmIm(), CpstrmAmp(), CpstrmPha(), NFRQ, CpstrmNQFR
'
    If bDisegnaCepstrum Then
        DisegnaCepstrum
'
    Else
        DisegnaLogSx
    End If
'
    Exit Sub
'
'
Cepstrum_ERR:
    Err.Clear
'
'
'
End Sub
Private Sub DisegnaQuadroCepstrum()
'
'   Dimensiona e disegna il quadro dello schermo
'   per la rappresentazione del Cepstrum.
'
    Dim I&, QxMin!, QxMax!, QyMin!, QyMax!, lRet&, Txt$
    Dim lpLogFont As LOGFONT, lpLogBrush As LOGBRUSH
'
    On Error Resume Next    ' Serve in fase di inizializzazione.
'
    picSchermo.ScaleMode = vbPixels
    picSchermo_PixW = picSchermo.ScaleWidth
    picSchermo_PixH = picSchermo.ScaleHeight
'
    ' Preparo il quadro:
    Quadro picSchermo, 0, 0, TMax, AMaxCe, "0.000E+00", "0.000E+00", True, True, _
           1, X_1Px, Y_1Px, Titolo$, "s", "Log(Vi)", True, , , _
           XMinR, YMinR, XMaxR, YMaxR, QxMin, QyMin, QxMax, QyMax, _
           ColRet, ColSch, ColTit
'
    ' Disegno il riferimento del tempo di soglia:
    shpEsclusione.Left = XMinR + X_1Px
    shpEsclusione.Width = XMinR + TSoglia
    shpEsclusione.Top = YMaxR - Y_1Px
    shpEsclusione.Height = AMaxCe - Y_1Px
'
    ' Scrivo il numero di Quefrencies ...:
    ScrivoCome picSchermo, "Small Fonts", 7, False, ColRet
    Txt$ = "N. Quefrencies: " & NFRQ / 2
    picSchermo.CurrentX = XMaxR - picSchermo.TextWidth(Txt$ & "II")
    picSchermo.CurrentY = YMaxR - 2 * picSchermo.TextHeight("R")
    picSchermo.Print Txt$;
'
    ' ... e la frequenza di campionamento:
    Txt$ = "Sampling Freq: " & Fs & " Hz"
    picSchermo.CurrentX = XMaxR - picSchermo.TextWidth(Txt$ & "II")
    picSchermo.CurrentY = YMaxR + 13 * Y_1Px
    picSchermo.Print Txt$;
'
    ' Scritta "Fundamental Frequency":
    ScrivoCome picSchermo, "MS Sans Serif", 8, False, ColF0
    picSchermo.CurrentX = XMinR
    picSchermo.CurrentY = YMaxR + 15 * Y_1Px
    picSchermo.Print "  Fundamental Frequency: ";
'
    If bCursoriOn Then
        ' Calcolo la dimensione delle etichette
        ' dei cursori e ne aggiorno i valori:
        lblCursoreX_W2 = lblCursoreX(1).Width / 2!
        CalcolaCursoriX
        lblCursoreY_H2 = lblCursoreY(1).Height / 2!
        CalcolaCursoriY
    End If
'
'---------------------------------------------------------------------------------------
'   Preparo variabili, handles, etc... per disegnare
'   lo schermo con API.
'
    ' Calcolo i coefficienti di trasformazione da vbUser a vbPixels per
    ' evitare, nella Sub DisegnaCepstrum, l' uso dei metodi ScaleX e ScaleY.
    ' Coefficienti per la trasformazione delle ordinate:
    Ay = picSchermo_PixH / (QyMin - QyMax)
    By = picSchermo_PixH * QyMax / (QyMax - QyMin)
'
    ' Calcolo, in Pixels, le posizioni
    ' orizzontali dei campioni sullo schermo:
    CpstrmNQ1 = CpstrmNQ + 1
    ReDim CePosPixXY(0 To CpstrmNQ)
    For I = 0 To CpstrmNQ
        CePosPixXY(I).X = picSchermo.ScaleX((CDbl(I) / Fs_2) - picSchermo.ScaleLeft, _
                                            vbUser, vbPixels)
    Next I
'
    ' Posizione orizzontale e verticale, in Pixels, della scritta F0:
    F0XPos = picSchermo.ScaleX(picSchermo.CurrentX - picSchermo.ScaleLeft, _
                               vbUser, vbPixels)
    F0YPos = picSchermo.ScaleY(picSchermo.CurrentY - picSchermo.ScaleTop, _
                               vbUser, vbPixels)
'
    ' Elimino gli handles correnti:
    lRet = DeleteDC(hDCh_Q)
    lRet = DeleteDC(hDCh_S)
    lRet = DeleteObject(hBmp_Q)
    lRet = DeleteObject(hBmp_S)
    lRet = DeleteObject(hPen_Mfn)
    lRet = DeleteObject(hPen_F0)
    lRet = DeleteObject(hPen_Prof)
    lRet = DeleteObject(hBrush_F0)
    lRet = DeleteObject(hFont)
'
    ' BitMap del quadro:
    hDCh_Q = CreateCompatibleDC(picSchermo.hdc)
    hBmp_Q = CreateCompatibleBitmap(picSchermo.hdc, picSchermo_PixW, picSchermo_PixH)
    lRet = SelectObject(hDCh_Q, hBmp_Q)
'
    ' BitMap del Cepstrum:
    hDCh_S = CreateCompatibleDC(picSchermo.hdc)
    hBmp_S = CreateCompatibleBitmap(picSchermo.hdc, picSchermo_PixW, picSchermo_PixH)
    lRet = SelectObject(hDCh_S, hBmp_S)
'
    ' Creo il rettangolo dedicato alla
    ' misura del reticolo:
    Rect_MI = CreaRettangolo(picSchermo, XMinR, YMinR, XMaxR, YMaxR)
'
    ' Creo il rettangolo dedicato allo
    ' spostamento dei cursori verticali:
    Rect_CV = CreaRettangolo(picSchermo, XMinR, YMaxR, XMaxR, QyMax)
'
    ' Creo il rettangolo dedicato allo
    ' spostamento dei cursori orizzontali:
    Rect_CO = CreaRettangolo(picSchermo, XMaxR, YMinR, QxMax, YMaxR)
'
    ' Creo il rettangolo dedicato al
    ' riferimento dell' area esclusa:
    Rect_SO = CreaRettangolo(picSchermo, XMinR + X_1Px, YMinR, XMinR + TSoglia, YMaxR)
'
    ' Creo ed assegno il "Font" necessario
    ' alla scrittura dell' F0:
    lpLogFont.lfEscapement = 0
    lpLogFont.lfOrientation = 0
    lpLogFont.lfQuality = PROOF_QUALITY
    lpLogFont.lfFaceName = "MS Sans Serif" & Chr$(0)
    lpLogFont.lfWeight = 400
    lpLogFont.lfHeight = 10
    hFont = CreateFontIndirect(lpLogFont)
    lRet = SelectObject(hDCh_S, hFont)
'
    ' Imposto i colori delle
    ' scritte sullo schermo:
    SetTextColor hDCh_S, ColF0
    SetBkColor hDCh_S, ColSch
'
    ' Creo la "penna" necessaria al disegno del Cepstrum:
    hPen_Mfn = CreatePen(PS_SOLID, 1, ColMfn)
'
    ' Creo la "penna" necessaria alla scritta dell' F0:
    hPen_F0 = CreatePen(PS_SOLID, 1, ColF0)
'
    ' Creo il "brush" necessario al disegno dell' F0:
    lpLogBrush.lbStyle = BS_NULL
    lpLogBrush.lbColor = 0
    lpLogBrush.lbHatch = 0
'
    hBrush_F0 = CreateBrushIndirect(lpLogBrush)
    lRet = SelectObject(hDCh_S, hBrush_F0)
'
    ' Copio il quadro sull' hDCh_Q dello sfondo:
    lRet = BitBlt(hDCh_Q, 0, 0, picSchermo_PixW, picSchermo_PixH, _
                  picSchermo.hdc, 0, 0, SRCCOPY)
'
'
'
End Sub
Private Sub DisegnaCepstrum()
'
'
    Dim I&, lRet&, Txt$
'
    On Error GoTo DisegnaCepstrum_ERR
'
    ' Cerco la F0 escludendo le quefrencies < TSoglia;
    ' conviene farlo qui anziche' nella Sub Cepstrum per
    ' poter analizzare correttamente anche gli spettri
    ' richiamati nelle memorie dell' Analizzatore di Spettro:
    CpstrmF0 = 0
    For I = IQSoglia To CpstrmNQFR
        If (CpstrmF0 < CpstrmAmp(I)) Then
            IQF0 = I
            CpstrmF0 = CpstrmAmp(I)
        End If
    Next I
'
'---------------------------------------------------------------------------------------
'
    ' Copio il quadro sull' hDCh_S dello schermo:
    Call BitBlt(hDCh_S, 0, 0, picSchermo_PixW, picSchermo_PixH, hDCh_Q, 0, 0, SRCCOPY)
'
    ' Grafico del Cepstrum sull' hDCh_S:
    For I = 0 To CpstrmNQ
        CePosPixXY(I).Y = Ay * CpstrmAmp(I) + By
    Next I
'
    lRet = SelectObject(hDCh_S, hPen_Mfn)
    Call Polyline(hDCh_S, CePosPixXY(0), CpstrmNQ1)
'
    ' Disegno la posizione dei campioni (per prove):
'    For I = 0 To CpstrmNQ
'        Call MoveToEx(hDCh_S, CePosPixXY(I).X, CePosPixXY(I).Y - 3, 0)
'        Call LineTo(hDCh_S, CePosPixXY(I).X, CePosPixXY(I).Y + 3)
'    Next I
'
    lRet = SelectObject(hDCh_S, hPen_F0) ' Se non serve adesso, serve dopo, forse...
    If (IQF0 <= CpstrmNQ) Then
        ' Segno il punto di F0:
        'Call Rectangle(hDCh_S, CePosPixXY(IQF0).X - 3, Ay * CpstrmF0 + By + 3, _
                               CePosPixXY(IQF0).X + 4, Ay * CpstrmF0 + By - 3)
        Call Ellipse(hDCh_S, CePosPixXY(IQF0).X - 4, Ay * CpstrmF0 + By + 4, _
                             CePosPixXY(IQF0).X + 4, Ay * CpstrmF0 + By - 4)
    End If
'
    If (0 < IQF0) Then
        ' Scrivo il valore "Fundamental Frequency" in alto a sinistra dello schermo:
        FormatPrf Fs_2 / IQF0, Mantissa$, Prefisso$, "0.000E+00"
        Txt$ = Mantissa$ & " " & Prefisso$ & "Hz"
        Call TextOut(hDCh_S, F0XPos, F0YPos, Txt$, Len(Txt$))
    End If
'
'---------------------------------------------------------------------------------------
    ' Copio l' hDCh_S del Cepstrum su picSchermo:
    picSchermo.Cls
    Call BitBlt(picSchermo.hdc, 0, 0, picSchermo_PixW, picSchermo_PixH, _
                hDCh_S, 0, 0, SRCCOPY)
'
    Exit Sub
'
'
DisegnaCepstrum_ERR:
    Err.Clear
'
'
'
End Sub
Private Sub DisegnaLogSx()
'
'
    Dim I&, lRet&
'
    On Error GoTo DisegnaLogSx_ERR
'
    ' Copio il quadro sull' hDCh_S dello schermo:
    Call BitBlt(hDCh_S, 0, 0, picSchermo_PixW, picSchermo_PixH, hDCh_Q, 0, 0, SRCCOPY)
'
    ' Disegno il Log(Sx):
    For I = 0 To LogSxNF
        LgPosPixXY(I).Y = Ay * LogSx(I) + By
    Next I
'
    Call Polyline(hDCh_S, LgPosPixXY(0), LogSxNF1)
'
    ' Disegno la posizione dei campioni (per prove):
'    For I = 0 To LogSxNF
'        Call MoveToEx(hDCh_S, LgPosPixXY(I).X, LgPosPixXY(I).Y - 3, 0)
'        Call LineTo(hDCh_S, LgPosPixXY(I).X, LgPosPixXY(I).Y + 3)
'    Next I
'
'---------------------------------------------------------------------------------------
    ' Copio l' hDCh_S del Log(Sx) su picSchermo:
    picSchermo.Cls
    Call BitBlt(picSchermo.hdc, 0, 0, picSchermo_PixW, picSchermo_PixH, _
                hDCh_S, 0, 0, SRCCOPY)
'
    Exit Sub
'
'
DisegnaLogSx_ERR:
    Err.Clear
'
'
'
End Sub
Private Sub chkCursori_Click()
'
'
    bCursoriOn = (chkCursori.Value = vbChecked)
'
    linCursoreX(1).Visible = bCursoriOn
    linCursoreX(2).Visible = bCursoriOn
    lblCursoreX(1).Visible = bCursoriOn
    lblCursoreX(2).Visible = bCursoriOn
    linCursoreY(1).Visible = bCursoriOn
    linCursoreY(2).Visible = bCursoriOn
    lblCursoreY(1).Visible = bCursoriOn
    lblCursoreY(2).Visible = bCursoriOn
'
    If bCursoriOn Then
        CalcolaCursoriX
        CalcolaCursoriY
        lblCursoreX_W2 = lblCursoreX(1).Width / 2!
        lblCursoreY_H2 = lblCursoreX(1).Height / 2!
'
    Else
        lblDeltaX.Caption = "--"
        lblDeltaY.Caption = "--"
        lblDeltaX.ToolTipText = " ?? "
    End If
'
'
'
End Sub
Private Sub Form_Load()
'
'
    Dim Me_L&, Me_T&, I&, N&
'
    LeggiPosizioneFormINI FileINI$, Me, Me_L, Me_T
    Me.Move Me_L, Me_T
'
    ' Parametri di default:
    AMaxCe = 1#
    AMaxLg = 50#
    TSoglia = 0.003 ' [s]
    IQSoglia = Ceil(TSoglia * Fs_2)
    Titolo$ = "Cepstrum"
'
    optDisegnaCepstrum.Value = True
'
    bDisegnaCepstrum = optDisegnaCepstrum.Value
'
    ' Imposto la risoluzione del timer
    ' timeGetTime al minimo possibile:
    uPeriod = 1
    Do While (timeBeginPeriod(uPeriod) = TIMERR_NOCANDO)
        uPeriod = uPeriod + 1
        If (1000 < uPeriod) Then Exit Do
    Loop
'
    bMeLoaded = True
'
'
'
End Sub
Private Sub Form_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
'
'
    AggiornaFinestrelle lblT, "", lblTU, "s", _
                        lblF, "", lblFU, "Hz", _
                        lblY, "", lblYU, "Vi"
'
'
'
End Sub
Private Sub Form_Unload(Cancel As Integer)
'
'
    Dim lRet&
'
    If bCepstrum Then
        Cancel = True
        Exit Sub
    End If
'
    lRet = timeEndPeriod(uPeriod)
'
    SalvaPosizioneFormINI FileINI$, Me
'
    lRet = DeleteDC(hDCh_Q)
    lRet = DeleteDC(hDCh_S)
    lRet = DeleteObject(hBmp_Q)
    lRet = DeleteObject(hBmp_S)
    lRet = DeleteObject(hPen_Mfn)
    lRet = DeleteObject(hPen_F0)
    lRet = DeleteObject(hPen_Prof)
    lRet = DeleteObject(hBrush_F0)
    lRet = DeleteObject(hFont)
'
    Set frmCepstrum = Nothing
'
'
'
End Sub

Private Sub fraTSoglia_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
'
'
    AggiornaFinestrelle lblT, "", lblTU, "s", _
                        lblF, "", lblFU, "Hz", _
                        lblY, "", lblYU, "Vi"
'
'
'
End Sub

Private Sub lblCursoreX_MouseDown(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
'
'
    lblCursoreX(Index).ZOrder vbBringToFront
'
'
'
End Sub
Private Sub lblCursoreX_MouseMove(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
'
'
    Dim lblTop!
    Static YPos!
'
    If (Button = vbLeftButton) Then
        lblTop = lblCursoreX(Index).Top + picSchermo.ScaleY(Y - YPos, vbTwips, vbUser)
        If (picSchermo.ScaleTop < lblTop) Then lblTop = picSchermo.ScaleTop
        If (lblTop - lblCursoreY(Index).Height < picSchermo.ScaleTop + picSchermo.ScaleHeight) Then _
            lblTop = picSchermo.ScaleTop + picSchermo.ScaleHeight + lblCursoreY(Index).Height
'
        lblCursoreX(Index).Top = lblTop
'
    Else
        YPos = Y
    End If
'
    ' Per facilitare la lettura dell' etichetta:
    lblCursoreX(Index).ToolTipText = " " & lblCursoreX(Index).Caption & " "
'
'
'
End Sub
Private Sub lblCursoreY_MouseDown(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
'
'
    lblCursoreY(Index).ZOrder vbBringToFront
'
'
'
End Sub
Private Sub lblCursoreY_MouseMove(Index As Integer, Button As Integer, Shift As Integer, X As Single, Y As Single)
'
'
    Dim lblLeft!
    Static XPos!
'
    If (Button = vbLeftButton) Then
        lblLeft = lblCursoreY(Index).Left + picSchermo.ScaleX(X - XPos, vbTwips, vbUser)
        If (lblLeft < picSchermo.ScaleLeft) Then lblLeft = picSchermo.ScaleLeft
        If (picSchermo.ScaleLeft + picSchermo.ScaleWidth < lblLeft + lblCursoreY(Index).Width) Then _
            lblLeft = picSchermo.ScaleLeft + picSchermo.ScaleWidth - lblCursoreY(Index).Width
'
        lblCursoreY(Index).Left = lblLeft
'
    Else
        XPos = X
    End If
'
    ' Per facilitare la lettura dell' etichetta:
    lblCursoreY(Index).ToolTipText = " " & lblCursoreY(Index).Caption & " "
'
'
'
End Sub

Private Sub lblTMin_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
'
'
    FormatPrf 1! / TSoglia, Mantissa$, Prefisso$, "0.000E+00"
    lblTMin.ToolTipText = "F Max: " & Mantissa$ & " " & Prefisso$ & "Hz"
'
'
'
End Sub

Private Sub mnuCalibrazione_Click()
'
'
    If IsLoaded(frmCalibrazione) Then
        frmCalibrazione.SetFocus
        If (frmCalibrazione.WindowState = vbMinimized) Then _
            frmCalibrazione.WindowState = vbNormal
    Else
        frmCalibrazione.Apri
    End If
'
'
'
End Sub
Private Sub mnuCambiaTitolo_Click()
'
'
    Dim Titolo_N$
    Dim Point1 As POINTAPI
'
    Point1.X = Me.ScaleX(picSchermo.Left - Me.ScaleLeft, Me.ScaleMode, vbPixels)
    Point1.Y = Me.ScaleY(picSchermo.Top - Me.ScaleTop, Me.ScaleMode, vbPixels)
    ClientToScreen Me.hWnd, Point1
'
    Titolo_N$ = InputBox(String$(5, vbNewLine) _
                         & " Nuovo titolo?", _
                         " Titolo dello schermo del Cepstrum", Titolo$, _
                         Point1.X * Screen.TwipsPerPixelX, _
                         Point1.Y * Screen.TwipsPerPixelY)
'
    If (Titolo$ <> Titolo_N$) And (Titolo_N$ <> "") Then
        Titolo$ = Titolo_N$
'
        DisegnaQuadroCepstrum
        DisegnaCepstrum
    End If
'
'
'
End Sub
Private Sub mnuCopiaSchermoInAppunti_Click()
'
'
    ' Riporto il grafico corrente (completo delle Labels
    ' dei cursori e di Lines) sul PictureBox d' appoggio ...:
    picSchermo.BorderStyle = vbBSNone
    frmStampaFCPB.Copia_Oggetto picSchermo, picCopia, True
    picSchermo.BorderStyle = vbFixedSingle
'
    ' ... e lo copio nel Clipboard:
    Clipboard.Clear
    Clipboard.SetData picCopia.Image, vbCFDIB
'
    ' Scarico il Form di stampa:
    Unload frmStampaFCPB
'
'
'
End Sub
Private Sub mnuCopiaStrumentoInAppunti_Click()
'
'
    Dim ctrAttivo As Control
'
    Screen.MousePointer = vbHourglass
    DoEvents
'
    ' Nascondo i riferimenti di fuoco:
    Set ctrAttivo = Me.ActiveControl
    picSchermo.SetFocus
'
    ' Riporto il Form dello strumento sul PictureBox d' appoggio ...:
    frmStampaFCPB.Copia_Oggetto Me, picCopia, True
'
    ' ... e lo copio nel Clipboard:
    Clipboard.Clear
    Clipboard.SetData picCopia.Image, vbCFDIB
'
    ' Scarico il Form di stampa:
    Unload frmStampaFCPB
'
    ctrAttivo.SetFocus
    Screen.MousePointer = vbDefault
'
'
'
End Sub
Private Sub mnuEsci_Click()
'
'
    Unload frmAudioCardDSP
'
'
'
End Sub

Private Sub mnuHtCurveFitter_Click()
'
'
    frmHtFitter.Show
'
'
'
End Sub
Private Sub mnuInformazioni_Click()
'
'
    frmCopyright.Apri frmAudioCardDSP
'
'
'
End Sub
Private Sub mnuIstruzioni_Click()
'
'
    frmIstruzioni.Apri App.Path & "\Istruzioni.rtf", " Istruzioni"
'
'
'
End Sub
Private Sub mnuPreferenze_Click()
'
'
    If IsLoaded(frmPreferenze) Then
        frmPreferenze.SetFocus
        If (frmPreferenze.WindowState = vbMinimized) Then _
            frmPreferenze.WindowState = vbNormal
    Else
        frmPreferenze.Apri
    End If
'
'
'
End Sub

Private Sub mnuStampa_Click()
'
'   Stampa, al centro del foglio, schermo e strumento
'   con dimensioni di St_W x St_H mm:
'
    Dim objOggetti(1 To 2) As Variant, St_H&, DocX&, DocY&, DocW&, DocH&
    Dim ctrAttivo As Control
'
    ' Dimensioni di stampa:
    Const St_W& = 200   ' [mm].
    St_H = St_W * Me.Height / Me.Width
'
    ' Recupero le dimensioni del foglio ...:
    frmStampaFCPB.FoglioStampa DocW, DocH, vbPRORLandscape
    ' ... e calcolo i margini sinistro e superiore:
    DocX = (DocW - St_W) / 2
    DocY = (DocH - St_H) / 2
'
    ' Riporto il grafico corrente (completo delle Labels
    ' dei cursori e di Lines) sul PictureBox d' appoggio:
    picSchermo.BorderStyle = vbBSNone
    frmStampaFCPB.Copia_Oggetto picSchermo, picCopia, True
    picSchermo.BorderStyle = vbFixedSingle
'
    Set objOggetti(1) = Me
    Set objOggetti(2) = picCopia
'
    ' Nascondo i riferimenti di fuoco:
    Set ctrAttivo = Me.ActiveControl
    picSchermo.SetFocus
'
    frmStampaFCPB.StampaFCPB objOggetti(), DocX, DocY, St_W, St_H, , _
                             "Cepstrum", 1, True
'
    ctrAttivo.SetFocus
'
'
'
End Sub

Private Sub optDisegnaCepstrum_Click()
'
'
    bDisegnaCepstrum = True
'
    shpEsclusione.Visible = bDisegnaCepstrum
    ContainerEnabled fraTSoglia, bDisegnaCepstrum
    mnuCambiaTitolo.Enabled = True
'
    FormatPrf TMax, Mantissa$, Prefisso$
    lblScaleX.Caption = Mantissa$
    lblScaleXU.Caption = Prefisso$ & "s"
'
    FormatPrf AMaxCe, Mantissa$, Prefisso$
    lblScaleY.Caption = Mantissa$
    lblScaleYU.Caption = Prefisso$ & "Log(Vi)"
'
    DisegnaQuadroCepstrum
    DisegnaCepstrum
'
    ' Aggiorno il significato dei cursori:
    lblDeltaXC.Caption = "dT:"
    lblDeltaYC = "dVi:"
    If (Not bCursoriOn) Then
        ' Non sono stati aggiornati
        ' da DisegnaQuadroCorr:
        lblDeltaXU.Caption = "s"
        lblDeltaYU.Caption = "Vi"
    End If
'
'
'
End Sub
Private Sub optDisegnaLogSx_Click()
'
'
    bDisegnaCepstrum = False
'
    shpEsclusione.Visible = bDisegnaCepstrum
    ContainerEnabled fraTSoglia, bDisegnaCepstrum
    mnuCambiaTitolo.Enabled = False
'
    FormatPrf FMax, Mantissa$, Prefisso$
    lblScaleX.Caption = Mantissa$
    lblScaleXU.Caption = Prefisso$ & "Hz"
'
    FormatPrf AMaxLg, Mantissa$, Prefisso$
    lblScaleY.Caption = Mantissa$
    lblScaleYU.Caption = Prefisso$ & "Log(Vi)"
'
    DisegnaQuadroLogSx
    DisegnaLogSx
'
    ' Aggiorno il significato dei cursori:
    lblDeltaXC.Caption = "dF:"
    lblDeltaYC = "dVi:"
    If (Not bCursoriOn) Then
        ' Non sono stati aggiornati
        ' da DisegnaQuadroCorr:
        lblDeltaXU.Caption = "Hz"
        lblDeltaYU.Caption = "Vi"
    End If
'
'
'
End Sub

Private Sub picSchermo_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
'
'
    Dim PCur As POINTAPI
'
    GetCursorPos PCur
    ScreenToClient picSchermo.hWnd, PCur
'
    If (Button = vbLeftButton) Then
        ' Blocco il cursore del mouse
        ' nella sua area di competenza:
        picSchermo.SetFocus ' Necessario per il funzionamento
        DoEvents            ' regolare di ResMouseAreaPB.
'
        If PtInRect(Rect_CV, PCur.X, PCur.Y) Then
            ' Mouse sui cursori verticali:
            ResMouseAreaPB picSchermo, XMinR, Y, XMaxR, Y
'
        ElseIf PtInRect(Rect_CO, PCur.X, PCur.Y) Then
            ' Mouse sui cursori orizzontali:
            ResMouseAreaPB picSchermo, X, YMinR, X, YMaxR
        End If
'
        picSchermo_MouseMove Button, 0, X, Y
'
    ElseIf (Button = vbRightButton) And PtInRect(Rect_MI, PCur.X, PCur.Y) Then
        TSoglia = X
        IQSoglia = Ceil(TSoglia * Fs_2)
        txtTSoglia_KeyPress vbKeyEscape
    End If
'
'
'
End Sub
Private Sub picSchermo_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
'
'
    Dim ICc&, PCur As POINTAPI
'
    GetCursorPos PCur
    ScreenToClient picSchermo.hWnd, PCur
'
    ' Verifico la posizione del cursore del mouse,
    ' ne imposto le caratteristiche ed aggiorno il
    ' valore delle finestrelle di misura:
    picSchermo.ToolTipText = ""
'
    If bCursoriOn And PtInRect(Rect_CV, PCur.X, PCur.Y) Then
        ' Mouse sui cursori verticali:
        AggiornaFinestrelle lblT, "", lblTU, "s", _
                            lblF, "", lblFU, "Hz", _
                            lblY, "", lblYU, "Vi"
'
        picSchermo.MousePointer = vbSizeWE
        picSchermo.ToolTipText = " Sposta i cursori "
'
    ElseIf bCursoriOn And PtInRect(Rect_CO, PCur.X, PCur.Y) Then
        ' Mouse sui cursori orizzontali:
        AggiornaFinestrelle lblT, "", lblTU, "s", _
                            lblF, "", lblFU, "Hz", _
                            lblY, "", lblYU, "Vi"
'
        picSchermo.MousePointer = vbSizeNS
        picSchermo.ToolTipText = " Sposta i cursori "
'
    ElseIf PtInRect(Rect_MI, PCur.X, PCur.Y) Then
        ' Mouse sul grafico del Cepstrum o del Log(Sx):
        If bDisegnaCepstrum Then
            If (0 < X) Then
                FormatPrf X, Mantissa$, Prefisso$, "0.000E+00"
                AggiornaFinestrelle lblT, Mantissa$, _
                                    lblTU, Prefisso$ & "s"
'
                FormatPrf 1! / X, Mantissa$, Prefisso$, "0.000E+00"
                AggiornaFinestrelle lblF, Mantissa$, _
                                    lblFU, Prefisso$ & "Hz"
            Else
                AggiornaFinestrelle lblT, "0", lblTU, "s"
                AggiornaFinestrelle lblF, " oo", lblFU, "Hz"
            End If
'
            FormatPrf Y, Mantissa$, Prefisso$, "0.000E+00"
            AggiornaFinestrelle lblY, Mantissa$, _
                                lblYU, Prefisso$ & "Vi"
'
            'If PtInRect(Rect_SO, PCur.X, PCur.Y) Then
                picSchermo.ToolTipText = " Click destro per spostare la soglia "
            'End If
'
        Else
            If (0 < X) Then
                AggiornaFinestrelle lblT, ""
'
                FormatPrf X, Mantissa$, Prefisso$, "0.000E+00"
                AggiornaFinestrelle lblF, Mantissa$, _
                                    lblFU, Prefisso$ & "Hz"
            Else
                AggiornaFinestrelle lblT, "", lblTU, "s"
                AggiornaFinestrelle lblF, "0", lblFU, "Hz"
            End If
'
            FormatPrf Y, Mantissa$, Prefisso$, "0.000E+00"
            AggiornaFinestrelle lblY, Mantissa$, _
                                lblYU, Prefisso$ & "Vi"
        End If
'
        picSchermo.MousePointer = vbCrosshair
'
    Else
        ' Mouse su zona libera:
        AggiornaFinestrelle lblT, "", lblTU, "s", _
                            lblF, "", lblFU, "Hz", _
                            lblY, "", lblYU, "Vi"
'
        picSchermo.MouseIcon = frmAudioCardDSP.imgCursori.ListImages("Menu").Picture
        picSchermo.MousePointer = vbCustom
        picSchermo.ToolTipText = " Click destro per Menu "
    End If
'
'---------------------------------------------------------------------------------------
'
'
    If (Button = vbLeftButton) Then
        ' Verifico la posizione del cursore del mouse
        ' ed eseguo le relative azioni richieste:
        If bCursoriOn And PtInRect(Rect_CV, PCur.X, PCur.Y) Then
            ' Mouse sui cursori verticali:
            ICc = TrovaCursoreX(X)
            linCursoreX(ICc).X1 = X
            linCursoreX(ICc).X2 = X
            lblCursoreX(ICc).Left = X - lblCursoreX_W2
            lblCursoreX(ICc).ZOrder vbBringToFront
            CalcolaCursoriX
'
        ElseIf bCursoriOn And PtInRect(Rect_CO, PCur.X, PCur.Y) Then
            ' Mouse sui cursori orizzontali:
            ICc = TrovaCursoreY(Y)
            linCursoreY(ICc).Y1 = Y
            linCursoreY(ICc).Y2 = Y
            lblCursoreY(ICc).Top = Y + lblCursoreY_H2
            lblCursoreY(ICc).ZOrder vbBringToFront
            CalcolaCursoriY
        End If
    End If
'
'
'
End Sub
Private Sub picSchermo_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
'
'
    ' Libero il puntatore del mouse,
    ' se costretto in un' area:
    ResMouseAreaPB
'
    If (Button = vbRightButton) _
    And (picSchermo.ToolTipText = " Click destro per Menu ") Then
        Me.PopupMenu mnuFile ', , picSchermo.Left + picSchermo.Width / 22, _
                                picSchermo.Top + picSchermo.Height / 10
    End If
'
'
'
End Sub
Private Sub txtTSoglia_Change()
'
'
    txtTSoglia.BackColor = vbYellow
'
'
'
End Sub
Private Sub txtTSoglia_KeyPress(KeyAscii As Integer)
'
'
    Dim M$
'
    On Error Resume Next
'
    If (KeyAscii = vbKeyEscape) Then
        KeyAscii = 0
        txtTSoglia.Text = Format$(TSoglia, "#0.000000")
        txtTSoglia.BackColor = vbWindowBackground
'
        IQSoglia = Ceil(TSoglia * Fs_2)
'
        DisegnaQuadroCepstrum
        DisegnaCepstrum
'
    ElseIf (KeyAscii = vbKeyReturn) Then
        KeyAscii = 0
        ' Verifiche per correttezza:
        If (CSng(txtTSoglia.Text) <= 0) Or (NFRQ / Fs <= CSng(txtTSoglia.Text)) Then
            M$ = "Valore errato." & vbNewLine
            M$ = M$ & "Deve essere: 0 < TsMin < " & Format$(NFRQ / Fs, "#0.000###") & " s"
            MsgBox M$, vbInformation, " fmCepstrum: Errore TsMin"
'
            txtTSoglia.Text = TSoglia
'
        Else
            TSoglia = CSng(txtTSoglia.Text)
            IQSoglia = Ceil(TSoglia * Fs_2)
'
            DisegnaQuadroCepstrum
            DisegnaCepstrum
        End If
'
        txtTSoglia.BackColor = vbWindowBackground
'
    Else
        KeyAscii = KAscNumReali(KeyAscii)
    End If
'
'
    If (Err.Number <> 0) Then Err.Clear
'
'
'
End Sub
Private Sub updScaleX_DownClick()
'
'   Implementa la sequenza 10 -> 5 -> 2 -> 1 sulla scala di tempo
'   del Cepstrum o della frequenza massima di Log(Sx):
'
    If bDisegnaCepstrum Then
        TMax = Sequenza5_2_1(TMax, , 10 / Fs)
        CpstrmNQ = TMax * Fs_2
'
        FormatPrf TMax, Mantissa$, Prefisso$
        lblScaleX.Caption = Mantissa$
        lblScaleXU.Caption = Prefisso$ & "s"
'
        DisegnaQuadroCepstrum
        DisegnaCepstrum
'
    Else
        FMax = Sequenza5_2_1(FMax, , 2 * Fs / NFRQ)
        LogSxNF = NFRQ * FMax / Fs_2
'
        FormatPrf FMax, Mantissa$, Prefisso$
        lblScaleX.Caption = Mantissa$
        lblScaleXU.Caption = Prefisso$ & "Hz"
'
        DisegnaQuadroLogSx
        DisegnaLogSx
    End If
'
'
'
End Sub
Private Sub updScaleX_UpClick()
'
'   Implementa la sequenza 1 -> 2 -> 5 -> 10 sulla scala di tempo
'   del Cepstrum o della frequenza massima di Log(Sx):
'
    If bDisegnaCepstrum Then
        TMax = Sequenza1_2_5(TMax, , NFRQ / Fs)
        CpstrmNQ = TMax * Fs_2
'
        FormatPrf TMax, Mantissa$, Prefisso$
        lblScaleX.Caption = Mantissa$
        lblScaleXU.Caption = Prefisso$ & "s"
'
        DisegnaQuadroCepstrum
        DisegnaCepstrum
'
    Else
        FMax = Sequenza1_2_5(FMax, , Fs_2)
        LogSxNF = NFRQ * FMax / Fs_2
'
        FormatPrf FMax, Mantissa$, Prefisso$
        lblScaleX.Caption = Mantissa$
        lblScaleXU.Caption = Prefisso$ & "Hz"
'
        DisegnaQuadroLogSx
        DisegnaLogSx
    End If
'
'
'
End Sub
Private Sub updScaleY_DownClick()
'
'   Implementa la sequenza 1 -> 2 -> 5 -> 10 sulla scala di ampiezza
'   del Cepstrum o di Log(Sx):
'
    If bDisegnaCepstrum Then
        AMaxCe = Sequenza1_2_5(AMaxCe)
'
        FormatPrf AMaxCe, Mantissa$, Prefisso$
        lblScaleY.Caption = Mantissa$
        lblScaleYU.Caption = Prefisso$ & "Log(Vi)"
'
        DisegnaQuadroCepstrum
        DisegnaCepstrum
'
    Else
        AMaxLg = Sequenza1_2_5(AMaxLg)
'
        FormatPrf AMaxLg, Mantissa$, Prefisso$
        lblScaleY.Caption = Mantissa$
        lblScaleYU.Caption = Prefisso$ & "Log(Vi)"
'
        DisegnaQuadroLogSx
        DisegnaLogSx
    End If
'
'
'
End Sub
Private Sub updScaleY_UpClick()
'
'   Implementa la sequenza 10 -> 5 -> 2 -> 1 sulla scala di ampiezza
'   del Cepstrum o di Log(Sx):
'
    If bDisegnaCepstrum Then
        AMaxCe = Sequenza5_2_1(AMaxCe, , 0.00000001)
'
        FormatPrf AMaxCe, Mantissa$, Prefisso$
        lblScaleY.Caption = Mantissa$
        lblScaleYU.Caption = Prefisso$ & "Log(Vi)"
'
        DisegnaQuadroCepstrum
        DisegnaCepstrum
'
    Else
        AMaxLg = Sequenza5_2_1(AMaxLg, , 0.00000001)
'
        FormatPrf AMaxLg, Mantissa$, Prefisso$
        lblScaleY.Caption = Mantissa$
        lblScaleYU.Caption = Prefisso$ & "Log(Vi)"
'
        DisegnaQuadroLogSx
        DisegnaLogSx
    End If
'
'
'
End Sub
Private Sub zFrame1_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
'
'
    AggiornaFinestrelle lblT, "", lblTU, "s", _
                        lblF, "", lblFU, "Hz", _
                        lblY, "", lblYU, "Vi"
'
'
'
End Sub
Private Sub DisegnaQuadroLogSx()
'
'   Dimensiona e disegna il quadro dello schermo
'   per la rappresentazione del Log(Sx).
'
    Dim I&, QxMin!, QxMax!, QyMin!, QyMax!, lRet&, Txt$
'
    picSchermo.ScaleMode = vbPixels
    picSchermo_PixW = picSchermo.ScaleWidth
    picSchermo_PixH = picSchermo.ScaleHeight
'
    ' Preparo il quadro:
    Quadro picSchermo, 0, 0, FMax, AMaxLg, "0.000E+00", "0.000E+00", True, True, _
           1, X_1Px, Y_1Px, "Log(Sx)", "Hz", "Log(Vi)", True, , , _
           XMinR, YMinR, XMaxR, YMaxR, QxMin, QyMin, QxMax, QyMax, _
           ColRet, ColSch, ColTit
'
    ' Scrivo la frequenza di campionamento:
    ScrivoCome picSchermo, "Small Fonts", 7, False, ColRet
    Txt$ = "Sampling Freq: " & Fs & " Hz"
    picSchermo.CurrentX = XMaxR - picSchermo.TextWidth(Txt$ & "II")
    picSchermo.CurrentY = YMaxR + 13 * Y_1Px
    picSchermo.Print Txt$;
'
    If bCursoriOn Then
        ' Calcolo la dimensione delle etichette
        ' dei cursori e ne aggiorno i valori:
        lblCursoreX_W2 = lblCursoreX(1).Width / 2!
        CalcolaCursoriX
        lblCursoreY_H2 = lblCursoreY(1).Height / 2!
        CalcolaCursoriY
    End If
'
'---------------------------------------------------------------------------------------
'   Preparo variabili, handles, etc... per disegnare
'   lo schermo con API.
'
    ' Calcolo i coefficienti di trasformazione da vbUser a vbPixels per
    ' evitare, nella Sub DisegnaLogSx, l' uso dei metodi ScaleX e ScaleY.
    ' Coefficienti per la trasformazione delle ordinate:
    Ay = picSchermo_PixH / (QyMin - QyMax)
    By = picSchermo_PixH * QyMax / (QyMax - QyMin)
'
    ' Calcolo, in Pixels, le posizioni
    ' orizzontali dei campioni sullo schermo:
    LogSxNF1 = LogSxNF + 1
    ReDim LgPosPixXY(0 To LogSxNF)
    For I = 0 To LogSxNF
        LgPosPixXY(I).X = picSchermo.ScaleX((I * Fs_2 / NFRQ) - picSchermo.ScaleLeft, _
                                            vbUser, vbPixels)
    Next I
'
    ' Elimino gli handles correnti:
    lRet = DeleteDC(hDCh_Q)
    lRet = DeleteDC(hDCh_S)
    lRet = DeleteObject(hBmp_Q)
    lRet = DeleteObject(hBmp_S)
    lRet = DeleteObject(hPen_Mfn)
    lRet = DeleteObject(hPen_F0)
    lRet = DeleteObject(hPen_Prof)
    lRet = DeleteObject(hBrush_F0)
    lRet = DeleteObject(hFont)
'
    ' BitMap del quadro:
    hDCh_Q = CreateCompatibleDC(picSchermo.hdc)
    hBmp_Q = CreateCompatibleBitmap(picSchermo.hdc, picSchermo_PixW, picSchermo_PixH)
    lRet = SelectObject(hDCh_Q, hBmp_Q)
'
    ' BitMap del Cepstrum:
    hDCh_S = CreateCompatibleDC(picSchermo.hdc)
    hBmp_S = CreateCompatibleBitmap(picSchermo.hdc, picSchermo_PixW, picSchermo_PixH)
    lRet = SelectObject(hDCh_S, hBmp_S)
'
    ' Creo il rettangolo dedicato alla
    ' misura del reticolo:
    Rect_MI = CreaRettangolo(picSchermo, XMinR, YMinR, XMaxR, YMaxR)
'
    ' Creo il rettangolo dedicato allo
    ' spostamento dei cursori verticali:
    Rect_CV = CreaRettangolo(picSchermo, XMinR, YMaxR, XMaxR, QyMax)
'
    ' Creo il rettangolo dedicato allo
    ' spostamento dei cursori orizzontali:
    Rect_CO = CreaRettangolo(picSchermo, XMaxR, YMinR, QxMax, YMaxR)
'
    ' Creo la "penna" necessaria al disegno del Log(Sx):
    hPen_Prof = CreatePen(PS_SOLID, 1, ColProf)
    lRet = SelectObject(hDCh_S, hPen_Prof)
'
    ' Copio il quadro sull' hDCh_Q dello sfondo:
    lRet = BitBlt(hDCh_Q, 0, 0, picSchermo_PixW, picSchermo_PixH, _
                  picSchermo.hdc, 0, 0, SRCCOPY)
'
'
'
End Sub
Private Sub zFrame2_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
'
'
    AggiornaFinestrelle lblT, "", lblTU, "s", _
                        lblF, "", lblFU, "Hz", _
                        lblY, "", lblYU, "Vi"
'
'
'
End Sub

Public Sub ApplicaPreferenze()
'
'
    If bDisegnaCepstrum Then
        DisegnaQuadroCepstrum
        DisegnaCepstrum
'
    Else
        DisegnaQuadroLogSx
        DisegnaLogSx
    End If
'
'
'
End Sub
