VERSION 5.00
Begin VB.Form frmCurve 
   BorderStyle     =   1  'Fixed Single
   ClientHeight    =   4635
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   6450
   Icon            =   "frmCurve.frx":0000
   LinkTopic       =   "frmCurvaPesatura"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MDIChild        =   -1  'True
   ScaleHeight     =   4635
   ScaleWidth      =   6450
   Begin VB.PictureBox picCurva 
      AutoRedraw      =   -1  'True
      BorderStyle     =   0  'None
      Height          =   4530
      Left            =   60
      ScaleHeight     =   302
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   424
      TabIndex        =   0
      Top             =   60
      Width           =   6360
   End
End
Attribute VB_Name = "frmCurve"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'=======================================================================================
' Descrizione.....: Form per la visualizzazione delle curve psofometriche
'                   del fonometro, dei profili di "Window" [e degli spettri
'                   usati da Calibrazione].
' Nome dei Files..: frmCurve.frm, frmCurve.frx,
'                   modAudioCardDSP, modDSP, modUtilita.bas.
' Data............: 29/02/2008
' Aggiornamento...: 02/05/2008 (Ver. 1.1).
' Aggiornamento...: 14/05/2008 (Ver. 1.2).
' Versione........: 1.2 a 32 Bits.
' Sistema.........: VB6 (SP5) sotto Windows XP (SP2).
' Scritto da......: F. Languasco 
' E-Mail..........: MC7061@mclink.it
' DownLoads a.....: http://www.flanguasco.org
'=======================================================================================
'
Option Explicit
'
Dim TipoCurva$  ' Tipo della curva da disegnare: "CurvaFM" o "Window".
'
Dim CurvaFM$    ' Curva psofometrica da disegnare.
Dim CurvaWi$    ' "Window" da disegnare.
Dim PCor#       ' Valore del Parametro associato alla "Window".
Dim NPunti&     ' N di punti sui quali calcolare la "Window".
'
Dim CurvaFM_V() As CurvaFM_Type ' Curva di compensazione psofometrica per il fonometro.
Dim Window#()                   ' Profilo della Window.
Public Sub Apri(Optional ByVal TipoCurva_I$ = "", Optional ByVal Curva_I$, _
    Optional ByVal PCor_I As Double, Optional ByVal NPunti_I As Long)
'
'   Nota: la chiamata a questa Sub senza argomenti imposta
'         solamente le preferenze di colore.
'
    Me.Show
'
    If (TipoCurva_I$ = "CurvaFM") Then
        TipoCurva$ = TipoCurva_I$
        CurvaFM$ = Curva_I$
'
    ElseIf (TipoCurva_I$ = "Window") Then
        TipoCurva$ = TipoCurva_I$
        CurvaWi$ = Curva_I$
        PCor = PCor_I
        NPunti = NPunti_I
    End If
'
    If (TipoCurva$ = "CurvaFM") Then
        DisegnaCurvaFM
'
    ElseIf (TipoCurva$ = "Window") Then
        DisegnaWindow
    End If
'
'
'
End Sub
Private Sub DisegnaCurvaFM()
'
'
    Dim I&, I0&, I1&
'
    Dim FmMin#, FmMax#  ' Limiti di frequenza della curva di compensazione [Hz].
    Dim dBMin#, dBMax#  ' Limiti di ampiezza della curva di compensazione [dB].
'
    Me.Caption = " Curva di pesatura per Fonometro"
'
    If LeggiCurvaFM(CurvaFM$, CurvaFM_V()) Then
        I0 = LBound(CurvaFM_V)
        I1 = UBound(CurvaFM_V)
'
        FmMin = CurvaFM_V(I0).Fm
        FmMax = CurvaFM_V(I1).Fm
'
        dBMin = CurvaFM_V(I0).dB
        dBMax = CurvaFM_V(I0).dB
        For I = I0 + 1 To I1
            If (CurvaFM_V(I).dB < dBMin) Then dBMin = CurvaFM_V(I).dB
            If (dBMax < CurvaFM_V(I).dB) Then dBMax = CurvaFM_V(I).dB
        Next I
'
        frmCurve.BackColor = ColSch
        Quadro picCurva, FmMin, dBMin, FmMax, dBMax, "0.0E+00", , True, , , , , _
               CurvaFM$, "Hz", "dB", True, , , , , , , , , , , _
               ColRet, ColSch, ColTit
'
        picCurva.PSet (CurvaFM_V(I0).Fm, CurvaFM_V(I0).dB), ColMfn
        For I = I0 + 1 To I1
            picCurva.Line -(CurvaFM_V(I).Fm, CurvaFM_V(I).dB), ColMfn
        Next I
'
    Else
        frmCurve.BackColor = ColSch
        picCurva.BackColor = ColSch
'
        ScrivoCome picCurva, "MS Sans Serif", 12, True, ColTit
        picCurva.CurrentX = picCurva.ScaleLeft + picCurva.TextWidth("OO")
        picCurva.CurrentY = picCurva.ScaleTop + 2 * picCurva.TextHeight("O")
        picCurva.Print "Manca il file " & CurvaFM$ & ".txt"
    End If
'
'
'
End Sub
Private Sub DisegnaWindow()
'
'
    Dim I&, I0&, I1&
'
    Dim AMin#, AMax#    ' Ampiezza minima e massima della "Window".
'
    Me.Caption = " Profilo di ""Window"""
'
    ' Calcolo il profilo di Window:
    Window() = WinProf(CurvaWi$, NPunti, PCor)
'
    I0 = LBound(Window)
    I1 = UBound(Window)
'
    AMin = Window(I0)
    AMax = Window(I0)
    For I = I0 + 1 To I1
        If (Window(I) < AMin) Then AMin = Window(I)
        If (AMax < Window(I)) Then AMax = Window(I)
    Next I
'
    frmCurve.BackColor = ColSch
    Quadro picCurva, I0, AMin, I1, AMax, "#0", , , , , , , _
           CurvaWi$, "Cmp.", "Amp.", True, , , , , , , , , , , _
           ColRet, ColSch, ColTit
'
    picCurva.PSet (I0, Window(I0)), ColMfn
    For I = I0 + 1 To I1
        picCurva.Line -(I, Window(I)), ColMfn
    Next I
'
'
'
End Sub
Private Sub Form_Load()
'
'
    Dim Me_L&, Me_T&
'
    LeggiPosizioneFormINI FileINI$, Me, Me_L, Me_T
    Me.Move Me_L, Me_T
'
'
'
End Sub
Private Sub Form_Unload(Cancel As Integer)
'
'
    SalvaPosizioneFormINI FileINI$, Me
'
    Set frmCurve = Nothing
'
'
'
End Sub

Public Sub DisegnaSpettroCalibrazione(Freq() As Double, R1() As Double, X1() As Double, _
    R2() As Double, X2() As Double, ByVal NFreq As Long, _
    ByVal Ich As Long, ByVal SpMaxCh As Double)
'
'
    Dim I&, SpCal#
    Const FMax# = 2000  ' [Hz].
'
    frmCurve.BackColor = ColSch
    
    Quadro picCurva, Freq(0), 0, FMax, Sqr(SpMaxCh) / NFreq, _
           "0.0E+00", "0.0E+00", True, True, , , , _
           "Spettro Calibrazione Ch #" & Ich, "Hz", "DigVal", _
           True, , , , , , , , , , , ColRet, ColSch, ColTit
'
    Select Case Ich
    Case 1
        SpCal = Sqr(R1(0) * R1(0) + X1(0) * X1(0)) / NFreq
        picCurva.PSet (Freq(0), SpCal), ColProf
        For I = 1 To NFreq
            SpCal = Sqr(R1(I) * R1(I) + X1(I) * X1(I)) / NFreq
            picCurva.Line -(Freq(I), SpCal), ColProf
'
            If (FMax <= Freq(I)) Then Exit For
        Next I
'
    Case 2
        SpCal = Sqr(R2(0) * R2(0) + X2(0) * X2(0)) / NFreq
        picCurva.PSet (Freq(0), SpCal), ColProf
        For I = 1 To NFreq
            SpCal = Sqr(R2(I) * R2(I) + X2(I) * X2(I)) / NFreq
            picCurva.Line -(Freq(I), SpCal), ColProf
'
            If (FMax <= Freq(I)) Then Exit For
        Next I
    End Select
'
'
'
End Sub
