VERSION 5.00
Object = "{FE0065C0-1B7B-11CF-9D53-00AA003C9CB6}#1.1#0"; "COMCT232.OCX"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "mscomctl.ocx"
Begin VB.Form frmLivelli 
   BorderStyle     =   1  'Fixed Single
   Caption         =   " Level meter"
   ClientHeight    =   6825
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   3135
   Icon            =   "frmLivelli.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MDIChild        =   -1  'True
   ScaleHeight     =   6825
   ScaleWidth      =   3135
   Begin VB.TextBox txtTsPicco 
      Height          =   285
      Left            =   1290
      TabIndex        =   1
      ToolTipText     =   " Invio per confermare "
      Top             =   180
      Width           =   795
   End
   Begin VB.Frame fraSmorzamento 
      Caption         =   "Max. value followers        |     "
      Height          =   690
      Left            =   120
      TabIndex        =   12
      Top             =   5970
      Width           =   2895
      Begin VB.PictureBox picLivMaxF 
         AutoRedraw      =   -1  'True
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   0  'None
         FillStyle       =   0  'Solid
         Height          =   150
         Index           =   2
         Left            =   2025
         ScaleHeight     =   10
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   6
         TabIndex        =   14
         TabStop         =   0   'False
         Top             =   30
         Width           =   90
      End
      Begin VB.PictureBox picLivMaxF 
         AutoRedraw      =   -1  'True
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   0  'None
         FillStyle       =   0  'Solid
         Height          =   150
         Index           =   1
         Left            =   1800
         ScaleHeight     =   10
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   6
         TabIndex        =   13
         TabStop         =   0   'False
         Top             =   30
         Width           =   90
      End
      Begin VB.CommandButton cmdVMaxReset 
         Caption         =   "&Reset"
         Height          =   285
         Left            =   1980
         TabIndex        =   18
         Top             =   300
         Width           =   675
      End
      Begin VB.TextBox txtAlfa 
         Height          =   285
         Left            =   960
         TabIndex        =   16
         ToolTipText     =   " Doppio click: azzera "
         Top             =   300
         Width           =   405
      End
      Begin ComCtl2.UpDown updAlfa 
         Height          =   285
         Left            =   1380
         TabIndex        =   17
         TabStop         =   0   'False
         Top             =   300
         Width           =   240
         _ExtentX        =   423
         _ExtentY        =   503
         _Version        =   327681
         BuddyControl    =   "txtAlfa"
         BuddyDispid     =   196613
         OrigLeft        =   540
         OrigTop         =   300
         OrigRight       =   780
         OrigBottom      =   555
         Max             =   100
         SyncBuddy       =   -1  'True
         BuddyProperty   =   0
         Enabled         =   -1  'True
      End
      Begin VB.Label zLabel02 
         Caption         =   "&Hold-up %:"
         Height          =   315
         Left            =   120
         TabIndex        =   15
         Top             =   300
         Width           =   795
      End
   End
   Begin VB.PictureBox picLivelli 
      AutoRedraw      =   -1  'True
      Height          =   5295
      Left            =   120
      ScaleHeight     =   349
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   189
      TabIndex        =   3
      TabStop         =   0   'False
      Top             =   540
      Width           =   2895
      Begin VB.PictureBox picLivMax 
         AutoRedraw      =   -1  'True
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   0  'None
         FillStyle       =   0  'Solid
         Height          =   150
         Index           =   2
         Left            =   2070
         ScaleHeight     =   10
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   6
         TabIndex        =   11
         TabStop         =   0   'False
         Top             =   4950
         Width           =   90
      End
      Begin VB.PictureBox picLivMax 
         AutoRedraw      =   -1  'True
         BackColor       =   &H00FFFFFF&
         BorderStyle     =   0  'None
         FillStyle       =   0  'Solid
         Height          =   150
         Index           =   1
         Left            =   720
         ScaleHeight     =   10
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   6
         TabIndex        =   10
         TabStop         =   0   'False
         Top             =   4950
         Width           =   90
      End
      Begin MSComctlLib.ProgressBar prgLivello 
         Height          =   4275
         Index           =   1
         Left            =   900
         TabIndex        =   4
         Top             =   780
         Width           =   375
         _ExtentX        =   661
         _ExtentY        =   7541
         _Version        =   393216
         Appearance      =   1
         Orientation     =   1
      End
      Begin MSComctlLib.ProgressBar prgLivello 
         Height          =   4275
         Index           =   2
         Left            =   1620
         TabIndex        =   5
         Top             =   780
         Width           =   375
         _ExtentX        =   661
         _ExtentY        =   7541
         _Version        =   393216
         Appearance      =   1
         Orientation     =   1
      End
      Begin VB.Label lblCh 
         Alignment       =   2  'Center
         Caption         =   "Ch 2"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   2
         Left            =   1590
         TabIndex        =   9
         Top             =   510
         Width           =   495
      End
      Begin VB.Label lblVi 
         Caption         =   "Vi"
         Height          =   195
         Left            =   2340
         TabIndex        =   7
         Top             =   420
         Width           =   255
      End
      Begin VB.Label lblDig 
         Caption         =   "Dig. Val."
         Height          =   195
         Left            =   120
         TabIndex        =   6
         Top             =   420
         Width           =   615
      End
      Begin VB.Label lblCh 
         Alignment       =   2  'Center
         Caption         =   "Ch 1"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Index           =   1
         Left            =   870
         TabIndex        =   8
         Top             =   510
         Width           =   495
      End
   End
   Begin ComCtl2.UpDown updTsPicco 
      Height          =   285
      Left            =   2100
      TabIndex        =   19
      TabStop         =   0   'False
      Top             =   180
      Width           =   240
      _ExtentX        =   423
      _ExtentY        =   503
      _Version        =   327681
      Value           =   1
      OrigLeft        =   600
      OrigTop         =   240
      OrigRight       =   840
      OrigBottom      =   495
      Max             =   1024
      Min             =   1
      Enabled         =   -1  'True
   End
   Begin VB.Label Label1 
      BackStyle       =   0  'Transparent
      Caption         =   "Find pea&k over"
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   195
      Width           =   1215
   End
   Begin VB.Label lblTsPiccoU 
      BackStyle       =   0  'Transparent
      Caption         =   "s"
      Height          =   255
      Left            =   2400
      TabIndex        =   2
      Top             =   195
      Width           =   120
   End
End
Attribute VB_Name = "frmLivelli"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'=======================================================================================
' Descrizione.....: Misuratore dei livelli di suono acquisiti tramite la Scheda Audio.
' Nome dei Files..: frmLivelli.frm, frmLivelli.frx
' Data............: 08/08/2007 (Ver. 1.0).
' Revisione.......: 08/01/2008 (Ver. 1.0.r).
' Versione........: 1.0.r a 32 Bits.
' Sistema.........: VB6 (SP5) sotto Windows XP (SP2).
' Scritto da......: F. Languasco 
' E-Mail..........: MC7061@mclink.it
' DownLoads a.....: http://www.flanguasco.org
'===================================================================================
'
'   Lo strumento deve essere inizializzato con:
'   frmLivelli.Apri Fs&, NBuff&, NcBufferSize&, [Titolo$]
'    Fs:           frequenza di campionamento della scheda audio [Hz].
'    NBuff:        N di buffers usati nella routine di acquisizione (per uso futuro).
'    NcBufferSize: N di campioni per canale nel blocco dati InData() in ingresso.
'    Titolo$:      scritta centrale, in alto sullo schermo (opzionale).
'
'   Successive chiamate ad Apri reimpostano lo strumento cambiando
'   solo i parametri passati a questa routine.
'
'   La misura dei livelli si ottiene con:
'   frmLivelli.Livelli InData%()
'    InData():     Vettore dei valori da misurare, di dimensioni
'                  InData(1 To NCanali, 1 To NcBufferSize), ed organizzato come:
'                   InData(1, J)   J valore del 1 canale (sinistro),
'                   InData(2, J)   J valore del 2 canale (destro);
'                                  con  NCanali = 2; 1 <= J <= NcBufferSize.
'
Option Explicit
'
Dim Fs#                 ' Frequenza di campionamento dei segnali in ingresso [Hz].
Dim NBuff&              ' N di buffers usati nella routine di acquisizione.
Dim NcBufferSize&       ' N di campioni per canale nel blocco dati InData() in ingresso.
Dim Titolo$             ' Titolo dello schermo.
'
Dim NcPicco&            ' N di campioni su cui ricercare il picco di livello.
Dim IcPicco&            ' Contatore dei campioni [campioni].
'
Const TsPiccoMin! = 0.001   ' Valor minimo ammesso per TsPiccoLS [s].
'
Dim LivMax!(1 To 2)     ' Valori massimi su NcPicco campioni consecutivi [DigVal].
'
Dim OffY_picLivMax!     ' Offset di posizione delle freccette dei livelli massimi.
'
Dim KCal!               ' Coefficiente di calibrazione in uso [Vi/DigVal].
'
Dim AlfaLS_1#           ' 1 - AlfaLS.
Dim LivMax_1!(1 To 2)   ' Memorie dei valori massimi [DigVal].
'
Dim LivMinSc&, LivMaxSc&    ' Livelli min. e Max. delle scale [DigVal].
'
Dim bMeLoaded As Boolean    ' Flag di Form gia' caricato.
'
Const V16Min& = -2 ^ 15     ' Valori min. e Max. dei dati in ingresso alla
Const V16Max& = 2 ^ 15 - 1  ' scheda audio; campionamento a 16 Bits [DigVal].
'
'-- Dichiarazioni, costanti e tipi per API: --------------------------------------------
'
Private Type RECT
    Left  As Long       ' [Pixels].
    Top  As Long        '     "
    Right  As Long      '     "
    Bottom  As Long     '     "
End Type
'
Private Const DT_LEFT = &H0
Private Const DT_CENTER& = &H1
Private Const DT_VCENTER& = &H4
Private Const DT_SINGLELINE& = &H20
Private Const DT_NOCLIP = &H100
Private Const DT_END_ELLIPSIS& = &H8000&
Private Const uFlags = DT_CENTER + DT_VCENTER + DT_SINGLELINE + DT_END_ELLIPSIS
'
Private Declare Function DrawText Lib "USER32" Alias "DrawTextA" _
    (ByVal hdc As Long, ByVal lpStr As String, ByVal nCount As Long, _
    lpRECT As RECT, ByVal uFlags As Long) As Long

Public Sub ApplicaCalibrazioni()
'
'
    ' Trovo, alla frequenza di campionamento
    ' corrente, la calibrazione di ampiezza:
    KCal = TrovaKCal(Fs)
'
    DisegnaQuadro
'
'
'
End Sub
Private Sub cmdVMaxReset_Click()
'
'
    IcPicco = 0
    LivMax_1(1) = 0
    LivMax_1(2) = 0
'
    ' Posiziono le barre al
    ' livello minimo:
    prgLivello(1).Value = LivMax_1(1)
    prgLivello(2).Value = LivMax_1(2)
'
    ' Posiziono le freccette al
    ' livello minimo:
    picLivMax(1).Top = LivMinSc + OffY_picLivMax
    picLivMax(2).Top = LivMinSc + OffY_picLivMax
'
'
'
End Sub
Private Sub Form_Load()
'
'
    Dim Me_L&, Me_T&
'
    On Error GoTo Form_Load_ERR
'
    LeggiPosizioneFormINI FileINI$, Me, Me_L, Me_T
    Me.Move Me_L, Me_T
'
    ' Intervallo temporale iniziale su
    ' cui ricercare il picco di livello:
    txtTsPicco_KeyPress vbKeyEscape
'
    ' Hold-up iniziale:
    txtAlfa.Text = 100 * AlfaLS
'
    ' Preparo la freccetta di posizione del livello del Ch #1 ...:
    picLivMax(1).FillColor = ColLivMax
    picLivMax(1).BackColor = picLivelli.BackColor
    picLivMax(1).Circle (5, 4), 20, ColLivMax, -(PI - PI_6), -(PI + PI_6)
'
    ' ... quella del Ch #2 ...:
    picLivMax(2).FillColor = ColLivMax
    picLivMax(2).BackColor = picLivelli.BackColor
    picLivMax(2).Circle (0, 4), 20, ColLivMax, -(PI2 - PI_6), -(0 + PI_6)
'
    ' ... e quelle del quadro di
    ' impostazione dello smorzamento:
    picLivMaxF(1).FillColor = ColLivMax
    picLivMaxF(1).BackColor = fraSmorzamento.BackColor
    picLivMaxF(1).Circle (5, 4), 20, ColLivMax, -(PI - PI_6), -(PI + PI_6)
    picLivMaxF(2).FillColor = ColLivMax
    picLivMaxF(2).BackColor = fraSmorzamento.BackColor
    picLivMaxF(2).Circle (0, 4), 20, ColLivMax, -(PI2 - PI_6), -(0 + PI_6)
'
    ' Disabilito la [X] di chiusura Form:
    CloseButtonDisable Me
'
    bMeLoaded = True
'
'
Form_Load_ERR:
'
'
'
End Sub
Private Sub Form_Unload(Cancel As Integer)
'
'
    SaveIniString FileINI$, "Preferenze L.S.:", "TsPicco", TsPiccoLS
    SaveIniString FileINI$, "Preferenze L.S.:", "Alfa", AlfaLS
'
    SalvaPosizioneFormINI FileINI$, Me
'
    Set frmLivelli = Nothing
'
'
'
End Sub
Public Sub Apri(ByVal Fs_I As Long, ByVal NBuff_I As Long, ByVal NcBufferSize_I As Long, _
    Optional ByVal Titolo_I$ = "")
'
'
    Fs = CDbl(Fs_I)
    NcBufferSize = NcBufferSize_I
    If (Titolo_I$ <> "") Then
        Titolo$ = Titolo_I$     ' Titolo dello schermo.
    End If
'
    If (Not bMeLoaded) Then
        Me.Show
    End If
'
    KCal = TrovaKCal(Fs)
'
    ' Calcolo il N di campioni su cui
    ' ricercare il picco di livello in
    ' funzione dell' Fs corrente:
    NcPicco = TsPiccoLS * Fs
'
    DisegnaQuadro
'
'
'
End Sub
Public Sub Livelli(InDataC() As Integer)
'
'   Trova i livelli massimi su di un numero
'   di campioni pari a NcPicco:
'
    Dim I&, LivI&
'
    For I = 1 To NcBufferSize
        ' Trovo i valori massimi dei dati
        ' contenuti nel buffer corrente:
        LivI = Abs(CLng(InDataC(1, I)))
        If (LivMax(1) < LivI) Then LivMax(1) = LivI
'
        LivI = Abs(CLng(InDataC(2, I)))
        If (LivMax(2) < LivI) Then LivMax(2) = LivI
'
        IcPicco = IcPicco + 1
        If (NcPicco <= IcPicco) Then
            ' Posiziono le barre al
            ' livello massimo corrente:
            prgLivello(1).Value = LivMax(1)
            prgLivello(2).Value = LivMax(2)
'
            ' Calcolo i livelli massimi smorzati ...:
            If (LivMax_1(1) < LivMax(1)) Then LivMax_1(1) = LivMax(1)
            LivMax_1(1) = AlfaLS * LivMax_1(1) + (AlfaLS_1) * LivMax(1)
'
            If (LivMax_1(2) < LivMax(2)) Then LivMax_1(2) = LivMax(2)
            LivMax_1(2) = AlfaLS * LivMax_1(2) + (AlfaLS_1) * LivMax(2)
'
            ' ... posiziono le freccette ...:
            picLivMax(1).Top = LivMax_1(1) + OffY_picLivMax
            picLivMax(2).Top = LivMax_1(2) + OffY_picLivMax
'
            ' ... e segnalo la saturazione
            ' dei canali:
            If (LivMaxSc <= LivMax_1(1)) Then
                lblCh(1).BackColor = vbRed
            Else
                lblCh(1).BackColor = vbButtonFace
            End If
'
            If (LivMaxSc <= LivMax_1(2)) Then
                lblCh(2).BackColor = vbRed
            Else
                lblCh(2).BackColor = vbButtonFace
            End If
'
            ' Ricomincio la ricerca
            ' dei livelli massimi:
            IcPicco = 0
            LivMax(1) = 0
            LivMax(2) = 0
        End If
    Next I
'
'
'
End Sub
Public Sub Livelli_1(InDataC() As Integer)
'
'   Routine NON PIU' USATA.
'
'   Trova i livelli massimi su di un numero
'   di campioni pari alla dimensione del
'   buffer InDataC(1 To NcBufferSize):
'
    Dim I&, Ich&, LivI&, LivMax&
'
    For Ich = 1 To 2
        ' Trovo i valori massimi dei dati
        ' contenuti nel buffer corrente:
        LivMax = 0
        For I = 1 To NcBufferSize
            LivI = Abs(CLng(InDataC(Ich, I)))
            If (LivMax < LivI) Then LivMax = LivI
        Next I
'
        prgLivello(Ich).Value = LivMax
'
        ' Calcolo i livelli massimi smorzati ...:
        If (LivMax_1(Ich) < LivMax) Then LivMax_1(Ich) = LivMax
        LivMax_1(Ich) = AlfaLS * LivMax_1(Ich) + (AlfaLS_1) * LivMax
'
        ' ... posiziono le freccette ...:
        picLivMax(Ich).Top = LivMax_1(Ich) + OffY_picLivMax
'
        ' ... e segnalo la saturazione
        ' del canale ICh:
        If (LivMaxSc <= LivMax_1(Ich)) Then
            lblCh(Ich).BackColor = vbRed
        Else
            lblCh(Ich).BackColor = vbButtonFace
        End If
    Next Ich
'
'
'
End Sub
Private Sub DisegnaQuadro()
'
'
    Dim I&, Y!, DTac!, XPix10!, YPix10!, RPixUser!
    Dim picLivelliPixH&, prgLivelloPixT&, prgLivelloPixB&
    Dim QxMin!, QxMax!, QyMin!, QyMax!
    Dim X0!, X1!, XDig!, XVi!, TextH_2!
    Dim TitL!, TitH!, TitRECT As RECT
'
    ' Imposto i valori min. e Max. del
    ' segnale di ingresso (a 16 bits):
    LivMinSc = 0                        ' [DigVal].
    LivMaxSc = V16Max + 1               '    "
    DTac = (LivMaxSc - LivMinSc) / 10   '    "
'
    prgLivello(1).MAX = LivMaxSc
    prgLivello(2).MAX = LivMaxSc
'
    ' Calcolo i riferimenti della scala verticale
    ' di picLivelli in funzione della posizione
    ' delle ProgressBars:
    picLivelli.ScaleMode = vbPixels
    picLivelliPixH = picLivelli.ScaleHeight
    prgLivelloPixT = prgLivello(1).Top + 3
    prgLivelloPixB = prgLivello(1).Top + prgLivello(1).Height - 3
'
    ' Limiti del quadro:
    QxMin = 0
    QxMax = 100
    RPixUser = (LivMaxSc - LivMinSc) / (prgLivelloPixB - prgLivelloPixT)
    QyMin = LivMinSc - RPixUser * (picLivelliPixH - prgLivelloPixB)
    QyMax = LivMaxSc + RPixUser * prgLivelloPixT
'
    ' Imposto la scala con unita' orizzontali arbitrarie
    ' ed unita' verticali in [DigVal]:
    picLivelli.Picture = LoadPicture()
    picLivelli.Scale (QxMin, QyMax)-(QxMax, QyMin)
'
    ' Calcolo l' offset di posizione delle
    ' freccette di livello massimo:
    OffY_picLivMax = Abs(picLivelli.ScaleY(4, vbPixels, vbUser))
'
    ' Variabili per il disegno delle linee orizzontali:
    XPix10 = picLivelli.ScaleX(10, vbPixels, vbUser)
    X0 = prgLivello(1).Left - XPix10
    X1 = prgLivello(2).Left + prgLivello(2).Width + XPix10
    XPix10 = picLivelli.ScaleY(10, vbPixels, vbUser)
'
    ' Variabili per la scrittura dei valori di scala:
    XDig = lblDig.Left
    XVi = lblVi.Left
    ScrivoCome picLivelli, "MS Sans Serif", 10, , vbBlack
    TextH_2 = picLivelli.TextHeight("O") / 2
'
    For I = 0 To 10
        ' Disegno le linee orizzontali:
        Y = LivMinSc + I * DTac
        picLivelli.Line (X0, Y)-(X1, Y)
'
        ' Scrivo la scala dei valori digitali ...
        picLivelli.CurrentX = XDig
        picLivelli.CurrentY = Y - TextH_2
        picLivelli.Print Format$(Y, "#0");
'
        ' ... e quella dei valori reali:
        picLivelli.CurrentX = XVi
        picLivelli.Print Format$(KCal * Y, "#0.00")
    Next I
'
    ' Linea verticale:
    'picLivelli.Line ((X0 + X1) / 2, LivMinSc + XPix10)-((X0 + X1) / 2, LivMaxSc - 2 * XPix10)
'
    ' Scrivo il titolo:
    If (0 < Len(Titolo$)) Then
        ScrivoCome picLivelli, "MS Sans Serif", 10, True, ColTit
'
        TitL = QxMin + picLivelli.TextWidth("I")
        TitH = picLivelli.TextHeight(Titolo$)
'
        TitRECT.Left = picLivelli.ScaleX(TitL - QxMin, vbUser, vbPixels)
        TitRECT.Right = picLivelli.ScaleX(QxMax - TitL, vbUser, vbPixels)
        TitRECT.Top = 0
        TitRECT.Bottom = picLivelli.ScaleY(TitH, vbUser, vbPixels)
'
        DrawText picLivelli.hdc, Titolo$, Len(Titolo$), TitRECT, uFlags
    End If
'
'
'
End Sub
Private Sub txtAlfa_Change()
'
'
    If (Val(txtAlfa.Text) <= 0) Then txtAlfa.Text = 0
    If (100 < Val(txtAlfa.Text)) Then txtAlfa.Text = 100
'
    AlfaLS = CDbl(txtAlfa.Text) / 100#
    AlfaLS_1 = 1# - AlfaLS
'
    'cmdVMaxReset.Enabled = (0.9 < AlfaLS)
'
'
'
End Sub
Private Sub txtAlfa_DblClick()
'
'
    txtAlfa.Text = 0
'
'
'
End Sub
Private Sub txtAlfa_KeyPress(KeyAscii As Integer)
'
'
    KeyAscii = KAscNumInteri(KeyAscii)
'
'
'
End Sub
Private Sub txtTsPicco_Change()
'
'
    txtTsPicco.BackColor = vbYellow
'
'
'
End Sub
Private Sub txtTsPicco_KeyPress(KeyAscii As Integer)
'
'
    Select Case KeyAscii
    Case vbKeyEscape
        KeyAscii = 0
'
        txtTsPicco.Text = Format$(TsPiccoLS, "#0.0###")
        txtTsPicco.BackColor = vbWindowBackground
'
    Case vbKeyReturn
        KeyAscii = 0
'
        If (Val(ValC2D(txtTsPicco.Text)) < TsPiccoMin) Then
            TsPiccoLS = TsPiccoMin
'
        Else
            TsPiccoLS = Val(ValC2D(txtTsPicco.Text))
        End If
'
        txtTsPicco.Text = Format$(TsPiccoLS, "#0.0###")
        txtTsPicco.BackColor = vbWindowBackground
'
        NcPicco = TsPiccoLS * Fs
        IcPicco = 0
        LivMax(1) = 0
        LivMax(2) = 0
'
    Case Else
        KeyAscii = KAscNumReali(KeyAscii)
        txtTsPicco.ToolTipText = " Invio per confermare "
    End Select
'
'
'
End Sub
Private Sub updTsPicco_DownClick()
'
'   Implementa la sequenza  ... -> 10 -> 5 -> 2 -> 1 sul numero dei campioni:
'
    txtTsPicco.Text = Sequenza5_2_1(CDbl(txtTsPicco.Text), , TsPiccoMin)
'
    txtTsPicco_KeyPress vbKeyReturn
'
'
'
End Sub
Private Sub updTsPicco_UpClick()
'
'   Implementa la sequenza 1 -> 2 -> 4 -> 10 sul numero dei campioni:
'
    txtTsPicco.Text = Sequenza1_2_5(CDbl(txtTsPicco.Text), , 10)
'
    txtTsPicco_KeyPress vbKeyReturn
'
'
'
End Sub
Private Sub lblTsPiccoU_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
'
'
    lblTsPiccoU.ToolTipText = " N campioni = " & NcPicco & " "
'
'
'
End Sub

Public Sub ApplicaPreferenze()
'
'
    DisegnaQuadro
'
'
'
End Sub
