VERSION 5.00
Begin VB.Form frmMisure 
   BorderStyle     =   1  'Fixed Single
   Caption         =   " Misure"
   ClientHeight    =   3555
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   5280
   Icon            =   "frmMisure.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MDIChild        =   -1  'True
   ScaleHeight     =   3555
   ScaleWidth      =   5280
   Begin VB.CommandButton cmdMisura 
      Caption         =   "Ferma &Misura"
      Height          =   285
      Left            =   3240
      Style           =   1  'Graphical
      TabIndex        =   5
      Top             =   2760
      Width           =   1515
   End
   Begin VB.Frame zFrame3 
      Caption         =   "Valore Efficace"
      Height          =   1515
      Left            =   2790
      TabIndex        =   13
      Top             =   180
      Width           =   2355
      Begin VB.CommandButton cmdAzzeraRMS 
         Caption         =   "&Azzera"
         Height          =   285
         Left            =   180
         TabIndex        =   1
         Top             =   1020
         Width           =   795
      End
      Begin VB.Label lblVRMS 
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   14.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   315
         Left            =   180
         TabIndex        =   16
         Top             =   360
         Width           =   1995
      End
      Begin VB.Label lblNSumRMS 
         BorderStyle     =   1  'Fixed Single
         Height          =   285
         Left            =   1140
         TabIndex        =   15
         Top             =   1020
         Width           =   1035
      End
      Begin VB.Label zLabel03 
         BackStyle       =   0  'Transparent
         Caption         =   "N Somme:"
         Height          =   315
         Left            =   1140
         TabIndex        =   14
         Top             =   780
         Width           =   1455
      End
   End
   Begin VB.CommandButton cmdAzzeraTutto 
      Caption         =   "Azzera &tutto"
      Height          =   285
      Left            =   3240
      TabIndex        =   4
      Top             =   2160
      Width           =   1515
   End
   Begin VB.Frame zFrame2 
      Caption         =   "Valore Picco-Picco"
      Height          =   1515
      Left            =   120
      TabIndex        =   9
      Top             =   1860
      Width           =   2355
      Begin VB.CommandButton cmdAzzeraPP 
         Caption         =   "&Azzera"
         Height          =   285
         Left            =   1380
         TabIndex        =   3
         Top             =   1020
         Width           =   795
      End
      Begin VB.TextBox txtRilassamento 
         Height          =   285
         Left            =   180
         TabIndex        =   2
         Top             =   1020
         Width           =   975
      End
      Begin VB.Label lblPP 
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   14.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   315
         Left            =   180
         TabIndex        =   11
         Top             =   360
         Width           =   1995
      End
      Begin VB.Label zLabel01 
         BackStyle       =   0  'Transparent
         Caption         =   "&Rilassamento:"
         Height          =   315
         Left            =   180
         TabIndex        =   10
         Top             =   780
         Width           =   1455
      End
   End
   Begin VB.Frame zFrame1 
      Caption         =   "Valor Medio"
      Height          =   1515
      Left            =   120
      TabIndex        =   6
      Top             =   180
      Width           =   2355
      Begin VB.CommandButton cmdAzzeraMedia 
         Caption         =   "&Azzera"
         Height          =   285
         Left            =   1380
         TabIndex        =   0
         Top             =   1020
         Width           =   795
      End
      Begin VB.Label zLabel02 
         BackStyle       =   0  'Transparent
         Caption         =   "N Somme:"
         Height          =   315
         Left            =   180
         TabIndex        =   12
         Top             =   780
         Width           =   1455
      End
      Begin VB.Label lblNSumMedia 
         BorderStyle     =   1  'Fixed Single
         Height          =   285
         Left            =   180
         TabIndex        =   8
         Top             =   1020
         Width           =   1035
      End
      Begin VB.Label lblVMedio 
         BorderStyle     =   1  'Fixed Single
         BeginProperty Font 
            Name            =   "Courier New"
            Size            =   14.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   315
         Left            =   180
         TabIndex        =   7
         Top             =   360
         Width           =   1995
      End
   End
   Begin VB.Line zLine4 
      X1              =   3360
      X2              =   2640
      Y1              =   2280
      Y2              =   2280
   End
   Begin VB.Line zLine3 
      X1              =   2640
      X2              =   2220
      Y1              =   3000
      Y2              =   3000
   End
   Begin VB.Line zLine2 
      X1              =   3000
      X2              =   2220
      Y1              =   1320
      Y2              =   1320
   End
   Begin VB.Line zLine1 
      X1              =   2640
      X2              =   2640
      Y1              =   1320
      Y2              =   3000
   End
End
Attribute VB_Name = "frmMisure"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'=======================================================================================
' Descrizione.....: Misura, per ora, il valore medio, il valore
'                   efficace (RMS) e quello picco-picco della
'                   sequenza di campioni Vin in ingresso.
'                   Form usato solo per calibrazione e debug.
' Nome dei Files..: frmMisure.frm, frmMisure.frx,
'                   modUtilita.bas.
' Data............: 23/08/2003
' Versione........: 1.0 a 32 Bits.
' Sistema.........: VB6 (SP5) sotto Windows XP (SP2).
' Scritto da......: F. Languasco 
' E-Mail..........: MC7061@mclink.it
' DownLoads a.....: http://www.flanguasco.org
'=======================================================================================
'
Option Explicit
'
Dim NSumMed#        ' N di somme su cui e' calcolata la media.
Dim VMedio#         ' Valor medio corrente (dall' ultimo azzeramento).
'
Dim NSumRMS#        ' N di somme su cui e' calcolato il valore efficace.
Dim V2RMS#          ' Quadrato del valore efficace corrente (dall' ultimo azzeramento).
'
Dim Rilassamento#   ' Fattore di rilassamento della misura picco-picco;
                    ' se = 0 viene memorizzato il valore piu'
                    ' grande dall' ultimo azzeramento.
Dim VMax#           ' Valor massimo corrente (dall' ultimo azzeramento).
Dim VMin#           '   "   minimo     "        "      "        "
'
Dim bMisura As Boolean      ' Flag di misura attiva.
Dim bMeLoaded As Boolean    ' Flag di Form caricata.
Private Sub cmdAzzeraMedia_Click()
'
'
    NSumMed = 0#
    VMedio = 0#
    lblVMedio.Caption = ""
    lblNSumMedia.Caption = ""
'
'
'
End Sub
Private Sub cmdAzzeraPP_Click()
'
'
    VMax = -1E+300
    VMin = 1E+300
    lblPP.Caption = ""
'
'
'
End Sub
Private Sub cmdAzzeraRMS_Click()
'
'
    NSumRMS = 0#
    V2RMS = 0#
    lblVRMS.Caption = ""
    lblNSumRMS.Caption = ""
'
'
'
End Sub
Private Sub cmdAzzeraTutto_Click()
'
'
    cmdAzzeraMedia_Click
    cmdAzzeraRMS_Click
    cmdAzzeraPP_Click
'
'
'
End Sub
Private Sub cmdMisura_Click()
'
'
    bMisura = (Not bMisura)
'
    cmdMisura.Caption = IIf(bMisura, "Ferma &Misura", "Continua &Misura")
    cmdMisura.BackColor = IIf(bMisura, vbButtonFace, vbYellow)
'
'
'
End Sub
Private Sub Form_Load()
'
    Dim Me_L&, Me_T&
'
    LeggiPosizioneFormINI FileINI$, Me, Me_L, Me_T
    Me.Move Me_L, Me_T
'
    txtRilassamento.Text = 0.000001
    cmdAzzeraTutto_Click
'
    bMisura = True
    bMeLoaded = True
'
'
'
End Sub
Public Sub Misura(ByVal VIn_I As Variant)
'
'   Misura il valor medio, il valore efficace e quello
'   picco-picco della sequenza di campioni VIn:
'
    Dim VIn#
'
    ' Per non perdere il primo campione:
    If (Not bMeLoaded) Then Me.Show
'
    If bMisura Then
        VIn = CDbl(VIn_I)
'
        ' Calcola il valor medio:
        NSumMed = NSumMed + 1#
        VMedio = (VMedio * (NSumMed - 1#) + VIn) / NSumMed
        lblNSumMedia.Caption = NSumMed
        lblVMedio.Caption = IIf(VMedio <= 0, "", "+") & Format$(VMedio, "#0.000000")
'
        ' Calcola il valore efficace:
        NSumRMS = NSumRMS + 1#
        V2RMS = (V2RMS * (NSumRMS - 1#) + VIn * VIn) / NSumRMS
        lblNSumRMS.Caption = NSumRMS
        lblVRMS.Caption = Format$(Sqr(V2RMS), "#0.000000")
'
        ' Calcola il valore picco-picco:
        VMin = VMin + Rilassamento
        VMax = VMax - Rilassamento
'
        If (VIn < VMin) Then VMin = VIn
        If (VMax < VIn) Then VMax = VIn
        lblPP.Caption = Format$(VMax - VMin, "#0.000000")
    End If
'
'
'
End Sub
Private Sub Form_Unload(Cancel As Integer)
'
'
    SalvaPosizioneFormINI FileINI$, Me
'
    Set frmMisure = Nothing
'
'
'
End Sub
Private Sub txtRilassamento_Change()
'
'
    Rilassamento = Val(ValC2D(txtRilassamento.Text))
'
'
'
End Sub
Private Sub txtRilassamento_KeyPress(KeyAscii As Integer)
'
'
    KeyAscii = KAscNumReali(KeyAscii)
'
'
'
End Sub
