Attribute VB_Name = "modAudioCardDSP"
'=======================================================================================
' Descrizione.....: Strumenti di misura per segnali elettrici ed acustici acquisiti
'                   tramite scheda audio.
'                   Comprende, per ora, un Analizzatore di Spettro con spettrogramma,
'                   un Oscilloscopio, un Correlatore con funzioni statistiche, un
'                   misuratore a barre del livello dei segnali [ed un misuratore
'                   numerico dei segnali].
' Nome dei Files..: frmAudioCardDSP.frm, frmAudioCardDSP.frx,
'                   frmAcquisizione.frm, frmAcquisizione.frx,
'                   frmASpettro.frm, frmASpettro.frx,
'                   frmOScopio.frm, frmOScopio.frx,
'                   frmCorrelatore.frm, frmCorrelatore.frx,
'                   frmHtFitter.frm, frmHtFitter.frx,
'                   frmCepstrum.frm, frmCepstrum.frx,
'                   frmLivelli.frm, frmLivelli.frx,
'                   frmCalibrazione.frm, frmCalibrazione.frx,
'                   frmPreferenze.frm, frmPreferenze.frx,
'                   frmStampaFCPB.frm, frmStampaFCPB.frx,
'                   frmIstruzioni.frm, frmIstruzioni.frx,
'                   frmInfoCr.frm, frmInfoCr.frx, frmCurve.frm, frmCurve.frx,
'                   frmMisure.frm, frmMisure.frx, frmInfo.frm, frmInfo.frx,
'                   modAudioCardDSP.bas, modDSP.bas, modComplex, modFlexPB.bas,
'                   modHtFitter, modCommonDialog.bas, modUtilita.bas,
'                   modMixerControl.bas, modMatrici, modRPOLY.
'
'                   Curva A.txt, Curva B.txt, Curva C.txt, Curva D.txt,
'                   Istruzioni.rtf, Calibrazione_KCal.rtf, Compensazione_MUX.rtf,
'                   Preferenze_del_Trigger.rtf.
'
' Data............: 15/08/2003 (Ver. 1.0).
' Aggiornamento...: 22/05/2004 (Ver. 2.0, prima versione per Scheda Audio).
' Aggiornamento...: 03/01/2005 (Ver. 2.1).
' Aggiornamento...: 22/08/2005 (Ver. 2.3).
' Aggiornamento...: 16/10/2005 (Ver. 2.4, aggiunto il correlatore).
' Aggiornamento...: 18/12/2005 (Ver. 2.5, aggiunto lo spettrogramma).
' Aggiornamento...: 29/07/2006 (Ver. 2.6, aggiunte le funzioni matematiche, etc...).
' Revisione.......: 29/09/2006 (Ver. 2.6.r, eliminati alcuni "bugs" della ver. 2.6).
' Aggiornamento...: 23/10/2006 (Ver. 2.7, aggiunte le configurazioni di misura, il
'                               "Delayed Time Base", le funzioni a due segnali, le
'                               unita' di misura ingegneristiche, etc...).
' Aggiornamento...: 31/05/2007 (Ver. 2.7.1, aggiunta la misura di frequenza, miglio-
'                               rato e velocizzato il calcolo delle funzioni di cor-
'                               relazione ed il disegno dei grafici, etc...).
' Revisione.......: 06/09/2007 (Ver. 2.7.1.r).
' Aggiornamento...: 20/11/2007 (Ver. 2.7.2, aggiunto il modo di visione "Roll", il
'                               misuratore a barre dei livelli, etc...).
' Aggiornamento...: 21/01/2008 (Ver. 2.7.3, aggiunto lo spettrogramma 3D, etc...).
' Revisione.......: 03/03/2008 (Ver. 2.7.3.r, eliminati alcuni "bugs" delle versioni
'                   13/05/2008  precedenti, e.g. il "system crash" in particolari
'                               condizioni del programma compilato, etc...).
' Aggiornamento...: 01/12/2008 (Ver. 2.8.0, aggiunto l' Ht(f) curve fitter, etc...).
' Aggiornamento...: 23/04/2009 (Ver. 2.8.1, aggiunto il filtro di trigger con spettro
'                   03/06/2009  mobile, l' isteresi variabile per il comparatore del
'                               trigger, cambiato l' algoritmo di sincronizzazione
'                               delle tracce in modo "Roll", etc...).
' Aggiornamento...: 15/01/2010 (Ver. 3.0.0, nuova versione della gestione delle
'                               schede audio, aggiunto il calcolo del Cepstrum, etc...)
' Versione........: 3.0.0 a 32 Bits.
' Sistema.........: VB6 (SP5) sotto Windows XP (SP2).
' Scritto da......: F. Languasco 
' E-Mail..........: MC7061@mclink.it
' DownLoads a.....: http://www.flanguasco.org
'=======================================================================================
'
'-------------------------------------------------------------------------*
'   Ringraziamenti a Marv Solowey, <mmsont@yahoo.ca>, Canada, per avermi  |
'   stimolato in questo progetto, per avermi iniziato all' uso delle API  |
'   di acquisizione dalla scheda audio e per le sue routines di controllo |
'   dei Recording Volume Controls (modMixerRecordingMUX).                 |
'-------------------------------------------------------------------------*
'
'   Nota 1: questo progetto e' stato sviluppato usando il "." come
'           separatore decimale; nonostante abbia cercato di prevenire
'           possibili problemi dovuti all' uso della "," non posso
'           escludere che sia rimasta qualche incongruenza.
'           In particolare potrebbe essere fonte di guai la lettura,
'           dal file AudioCardDSP.ini (specialmente con XP!), dei pa-
'           rametri di calibrazione (vedere i valori assegnati nella
'           routine LeggiParametri e successivamente osservabili con
'           il Form richiamabile dal menu [Calibrazione])
'           In caso di malfunzionamenti dovuti a questo problema,
'           provate a cambiare sul vostro PC le impostazioni interna-
'           zionali e datemi notizia dei "bugs" trovati.
'
'   Nota 2: per un comodo uso degli strumenti di questo progetto
'           e' consigliabile avere una risoluzione dello schermo
'           di almeno 1024 x 768 Pixels.  Per un miglior utilizzo
'           dello strumento Oscilloscopio e' consigliabile l' uso
'           di CPU Pentium III a 500 MHz o superiori; l' uso del
'           "Roll" pu essere problematico su PC dotati di CPU con
'           frequenza di clock inferiore ai 700 MHz.
'
'   Nota 3: in questo progetto ho fatto largo uso di variabili booleane
'           corrispondenti allo stato dei controlli di tipo OptionButtons
'           e CheckBoxes.  Questo per aumentare la velocita' di esecuzione
'           delle routines critiche: la verifica dello stato di questi
'           controlli e', infatti, circa venti volte piu' lenta di quella
'           di una variabile booleana.
'
'   Nota 4: ho introdotto l' unita' di misura [DigVal] per indicare valori
'           digitali a 16 Bits, i.e. quelli direttamente ritornati dal
'           convertitore A/D della scheda audio.
'           Dalla Ver. 2.7 e' possibile definire, indipendentemente e per
'           ognuno dei due canali, le unita' ingegneristiche preferite ma,
'           nelle unita' di misura associate alle variabili del progetto,
'           ho sempre usato l' unita' [Vi] per indicare valori di segnali
'           in ingresso alla scheda audio.
'           L' unita' [campioni] e' per le grandezze misurabili in [s * Fs].
'
'   Nota 5: le variabili di tipo Currency sono utilizzate dal "Performance
'           Counter", i.e. quando servono nelle API variabili intere di 64 Bits.
'
'   Nota 6: NON forzare (e.g. con Task Manager) e specialmente in IDE, l' arresto
'           di questo programma quando e' attiva l' acquisizione dei segnali: il
'           collegamento con la scheda audio potrebbe restare aperto impedendo ogni
'           successivo riavvio ed obbligando ad uno "shut-down" e "restart" del sistema.
'           Usare sempre, prima di chiudere, il pulsante [Stop] del Form Acquisizione
'           dei segnali.
'
'   Nota 7: il progetto e' ancora in via di sviluppo; ho lasciato, pertanto,
'           istruzioni e routines per taratura, debug, misure dei tempi di
'           calcolo/disegno ed uscite di sicurezza (per poter saltare intere
'           routines senza fermare l' esecuzione del programma; vedi Nota 6).
'
Option Explicit
'
Public MixerWiI&    ' Indice, in MixerWi(), del mixer corrente di tipo WAVEIN;
                    '  1 <= MixerWiI <= NMixWi.
'
Public Fs&  ' Frequenza di campionamento del segnale [Hz].
            ' Nota: questa variabile pubblica e' usata dai Forms
            '       frmAcquisizione, frmCalibrazione e frmPreferenze;
            '       i Forms degli strumenti (frmAspettro, frmOScopio
            '       frmCorrelatore e frmCepstrum) usano una loro propria
            '       frequenza di campionamento Fs che puo' avere valore
            '       diverso da questa.
'
Public NbDone&  ' N di buffer WaveInHdr, nella Sub Acquisizione,
                ' gia' marcati con il flag .dwFlags = WHDR_DONE.
                ' Serve ad evitare il disallineamento dei buffers.
'
Public bAcqOn As Boolean                ' Flag di acquisizione in corso.
'
Public bAnalizzatoreSpettro As Boolean  ' Flag di analizzatore di spettro attivo.
Public bOscilloscopio As Boolean        ' Flag di oscilloscopio attivo.
Public bCorrelatore As Boolean          ' Flag di correlatore attivo.
Public bLivelliSuono As Boolean         ' Flag di misuratore di livelli attivo.
'
Public bPerfCounterOK As Boolean        ' Flag di "Performance Counter" disponibile.
'
Public FileINI$     ' File di inizializzazione dei parametri dello strumento.
'
Public Type CurvaFM_Type    ' Curva di compensazione psofometrica per il fonometro.
    Fm As Double            ' Frequenza di misura [Hz].
    dB As Double            ' Attenuazione in [dB] alla frequenza Fm.
    Lin As Double           ' Attenuazione lineare  "      "      ".
End Type
Public CurvaFM() As CurvaFM_Type
'
Private CurvaFM2_Lin#()     ' Derivata seconda della curva CurvaFM().Lin: per SplineIntCurvaFM.
Private CurvaFM2_dB#()      '    "        "      "     "   CurvaFM().dB:   "     "
'
Public mstPreferenze_Tab&   ' Tavola corrente del Form Preferenze.
'
' Coefficienti di calibrazione dei canali (vedi nota 1 di frmASpettro e frmOScopio).
Public KCal08k! ' Per frequenza di campionamento di  8000 Hz.
Public KCal11k! '  "     "       "      "         " 11025 Hz ed altre < 48000 Hz.
Public KCal22k! '  "     "       "      "         " 22050 Hz.
Public KCal32k! '  "     "       "      "         " 32000 Hz.
Public KCal44k! '  "     "       "      "         " 44100 Hz.
Public KCal48k! '  "     "       "      "         " 48000 Hz e superiori.
'
Public Ui_Ch$(1 To 2)   ' Unita' di misura dei segnali in ingresso.
'
Public CompMUX! ' Coefficiente di compensazione (vedi nota 3 di frmOScopio) del
                ' ritardo introdotto dal multiplexer della scheda audio [s].
Public AdcV2V1! ' Rapporto di guadagno fra il canale destro e quello sinistro
                ' del convertitore ADC della scheda audio (solo calcolato, per
                ' ora; previsto per usi futuri).
'
' Preferenze generali:
Public ColRet&          ' Colore dei reticoli.
Public ColSch&          ' Colore di fondo degli schermi.
Public ColTit&          ' Colore dei titoli.
'
Public ColTrig&         ' Colore dei riferimenti di trigger.
Public ColPreTrig&      ' Colore dei riferimenti di pre-trigger.
Public ColCur&          ' Colore dei cursori di misura.
'
Public Const ColOn& = &H80FF80      ' Colore di comando attivo.
'
Private bVediMsgSchermo As Boolean  ' Messaggio attivo di bassa risoluzione schermo.
Private bLeggiIstruzioni As Boolean ' Messaggio attivo di "Leggi le Istruzioni".
'
' Preferenze, variabili e costanti per l' analizzatore di spettro:
Public ColCmp&          ' Colore dei campioni dello spettro.
Public ColProf&         ' Colore del profilo dello spettro (*);
                        ' e' usato anche in frmCepstrum per il colore del Log(Sx).
Public ColProf_3D&      ' Colore del profilo dello spettrogramma in 3D (*).
Public ColFase&         ' Colore del grafico della fase (*).
Public ColGammaQ&       ' Colore del grafico della funzione di coerenza.
Public ColFTRea&        ' Colore del grafico della parte reale dello spettro (*).
Public ColFTImm&        ' Colore del grafico della parte immaginaria dello spettro (*).
'
Public ITCol&           ' Indice della tabella corrente dei colori (*).
Public NTCol&           ' Numero di colori disponibili in TCol() (*).
Public TCol&()          ' Tavola dei colori per lo spettrogramma e Ht(p) 3D (*).
'
Public bRiConfigAS As Boolean   ' Flag di inizializzazione con l' ultima configurazione.
'
Public b2Sig As Boolean         ' Flag di analisi di due segnali.
Public bCepstrum As Boolean     ' Flag di calcolo del Cepstrum attivo.
Public bLinee As Boolean        ' Flag di grafico a linee.
Public bProfilo As Boolean      ' Flag di profilo visibile.
Public bProfilo_3D As Boolean   ' Flag di profilo in 3D visibile.
Public bNotSProf_3D As Boolean  ' Flag di solo profilo in 3D disabilitato.
Public bReticoloSpgm As Boolean ' Flag di disegno del reticolo dello spettrogramma.
Public bScalaF_Fs As Boolean    ' Flag di scala in f/Fs visibile (*).
Public bSpgm_3D As Boolean      ' Flag di spettrogramma in 3D.
Public NPixSpgmY&               ' Passo di avanzamento degli spettri nello spettrogramma 3D [Pixels].
Public NPixSpgmX&               ' Passo di scostamento degli spettri nello spettrogramma 3D [Pixels].
'
                                ' Enumerazioni per i dBu/dBV:
Public Const dBu_RMS& = 1       '  scala dello spettro di ampiezza RMS in dBu;
Public Const dBV_RMS& = 2       '    "     "     "     "     "      "  "  dBV.
Public dB_RMS&                  ' Tipo di scala per lo spettro di ampiezza RMS.
'
Public dBm_Z0#                  ' Impedenza per il calcolo dello spettro
                                ' di potenza in dBm [Ohm].
'
Public Const dBu_Ref# = 0.7746  ' Tensione efficace di riferimento
                                ' per il calcolo dei dBu [Vrms].
Public Const dBV_Ref# = 1#      ' Tensione efficace di riferimento
                                ' per il calcolo dei dBV [Vrms].
'
Public bFonometroOn As Boolean  ' Flag di misura con fonometro attiva.
Public KCalFM#                  ' Coefficiente di taratura del fonometro.
Public TipoCurvaFM$             ' Tipo della curva (A|B|C|D|Piatta) di ponderazione
                                ' per fonometro.
'
' Preferenze per l' oscilloscopio:
Public IntTracce&               ' Intensita' delle tracce [Pixels].
Public ColTr&(1 To 3)           ' Colore delle tracce; il colore della traccia #3 e',
                                ' per ora, attribuito solo al "Delayed Time Base".
Public ColMfn&                  ' Colore della traccia #3 con funzione matematica (*);
                                ' e' usato anche in frmCorrelatore per il disegno dei
                                ' grafici ed in frmCepstrum per il colore del Cepstrum.
'
Public bRiConfigOS As Boolean   ' Flag di inizializzazione con l' ultima configurazione.
'
Public bCampioniCh1 As Boolean  ' Flag di visualizzazione dei campioni del canale #1.
Public bCampioniCh2 As Boolean  ' Flag di visualizzazione dei campioni del canale #2.
Public bRiseTime As Boolean     ' Flag di visualizzazione dei riferimenti per "rise-time".
Public bLinTrigDtbOn As Boolean ' Flag di visualizzazione delle linee di trigger e pre-trigger.
Public bLinTrigIstOn As Boolean ' Flag di visualizzazione della linea di isteresi del trigger.
Public bTTracciaOn As Boolean   ' Flag di richiesta scrittura del tempo traccia.
Public bCicloTrigOn As Boolean  ' Flag di richiesta scrittura del ciclo di trigger.
Public bCicloTrigFr As Boolean  ' Flag di scrittura del ciclo di trigger in frequenza.
Public bCorrDtDer As Boolean    ' Flag di correzione, con dt, del valore della derivata.
Public bCorrDtInt As Boolean    ' Flag di correzione, con dt, del valore dell' integrale.
'
Public bTrigFiltLHP As Boolean  ' Tipo di filtro del trigger: True  = passa-basso o passa-alto.
                                '                             False = spettro mobile.
Public bTrigFiltLP As Boolean   ' Filtro del trigger: True  = passa-basso,
                                '                     False = passa-alto.
Public bTrigFiltRC As Boolean   ' Filtro del trigger: True  = tipo RC,
                                '                     False = tipo Chebyshev.
Public TrigFiltFT#              ' Frequenza di taglio del filtro del trigger LP/HP
                                ' o frequenza di accordo dello spettro mobile [Hz].
Public TrigFiltRSpM#            ' Ritardo del filtro del trigger con spettro mobile [s].
Public TrigIstV#                ' Isteresi del trigger [V].
'
Public NpRisRoll&               ' Passo di avanzamento delle tracce in modo "Roll" [Pixels].
Public bAutoLimInt As Boolean   ' Flag di autolimitazione dell' integrale in "Roll".
'
' Preferenze per il misuratore di livelli:
Public Const ColLivMax& = vbRed ' Colore delle freccette di livello massimo.
'
Public TsPiccoLS!               ' Intervallo temporale su cui ricercare il picco
                                ' di livello [s].
Public AlfaLS#                  ' Coefficiente di smorzamento per l'indicazione dei
                                ' valori massimi(0 <= Alfa <= 1).
'
' Preferenze per il "Frequency Transfer Function Curve Fitter":
'  I valori segnati con (*) sono usati anche in frmHtFitter.
'
'--- PerformanceCounter: ---------------------------------------------------------------
Public lpFrequency As Currency ' Conteggi al secondo del timer [Hz / 10000].
Public Declare Function QueryPerformanceFrequency Lib "kernel32" (lpFrequency As Currency) As Boolean
Public Declare Function QueryPerformanceCounter Lib "kernel32" (lpCount As Currency) As Boolean
Public Function LeggiCurvaFM(ByVal FileCurvaFM$, CurvaFM_L() As CurvaFM_Type) As Boolean
'
'
    Dim I&, FF%
'
    On Error GoTo LeggiCurvaFM_ERR
'
    If (FileCurvaFM$ = "Piatta") Then
        ReDim Preserve CurvaFM_L(1 To 50)
        For I = 1 To 50
            CurvaFM_L(I).Fm = LinTrasf(CDbl(I), 1#, 0#, 50#, 25000#)
            CurvaFM_L(I).dB = 0#
            CurvaFM_L(I).Lin = 1#
        Next I
'
    Else
        FF = FreeFile
        Open App.Path & "\" & FileCurvaFM$ & ".txt" For Input As #FF
'
        I = 1
        Do While (Not EOF(FF))
            ReDim Preserve CurvaFM_L(1 To I)
            Input #FF, CurvaFM_L(I).Fm, CurvaFM_L(I).dB
            CurvaFM_L(I).Lin = dBToLin(CurvaFM_L(I).dB)
'
            I = I + 1
        Loop
    End If
'
'
LeggiCurvaFM_ERR:
    If (FileCurvaFM$ <> "Piatta") Then Close #FF
'
    LeggiCurvaFM = (Err.Number = 0)
    If (Err.Number <> 0) Then
        Dim M$
        If (Err.Number = 53) Then
            M$ = "Manca il file " & FileCurvaFM$ & ".txt" & vbNewLine & vbNewLine
        End If
        M$ = M$ & "Errore " & Str$(Err.Number) & vbNewLine
        M$ = M$ & Err.Description
        MsgBox M$, vbCritical, " modAudioCardDSP: LeggiCurvaFM"
    End If
'
'
'
End Function
Public Function InterpolaCurvaFM(ByVal Fm As Double) As Double
'
'   Ritorna il valore interpolato alla frequenza Fm
'   della curva psofometrica corrente; il valore in
'   [dB] non e', al momento, utilizzato:
'
    Dim VdB#, VLin#
'
    SplineIntCurvaFM CurvaFM(), Fm, VdB, VLin
'
    InterpolaCurvaFM = VLin
'
'
'
End Function
Public Sub SplineCurvaFM(CurvaFM() As CurvaFM_Type)
'
'   Routine di inizializzazione per SplineIntCurvaFM.
'
'   Given arrays X(1:n) and Y(1:n) containing a tabulated function, i.e., yi = f(xi),
'   with x1 < x2 < :: : < xn , and given values yp1 and ypn for the first derivative
'   of the interpolating function at points 1 and n, respectively, this routine returns
'   an array Y2(1:n) of length n which contains the second derivatives of the interpo-
'   lating function at the tabulated points xi. If yp1 and/or ypn are equal to +1e30
'   or larger, the routine is signaled to set the corresponding boundary condition for
'   a natural spline, with zero second derivative on that boundary.
'
'   Da: Numerical Recipes in FORTRAN 77,
'       The Art of Scientific Computing,
'       Second Edition, pg. 109.
'
'   Vers. per VectImp del 02/02/2006.
'   Vers. per Fonometro di AudioCardDSP del 19/09/2006.
'
    Dim I&, K&, N&, NP&
    Dim p#, qn#, SIG#, un#
    N = UBound(CurvaFM)
    ReDim u#(1 To N)
'
    NP = UBound(CurvaFM)
    ReDim X#(1 To NP), Y#(1 To NP), CurvaFM2_dB#(1 To NP), CurvaFM2_Lin#(1 To NP)
'
    For I = 1 To NP
        X(I) = CurvaFM(I).Fm
        Y(I) = CurvaFM(I).dB
    Next I
'
    ' Calcoli per la curva in [dB]:
    CurvaFM2_dB(1) = 0#  ' The lower boundary condition is set to be "natural".
    u(1) = 0#
'
    For I = 2 To N - 1  ' This is the decomposition loop of the tridiagonal
                        ' algorithm. y2 and u are used for temporary
                        ' storage of the decomposed factors.
        SIG = (X(I) - X(I - 1)) / (X(I + 1) - X(I - 1))
        p = SIG * CurvaFM2_dB(I - 1) + 2#
        CurvaFM2_dB(I) = (SIG - 1#) / p
        u(I) = (6# * ((Y(I + 1) - Y(I)) / (X(I + 1) - X(I)) - (Y(I) - Y(I - 1)) _
             / (X(I) - X(I - 1))) / (X(I + 1) - X(I - 1)) - SIG * u(I - 1)) / p
    Next I
'
    qn = 0#     ' The upper boundary condition is set to be "natural".
    un = 0#
'
    CurvaFM2_dB(N) = (un - qn * u(N - 1)) / (qn * CurvaFM2_dB(N - 1) + 1#)
    For K = N - 1 To 1 Step -1  ' This is the backsubstitution loop of the tridiago-
                                ' nal algorithm.
        CurvaFM2_dB(K) = CurvaFM2_dB(K) * CurvaFM2_dB(K + 1) + u(K)
    Next K
'
    ' Calcoli per la curva lineare:
    For I = 1 To NP
        Y(I) = CurvaFM(I).Lin
    Next I
'
    CurvaFM2_Lin(1) = 0#  ' The lower boundary condition is set to be "natural".
    u(1) = 0#
'
    For I = 2 To N - 1  ' This is the decomposition loop of the tridiagonal
                        ' algorithm. y2 and u are used for temporary
                        ' storage of the decomposed factors.
        SIG = (X(I) - X(I - 1)) / (X(I + 1) - X(I - 1))
        p = SIG * CurvaFM2_Lin(I - 1) + 2#
        CurvaFM2_Lin(I) = (SIG - 1#) / p
        u(I) = (6# * ((Y(I + 1) - Y(I)) / (X(I + 1) - X(I)) - (Y(I) - Y(I - 1)) _
             / (X(I) - X(I - 1))) / (X(I + 1) - X(I - 1)) - SIG * u(I - 1)) / p
    Next I
'
    qn = 0#     ' The upper boundary condition is set to be "natural".
    un = 0#
'
    CurvaFM2_Lin(N) = (un - qn * u(N - 1)) / (qn * CurvaFM2_Lin(N - 1) + 1#)
    For K = N - 1 To 1 Step -1  ' This is the backsubstitution loop of the tridiago-
                                ' nal algorithm.
        CurvaFM2_Lin(K) = CurvaFM2_Lin(K) * CurvaFM2_Lin(K + 1) + u(K)
    Next K
'
'
'
End Sub
Private Sub SplineIntCurvaFM(CurvaFM() As CurvaFM_Type, ByVal Fm As Double, _
    ByRef VdB As Double, ByRef VLin As Double)
'
'   Routine di interpolazione, con "cubic spline", per i punti di CurvaFM().
'
'   Given the arrays X(1:N) and Y(1:N) of length N, which tabulate a function (with the
'   xi 's in order), and given the array Y2(1:N), which is the output from Spline above,
'   and given a value of Xn, this routine returns a cubic-spline interpolated value.
'
'   Da: Numerical Recipes in FORTRAN 77,
'       The Art of Scientific Computing,
'       Second Edition, pg. 110.
'
'   Vers. per Fonometro di AudioCardDSP del 19/09/2006.
'
    Dim I&, K&, NP&, khi&, klo&
    Dim a#, B#, h#
'
    On Error GoTo SplineIntCurvaFM_ERR
'
    NP = UBound(CurvaFM)
'
    ' We will find the right place in the table by means of bisection.
    ' This is optimal if sequential calls to this routine are at random
    ' values of x. If sequential calls are in order, and closely
    ' spaced, one would do better to store previous values of
    ' klo and khi and test if they remain appropriate on the next call.
    klo = 1
    khi = NP
'
    Do While (1 < khi - klo)
        K = (khi + klo) / 2
        If (Fm < CurvaFM(K).Fm) Then
            khi = K
        Else
            klo = K
        End If
    Loop
    ' klo and khi now bracket the input value of xn.
'
    h = CurvaFM(khi).Fm - CurvaFM(klo).Fm
    'if (h = 0#) Then ...  routine di gestione errore.  ' bad xi input in Splint
                                                        ' The xi 's must be distinct.
'
    a = (CurvaFM(khi).Fm - Fm) / h   ' Cubic spline polynomial is now evaluated.
    B = (Fm - CurvaFM(klo).Fm) / h
    ' Valore in [dB]:
    VdB = a * CurvaFM(klo).dB + B * CurvaFM(khi).dB _
        + ((a * a * a - a) * CurvaFM2_dB(klo) _
        + (B * B * B - B) * CurvaFM2_dB(khi)) * (h * h) / 6#
    ' Valore lineare:
    VLin = a * CurvaFM(klo).Lin + B * CurvaFM(khi).Lin _
         + ((a * a * a - a) * CurvaFM2_Lin(klo) _
         + (B * B * B - B) * CurvaFM2_Lin(khi)) * (h * h) / 6#
'
'
SplineIntCurvaFM_ERR:
'
'
'
End Sub
Public Sub Main()
'
'
    Dim SW&, SH&, M$, lRetMsg&
'
    On Error GoTo Main_ERR
'
    ' Verifico la disponibilita' di almeno una scheda audio:
    If (Not CercaSchedeAudio) Then
        MsgBox "Questo PC non ha schede audio.", _
               vbCritical, " modDecoToni: Main"
        Exit Sub
    End If
'
    ' Trovo i mixers audio disponibili nel sistema:
    If (Not CercaMixersWi) Then
        MsgBox "La ricerca dei mixers audio ha" & vbNewLine & _
               "trovato una condizione imprevista." & vbNewLine & vbNewLine & _
               "Per la selezione dei canali di ingresso" & vbNewLine & _
               "provare ad usare il ""Volume Control""" & vbNewLine & _
               "di Windows." & vbNewLine, _
               vbCritical, " modDecoToni: Main"
    End If
'
    FileINI$ = App.Path & "\AudioCardDSP.ini"
'
    ' Leggo impostazioni, preferenze e
    ' coefficienti di calibrazione:
    LeggiParametri
'
    ' Verifico la disponibilita' del timer PerformanceCounter
    ' e ne trovo i conteggi al secondo:
    bPerfCounterOK = QueryPerformanceFrequency(lpFrequency)
    'frmInfo.lblPcFrequency = Format$(10000 * lpFrequency, "#,###")
'
    If bFonometroOn Then
        ' Leggo la curva di pesatura corrente ...:
        If LeggiCurvaFM(TipoCurvaFM$, CurvaFM()) Then
            ' ... e ne calcolo la derivata seconda:
            SplineCurvaFM CurvaFM()
        Else
            bFonometroOn = False
        End If
    End If
'
    frmAudioCardDSP.Show
'
    SW = Screen.Width / Screen.TwipsPerPixelX
    SH = Screen.Height / Screen.TwipsPerPixelY
    If ((SW < 1024) Or (SH < 768)) And bVediMsgSchermo Then
        M$ = "La risoluzione di questo schermo e' di "
        M$ = M$ & SW & " x " & SH & " pixels." & vbNewLine & vbNewLine
        M$ = M$ & "Per un miglior utilizzo di questo programma" & vbNewLine
        M$ = M$ & "si consiglia di usare almeno 1024 x 768 pixels."
        M$ = M$ & vbNewLine & vbNewLine & vbNewLine
        M$ = M$ & "Vuoi che questo messaggio venga ripetuto?"
        lRetMsg = MsgBox(M$, vbInformation + vbYesNo, " Avvertenza")
'
        bVediMsgSchermo = (lRetMsg = vbYes)
        SaveIniString FileINI$, "Preferenze Gen.:", "Vedi Msg. Schermo", bVediMsgSchermo
    End If
'
    If bLeggiIstruzioni Then
        M$ = "Per sfruttare al meglio le possibilit offerte" & vbNewLine
        M$ = M$ & "da questo programma leggere attentamente" & vbNewLine
        M$ = M$ & "(ed eventualmente stampare) il file:" & vbNewLine & vbNewLine
        M$ = M$ & "   --->        Istruzioni.rtf        <---"
        M$ = M$ & vbNewLine & vbNewLine & vbNewLine
        M$ = M$ & "Vuoi che questo messaggio venga ripetuto?"
        lRetMsg = MsgBox(M$, vbInformation + vbYesNo, " Avvertenza")
'
        bLeggiIstruzioni = (lRetMsg = vbYes)
        SaveIniString FileINI$, "Preferenze Gen.:", "Leggi istruzioni", bLeggiIstruzioni
    End If
'
    ' "Splash Form" iniziale:
    frmCopyright.Apri frmAudioCardDSP, vbModeless, 4
'
'
Main_ERR:
    If (Err.Number <> 0) Then
        M$ = "Errore " & Str$(Err.Number) & vbNewLine
        M$ = M$ & Err.Description
        MsgBox M$, vbCritical, " modAudioCardDSP: Main"
    End If
'
'
'
End Sub
Private Sub LeggiParametri()
'
'   Legge, dal file AudiCardDSP.ini, impostazioni,
'   preferenze e coefficienti di calibrazione:
'
    On Error GoTo LeggiParametri_ERR
'
    ' Impostazioni:
    MixerWiI = CLng(GetIniString(FileINI$, "Impostazioni:", "MixerWiI", "1"))
    MixerWiI = MAX0(MIN0(MixerWiI, NMixWi), 1)
    Fs = Val(ValC2D(GetIniString(FileINI$, "Impostazioni:", "Fs", 11025)))
'
    ' Preferenze generali:
    ColRet = CLng(GetIniString(FileINI$, "Preferenze Gen.:", "Col. Reticolo", &HAFAFAF))
    ColSch = CLng(GetIniString(FileINI$, "Preferenze Gen.:", "Col. Schermo", &H5B5B2F))
    ColTit = CLng(GetIniString(FileINI$, "Preferenze Gen.:", "Col. Titolo", vbRed))
    ColTrig = CLng(GetIniString(FileINI$, "Preferenze Gen.:", "Col. Trigger", vbCyan))
    ColPreTrig = CLng(GetIniString(FileINI$, "Preferenze Gen.:", "Col. Pre-trigger", &HFF8080))
    ColCur = CLng(GetIniString(FileINI$, "Preferenze Gen.:", "Col. Cursori", vbMagenta))
'
    bVediMsgSchermo = CBool(GetIniString(FileINI$, "Preferenze Gen.:", "Vedi Msg. Schermo", True))
    bLeggiIstruzioni = CBool(GetIniString(FileINI$, "Preferenze Gen.:", "Leggi istruzioni", True))
'
    ' Preferenze dell' analizzatore di spettro:
    bAnalizzatoreSpettro = CBool(GetIniString(FileINI$, "Preferenze A.S.:", "A. Spettro acceso", True))
'
    ColCmp = CLng(GetIniString(FileINI$, "Preferenze A.S.:", "Colore campioni", vbYellow))
    ColProf = CLng(GetIniString(FileINI$, "Preferenze A.S.:", "Colore profilo", &H80FF&))
    ColProf_3D = CLng(GetIniString(FileINI$, "Preferenze A.S.:", "Colore profilo 3D", vbWhite))
    ColFase = CLng(GetIniString(FileINI$, "Preferenze A.S.:", "Colore fase", vbCyan))
    ColGammaQ = CLng(GetIniString(FileINI$, "Preferenze A.S.:", "Colore GammaQ", vbWhite))
    ColFTRea = CLng(GetIniString(FileINI$, "Preferenze A.S.:", "Colore parte reale", &H80FF&))
    ColFTImm = CLng(GetIniString(FileINI$, "Preferenze A.S.:", "Colore parte imm.", vbCyan))
    ITCol = CLng(GetIniString(FileINI$, "Preferenze A.S.:", "Col. spettrogramma", 5))
'
    bRiConfigAS = CBool(GetIniString(FileINI$, "Preferenze A.S.:", "Usa ultima config.", False))
'
    b2Sig = CBool(GetIniString(FileINI$, "Preferenze A.S.:", "Calcolo doppio spettro", True))
    bCepstrum = CBool(GetIniString(FileINI$, "Preferenze A.S.:", "Calcolo Cepstrum", False))
    bLinee = CBool(GetIniString(FileINI$, "Preferenze A.S.:", "Spettro a linee", False))
    bProfilo = CBool(GetIniString(FileINI$, "Preferenze A.S.:", "Disegna profilo", True))
    bProfilo_3D = CBool(GetIniString(FileINI$, "Preferenze A.S.:", "Disegna profilo in 3D", True))
    bNotSProf_3D = CBool(GetIniString(FileINI$, "Preferenze A.S.:", "Disegna solo profilo in 3D", False))
    bReticoloSpgm = CBool(GetIniString(FileINI$, "Preferenze A.S.:", "Reticolo spettrogramma", False))
    bScalaF_Fs = CBool(GetIniString(FileINI$, "Preferenze A.S.:", "Scala f/Fs", False))
    bSpgm_3D = CBool(GetIniString(FileINI$, "Preferenze A.S.:", "Spettrogramma in 3D", False))
    dB_RMS = CLng(GetIniString(FileINI$, "Preferenze A.S.:", "dB_RMS", dBu_RMS))
    dBm_Z0 = CDbl(GetIniString(FileINI$, "Preferenze A.S.:", "dBm_Z0", 600))
'
    bFonometroOn = CBool(GetIniString(FileINI$, "Preferenze A.S.:", "Fonometro attivo", False))
    KCalFM = Val(ValC2D(GetIniString(FileINI$, "Preferenze A.S.:", "KCalFM", 1#)))
    TipoCurvaFM$ = GetIniString(FileINI$, "Preferenze A.S.:", "Tipo curva psofometrica", "Curva A")
'
    NPixSpgmX = CLng(GetIniString(FileINI$, "Preferenze A.S.:", "Passo X Spgm 3D", 5))
    NPixSpgmY = CLng(GetIniString(FileINI$, "Preferenze A.S.:", "Passo Y Spgm 3D", 5))
'
    ' Preferenze dell' oscilloscopio:
    bOscilloscopio = CBool(GetIniString(FileINI$, "Preferenze O.S.:", "Oscilloscopio acceso", True))
'
    IntTracce = CLng(GetIniString(FileINI$, "Preferenze O.S.:", "Intensita' tracce", 1))
    ColTr(1) = CLng(GetIniString(FileINI$, "Preferenze O.S.:", "Colore traccia 1", vbYellow))
    ColTr(2) = CLng(GetIniString(FileINI$, "Preferenze O.S.:", "Colore traccia 2", &H80FF&))
    ColTr(3) = CLng(GetIniString(FileINI$, "Preferenze O.S.:", "Colore traccia 3", &HFFC9C1))
    ColMfn = CLng(GetIniString(FileINI$, "Preferenze O.S.:", "Colore funzione", vbWhite))
'
    bRiConfigOS = CBool(GetIniString(FileINI$, "Preferenze O.S.:", "Usa ultima config.", False))
'
    bCampioniCh1 = CBool(GetIniString(FileINI$, "Preferenze O.S.:", "Disegna campioni Ch 1", False))
    bCampioniCh2 = CBool(GetIniString(FileINI$, "Preferenze O.S.:", "Disegna campioni Ch 2", False))
    bRiseTime = CBool(GetIniString(FileINI$, "Preferenze O.S.:", "Rif. ""rise-time""", True))
    bLinTrigDtbOn = CBool(GetIniString(FileINI$, "Preferenze O.S.:", "Linee (pre)trigger, DTB", True))
    bLinTrigIstOn = CBool(GetIniString(FileINI$, "Preferenze O.S.:", "Linea isteresi trigger", False))
'
    bTTracciaOn = CBool(GetIniString(FileINI$, "Preferenze O.S.:", "Scrivi tempo traccia", False))
    bCicloTrigOn = CBool(GetIniString(FileINI$, "Preferenze O.S.:", "Misura ciclo trig.", True))
    bCicloTrigFr = CBool(GetIniString(FileINI$, "Preferenze O.S.:", "Misura ciclo trig. Freq.", True))
'
    bCorrDtDer = CBool(GetIniString(FileINI$, "Preferenze O.S.:", "Derivata con dt", False))
    bCorrDtInt = CBool(GetIniString(FileINI$, "Preferenze O.S.:", "Integrale con dt", False))
'
    bTrigFiltLHP = CBool(GetIniString(FileINI$, "Preferenze O.S.:", "TrigFiltLHP", True))
    bTrigFiltLP = CBool(GetIniString(FileINI$, "Preferenze O.S.:", "TrigFiltLP", True))
    TrigFiltFT = Val(ValC2D(GetIniString(FileINI$, "Preferenze O.S.:", "TrigFiltFT", 500#)))
    TrigFiltRSpM = Val(ValC2D(GetIniString(FileINI$, "Preferenze O.S.:", "TrigFiltRSpM", 0.01)))
    bTrigFiltRC = CBool(GetIniString(FileINI$, "Preferenze O.S.:", "TrigFiltRC", True))
    TrigIstV = Val(ValC2D(GetIniString(FileINI$, "Preferenze O.S.:", "Isteresi Trigger", 0.001)))
'
    NpRisRoll = CLng(GetIniString(FileINI$, "Preferenze O.S.:", "Passo Roll", 1))
    bAutoLimInt = CBool(GetIniString(FileINI$, "Preferenze O.S.:", "Autolimite integrale ""Roll""", False))
'
    ' Preferenze del misuratore di livelli:
    bLivelliSuono = CBool(GetIniString(FileINI$, "Preferenze L.S.:", "Misura livelli acceso", False))
'
    TsPiccoLS = Val(ValC2D(GetIniString(FileINI$, "Preferenze L.S.:", "TsPicco", 0.05)))
    AlfaLS = Val(ValC2D(GetIniString(FileINI$, "Preferenze L.S.:", "Alfa", 0.8)))
'
    ' Calibrazioni:
    KCal08k = Val(ValC2D(GetIniString(FileINI$, "Calibrazioni:", "KCal08k", 0.598 / 10000)))
    KCal11k = Val(ValC2D(GetIniString(FileINI$, "Calibrazioni:", "KCal11k", 0.574 / 10000)))
    KCal22k = Val(ValC2D(GetIniString(FileINI$, "Calibrazioni:", "KCal22k", 0.503 / 10000)))
    KCal32k = Val(ValC2D(GetIniString(FileINI$, "Calibrazioni:", "KCal32k", 0.503 / 10000)))
    KCal44k = Val(ValC2D(GetIniString(FileINI$, "Calibrazioni:", "KCal44k", 0.505 / 10000)))
    KCal48k = Val(ValC2D(GetIniString(FileINI$, "Calibrazioni:", "KCal48k", 0.474 / 10000)))
'
    Ui_Ch$(1) = GetIniString(FileINI$, "Calibrazioni:", "Unita' di misura Ch 1", "Vi")
    Ui_Ch$(2) = GetIniString(FileINI$, "Calibrazioni:", "Unita' di misura Ch 2", "Vi")
'
    CompMUX = Val(ValC2D(GetIniString(FileINI$, "Calibrazioni:", "CompMUX", 1! / 48000)))
    AdcV2V1 = Val(ValC2D(GetIniString(FileINI$, "Calibrazioni:", "AdcV2V1", 1!)))
'
'
LeggiParametri_ERR:
    If (Err.Number <> 0) Then
        Dim M$
        M$ = "Errore " & Str$(Err.Number) & vbNewLine
        M$ = M$ & Err.Description
        MsgBox M$, vbCritical, " modAudioCardDSP: LeggiParametri"
    End If
'
'
'
End Sub
Public Function TrovaKCal(ByVal Fs_I As Double) As Single
'
'   Ritorna la costante di calibrazione corrispondente
'   alla frequenza di campionamento Fs_I:
'
    Select Case Fs_I
    Case 8000
        TrovaKCal = KCal08k
    Case 11025, 16000
        TrovaKCal = KCal11k
    Case 22050, 24000
        TrovaKCal = KCal22k
    Case 32000
        TrovaKCal = KCal32k
    Case 44100
        TrovaKCal = KCal44k
    Case Is >= 48000
        TrovaKCal = KCal48k
'
    Case Else
        TrovaKCal = KCal11k
    End Select
'
'
'
End Function
