Attribute VB_Name = "modCommonDialog"
'=======================================================================================
' Descrizione.....: Collezione di routines per la gestione, tramite API, del
'                   CommonDialog per i modi ShowColor, ShowOpen e ShowSave.
'                   Sostituisce il controllo CommonDialog di VB6.
' Nome dei Files..: modCommonDialog.bas
' Data............: 11/12/2009 (Ver. 1.0).
' Revisione.......: 04/02/2010 (Ver. 1.1).
' Versione........: 1.1 a 32 Bits.
' Sistema.........: VB6 (SP5) sotto Windows XP (SP2).
' E-Mail..........: MC7061@mclink.it
' DownLoads a.....: http://www.flanguasco.org
'=======================================================================================
'
Option Explicit
'
Public hWndCmdlgOwnerForm&  ' hWnd del Form rispetto a cui i Common Dialogs appariranno
                            ' come modali; se hwndCmdlgOwnerForm = 0 i Common Dialogs
                            ' appariranno come non modali.
'
Public Const cdlCancel& = &H7FF3&
'
'-- Costanti per API: ------------------------------------------------------------------
'
Private Const CC_RGBINIT& = &H1&
Private Const CC_ANYCOLOR& = &H100
'
Private Const OFN_OVERWRITEPROMPT& = &H2
Private Const OFN_HIDEREADONLY& = &H4
Private Const OFN_FILEMUSTEXIST& = &H1000
'
'-- Strutture per API: -----------------------------------------------------------------
'
Private Type CHOOSECOLORs
    lStructSize As Long
    hwndOwner As Long
    hInstance As Long
    rgbResult As Long
    lpCustColors As Long
    Flags As Long
    lCustData As Long
    lpfnHook As Long
    lpTemplateName As String
End Type
'
Private Type OPENFILENAME
   lStructSize As Long
   hwndOwner As Long
   hInstance As Long
   lpstrFilter As String
   lpstrCustomFilter As String
   nMaxCustFilter As Long
   nFilterIndex As Long
   lpstrFile As String
   nMaxFile As Long
   lpstrFileTitle As String
   nMaxFileTitle As Long
   lpstrInitialDir As String
   lpstrTitle As String
   Flags As Long
   nFileOffset As Integer
   nFileExtension As Integer
   lpstrDefExt As String
   lCustData As Long
   lpfnHook As Long
   lpTemplateName As String
End Type
'
'-- API: -------------------------------------------------------------------------------
'
Private Declare Function ChooseColor Lib "comdlg32.dll" Alias "ChooseColorA" _
    (pChoosecolor As CHOOSECOLORs) As Long
'
Private Declare Function GetOpenFileName Lib "comdlg32.dll" Alias "GetOpenFileNameA" _
    (pOpenfilename As OPENFILENAME) As Long
'
Private Declare Function GetSaveFileName Lib "comdlg32.dll" Alias "GetSaveFileNameA" _
    (pOpenfilename As OPENFILENAME) As Long
'
Private Declare Function CommDlgExtendedError Lib "comdlg32.dll" () As Long
Private Function ShowOpen(ByRef FileName$, ByVal DirNome$, ByVal Filter$, _
    ByVal DialogTitle$, ByVal Flags As Long, Optional ByRef FilterIndex As Long, _
    Optional ByVal MaxFileSize As Long = 256, Optional ByRef ExtendedError As Long) As Boolean
'
'
    Dim I&, FileNameBuff$, NullPos&, OFN As OPENFILENAME
'
    ' Sostituisco gli "|" con caratteri Null ...:
    Filter$ = Replace(Filter$, "|", Chr$(0))
    ' ... e aggiungo due Null finali, come
    ' richiesto dall' API GetSaveFileName:
    Filter$ = Filter$ & Chr$(0) & Chr$(0)
'
    ' Preparo il FileNameBuff$:
    FileNameBuff$ = FileName$
    For I = Len(FileName$) + 1 To MaxFileSize - 1
        FileNameBuff$ = FileNameBuff$ & " "
    Next I
    FileNameBuff$ = FileNameBuff$ & Chr$(0)
'
    With OFN
        .lStructSize = Len(OFN)
        .hwndOwner = hWndCmdlgOwnerForm
        .lpstrFilter = Filter$
        .nFilterIndex = FilterIndex
        .lpstrFile = FileNameBuff$
        .nMaxFile = MaxFileSize
        .lpstrFileTitle = String$(MaxFileSize, 0)
        .nMaxFileTitle = MaxFileSize
        .lpstrInitialDir = DirNome$
        .lpstrTitle = DialogTitle$
        .Flags = Flags
    End With
'
    ' Apro la finestra CommonDialog:
    If (GetOpenFileName(OFN) = 0) Then
        ' E' stato scelto il "Cancel" (o la GetOpenFileName
        ' e' incorsa in qualche altro errore):
        ShowOpen = False
        FileName$ = ""
        ExtendedError = CommDlgExtendedError
'
    Else
        ' Ritorno il nome del file selezionato:
        ShowOpen = True
        FileName$ = OFN.lpstrFile
        NullPos = InStr(FileName$, Chr$(0))
        If (0 < NullPos) Then FileName$ = Left$(FileName$, NullPos - 1)
'
        FilterIndex = OFN.nFilterIndex
    End If
'
'
'
End Function
Private Function ShowSave(ByRef FileName$, ByVal DirNome$, ByVal Filter$, _
    ByVal DialogTitle$, ByVal Flags As Long, Optional ByRef FilterIndex As Long, _
    Optional ByVal MaxFileSize As Long = 256, Optional ByRef ExtendedError As Long) As Boolean
'
'
    Dim I&, FileNameBuff$, NullPos&, OFN As OPENFILENAME
'
    ' Sostituisco gli "|" con caratteri Null ...:
    Filter$ = Replace(Filter$, "|", Chr$(0))
    ' ... e aggiungo due Null finali, come
    ' richiesto dall' API GetSaveFileName:
    Filter$ = Filter$ & Chr$(0) & Chr$(0)
'
    ' Preparo il FileNameBuff$:
    FileNameBuff$ = FileName$
    For I = Len(FileName$) + 1 To MaxFileSize - 1
        FileNameBuff$ = FileNameBuff$ & " "
    Next I
    FileNameBuff$ = FileNameBuff$ & Chr$(0)
'
    With OFN
        .lStructSize = Len(OFN)
        .hwndOwner = hWndCmdlgOwnerForm
        .lpstrFilter = Filter$
        .nFilterIndex = FilterIndex
        .lpstrFile = FileNameBuff$
        .nMaxFile = MaxFileSize
        .lpstrFileTitle = String$(MaxFileSize, 0)
        .nMaxFileTitle = MaxFileSize
        .lpstrInitialDir = DirNome$
        .lpstrTitle = DialogTitle$
        .Flags = Flags
    End With
'
    ' Apro la finestra CommonDialog:
    If (GetSaveFileName(OFN) = 0) Then
        ' E' stato scelto il "Cancel" (o la GetSaveFileName
        ' e' incorsa in qualche altro errore):
        ShowSave = False
        FileName$ = ""
        ExtendedError = CommDlgExtendedError
'
    Else
        ' Ritorno il nome del file scelto:
        ShowSave = True
        FileName$ = OFN.lpstrFile
        NullPos = InStr(FileName$, Chr$(0))
        If (0 < NullPos) Then FileName$ = Left$(FileName$, NullPos - 1)
'
        FilterIndex = OFN.nFilterIndex
    End If
'
'
'
End Function
Public Function CMDialog_Files(ByVal Oper$, Optional ByVal Filter$ = "(*.*)|*.*|", _
    Optional ByVal DirNome$ = "", Optional ByVal FileNome$ = "", _
    Optional ByVal Titolo$ = "", Optional ByRef FilterIndex As Long = 1) As String
'
'   Imposta i valori di una finestra per la gestione dei Files
'   e ritorna il nome completo del File scelto.
'   La gestione degli errori (e.g. cdlCancel) va' fatta nella
'   routine chiamante.
'
'   Parametri:
'    Oper$:         operazione da eseguire (solo "Save" o "Open").
'    Filter$:       tipo dei files da proporre (e.g. "Files1|*.txt|[Files2|*.rtf|]...").
'    [DirNome$]:    nome del Folder di default.
'    [FileNome$]:   nome del File di default.
'    [Titolo$]:     titolo della finestra.
'    [FilterIndex]: imposta/ritorna l' indice del filtro da usare/usato per
'                   selezionare i files.
'
    Dim Flags&
'
    If (Oper$ <> "Open") And (Oper$ <> "Save") Then Err.Raise 5
'
    ' Imposto il Folder di default:
    If (DirNome$ = "") Then
        DirNome$ = App.Path
    End If
'
    ' Controllo l' esistenza del File, chiedo conferma
    ' se File Already Exists e nascondo la casella Read Only:
    Flags = OFN_FILEMUSTEXIST + OFN_OVERWRITEPROMPT + OFN_HIDEREADONLY
'
    ' Apro la finestra con
    ' l' operazione richiesta:
    If (Oper$ = "Open") Then
        If (Not ShowOpen(FileNome$, DirNome$, Filter$, Titolo$, Flags, FilterIndex)) Then
            Err.Raise cdlCancel, "modCommonDialog", "ShowOpen: Cancel."
        End If
'
    ElseIf (Oper$ = "Save") Then
        If (Not ShowSave(FileNome$, DirNome$, Filter$, Titolo$, Flags, FilterIndex)) Then
            Err.Raise cdlCancel, "modCommonDialog", "ShowSave: Cancel."
        End If
    End If
'
    CMDialog_Files = FileNome$
'
'
'
End Function
Public Function CMDialog_Color(Optional ByVal Color As Long = 0) As Long
'
'   Imposta i valori di una finestra per la gestione dei Colori
'   e ritorna il colore selezionato.
'   La gestione degli errori (e.g. cdlCancel) va' fatta nella
'   routine chiamante.
'
'   Parametri:
'    [Color]:   colore da mettere in evidenza all' apertura
'               della finestra ShowColor; se il parametro non
'               viene passato il colore messo in evidenza e'
'               il nero.
'
    Dim Flags&
'
    ' Metto in evidenza il colore Color e
    ' presento tutti i colori disponibili:
    Flags = CC_RGBINIT + CC_ANYCOLOR
'
    If (Not ShowColor(Color, Flags)) Then
        Err.Raise cdlCancel, "modCommonDialog", "ShowColor: Cancel."
    End If
'
    CMDialog_Color = Color
'
'
'
End Function
Private Function ShowColor(ByRef Color As Long, ByVal Flags As Long, _
    Optional ByRef ExtendedError As Long) As Boolean
'
'
    Dim I&, K&, CustColors(0 To 15) As Long, CC As CHOOSECOLORs
'
    ' Preparo i "Custom colors" come toni di grigio:
    For I = 0 To 15
        K = I * 255 / 15
        CustColors(I) = RGB(K, K, K)
    Next
'
    With CC
        .lStructSize = Len(CC)
        .hwndOwner = hWndCmdlgOwnerForm
        .rgbResult = Color
        .lpCustColors = VarPtr(CustColors(0))
        .Flags = Flags
    End With
'
    ' Apro la finestra CommonDialog:
    If (ChooseColor(CC) = 0) Then
        ' E' stato scelto il "Cancel" (o la ChooseColor
        ' e' incorsa in qualche altro errore):
        ShowColor = False
        ExtendedError = CommDlgExtendedError
'
    Else
        ' Ritorno il colore selezionato:
        ShowColor = True
        Color = CC.rgbResult
    End If
'
'
'
End Function
