Attribute VB_Name = "modFlexPB"
'=======================================================================================
' Descrizione.....: Routines per la gestione di PictureBoxes
'                   con barre di scorrimento e capaci di
'                   essere ridimensionati al "run-time.
'                   Comprende anche le routines per spostare
'                   l' immagine trascinandola con il mouse e
'                   per mantenere un punto, indicato dal cursore,
'                   sempre nell' area visibile.
'                   (Versione con codice in linea).
' Nome dei Files..: modFlexPB.bas
' Data............: 07/06/2000
' Aggiornamento...: 21/05/2003
' Versione........: 1.1 a 32 bits
' Sistema.........: VB6 (SP5) sotto Windows XP (SP2).
' Scritto da......: F. Languasco 
' E-Mail..........: MC7061@mclink.it
' DownLoads a.....: http://www.flanguasco.org
'=======================================================================================
'
'   Queste routines possono essere usate come Private nel
'   Form interessato ed in questo caso essere notevolmente
'   semplificate nel codice di ricerca dei controlli.
'   Oppure possono essere dichiarate come Public in un modulo
'   .bas per gestire tutti i FlexPB presenti su diversi Forms
'   componenti il progetto.
'   Versione con ScrollBars [e CommandButton] inseriti internamente
'   a PB_Cont.
'
'   Note ed istruzioni:
'   - FlexPB e' un insieme di controlli, composto da:
'      PB_Cont:   PictureBox contenitore che stabilisce le  massime
'                 dimensioni visibili dell' immagine.
'                 Esso contiene al suo interno:
'       PB_Imm:   PictureBox con l' immagine da visualizzare.
'       HSB_Imm:  ScrollBar orizzontale.
'       VSB_Imm:  ScrollBar verticale.
'       CB_4W:    CommandButton per il ridimensionamento,
'                 al "run-time", di PB_Cont [opzionale].
'
'   - Si devono inserire le chiamate a FlexPB_ImmScroll negli eventi Change
'     [e Scroll] delle due ScrollBars, passando  come argomento la stessa
'     ScrollBar.
'
'   - Per poter ridimensionare PB_cont con il bottoncino CB_4W, inserire le
'     opportune chiamate a FlexPB_SetScroll negli eventi MouseMove [e KeyDown]
'     di CB_4W.
'
'    - Cambiando (da programma) le dimensioni di PB_Imm e' necessario effettuare
'      una chiamata a FlexPB_SetScroll (o inserirla nel suo  evento Resize).
'
'   - Se PB_Cont e' ridimensionabile, da programma e non con CB_4W, inserire
'     anche una chiamata a FlexPB_SetScroll nell' evento  Resize di PB_Cont.
'
'   - Se si vuole inizializzare PB_Cont alla creazione del  Form, inserire
'     una chiamata a FlexPB_SetScroll nell' evento Initialize del Form
'     (non in Load) e cioe' quando  tutti i controlli sono attivi.
'
'   - Lo ScaleMode di PB_Imm puo' essere espresso in qualsiasi unita'.
'     Lo ScaleMode di PB_Cont puo' essere solo [Twips] o [Pixels].
'
'   - Quando si crea il gruppo di controlli PB_Imm, HSB_Imm, VSB_Imm e CB_4W
'     (dentro a PB_Cont) accertarsi che  PB_Imm sia in secondo piano
'     rispetto a tutti gli altri.
'
'   - PB_Imm puo' a sua volta contenere qualsiasi tipo di controllo (e.g. Labels,
'     Shapes di selezione, etc..); PB_Cont non puo' contenere altri controlli
'     di tipo PictureBox, HScrollBar, VScrollBar e CommandButton al di fuori di
'     quelli previsti da questo programma.
'
'   - [Tutte le routines ritornano in PB_ImmX1, PB_ImmY1 e PB_ImmX2, PB_ImmY2
'      le coordinate degli angoli superiore sinistro, inferiore destro dell' area
'      correntemente visibile di PB_Imm, espresse nelle unita' di PB_Imm.ScaleMode;
'      FlexPB_ImmArea ritorna questi valori nelle unita' richieste con ScaleMode].

'   - [Dovrebbe essere: CB_4W.Height = HSB_Imm.Height e
'      CB_4W.Width = VSB_Imm.Width (ragioni estetiche)].
'
'   - Le routines, nonostante la loro (relativa) complessita', lavorano in
'     maniera soddisfacente anche con CPU piuttosto lente (le ho provate, con
'     qualche ritardo al FlexPB_ImmPan, su di un 486 a 100 MHz).
'
Option Explicit
'
'-- Dichiarazioni, costanti e tipi per API: --------------------------------------------
'
Private Type POINTAPI_Type
    X As Long
    Y As Long
End Type
'
Private Declare Function ClientToScreen Lib "USER32" (ByVal hWnd As Long, _
    lpPoint As POINTAPI_Type) As Long
Private Declare Function SetCursorPos Lib "USER32" (ByVal X As Long, _
    ByVal Y As Long) As Long
Public Sub FlexPB_ImmScroll(ByVal SB_Imm As Control, _
    Optional ByRef PB_ImmX1 As Single, Optional ByRef PB_ImmY1 As Single, _
    Optional ByRef PB_ImmX2 As Single, Optional ByRef PB_ImmY2 As Single)
'
'   Sposta PB_Imm come richiesto dal nuovo valore
'   della ScrollBar SB_Imm:
'
    Dim PB_Imm As Control
'
    ' Trovo il PictureBox da muovere con SB_Imm:
    For Each PB_Imm In SB_Imm.Parent.Controls 'Screen.ActiveForm.Controls
        If TypeOf PB_Imm Is PictureBox Then
            If PB_Imm.Container Is SB_Imm.Container Then Exit For
        End If
    Next PB_Imm
'
'
'   PB_Imm.Left(Top) is set to the negative of the value because
'   as you scroll the scroll bar to the right(down), the display
'   should move to the left(up), showing more of the right(bottom)
'   of the display, and vice-versa when scrolling to the
'   left(up):
'
    If TypeOf SB_Imm Is HScrollBar Then
        PB_Imm.Left = -SB_Imm.Value
    ElseIf TypeOf SB_Imm Is VScrollBar Then
        PB_Imm.Top = -SB_Imm.Value
    End If
    DoEvents
'
'
    ' Trovo gli angoli superiore sinistro ed inferiore
    ' destro dell' area visibile di PB_Imm:
    FlexPB_ImmArea PB_Imm, PB_ImmX1, PB_ImmY1, PB_ImmX2, PB_ImmY2
'
'
'
End Sub
Public Sub FlexPB_SetScroll(ByVal PB_Imm As PictureBox, _
    Optional ByVal X As Long = 0, Optional ByVal Y As Long = 0, _
    Optional ByVal KeyCode As Long = 0, _
    Optional ByRef PB_ImmX1 As Single, Optional ByRef PB_ImmY1 As Single, _
    Optional ByRef PB_ImmX2 As Single, Optional ByRef PB_ImmY2 As Single)
'
'   Prepara la gestione dello "scroll" e del ridimensionamento di
'   un PictureBox.
'   Versione con ScrollBars (e CommandButton) inseriti internamente
'   a PB_Cont e da usare insieme a FlexPB_ImmScroll.
'
'    PB_Imm:    PictureBox con l' immagine che si vuole spostare.
'               Esso deve essere inserito internamente ad un altro
'               PictureBox contenente anche una ScrollBar orizzontale,
'               una verticale ed, opzionale, un CommandButton.
'    X, Y:      Sono le coordinate passate dagli eventi MouseMove sul
'               CommandButton di ridimensionamento.
'    KeyCode:   Serve a ridimensionare PB_Cont con Alt + Frecce di
'               navigazione: inserire, in questo caso, una chiamata
'               a FlexPB_SetScroll nell' evento KeyDown di CB_4W.
'
'
'    PB_Cont:   PictureBox contenitore.
'    HSB_Imm:   ScrollBar orizzontale.
'    VSB_Imm:   ScrollBar verticale.
'    CB_4W:     CommandButton per il ridimensionamento di PB_Cont.
'
'   Liberamente adattato da un' idea di:
'   "Microsoft Knowledge Base - Visual Basic 3.0".
'
    Dim PB_Cont As PictureBox, Control As Control
    Dim HSB_Imm As HScrollBar, VSB_Imm As VScrollBar, CB_4W As CommandButton
    Dim PB_ContSW&, PB_ContSH&, PB_ContBX&, PB_ContBY&
    Dim PB_ContRX!, PB_ContRY!, PB_Cont1X&, PB_Cont1Y&
    Dim CB_4W_Left&, CB_4W_Top&, bCB_4W_E As Boolean
'
    ' Trovo il PictureBox contenitore:
    Set PB_Cont = PB_Imm.Container
'
    ' Trovo le ScrollBars ed il CommandButton associati a PB_Imm:
    For Each Control In PB_Imm.Parent.Controls 'Screen.ActiveForm.Controls
        If TypeOf Control Is HScrollBar Then
            If Control.Container Is PB_Cont Then Set HSB_Imm = Control
        End If
        If TypeOf Control Is VScrollBar Then
            If Control.Container Is PB_Cont Then Set VSB_Imm = Control
        End If
        If TypeOf Control Is CommandButton Then
            If Control.Container Is PB_Cont Then
                Set CB_4W = Control
                bCB_4W_E = CB_4W.Visible
            End If
        End If
    Next Control
'
    If bCB_4W_E Then
    ' Provo a ridimensionare PB_Cont:
'
        ' Verifico se il ridimensionamento e' comandato
        ' da Alt + Frecce di navigazione:
        Select Case KeyCode
            Case vbKeyRight
            X = 15
            Case vbKeyUp
            Y = -15
            Case vbKeyLeft
            X = -15
            Case vbKeyDown
            Y = 15
        End Select
'
        ' Calcolo la nuova posizione di CB_4W:
        If KeyCode = vbKeyHome Then
            CB_4W_Left = 0
            CB_4W_Top = 0
        Else
            CB_4W_Left = CB_4W.Left + PB_Cont.ScaleX(X, vbTwips)
            CB_4W_Top = CB_4W.Top + PB_Cont.ScaleY(Y, vbTwips)
        End If
'
        ' Larghezza dei bordi di PB_Cont:
        If PB_Cont.BorderStyle = vbFixedSingle Then
            PB_ContBX = PB_Cont.ScaleX(4, vbPixels)
            PB_ContBY = PB_Cont.ScaleY(4, vbPixels)
        End If
'
        ' Calcolo i rapporti tra dimensioni esterne/interne di PB_Cont:
        PB_ContRX = CSng(PB_Cont.Width) / CSng(PB_Cont.ScaleWidth + PB_ContBX)
        PB_ContRY = CSng(PB_Cont.Height) / CSng(PB_Cont.ScaleHeight + PB_ContBY)
'
        ' Nuove dimensioni richieste a PB_Cont:
        PB_ContSW = (CB_4W_Left + CB_4W.Width)
        PB_ContSH = (CB_4W_Top + CB_4W.Height)
'
        ' Verifico le dimensioni minime di PB_Cont:
        If PB_ContSW < VSB_Imm.Width Then PB_ContSW = VSB_Imm.Width
        If PB_ContSH < HSB_Imm.Height Then PB_ContSH = HSB_Imm.Height
'
        ' Ridimensiono PB_Cont:
        PB_Cont.Width = PB_ContRX * (PB_ContSW + PB_ContBX)
        PB_Cont.Height = PB_ContRY * (PB_ContSH + PB_ContBY)
        PB_Cont.ZOrder vbBringToFront
'
        ' Riposiziono CB_4W:
        CB_4W.Move (PB_ContSW - CB_4W.Width), (PB_ContSH - CB_4W.Height)
    End If
'
'
    ' Determine if child picture will fill up PB_Cont.
    ' If so, then there is no need to use scroll bars:
    PB_Cont1X = PB_Cont.ScaleX(1, vbPixels)
    If PB_Cont1X < 1 Then PB_Cont1X = 1
    If (PB_Imm.Height + 2 * PB_Cont1X) > PB_Cont.ScaleHeight Then
        PB_ContSW = PB_Cont.ScaleWidth - VSB_Imm.Width
    Else
        PB_ContSW = PB_Cont.ScaleWidth
    End If
    'HSB_Imm.Visible = (PB_Imm.Width + 2 * PB_Cont1X > PB_ContSW) And PB_Imm.Visible
'
    PB_Cont1Y = PB_Cont.ScaleY(1, vbPixels)
    If PB_Cont1Y < 1 Then PB_Cont1Y = 1
    If (PB_Imm.Width + 2 * PB_Cont1Y) > PB_Cont.ScaleWidth Then
        PB_ContSH = PB_Cont.ScaleHeight - HSB_Imm.Height
    Else
        PB_ContSH = PB_Cont.ScaleHeight
    End If
    VSB_Imm.Visible = (PB_Imm.Height + 2 * PB_Cont1Y > PB_ContSH) And PB_Imm.Visible
'
'    ' Position and set the values
'    ' for the horizontal scroll bar:
'    HSB_Imm.Min = -PB_Cont1X
'    If HSB_Imm.Visible Then
'        HSB_Imm.Left = 0
'        HSB_Imm.Top = PB_Cont.ScaleHeight - HSB_Imm.Height
''
'        HSB_Imm.SmallChange = PB_Cont1X
''
'        If VSB_Imm.Visible Or bCB_4W_E Then
'            HSB_Imm.Width = PB_Cont.ScaleWidth - VSB_Imm.Width
'            HSB_Imm.Max = PB_Imm.Width - PB_Cont.ScaleWidth + VSB_Imm.Width + PB_Cont1X
'        Else
'            HSB_Imm.Width = PB_Cont.ScaleWidth
'            HSB_Imm.Max = PB_Imm.Width - PB_Cont.ScaleWidth + PB_Cont1X
'        End If
'        If HSB_Imm.Max / 10 > HSB_Imm.SmallChange Then _
'            HSB_Imm.LargeChange = HSB_Imm.Max / 10
'    Else
'        HSB_Imm.Max = HSB_Imm.Min
'        HSB_Imm.Value = HSB_Imm.Min
'    End If
'
    ' Position and set the values
    ' for the vertical scroll bar:
    VSB_Imm.MIN = -PB_Cont1Y
    If VSB_Imm.Visible Then
        VSB_Imm.Top = 0
        VSB_Imm.Left = PB_Cont.ScaleWidth - VSB_Imm.Width
'
        VSB_Imm.SmallChange = PB_Cont1Y
'
        If HSB_Imm.Visible Or bCB_4W_E Then
            VSB_Imm.Height = PB_Cont.ScaleHeight - HSB_Imm.Height
            VSB_Imm.MAX = PB_Imm.Height - PB_Cont.ScaleHeight + HSB_Imm.Height + PB_Cont1Y
        Else
            VSB_Imm.Height = PB_Cont.ScaleHeight
            VSB_Imm.MAX = PB_Imm.Height - PB_Cont.ScaleHeight + PB_Cont1Y
        End If
        If VSB_Imm.MAX / 10 > VSB_Imm.SmallChange Then _
            VSB_Imm.LargeChange = VSB_Imm.MAX / 10
    Else
        VSB_Imm.MAX = VSB_Imm.MIN
        VSB_Imm.Value = VSB_Imm.MIN
    End If
'
'
    ' Trovo gli angoli superiore sinistro ed inferiore
    ' destro dell' area visibile di PB_Imm:
    FlexPB_ImmArea PB_Imm, PB_ImmX1, PB_ImmY1, PB_ImmX2, PB_ImmY2
'
'
'
End Sub
Public Sub FlexPB_ImmPan(ByVal PB_Imm As PictureBox, _
    ByVal X As Single, ByVal Y As Single, _
    Optional ByVal IFI As Long = 0, _
    Optional ByRef PB_ImmX1 As Single, Optional ByRef PB_ImmY1 As Single, _
    Optional ByRef PB_ImmX2 As Single, Optional ByRef PB_ImmY2 As Single)
'
'   Routine opzionale:
'   Trascina il PictureBox PB_Imm nella direzione dello
'   spostamento del mouse.
'
'    Note:      - Nell' evento PB_Imm.MouseDown inserire la
'                 chiamata FlexPB_ImmPan PB_Imm, X, Y, 1.
'               - Nell' evento PB_Imm.MouseMove inserire la
'                 chiamata FlexPB_ImmPan PB_Imm, X, Y.
'               - Nell' evento PB_Imm.MouseUp inserire la
'                 chiamata FlexPB_ImmPan PB_Imm, X, Y, -1.
'               - Tutte le chiamate a FlexPB_ImmPan devono
'                 essere condizionate al tasto destro o sinistro
'                 del mouse premuto.
'
    Dim dx!, DY!
    Dim PB_Cont As PictureBox, Control As Control
    Dim HSB_Imm As HScrollBar, VSB_Imm As VScrollBar
    Static bSposto As Boolean   ' Evita la cascata di eventi MouseMove.
    Static PB_ImmX0!, PB_ImmY0! ' Ricorda i valori precedenti di X e Y.
    Static MP_Normale&          ' Ricorda il MousePointer di PB_Imm.
'
    If IFI > 0 Then
        ' Inizio il trascinamento:
        PB_ImmX0 = X
        PB_ImmY0 = Y
        MP_Normale = PB_Imm.MousePointer
        PB_Imm.MousePointer = vbCustom      ' [Per PB_Imm.MouseIcon dovrebbe
                                            '  essere selezionato H_move.cur].
'
        ' Trovo gli angoli superiore sinistro ed inferiore
        ' destro del' area correntemente visibile di PB_Imm:
        FlexPB_ImmArea PB_Imm, PB_ImmX1, PB_ImmY1, PB_ImmX2, PB_ImmY2
'
    ElseIf IFI < 0 Then
        ' Termino il trascinamento:
        PB_Imm.MousePointer = MP_Normale    ' Cursore scelto come default.
'
    Else
        ' Trovo il PictureBox contenitore:
        Set PB_Cont = PB_Imm.Container
'
        ' Trovo le ScrollBars associate con PB_Imm:
        For Each Control In PB_Imm.Parent.Controls 'Screen.ActiveForm.Controls
            If TypeOf Control Is HScrollBar Then
                If Control.Container Is PB_Cont Then Set HSB_Imm = Control
            End If
            If TypeOf Control Is VScrollBar Then
                If Control.Container Is PB_Cont Then Set VSB_Imm = Control
            End If
            If (Not HSB_Imm Is Nothing) And (Not VSB_Imm Is Nothing) Then Exit For
        Next Control
'
        ' Calcolo lo spostamento richiesto:
        dx = PB_Imm.ScaleX((PB_ImmX0 - X), PB_Imm.ScaleMode, PB_Cont.ScaleMode)
        PB_ImmX0 = X
        DY = PB_Imm.ScaleY((PB_ImmY0 - Y), PB_Imm.ScaleMode, PB_Cont.ScaleMode)
        PB_ImmY0 = Y
'
        If Not bSposto Then
            bSposto = True
'
            If dx > 0 Then
                If HSB_Imm.Value + dx > HSB_Imm.MAX Then dx = HSB_Imm.MAX - HSB_Imm.Value
            ElseIf dx < 0 Then
                If HSB_Imm.Value + dx < HSB_Imm.MIN Then dx = HSB_Imm.MIN - HSB_Imm.Value
            End If
'
            If DY > 0 Then
                If VSB_Imm.Value + DY > VSB_Imm.MAX Then DY = VSB_Imm.MAX - VSB_Imm.Value
            ElseIf DY < 0 Then
                If VSB_Imm.Value + DY < VSB_Imm.MIN Then DY = VSB_Imm.MIN - VSB_Imm.Value
            End If
'
            ' Sposto PB_Imm:
            HSB_Imm.Value = HSB_Imm.Value + dx
            VSB_Imm.Value = VSB_Imm.Value + DY
            DoEvents
            bSposto = False
'
            ' Trovo gli angoli superiore sinistro ed inferiore
            ' destro della nuova area visibile di PB_Imm:
            FlexPB_ImmArea PB_Imm, PB_ImmX1, PB_ImmY1, PB_ImmX2, PB_ImmY2
        End If
    End If
'
'
'
End Sub
Public Sub FlexPB_ImmArea(ByVal PB_Imm As PictureBox, _
    ByRef PB_ImmX1 As Single, ByRef PB_ImmY1 As Single, _
    ByRef PB_ImmX2 As Single, ByRef PB_ImmY2 As Single, _
    Optional ByVal ScaleMode As Long = -1)
'
'   Ritorna le coordinate dell' area visibile di PB_Imm.
'    PB_ImmX1, PB_ImmY1:  Coordinate dell' angolo superiore sinistro.
'    PB_ImmX2, PB_ImmY2:  Coordinate dell' angolo inferiore destro.
'    ScaleMode:           Unita' in cui vengono ritornate le coordinate
'                         [opzionale; default = PB_Imm.ScaleMode].
'
    Dim PB_Cont As PictureBox, Control As Control
    Dim HSB_Imm As HScrollBar, VSB_Imm As VScrollBar
'
    ' Trovo il PictureBox contenitore:
    Set PB_Cont = PB_Imm.Container
'
    ' Trovo le ScrollBars associate con PB_Imm:
    For Each Control In PB_Imm.Parent.Controls 'Screen.ActiveForm.Controls
        If TypeOf Control Is HScrollBar Then
            If Control.Container Is PB_Cont Then Set HSB_Imm = Control
        End If
        If TypeOf Control Is VScrollBar Then
            If Control.Container Is PB_Cont Then Set VSB_Imm = Control
        End If
        If (Not HSB_Imm Is Nothing) And (Not VSB_Imm Is Nothing) Then Exit For
    Next Control
'
    ' Coordinate X:
    PB_ImmX1 = PB_Imm.ScaleX(HSB_Imm.Value, PB_Cont.ScaleMode, vbPixels)
'
    If VSB_Imm.Visible Then
        PB_ImmX2 = PB_ImmX1 - 1! _
        + PB_Imm.ScaleX(PB_Cont.ScaleWidth - VSB_Imm.Width, PB_Cont.ScaleMode, vbPixels)
    Else
        PB_ImmX2 = PB_ImmX1 - 1! _
        + PB_Imm.ScaleX(PB_Cont.ScaleWidth, PB_Cont.ScaleMode, vbPixels)
    End If
'
    If PB_ImmX1 < 0 Then PB_ImmX1 = 0
    If PB_ImmX2 >= PB_Imm.ScaleX(PB_Imm.ScaleWidth, PB_Imm.ScaleMode, vbPixels) Then
        PB_ImmX2 = PB_Imm.ScaleX(PB_Imm.ScaleWidth, PB_Imm.ScaleMode, vbPixels) - 1!
    End If
'
    ' Coordinate Y:
    PB_ImmY1 = PB_Imm.ScaleY(VSB_Imm.Value, PB_Cont.ScaleMode, vbPixels)
'
    If HSB_Imm.Visible Then
        PB_ImmY2 = PB_ImmY1 - 1! _
        + PB_Imm.ScaleY(PB_Cont.ScaleHeight - HSB_Imm.Height, PB_Cont.ScaleMode, vbPixels)
    Else
        PB_ImmY2 = PB_ImmY1 - 1! _
        + PB_Imm.ScaleY(PB_Cont.ScaleHeight, PB_Cont.ScaleMode, vbPixels)
    End If
'
    If PB_ImmY1 < 0 Then PB_ImmY1 = 0
    If PB_ImmY2 >= PB_Imm.ScaleY(PB_Imm.ScaleHeight, PB_Imm.ScaleMode, vbPixels) Then
        PB_ImmY2 = PB_Imm.ScaleY(PB_Imm.ScaleHeight, PB_Imm.ScaleMode, vbPixels) - 1!
    End If
'
    ' Converto le coordinate nell' unita' richiesta:
    If ScaleMode < 0 Then ScaleMode = PB_Imm.ScaleMode
    If ScaleMode <> vbPixels Then
        PB_ImmX1 = PB_Imm.ScaleX(PB_ImmX1, vbPixels, ScaleMode) + PB_Imm.ScaleLeft
        PB_ImmY1 = PB_Imm.ScaleY(PB_ImmY1, vbPixels, ScaleMode) + PB_Imm.ScaleTop
        PB_ImmX2 = PB_Imm.ScaleX(PB_ImmX2, vbPixels, ScaleMode) + PB_Imm.ScaleLeft
        PB_ImmY2 = PB_Imm.ScaleY(PB_ImmY2, vbPixels, ScaleMode) + PB_Imm.ScaleTop
    End If
'
'
'
End Sub
Public Sub FlexPB_ImmOnXY(ByVal PB_Imm As PictureBox, _
    ByRef X As Single, ByRef Y As Single, _
    Optional ByRef PB_ImmX1 As Single, Optional ByRef PB_ImmY1 As Single, _
    Optional ByRef PB_ImmX2 As Single, Optional ByRef PB_ImmY2 As Single, _
    Optional ByVal bCentro As Boolean = False, _
    Optional ByVal bCentraCursore As Boolean = True)
'
'   Routine opzionale:
'   Sposta PB_Imm in modo da portare il punto con coordinate X, Y all' interno
'   dell' area visibile di PB_Imm e colloca il cursore a X, Y.
'   Se il punto e' fuori PB_Imm, esso viene forzato al suo interno.
'   Se bCentro = True tenta di mettere il punto X, Y al centro.
'   Se bCentraCursore = True tenta di posizionare il cursore a X, Y.
'   Se, nel progetto, si intende usare anche questa routine, va' dichiarata
'   la struttura POINTAPI_Type come pure le API ClientToScreen e SetCursorPos.
'
'    Nota:      - Nell' evento PB_Imm.MouseMove inserire la
'                 chiamata FlexPB_ImmOnXY PB_Imm, X, Y, condizionata al tasto
'                 destro o sinistro del mouse premuto.
'
    Dim dx&, DY&
    Dim PB_Cont As PictureBox, Control As Control
    Dim HSB_Imm As HScrollBar, VSB_Imm As VScrollBar
    Dim Xp!, Yp!, X1p!, Y1p!, X2p!, Y2p!, Point1 As POINTAPI_Type
    Static bSposto As Boolean   ' Evita la cascata di eventi MouseMove.
'
    ' Lavoro in [Pixels] per semplificare i calcoli successivi:
    Xp = PB_Imm.ScaleX(X - PB_Imm.ScaleLeft, PB_Imm.ScaleMode, vbPixels)
    Yp = PB_Imm.ScaleY(Y - PB_Imm.ScaleTop, PB_Imm.ScaleMode, vbPixels)
'
    ' Trovo gli angoli superiore sinistro ed inferiore destro
    ' dell' area correntemente visibile di PB_Imm:
    FlexPB_ImmArea PB_Imm, X1p, Y1p, X2p, Y2p, vbPixels
'
    If (Xp < X1p Or X2p < Xp) Or (Yp < Y1p Or Y2p < Yp) Or bCentro Then
        If Not bSposto Then
            bSposto = True
            ' Trovo il PictureBox contenitore:
            Set PB_Cont = PB_Imm.Container
'
            ' Trovo le ScrollBars associate con PB_Imm:
            For Each Control In PB_Imm.Parent.Controls 'Screen.ActiveForm.Controls
                If TypeOf Control Is HScrollBar Then
                    If Control.Container Is PB_Cont Then Set HSB_Imm = Control
                End If
                If TypeOf Control Is VScrollBar Then
                    If Control.Container Is PB_Cont Then Set VSB_Imm = Control
                End If
                If (Not HSB_Imm Is Nothing) And (Not VSB_Imm Is Nothing) Then Exit For
            Next Control
'
            ' Verifico che il punto (X, Y) non sia fuori
            ' PB_Imm e se il caso, lo forzo all' interno:
            If Xp < 0! Then
                Xp = 0!
            ElseIf Xp >= PB_Imm.ScaleX(PB_Imm.ScaleWidth, PB_Imm.ScaleMode, vbPixels) Then
                Xp = PB_Imm.ScaleX(PB_Imm.ScaleWidth, PB_Imm.ScaleMode, vbPixels) - 1!
            End If
'
            If Yp < 0! Then
                Yp = 0!
            ElseIf Yp >= PB_Imm.ScaleY(PB_Imm.ScaleHeight, PB_Imm.ScaleMode, vbPixels) Then
                Yp = PB_Imm.ScaleY(PB_Imm.ScaleHeight, PB_Imm.ScaleMode, vbPixels) - 1!
            End If
'
            ' Calcolo lo spostamento orizzontale:
            If bCentro Then
                dx = PB_Cont.ScaleX((Xp - (X1p + X2p) / 2), vbPixels)
            ElseIf Xp < X1p Then
                dx = PB_Cont.ScaleX((Xp - X1p), vbPixels)
            ElseIf Xp > X2p Then
                dx = PB_Cont.ScaleX((Xp - X2p), vbPixels)
            End If
            If dx < HSB_Imm.MIN - HSB_Imm.Value Then dx = HSB_Imm.MIN - HSB_Imm.Value
            If dx > HSB_Imm.MAX - HSB_Imm.Value Then dx = HSB_Imm.MAX - HSB_Imm.Value
'
            ' Calcolo lo spostamento verticale:
            If bCentro Then
                DY = PB_Cont.ScaleY((Yp - (Y1p + Y2p) / 2), vbPixels)
            ElseIf Yp < Y1p Then
                DY = PB_Cont.ScaleY((Yp - Y1p), vbPixels)
            ElseIf Yp > Y2p Then
                DY = PB_Cont.ScaleY((Yp - Y2p), vbPixels)
            End If
            If DY < VSB_Imm.MIN - VSB_Imm.Value Then DY = VSB_Imm.MIN - VSB_Imm.Value
            If DY > VSB_Imm.MAX - VSB_Imm.Value Then DY = VSB_Imm.MAX - VSB_Imm.Value
'
            ' Riposiziono PB_Imm:
            HSB_Imm.Value = HSB_Imm.Value + dx
            VSB_Imm.Value = VSB_Imm.Value + DY
            DoEvents
            bSposto = False
'
            If bCentraCursore Then
                ' Riposiziono il cursore:
                Point1.X = Xp
                Point1.Y = Yp
                ClientToScreen PB_Imm.hWnd, Point1
                SetCursorPos Point1.X, Point1.Y
                ' e calcolo le sue nuove coordinate
                ' nello ScaleMode di PB_Imm:
                X = PB_Imm.ScaleX(Xp, vbPixels) + PB_Imm.ScaleLeft
                Y = PB_Imm.ScaleY(Yp, vbPixels) + PB_Imm.ScaleTop
            End If
'
            ' Trovo gli angoli superiore sinistro ed inferiore
            ' destro della nuova area visibile di PB_Imm:
            FlexPB_ImmArea PB_Imm, PB_ImmX1, PB_ImmY1, PB_ImmX2, PB_ImmY2
        End If
    End If
'
'
'
End Sub
