Attribute VB_Name = "modRPOLY"
'=======================================================================================
' Descrizione.....: Routine per il calcolo delle radici,
'                   complesse, di polinomi a coefficienti
'                   reali.
'                   Implementa il metodo Jenkins-Traub
'                   evitando l' uso di operazioni con
'                   numeri complessi.
' Nome dei Files..: modRPOLY.bas
' Data............: 15/02/2000
' Aggiornamento...: 20/05/2001 (corretto un errore in QUAD).
' Versione........: 1.0 a 32 bits.
' Sistema.........: VB6 (SP5) sotto Windows XP (SP2).
' Scritto da......: F. Languasco 
' E-Mail..........: MC7061@mclink.it
' DownLoads a.....: http://www.flanguasco.org
'=======================================================================================
'
'   Routine di ingresso:
'    RPOLY op(), zeror(), zeroi()
'     op():     vettore dei coefficienti reali del polinomio.
'               Inizia dall' indice 1 e la routine RPOLY e'
'               stata modificata per accettare op(1) come
'               termine costante e op(N) = coefficiente della piu'
'               alta potenza di x, i.e:
'                op(I) = coefficiente di x ^ (I - 1))
'     zeror():  vettore delle parti reali delle radici.
'     zeroi():  vettore delle parti immaginarie delle radici.
'
'   Tratta dal programma FORTRAN (vedi file J&T_CR.txt):
'    Title:  RPOLY
'    For:    Zeros of real polynomial
'    Alg:    Jenkins and Traub
'    By:     M. A. Jenkins
'    Ref:    ACM TOMS 1 (1975) 178-189
'
'   I commenti in tutte maiuscole sono originali.
'
Option Explicit
'
Private N&, NN&
Private p#(), qp#(), w#(), qw#(), svw#()
Private SR#, si#, u#, v#, szr#, szi#, lzr#, lzi#
Private a#, B#, C#, d#, e#, f#, g#, h#
Private A1#, A2#, A3#, A6#, A7#
Private ARE#, MRE#
'
' Vedi MCON:
Private Const vbT& = 15
Private Const vbM& = 308
Private Const vbN& = -323
Private Const BASE# = 10#
Private Const ETA# = BASE ^ (1 - vbT)
Private Const INFINY# = BASE * (1# - BASE ^ (-vbT)) * BASE ^ (vbM - 1)
Private Const SMALNO# = (BASE ^ (vbN + 3)) / BASE ^ 3
Public Sub RPOLY(Op() As Double, ByRef zeror() As Double, ByRef zeroi() As Double, _
    Optional ByRef DEGREE As Long, Optional ByRef Fail As Boolean)
'
'   FINDS THE ZEROS OF A REAL POLYNOMIAL.
'   OP:             DOUBLE PRECISION VECTOR OF COEFFICIENTS IN
'                   ORDER OF increasing POWERS.
'                   As usual, the first coefficient OP(1) is
'                   the constant term, while OP(DEGREE + 1) is
'                   the coefficient of the highest power of x.
'   DEGREE:         INTEGER DEGREE OF POLYNOMIAL.
'   ZEROR, ZEROI:   OUTPUT DOUBLE PRECISION VECTORS OF
'                   REAL AND IMAGINARY PARTS OF THE
'                   ZEROS.
'   FAIL:           OUTPUT LOGICAL PARAMETER, TRUE ONLY IF
'                   LEADING COEFFICIENT IS ZERO OR IF RPOLY
'                   HAS FOUND FEWER THAN DEGREE ZEROS.
'                   IN THE LATTER CASE DEGREE IS RESET TO
'                   THE NUMBER OF ZEROS FOUND.
'
    Dim I&, J&, JJ&, NM1&, CNT&, NZ&
    Dim t#, AA#, BB#, CC#, X#, XX#, XXX#, YY#
    Dim bnd#, FF#, df#, dx#, SC#, xm#, factor#
    Dim L#, LO#, MAX#, MIN#
    Dim ZEROW As Boolean
    'Dim SMALNO#, BASE#
'
    On Error GoTo RPOLY_ERR
'
'   Legge il grado del polinomio:
    DEGREE = UBound(Op) - 1
'
    ReDim p#(1 To DEGREE + 1), zeror#(1 To DEGREE), zeroi#(1 To DEGREE)
    ReDim qp#(1 To DEGREE + 1), w#(1 To DEGREE + 1), qw#(1 To DEGREE + 1)
    ReDim TEMP#(1 To DEGREE + 1), pt#(1 To DEGREE + 1), svw#(1 To DEGREE + 1)
'
'   THE FOLLOWING STATEMENT SETS MACHINE CONSTANTS USED
'   IN VARIOUS PARTS OF THE PROGRAM.
'   ' Dichiarate come Private Const:
    'Call MCON(ETA, INFINY, SMALNO, BASE)
'
'   ARE AND MRE REFER TO THE UNIT ERROR IN + AND *
'   RESPECTIVELY. THEY ARE ASSUMED TO BE THE SAME AS
'   ETA.
    ARE = ETA
    MRE = ETA
    LO = SMALNO / ETA
'
'   INITIALIZATION OF CONSTANTS FOR SHIFT ROTATION.
    Const COSR# = -6.97564737441253E-02 '-0.069756474
    Const SINR# = 0.997564050259824     ' 0.99756405
    XX = Sin(Atn(1#))                   ' 0.70710678
    YY = -XX
'
    Fail = False
    N = DEGREE
    NN = N + 1
'
'   MAKE A COPY OF THE COEFFICIENTS.
'   Inverte l' ordine dei coefficienti
'   per adeguarsi alla struttura originale
'   di RPOLY:
    For I = 1 To DEGREE + 1
        p(I) = Op(DEGREE + 2 - I)
        pt(I) = Abs(p(I))   ' Aggiunto al programma originale
        '                   ' per poter usare SFACTOR.
    Next I
'
'   ALGORITHM FAILS IF THE LEADING COEFFICIENT IS ZERO.
    If (p(1) <> 0#) Then GoTo 10
    Fail = True
    DEGREE = 0
    Exit Sub
'
'   REMOVE THE ZEROS AT THE ORIGIN IF ANY.
10
    If (p(NN) <> 0#) Then GoTo 40
    J = DEGREE - N + 1
    zeror(J) = 0#
    zeroi(J) = 0#
    NN = NN - 1
    N = N - 1
    GoTo 10
'
'   START THE ALGORITHM FOR ONE ZERO.
40
    If (N > 2) Then GoTo 60
    If (N < 1) Then Exit Sub
'
'   CALCULATE THE FINAL ZERO OR PAIR OF ZEROS.
    If (N = 2) Then GoTo 50
    zeror(DEGREE) = -p(2) / p(1)
    zeroi(DEGREE) = 0#
    Exit Sub
'
50
    Call QUAD(p(1), p(2), p(3), zeror(DEGREE - 1), _
              zeroi(DEGREE - 1), zeror(DEGREE), zeroi(DEGREE))
    Exit Sub
'
'   SCALE IF THERE ARE LARGE OR VERY SMALL COEFFICIENTS.
'   COMPUTES A SCALE FACTOR TO MULTIPLY THE
'   COEFFICIENTS OF THE POLYNOMIAL. THE SCALING IS DONE
'   TO AVOID OVERFLOW AND TO AVOID UNDETECTED UNDERFLOW
'   INTERFERING WITH THE CONVERGENCE CRITERION.
'   THE FACTOR IS A POWER OF THE BASE.
60
    factor = SFACTOR(NN, pt(), SMALNO, BASE)
    If (factor = 1#) Then GoTo 110
    For I = 1 To NN
        p(I) = factor * p(I)
    Next I
'
'   COMPUTE LOWER BOUND ON MODULI OF ZEROS.
110
    For I = 1 To NN
        pt(I) = Abs(p(I))
    Next I
'
'   COMPUTE UPPER ESTIMATE OF BOUND.
    pt(NN) = -pt(NN)
    X = Exp((Log(-pt(NN)) - Log(pt(1))) / CDbl(N))
    If (pt(N) = 0#) Then GoTo 130
'
'   IF NEWTON STEP AT THE ORIGIN IS BETTER, USE IT.
    xm = -pt(NN) / pt(N)
    If (xm < X) Then X = xm
'
'   CHOP THE INTERVAL (0,X) UNTIL FF .LE. 0.
130
    xm = X * 0.1
    FF = pt(1)
    For I = 2 To NN
        FF = FF * xm + pt(I)
    Next I
'
    If (FF <= 0#) Then GoTo 150
    X = xm
    GoTo 130
'
'   DO NEWTON ITERATION UNTIL X CONVERGES TO TWO
'   DECIMAL PLACES.
150
    dx = X
'
160
    If (Abs(dx / X) <= 0.005) Then GoTo 180
    FF = pt(1)
    df = FF
    For I = 2 To N
        FF = FF * X + pt(I)
        df = df * X + FF
    Next I
'
    FF = FF * X + pt(NN)
    dx = FF / df
    X = X - dx
    GoTo 160
'
180
    bnd = X
'
'   COMPUTE THE DERIVATIVE AS THE INITIAL W POLYNOMIAL
'   AND DO 5 STEPS WITH NO SHIFT.
    NM1 = N - 1
    For I = 2 To N
        w(I) = CDbl(NN - I) * p(I) / CDbl(N)
    Next I
'
    w(1) = p(1)
    AA = p(NN)
    BB = p(N)
    ZEROW = (w(N) = 0#)
    For JJ = 1 To 5
        CC = w(N)
        If (ZEROW) Then GoTo 210
'
'       USE SCALED FORM OF RECURRENCE IF VALUE OF W AT 0 IS
'       NONZERO.
        t = -AA / CC
        For I = 1 To NM1
            J = NN - I
            w(J) = t * w(J - 1) + p(J)
        Next I
'
        w(1) = p(1)
        ZEROW = (Abs(w(N)) <= (Abs(BB) * ETA * 10#))
        GoTo 230
'
'       USE UNSCALED FORM OF RECURRENCE.
210
        For I = 1 To NM1
          J = NN - I
          w(J) = w(J - 1)
        Next I
'
        w(1) = 0#
        ZEROW = (w(N) = 0#)
'
230
    Next JJ
'
'   SAVE W FOR RESTARTS WITH NEW SHIFTS.
    For I = 1 To N
        TEMP(I) = w(I)
    Next I
'
'   LOOP TO SELECT THE QUADRATIC CORRESPONDING TO EACH
'   NEW SHIFT.
    For CNT = 1 To 20
'       QUADRATIC CORRESPONDS TO A DOUBLE SHIFT TO A
'       NON-REAL POINT AND ITS COMPLEX CONJUGATE. THE POINT
'       HAS MODULUS BND AND AMPLITUDE ROTATED BY 94 DEGREES
'       FROM THE PREVIOUS SHIFT.
        XXX = COSR * XX - SINR * YY
        YY = SINR * XX + COSR * YY
        XX = XXX
        SR = bnd * XX
        si = bnd * YY
        u = -2# * SR
        v = bnd
'       SECOND STAGE CALCULATION, FIXED QUADRATIC.
        Call FXSHFR(20 * CNT, NZ)
        If (NZ = 0) Then GoTo 260
'       THE SECOND STAGE JUMPS DIRECTLY TO ONE OF THE THIRD
'       STAGE ITERATIONS AND RETURNS HERE IF SUCCESSFUL.
'       DEFLATE THE POLYNOMIAL, STORE THE ZERO OR ZEROS AND
'       RETURN TO THE MAIN ALGORITHM.
        J = DEGREE - N + 1
        zeror(J) = szr
        zeroi(J) = szi
        NN = NN - NZ
        N = NN - 1
        For I = 1 To NN
            p(I) = qp(I)
        Next I
'
        If (NZ = 1) Then GoTo 40
        zeror(J + 1) = lzr
        zeroi(J + 1) = lzi
        GoTo 40
'
'       IF THE ITERATION IS UNSUCCESSFUL ANOTHER QUADRATIC
'       IS CHOSEN AFTER RESTORING W.
260
        For I = 1 To N
            w(I) = TEMP(I)
        Next I
'
    Next CNT
'
'   RETURN WITH FAILURE IF NO CONVERGENCE WITH 20 SHIFTS.
    Fail = True
    DEGREE = DEGREE - N
'
'
RPOLY_ERR:
    If (Err <> 0) Then
        Fail = True
    End If
'
'
'
End Sub
Private Sub FXSHFR(ByVal L2 As Long, NZ As Long)
'
'   COMPUTES UP TO  L2  FIXED SHIFT K-POLYNOMIALS,
'   TESTING FOR CONVERGENCE IN THE LINEAR OR QUADRATIC
'   CASE. INITIATES ONE OF THE VARIABLE SHIFT
'   ITERATIONS AND RETURNS WITH THE NUMBER OF ZEROS
'   FOUND.
'   L2: LIMIT OF FIXED SHIFT STEPS
'   NZ: NUMBER OF ZEROS FOUND
'
    Dim svu#, svv#, Ui#, vi#, s#
    Dim betas#, betav#, oss#, ovv#, SS#, VV#, Ts#, tv#
    Dim ots#, otv#, tvv#, tss#
    Dim TYP&, I&, J&, IFLAG&
    Dim VPASS As Boolean, SPASS As Boolean, VTRY As Boolean, STRY As Boolean
'
    NZ = 0
    betav = 0.25
    betas = 0.25
    oss = SR
    ovv = v
'
'   EVALUATE POLYNOMIAL BY SYNTHETIC DIVISION
    Call QUADSD(NN, u, v, p, qp, a, B)
    Call CALCSC(TYP)
    For J = 1 To L2
'
'   CALCULATE NEXT W POLYNOMIAL AND ESTIMATE V
        Call NEXTW(TYP)
        Call CALCSC(TYP)
        Call NEWEST(TYP, Ui, vi)
        VV = vi
'
'   ESTIMATE S
        SS = 0#
        If (w(N) <> 0#) Then SS = -p(NN) / w(N)
        tv = 1#
        Ts = 1#
        If (J = 1) Or (TYP = 3) Then GoTo 70
'
'   COMPUTE RELATIVE MEASURES OF CONVERGENCE OF S AND V
'   SEQUENCES
        If (VV <> 0#) Then tv = Abs((VV - ovv) / VV)
        If (SS <> 0#) Then Ts = Abs((SS - oss) / SS)
'
'   IF DECREASING, MULTIPLY TWO MOST RECENT
'   CONVERGENCE MEASURES
        tvv = 1#
        If (tv < otv) Then tvv = tv * otv
        tss = 1#
        If (Ts < ots) Then tss = Ts * ots
'
'   COMPARE WITH CONVERGENCE CRITERIA
        VPASS = (tvv < betav)
        SPASS = (tss < betas)
        If (Not (SPASS Or VPASS)) Then GoTo 70
'
'   AT LEAST ONE SEQUENCE HAS PASSED THE CONVERGENCE
'   TEST. STORE VARIABLES BEFORE ITERATING
        svu = u
        svv = v
        For I = 1 To N
            svw(I) = w(I)
        Next I
        s = SS
'
'   CHOOSE ITERATION ACCORDING TO THE FASTEST
'   CONVERGING SEQUENCE
        VTRY = False
        STRY = False
        If (SPASS And ((Not VPASS) Or tss < tvv)) Then GoTo 40
20      Call QUADIT(Ui, vi, NZ)
        If (NZ > 0) Then Exit Sub
'
'   QUADRATIC ITERATION HAS FAILED. FLAG THAT IT HAS
'   BEEN TRIED AND DECREASE THE CONVERGENCE CRITERION.
        VTRY = True
        betav = betav * 0.25
'
'   TRY LINEAR ITERATION IF IT HAS NOT BEEN TRIED AND
'   THE S SEQUENCE IS CONVERGING
        If (STRY Or (Not SPASS)) Then GoTo 50
        For I = 1 To N
          w(I) = svw(I)
        Next I
40
        Call REALIT(s, NZ, IFLAG)
        If (NZ > 0) Then Exit Sub
'
'   LINEAR ITERATION HAS FAILED. FLAG THAT IT HAS BEEN
'   TRIED AND DECREASE THE CONVERGENCE CRITERION
        STRY = True
        betas = betas * 0.25
        If (IFLAG = 0) Then GoTo 50
'
'   IF LINEAR ITERATION SIGNALS AN ALMOST DOUBLE REAL
'   ZERO ATTEMPT QUADRATIC INTERATION
        Ui = -(s + s)
        vi = s * s
        GoTo 20
'
'   RESTORE VARIABLES
50
        u = svu
        v = svv
        For I = 1 To N
            w(I) = svw(I)
        Next I
'
'   TRY QUADRATIC ITERATION IF IT HAS NOT BEEN TRIED
'   AND THE V SEQUENCE IS CONVERGING
        If (VPASS And (Not VTRY)) Then GoTo 20
'
'   RECOMPUTE QP AND SCALAR VALUES TO CONTINUE THE
'   SECOND STAGE
        Call QUADSD(NN, u, v, p, qp, a, B)
        Call CALCSC(TYP)
70
        ovv = VV
        oss = SS
        otv = tv
        ots = Ts
    Next J
'
'
'
End Sub

Private Sub QUADIT(ByVal UU As Double, ByVal VV As Double, NZ As Long)
'
'   VARIABLE-SHIFT K-POLYNOMIAL ITERATION FOR A
'   QUADRATIC FACTOR CONVERGES ONLY IF THE ZEROS ARE
'   EQUIMODULAR OR NEARLY SO.
'   UU,VV:  COEFFICIENTS OF STARTING QUADRATIC
'   NZ:     NUMBER OF ZERO FOUND
'
    Dim TYP&, I&, J&
    Dim Ui#, vi#
    Dim MS#, mp#, omp#, ee#, relstp#, t#, zm#
    Dim TRIED As Boolean
'
    NZ = 0
    TRIED = False
    u = UU
    v = VV
    J = 0
'
'   MAIN LOOP.
10
    Call QUAD(1#, u, v, szr, szi, lzr, lzi)
'
'   RETURN IF ROOTS OF THE QUADRATIC ARE REAL AND NOT
'   CLOSE TO MULTIPLE OR NEARLY EQUAL AND  OF OPPOSITE
'   SIGN.
    If (Abs(Abs(szr) - Abs(lzr)) > (0.01 * Abs(lzr))) Then Exit Sub
'
'   EVALUATE POLYNOMIAL BY QUADRATIC SYNTHETIC DIVISION.
    Call QUADSD(NN, u, v, p, qp, a, B)
    mp = Abs(a - szr * B) + Abs(szi * B)
'
'   COMPUTE A RIGOROUS BOUND ON THE ROUNDING ERROR IN
'   EVALUTING P.
    zm = Sqr(Abs(v))
    ee = 2# * Abs(qp(1))
    t = -szr * B
    For I = 2 To N
        ee = ee * zm + Abs(qp(I))
    Next I
    ee = ee * zm + Abs(a + t)
    ee = (5# * MRE + 4# * ARE) * ee - (5# * MRE + 2# * ARE) _
       * (Abs(a + t) + Abs(B) * zm) + 2# * ARE * Abs(t)
'
'   ITERATION HAS CONVERGED SUFFICIENTLY IF THE
'   POLYNOMIAL VALUE IS LESS THAN 20 TIMES THIS BOUND.
    If (mp > 20# * ee) Then GoTo 30
    NZ = 2
    Exit Sub
'
30
    J = J + 1
'
'   STOP ITERATION AFTER 20 STEPS.
    If (J > 20) Then Exit Sub
    If (J < 2) Then GoTo 50
    If (relstp > 0.01) Or (mp < omp) Or TRIED Then GoTo 50
'
'   A CLUSTER APPEARS TO BE STALLING THE CONVERGENCE.
'   FIVE FIXED SHIFT STEPS ARE TAKEN WITH A U,V CLOSE
'   TO THE CLUSTER.
    If (relstp < ETA) Then relstp = ETA
    relstp = Sqr(relstp)
    u = u - u * relstp
    v = v + v * relstp
    Call QUADSD(NN, u, v, p, qp, a, B)
    For I = 1 To 5
        Call CALCSC(TYP)
        Call NEXTW(TYP)
    Next I
    TRIED = True
    J = 0
'
50
    omp = mp
'
'   CALCULATE NEXT W POLYNOMIAL AND NEW U AND V.
    Call CALCSC(TYP)
    Call NEXTW(TYP)
    Call CALCSC(TYP)
    Call NEWEST(TYP, Ui, vi)
'
'   IF VI IS ZERO THE ITERATION IS NOT CONVERGING.
    If (vi = 0#) Then Exit Sub
    relstp = Abs((vi - v) / vi)
    u = Ui
    v = vi
    GoTo 10
'
'
'
End Sub
Private Sub REALIT(sss As Double, NZ As Long, IFLAG As Long)
'
'   VARIABLE-SHIFT H POLYNOMIAL ITERATION FOR A REAL
'   ZERO.
'   SSS:    STARTING ITERATE
'   NZ:     NUMBER OF ZERO FOUND
'   IFLAG:  FLAG TO INDICATE A PAIR OF ZEROS NEAR REAL
'           AXIS.
'
    Dim I&, J&, NM1&
    Dim pv#, wv#, t#, s#
    Dim MS#, mp#, omp#, ee#
'
      NM1 = N - 1
      NZ = 0
      s = sss
      IFLAG = 0
      J = 0
'
'   MAIN LOOP.
10
    pv = p(1)
'
'   EVALUATE P AT S.
    qp(1) = pv
    For I = 2 To NN
        pv = pv * s + p(I)
        qp(I) = pv
    Next I
    mp = Abs(pv)
'
'   COMPUTE A RIGOROUS BOUND ON THE ERROR IN EVALUATING P.
    MS = Abs(s)
    ee = (MRE / (ARE + MRE)) * Abs(qp(1))
    For I = 2 To NN
        ee = ee * MS + Abs(qp(I))
    Next I
'
'   ITERATION HAS CONVERGED SUFFICIENTLY IF THE
'   POLYNOMIAL VALUE IS LESS THAN 20 TIMES THIS BOUND.
    If (mp > (20# * ((ARE + MRE) * ee - MRE * mp))) Then GoTo 40
    NZ = 1
    szr = s
    szi = 0#
    Exit Sub
'
40
    J = J + 1
'
'   STOP ITERATION AFTER 10 STEPS.
    If (J > 10) Then Exit Sub
    If (J < 2) Then GoTo 50
    If (Abs(t) > 0.001 * Abs(s - t)) Or (mp <= omp) Then GoTo 50
'
'   A CLUSTER OF ZEROS NEAR THE REAL AXIS HAS BEEN
'   ENCOUNTERED RETURN WITH IFLAG SET TO INITIATE A
'   QUADRATIC ITERATION.
    IFLAG = 1
    sss = s
    Exit Sub
'
'   RETURN IF THE POLYNOMIAL VALUE HAS INCREASED
'   SIGNIFICANTLY.
50
    omp = mp
'
'   COMPUTE T, THE NEXT POLYNOMIAL, AND THE NEW ITERATE.
    wv = w(1)
    qw(1) = wv
    For I = 2 To N
        wv = wv * s + w(I)
        qw(I) = wv
    Next I
    If (Abs(wv) <= Abs(w(N)) * 10# * ETA) Then GoTo 80
'
'   USE THE SCALED FORM OF THE RECURRENCE IF THE VALUE
'   OF W AT S IS NONZERO.
    t = -pv / wv
    w(1) = qp(1)
    For I = 2 To N
        w(I) = t * qw(I - 1) + qp(I)
    Next I
    GoTo 100
'
'   USE UNSCALED FORM.
80
    w(1) = 0#
    For I = 2 To N
        w(I) = qw(I - 1)
    Next I
'
100
    wv = w(1)
    For I = 2 To N
        wv = wv * s + w(I)
    Next I
    t = 0#
    If (Abs(wv) > Abs(w(N)) * 10# * ETA) Then t = -pv / wv
    s = s + t
    GoTo 10
'
'
'
End Sub
Private Sub QUADSD(ByVal qNn As Long, ByVal qu As Double, ByVal qv As Double, _
    qz() As Double, qq() As Double, qa As Double, qb As Double)
'
'   DIVIDES P BY THE QUADRATIC  1,U,V  PLACING THE
'   QUOTIENT IN Q AND THE REMAINDER IN A,B.
'
    Dim I&, qc#
'
    qb = qz(1)
    qq(1) = qb
    qa = qz(2) - qu * qb
    qq(2) = qa
    For I = 3 To qNn
        qc = qz(I) - qu * qa - qv * qb
        qq(I) = qc
        qb = qa
        qa = qc
    Next I
'
'
'
End Sub
Private Sub QUAD(ByVal qa As Double, ByVal qb1 As Double, ByVal qc As Double, _
    qsr As Double, qsi As Double, qlr As Double, qli As Double)
'
'   CALCULATE THE ZEROS OF THE QUADRATIC A*Z**2+B1*Z+C.
'   THE QUADRATIC FORMULA, MODIFIED TO AVOID
'   OVERFLOW, IS USED TO FIND THE LARGER ZERO IF THE
'   ZEROS ARE REAL AND BOTH ZEROS ARE COMPLEX.
'   THE SMALLER REAL ZERO IS FOUND DIRECTLY FROM THE
'   PRODUCT OF THE ZEROS C/A.
'
    Dim qb#, qd#, qe#
'
    If (qa <> 0#) Then GoTo 20
    qsr = 0#
    If (qb1 <> 0#) Then qsr = -qc / qb1
    qlr = 0#
'
10
    qsi = 0#
    qli = 0#
    Exit Sub
'
20
    If (qc <> 0#) Then GoTo 30
    qsr = 0#
    qlr = -qb1 / qa
    GoTo 10
'
'   COMPUTE DISCRIMINANT AVOIDING OVERFLOW.
30
    qb = qb1 / 2#
    If (Abs(qb) < Abs(qc)) Then GoTo 40
    qe = 1# - (qa / qb) * (qc / qb)
    qd = Sqr(Abs(qe)) * Abs(qb)
    GoTo 50
'
40
    qe = qa
    If (qc < 0#) Then qe = -qa
    qe = qb * (qb / Abs(qc)) - qe
    qd = Sqr(Abs(qe)) * Sqr(Abs(qc))
'
50
    If (qe < 0#) Then GoTo 60
'
'   REAL ZEROS.
    If (qb >= 0#) Then qd = -qd
    qlr = (-qb + qd) / qa
    qsr = 0#
    If (qlr <> 0#) Then qsr = (qc / qlr) / qa
    GoTo 10
'
'   COMPLEX CONJUGATE ZEROS.
60
    qsr = -qb / qa
    qlr = qsr
    qsi = Abs(qd / qa)
    qli = -qsi
'
'
'
End Sub
Private Sub CALCSC(TYP As Long)
'
'   THIS ROUTINE CALCULATES SCALAR QUANTITIES USED TO
'   COMPUTE THE NEXT W POLYNOMIAL AND NEW ESTIMATES OF
'   THE QUADRATIC COEFFICIENTS.
'   TYP:    INTEGER VARIABLE SET HERE INDICATING HOW THE
'           CALCULATIONS ARE NORMALIZED TO AVOID OVERFLOW
'
'   SYNTHETIC DIVISION OF W BY THE QUADRATIC 1,U,V
    Call QUADSD(N, u, v, w(), qw(), C, d)
    If (Abs(C) > Abs(w(N)) * 100# * ETA) Then GoTo 10
    If (Abs(d) > Abs(w(N - 1)) * 100# * ETA) Then GoTo 10
'
    TYP = 3
'   TYP=3 INDICATES THE QUADRATIC IS ALMOST A FACTOR
'   OF W
    Exit Sub
'
10
    If (Abs(d) < Abs(C)) Then GoTo 20
'
    TYP = 2
'   TYP=2 INDICATES THAT ALL FORMULAS ARE DIVIDED BY D
    e = a / d
    f = C / d
    g = u * B
    h = v * B
    A3 = (a + g) * e + h * (B / d)
    A1 = B * f - a
    A7 = (f + u) * a + h
    Exit Sub
'
20
    TYP = 1
'   TYP=1 INDICATES THAT ALL FORMULAS ARE DIVIDED BY C
    e = a / C
    f = d / C
    g = u * e
    h = v * B
    A3 = a * e + (h / C + g) * B
    A1 = B - a * (d / C)
    A7 = a + g * d + h * f
'
'
'
End Sub

Private Sub NEXTW(ByVal TYP As Long)
'
'   COMPUTES THE NEXT W POLYNOMIALS USING SCALARS
'   COMPUTED IN CALCSC
'
    Dim I&, TEMP#
'
    If (TYP = 3) Then GoTo 40
    TEMP = a
    If (TYP = 1) Then TEMP = B
    If (Abs(A1) > Abs(TEMP) * ETA * 10#) Then GoTo 20
'
'   IF A1 IS NEARLY ZERO THEN USE A SPECIAL FORM OF THE
'   RECURRENCE
    w(1) = 0#
    w(2) = -A7 * qp(1)
    For I = 3 To N
        w(I) = A3 * qw(I - 2) - A7 * qp(I - 1)
    Next I
    Exit Sub
'
'   USE SCALED FORM OF THE RECURRENCE
20
    A7 = A7 / A1
    A3 = A3 / A1
    w(1) = qp(1)
    w(2) = qp(2) - A7 * qp(1)
    For I = 3 To N
        w(I) = A3 * qw(I - 2) - A7 * qp(I - 1) + qp(I)
    Next I
    Exit Sub
'
'   USE UNSCALED FORM OF THE RECURRENCE IF TYP IS 3
40
    w(1) = 0#
    w(2) = 0#
    For I = 3 To N
        w(I) = qw(I - 2)
    Next I
'
'
'
End Sub


Private Sub NEWEST(ByVal TYP As Long, UU As Double, VV As Double)
'
'   COMPUTE NEW ESTIMATES OF THE QUADRATIC COEFFICIENTS
'   USING THE SCALARS COMPUTED IN CALCSC.
'
    Dim A4#, A5#, B1#, B2#, C1#, C2#, C3#, C4#, TEMP#
'
'   USE FORMULAS APPROPRIATE TO SETTING OF TYP.
    If (TYP = 3) Then GoTo 30
    If (TYP = 2) Then GoTo 10
    A4 = a + u * B + h * f
    A5 = C + (u + v * f) * d
    GoTo 20
'
10
    A4 = (a + g) * f + h
    A5 = (f + u) * C + v * d
'
'   EVALUATE NEW QUADRATIC COEFFICIENTS.
20
    B1 = -w(N) / p(NN)
    B2 = -(w(N - 1) + B1 * p(N)) / p(NN)
    C1 = v * B2 * A1
    C2 = B1 * A7
    C3 = B1 * B1 * A3
    C4 = C1 - C2 - C3
    TEMP = A5 + B1 * A4 - C4
    If (TEMP = 0#) Then GoTo 30
    UU = u - (u * (C3 + C2) + v * (B1 * A1 + B2 * A7)) / TEMP
    VV = v * (1# + C4 / TEMP)
    Exit Sub
'
'   IF TYP=3 THE QUADRATIC IS ZEROED
30
    UU = 0#
    VV = 0#
'
'
'
End Sub

Private Sub MCON(vbETA As Double, vbINFINY As Double, vbSMALNO As Double, vbBASE As Double)
'
'   Non usata.
'   ----------
'
'   MCON PROVIDES MACHINE CONSTANTS USED IN VARIOUS PARTS OF THE
'   PROGRAM. THE USER MAY EITHER SET THEM DIRECTLY OR USE THE
'   STATEMENTS BELOW TO COMPUTE THEM. THE MEANING OF THE FOUR
'   CONSTANTS ARE:
'   ETA:    THE MAXIMUM RELATIVE REPRESENTATION ERROR
'           WHICH CAN BE DESCRIBED AS THE SMALLEST POSITIVE
'           FLOATING-POINT NUMBER SUCH THAT 1.0D0 + ETA IS
'           GREATER THAN 1.0D0.
'   INFINY: THE LARGEST FLOATING-POINT NUMBER
'   SMALNO: THE SMALLEST POSITIVE FLOATING-POINT NUMBER
'   BASE:   THE BASE OF THE FLOATING-POINT NUMBER SYSTEM USED
'
'   LET T BE THE NUMBER OF BASE-DIGITS IN EACH FLOATING-POINT
'   NUMBER(DOUBLE PRECISION). THEN ETA IS EITHER .5*B**(1-T)
'   OR B**(1-T) DEPENDING ON WHETHER ROUNDING OR TRUNCATION
'   IS USED.
'   LET M BE THE LARGEST EXPONENT AND N THE SMALLEST EXPONENT
'   IN THE NUMBER SYSTEM. THEN INFINY IS (1-BASE**(-T))*BASE**M
'   AND SMALNO IS BASE**N.
'
    Dim vbM&, vbN&, vbT&
'
    ' Visual Basic 6.0 Double data type:
    ' vbN = -323: vbM = 308: BASE# = 10: vbT = 15
    ' INFINY = (1# - 10 ^ (-15)) * 10 ^ 308 = 9.99999999999999E+307
    ' SMALNO = 10 ^ -323 = 9.88131291682493E-324
    ' ETA = 10 ^ (1 - 15) = 0.00000000000001
    ' 1# + ETA = 1# + 10 ^ (1 - 15) = 1.00000000000001
'
    vbBASE = 10#
    vbT = 15
    vbM = 308
    vbN = -323
    vbETA = vbBASE ^ (1 - vbT)
    vbINFINY = vbBASE * (1# - vbBASE ^ (-vbT)) * vbBASE ^ (vbM - 1)
    vbSMALNO = (vbBASE ^ (vbN + 3)) / vbBASE ^ 3
'
'
'
End Sub
Private Function SFACTOR_O(ByVal NN As Long, p() As Double, ByVal SMALNO As Double, _
    ByVal BASE As Double) As Double
'
'   Non usata.
'   ----------
'   Procedura originale di scalatura.
'   E' stata sostituita da quella di CPOLY che offre
'   risultati piu' equilibrati.
'
    Dim I&, X#, hi#, L#, LO#, MAX#, MIN#, SC#
'
'   FIND LARGEST AND SMALLEST MODULI OF COEFFICIENTS.
    LO = SMALNO / ETA
    MAX = 0#
    MIN = INFINY
    For I = 1 To NN
        X = Abs(p(I))
        If (X > MAX) Then MAX = X
        If ((X <> 0#) And (X < MIN)) Then MIN = X
    Next I
'
'   SCALE IF THERE ARE LARGE OR VERY SMALL COEFFICIENTS
'   COMPUTES A SCALE FACTOR TO MULTIPLY THE
'   COEFFICIENTS OF THE POLYNOMIAL. THE SCALING IS DONE
'   TO AVOID OVERFLOW AND TO AVOID UNDETECTED UNDERFLOW
'   INTERFERING WITH THE CONVERGENCE CRITERION.
'   THE FACTOR IS A POWER OF THE BASE.
    SC = LO / MIN
    If (SC > 1#) Then GoTo 80
    If (MAX < 1#) Then GoTo 110
    If (SC = 0#) Then SC = SMALNO
    GoTo 90
'
80
    If (INFINY / SC < MAX) Then GoTo 110
'
90
    L = Log(SC) / Log(BASE) + 0.5
    SFACTOR_O = BASE ^ L
'
110
'
'
'
End Function
Private Function SFACTOR(ByVal NN As Long, pt() As Double, ByVal SMALNO As Double, _
    ByVal BASE As Double) As Double
'
'   RETURNS A SCALE FACTOR TO MULTIPLY THE COEFFICIENTS OF THE
'   POLYNOMIAL. THE SCALING IS DONE TO AVOID OVERFLOW AND TO AVOID
'   UNDETECTED UNDERFLOW INTERFERING WITH THE CONVERGENCE
'   CRITERION.  THE FACTOR IS A POWER OF THE BASE.
'   PT:                     MODULUS OF COEFFICIENTS OF P.
'   ETA,INFINY,SMALNO,BASE: CONSTANTS DESCRIBING THE
'                           FLOATING POINT ARITHMETIC.
'
    Dim I&, X#, hi#, L#, LO#, MAX#, MIN#, SC#
'
'   FIND LARGEST AND SMALLEST MODULI OF COEFFICIENTS.
    hi = Sqr(INFINY)
    LO = SMALNO / ETA
    MAX = 0#
    MIN = INFINY
    For I = 1 To NN
        X = pt(I)
        If (X > MAX) Then MAX = X
        If (X <> 0# And X < MIN) Then MIN = X
    Next I
'
'   SCALE ONLY IF THERE ARE VERY LARGE OR VERY SMALL COMPONENTS.
    SFACTOR = 1#
    If ((MIN >= LO) And (MAX <= hi)) Then Exit Function
    X = LO / MIN
    If (X > 1#) Then GoTo 20
    SC = 1# / (Sqr(MAX) * Sqr(MIN))
    GoTo 30
'
20
    SC = X
    If (INFINY / SC > MAX) Then SC = 1#
'
30
    L = Log(SC) / Log(BASE) + 0.5
    SFACTOR = BASE ^ L
'
'
'
End Function
