Attribute VB_Name = "modUtilita"
'=======================================================================================
' Descrizione.....: Collezione di routines e costanti di utilita'
'                   per l' acquisizione dei segnali dalla scheda
'                   audio, per l' Oscilloscopio, per l' Analiz-
'                   zatore di Spettro e per il Correlatore.
'                   Non tutte le costanti e le routines di questo
'                   modulo vengono, necessariamente, usate.
' Nome dei Files..: modUtilita.bas
' Data............: 16/08/2003
' Versione........: 1.0 a 32 Bits.
' Sistema.........: VB6 (SP5) sotto Windows XP (SP2).
' Scritto da......: F. Languasco 
' E-Mail..........: MC7061@mclink.it
' DownLoads a.....: http://www.flanguasco.org
'=======================================================================================
'
Option Explicit
'
Public Const PI# = 3.14159265358979     ' 4# * Atn(1#)
Public Const PI2# = 2# * PI
Public Const PI_2# = PI / 2#            ' 90 in [rad].
Public Const PI_6# = PI / 6#            ' 30 in [rad].
Public Const Log2# = 0.693147180559945  ' Log(2#)
Public Const Log10# = 2.30258509299405  ' Log(10#)
Public Const Sqr2# = 1.4142135623731    ' Sqr(2#)
Public Const dB_3# = 3.01029995663981   ' 20# * Log(Sqr(2#)) / Log(10#)
Public Const KNote# = 1.0594630943593   ' 2 ^ (1/12)
'
Public Const RadToGrd# = 180# / PI      ' Fattore di conversione da [rad] a [Grd].
'
Public Const ColZoom& = vbGreen         ' Colore delle finestre di zoom.
Public Const ColEvi& = vbInfoBackground ' Colore degli evidenziatori.
'
Private Const V16Min# = -2 ^ 15         ' Valori min. e Max. dei dati in ingresso alla
Private Const V16Max# = 2 ^ 15 - 1      ' scheda audio; campionamento a 16 Bits [DigVal].
'
Private Const MaxDouble# = 1.7976931348623E+308 ' Massimo valore rappresentabile nel tipo Double.
Private Const MinDouble# = -1.797693134862E+308 ' Minimo  valore rappresentabile nel tipo Double.
'
'-- Dichiarazioni, costanti e tipi per API: --------------------------------------------
'
'--- CloseButtonDisable: ---------------------------------------------------------------
Private Declare Function RemoveMenu Lib "USER32" (ByVal hMenu As Long, _
    ByVal nPosition As Long, ByVal wFlags As Long) As Long
Private Declare Function GetSystemMenu Lib "USER32" (ByVal hWnd As Long, _
    ByVal bRevert As Long) As Long
Private Const MF_REMOVE& = &H1000&
Private Const SC_CLOSE& = &HF060
'
'--- GetIniString, SaveIniString: ------------------------------------------------------
Private Declare Function GetPrivateProfileString Lib "kernel32" _
    Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, _
    ByVal lpKeyName As Any, ByVal lpDefault As String, _
    ByVal lpReturnedString As String, ByVal nSize As Long, _
    ByVal lpFileName As String) As Long
Private Declare Function WritePrivateProfileString Lib "kernel32" _
    Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, _
    ByVal lpKeyName As Any, ByVal lpString As Any, _
    ByVal lpFileName As String) As Long
'
'--- GetLocale: ------------------------------------------------------------------------
Private Const LOCALE_STHOUSAND& = &HF
Private Const LOCALE_SDECIMAL& = &HE
Private Declare Function GetLocaleInfo Lib "kernel32" Alias "GetLocaleInfoA" _
    (ByVal Locale As Long, ByVal LCType As Long, ByVal lpLCData As String, _
    ByVal cchData As Long) As Long
Private Declare Function GetThreadLocale Lib "kernel32" () As Long
'
'--- Crea regioni: ---------------------------------------------------------------------
Private Type POINTAPI
     X As Long          ' [Pixels].
     Y As Long          '     "
End Type
'
Private Const ALTERNATE% = 1
Private Const WINDING% = 2
'
Private Declare Function CreateRectRgn Lib "gdi32" _
    (ByVal X1 As Long, ByVal Y1 As Long, ByVal X2 As Long, ByVal Y2 As Long) As Long
'
Private Declare Function CreateEllipticRgn Lib "gdi32" _
    (ByVal X1 As Long, ByVal Y1 As Long, ByVal X2 As Long, ByVal Y2 As Long) As Long
'
Private Declare Function CreatePolygonRgn Lib "gdi32" _
    (lpPoint As POINTAPI, ByVal nCount As Long, ByVal nPolyFillMode As Long) As Long
'
'--- ResMouseAreaPB, MoveCursorPosPB: --------------------------------------------------
Private Type RECT
    Left  As Long       ' [Pixels].
    Top  As Long        '     "
    Right  As Long      '     "
    Bottom  As Long     '     "
End Type
'
Private Declare Function ClientToScreen Lib "USER32" (ByVal hWnd As Long, _
    lpPoint As POINTAPI) As Long
'
Private Declare Function ClipCursorRect Lib "USER32" Alias _
    "ClipCursor" (lpRECT As RECT) As Long
Private Declare Function ClipCursorClear Lib "USER32" Alias _
    "ClipCursor" (ByVal lpNULLRECT&) As Long
'
Private Declare Function SetCursorPos Lib "USER32" (ByVal X As Long, _
    ByVal Y As Long) As Long
'
'--- ScreenSaver: ----------------------------------------------------------------------
Private Const SPI_GETSCREENSAVEACTIVE& = 16
Private Const SPI_SETSCREENSAVEACTIVE& = 17
Private Declare Function SystemParametersInfo Lib "USER32" Alias _
    "SystemParametersInfoA" (ByVal uAction As Long, ByVal uParam As Long, _
    lpvParam As Any, ByVal fuWinIni As Long) As Long
'
'--- TempFile: -------------------------------------------------------------------------
Private Const MAX_PATH& = 260
Private Declare Function GetTempPath Lib "kernel32" Alias "GetTempPathA" _
    (ByVal nBufferLength As Long, ByVal lpBuffer As String) As Long
Private Declare Function GetTempFileName Lib "kernel32" Alias "GetTempFileNameA" _
    (ByVal lpszPath As String, ByVal lpPrefixString As String, _
    ByVal wUnique As Long, ByVal lpTempFileName As String) As Long
Private Sub QuickSort(ByRef ValTab() As Double, ByVal Low As Long, ByVal High As Long, _
    Optional ByVal Verso As Long = 1)
'
'   Routine QuickSort:
'    ValTab():  Vettore che si vuole ordinare.
'    Low:       Posizione iniziale della zona da ordinare.
'    High:      Posizione finale della zona da ordinare.
'    Verso:     Direzione dell' ordinamento:
'                > 0 -> dal minore al maggiore.
'                = 0 -> nessun ordinamento.
'                < 0 -> dal maggiore al minore.
'
    Dim RandIndex&, I&, J&
    Dim ValTemp As Double   ' Tipo del vettore che si vuole ordinare.
    Dim Part As Double      ' Tipo della chiave di ordinamento.
'
    On Error GoTo QuickSort_ERR
    If Verso = 0 Then Exit Sub
'
    If (Low < High) Then
'
        If ((High - Low) = 1) Then
            ' Only two elements in this subdivision; swap them
            ' if they are out of order, then end recursive calls:
            If ((0 < Verso) And (ValTab(High) < ValTab(Low))) _
            Or ((Verso < 0) And (ValTab(Low) < ValTab(High))) Then
                'SWAP ValTab(Low), ValTab(High)
                ValTemp = ValTab(Low)
                ValTab(Low) = ValTab(High)
                ValTab(High) = ValTemp
            End If
'
        Else
            ' Pick a pivot element, then move it to the end:
            RandIndex = (High + Low) / 2
            'SWAP ValTab(High), ValTab(RandIndex)
            ValTemp = ValTab(High)
            ValTab(High) = ValTab(RandIndex)
            ValTab(RandIndex) = ValTemp
            Part = ValTab(High)
'
            ' Move in from both sides towards the pivot element:
            Do
                I = Low: J = High
                Do While ((0 < Verso) And (I < J) And (ValTab(I) <= Part)) _
                Or ((Verso < 0) And (I < J) And (Part <= ValTab(I)))
                    I = I + 1
                Loop
                Do While ((0 < Verso) And (I < J) And (Part <= ValTab(J))) _
                Or ((Verso < 0) And (I < J) And (ValTab(J) <= Part))
                    J = J - 1
                Loop
'
                If (I < J) Then
                    ' We haven't reached the pivot element; it means that two
                    ' elements on either side are out of order, so swap them:
                    'SWAP ValTab(I), ValTab(J)
                    ValTemp = ValTab(I)
                    ValTab(I) = ValTab(J)
                    ValTab(J) = ValTemp
                End If
'
            Loop While (I < J)
            ' Move the pivot element back to its proper place in the array:
            'SWAP ValTab(I), ValTab(High)
            ValTemp = ValTab(I)
            ValTab(I) = ValTab(High)
            ValTab(High) = ValTemp
'
            ' Recursively call the QuickSort procedure (pass the smaller
            ' subdivision first to use less stack space):
            If ((I - Low) < (High - I)) Then
                QuickSort ValTab(), Low, I - 1, Verso
                QuickSort ValTab(), I + 1, High, Verso
            Else
                QuickSort ValTab(), I + 1, High, Verso
                QuickSort ValTab(), Low, I - 1, Verso
            End If
        End If
    End If
'
'
QuickSort_ERR:
    If (Err <> 0) Then
        Dim M$
        M$ = "Errore " & Str$(Err.Number) & vbNewLine
        M$ = M$ & Err.Description
        MsgBox M$, vbCritical, " QuickSort"
    End If
'
'
'
End Sub
Public Function MoveCursorPosPB(ByVal picB As PictureBox, _
    ByVal X1 As Single, ByVal Y1 As Single) As Long
'
'   Sposta il puntatore del Mouse, nel PictureBox picB,
'   alla posizione X1, Y1.  Le coordinate sono relative a
'   picB ed in unita' picB.ScaleMode:
'
    Dim Point1 As POINTAPI
'
    ' Converto le coordinate in Pixels:
    Point1.X = picB.ScaleX(X1 - picB.ScaleLeft, picB.ScaleMode, vbPixels)
    Point1.Y = picB.ScaleY(Y1 - picB.ScaleTop, picB.ScaleMode, vbPixels)
'
    ClientToScreen picB.hWnd, Point1
    MoveCursorPosPB = SetCursorPos(Point1.X, Point1.Y)
'
'
'
End Function
Public Function Sequenza1_2_3(ByVal ValI As Double, _
    Optional ByVal bMantissaInSeq As Boolean = False, _
    Optional ByVal ValMax As Double = 1E+300) As Double
'
'   Ritorna il prossimo valore nella sequenza ... -> 8 -> 9 -> 10 -> 20 -> ...
'   Se bMantissaInSeq = True e ValI e' gia' uno dei numeri della sequenza
'   ritorna lo stesso ValI; se ValI <= 0 ritorna 1.  Il valore massimo
'   della sequenza e' limitato al valore ValMax:
'
    Dim I&, ValE$, rrM#, rrE#, Seq1_2_3#
'
    ValE$ = Format$(ValI, "0.000000E+000")
    rrM = CDbl(Left$(ValE$, 8))
    rrE = CDbl("1" & Right$(ValE$, 5))
'
    Seq1_2_3 = 1
'
    If bMantissaInSeq And (Fix(rrM) = rrM) Then
       Seq1_2_3 = ValI
'
    Else
        For I = 1 To 10
            If (I - 1 <= rrM) And (rrM < I) Then
                Seq1_2_3 = I * rrE
                Exit For
            End If
        Next I
    End If
'
    If (Seq1_2_3 <= ValMax) Then
        Sequenza1_2_3 = Seq1_2_3
    Else
        Sequenza1_2_3 = ValMax
    End If
'
'
'
End Function
Public Sub DSWAP(ByRef dN1 As Double, ByRef dN2 As Double)
'
'
    Dim dTn As Double
'
    dTn = dN1
    dN1 = dN2
    dN2 = dTn
'
'
'
End Sub
Public Sub ISWAP(ByRef lN1 As Long, ByRef lN2 As Long)
'
'
    Dim lTn As Long
'
    lTn = lN1
    lN1 = lN2
    lN2 = lTn
'
'
'
End Sub
Public Function Seno_AM(ByRef I As Long) As Double
'
'   Ritorna i valori corrispondenti ad un
'   segnale sinusoidale campionato a 1/Fs [s]
'   e modulato in ampiezza.
'   Usata solo per calibrazione e debug:
'
    Dim t#, J&, L&, KCal!, Freq1#, Freq2#, Y!, AmpR#
    Static FsSin#
    Static Amp1#, Ma#, Kcc#, Om1#, Om2#
    Static RumoreV#, bRumore As Boolean, bModSin As Boolean
    Static NK_Fr&, NCel_Fr&, W_Fr!(), Ac_Fr!(), Bc_Fr!()
'
    If (I = 0) Then
        ' Imposto i parametri del segnale:
        FsSin = Fs          ' Frequenza di campionamento [Hz].
        KCal = TrovaKCal(FsSin)
'
        'Amp1 = V16Max       ' Ampiezza della 1 sinusoide; ~3.7 Vi pp.
        'Amp1 = 8711         ' Ampiezza della 1 sinusoide; ~1 Vi pp.
        Amp1 = 1 / KCal     ' Ampiezza della 1 sinusoide; 2 Vi pp.
        Kcc = 0#            ' Componente continua.
'
        Freq1 = 2000#       ' Frequenza della 1 sinusoide (portante) [Hz].
        Freq2 = 100#        ' Frequenza della 2 sinusoide (modulante) [Hz].
'
        Om1 = PI2 * Freq1
        Om2 = PI2 * Freq2
'
        Ma = 0.5            ' Indice di modulazione.
        bModSin = True      ' Flag di modulazione sinusoidale (o casuale).
'
        'bRumore = True      ' Flag di rumore additivo abilitato.
        RumoreV = Amp1 / 1  ' Componente di rumore.
'
        ' Calcolo il filtro per la modulazione casuale:
        SintesiIIR_BT "Low Pass -> Low Pass", "Chebyshev", _
                      0.2, 0.25, -20#, 1#, Freq2 / FsSin
'
        ' Copia locale dei parametri del filtro:
        LeggiCoefficienti_IIR NK_Fr, NCel_Fr, W_Fr(), Ac_Fr(), Bc_Fr()
    End If
'
    t = I / FsSin
'
    If bModSin Then
        ' Modulazione sinusoidale:
        Seno_AM = Amp1 * (1 + Ma * Cos(Om2 * t)) * Cos(Om1 * t) + Kcc
'
    Else
        ' Modulazione casuale:
        Y = RandU(-10, 10)
'
        ' Filtro IIR il segnale casuale modulante:
        For J = 1 To NCel_Fr
            W_Fr(0, J) = Y
            Y = 0!
            For L = NK_Fr To 1 Step -1
                W_Fr(0, J) = W_Fr(0, J) - Bc_Fr(L, J) * W_Fr(L, J)
                Y = Y + Ac_Fr(L, J) * W_Fr(L, J)
                W_Fr(L, J) = W_Fr(L - 1, J)
            Next L
            Y = Y + Ac_Fr(0, J) * W_Fr(0, J)
        Next J
'
        Seno_AM = Amp1 * (1 + Ma * Y) * Cos(Om1 * t) + Kcc
    End If
'
    If bRumore Then
        ' Aggiungo il rumore:
        AmpR = RandU(CSng(-RumoreV), CSng(RumoreV))  ' Rumore uniforme.
        'AmpR = RandN(0!, CSng(RumoreV))              ' Rumore Gaussiano.
        Seno_AM = Seno_AM + AmpR
    End If
'
    ' Limito il valore alla capacita'
    ' del tipo Integer:
    If (Seno_AM < V16Min) Then Seno_AM = V16Min
    If (V16Max < Seno_AM) Then Seno_AM = V16Max
'
    I = I + 1
'
'
'
End Function
Public Function SigRand_BF(ByRef I As Long) As Double
'
'   Ritorna i valori corrispondenti ad un
'   segnale ad ampiezza casuale e filtrato
'   passa-basso.
'   Usata solo per calibrazione e debug:
'
    Dim J&, L&, KCal!, Freq1#, Y!
    Static FsSin#, Amp1#, Kcc#
    Static NK_Fr&, NCel_Fr&, W_Fr!(), Ac_Fr!(), Bc_Fr!()
'
    If (I = 0) Then
        ' Imposto i parametri del segnale:
        FsSin = Fs          ' Frequenza di campionamento [Hz].
        KCal = TrovaKCal(FsSin)
'
        Amp1 = 10 / KCal    ' Ampiezza massima del segnale.
        Kcc = 0#            ' Componente continua.
'
        Freq1 = 100#        ' Frequenza di taglio [Hz].
'
        ' Calcolo il filtro passa-basso:
        SintesiIIR_BT "Low Pass -> Low Pass", "Chebyshev", _
                      0.2, 0.25, -20#, 1#, Freq1 / FsSin
'
        ' Copia locale dei parametri del filtro:
        LeggiCoefficienti_IIR NK_Fr, NCel_Fr, W_Fr(), Ac_Fr(), Bc_Fr()
    End If
'
    ' Segnale casuale:
    Y = RandU(-Amp1, Amp1)
'
    ' Filtro IIR il segnale casuale:
    For J = 1 To NCel_Fr
        W_Fr(0, J) = Y
        Y = 0!
        For L = NK_Fr To 1 Step -1
            W_Fr(0, J) = W_Fr(0, J) - Bc_Fr(L, J) * W_Fr(L, J)
            Y = Y + Ac_Fr(L, J) * W_Fr(L, J)
            W_Fr(L, J) = W_Fr(L - 1, J)
        Next L
        Y = Y + Ac_Fr(0, J) * W_Fr(0, J)
    Next J
'
    SigRand_BF = Y
'
    ' Limito il valore alla capacita'
    ' del tipo Integer:
    If (SigRand_BF < V16Min) Then SigRand_BF = V16Min
    If (V16Max < SigRand_BF) Then SigRand_BF = V16Max
'
    I = I + 1
'
'
'
End Function
Public Function Seno_FM(ByRef I As Long) As Double
'
'   Ritorna i valori corrispondenti ad un
'   segnale sinusoidale campionato a 1/Fs [s]
'   e modulato in frequenza.
'   Usata solo per calibrazione e debug:
'
    Dim t#, J&, L&, KCal!, Freq1#, Freq2#, Y!, AmpR#
    Static FsSin#
    Static Amp1#, Mf#, Kcc#, Om1#, Om2#
    Static RumoreV#, bRumore As Boolean, bModSin As Boolean
    Static NK_Fr&, NCel_Fr&, W_Fr!(), Ac_Fr!(), Bc_Fr!()
'
    If (I = 0) Then
        ' Imposto i parametri del segnale:
        FsSin = Fs          ' Frequenza di campionamento [Hz].
        KCal = TrovaKCal(FsSin)
'
        'Amp1 = V16Max       ' Ampiezza della 1 sinusoide; ~3.7 Vi pp.
        'Amp1 = 8711         ' Ampiezza della 1 sinusoide; ~1 Vi pp.
        Amp1 = 1 / KCal     ' Ampiezza della 1 sinusoide; 2 Vi pp.
        Kcc = 0#            ' Componente continua.
'
        Freq1 = 2000#       ' Frequenza della 1 sinusoide (portante) [Hz].
        Freq2 = 100#        ' Frequenza della 2 sinusoide (modulante) [Hz].
'
        Om1 = PI2 * Freq1
        Om2 = PI2 * Freq2
'
        Mf = 1              ' Indice di modulazione.
        bModSin = False      ' Flag di modulazione sinusoidale (o casuale).
'
        'bRumore = True      ' Flag di rumore additivo abilitato.
        RumoreV = Amp1 / 5  ' Componente di rumore.
'
        ' Calcolo il filtro per la modulazione casuale:
        SintesiIIR_BT "Low Pass -> Low Pass", "Chebyshev", _
                      0.2, 0.25, -20#, 1#, Freq2 / FsSin
'
        ' Copia locale dei parametri del filtro:
        LeggiCoefficienti_IIR NK_Fr, NCel_Fr, W_Fr(), Ac_Fr(), Bc_Fr()
    End If
'
    t = I / FsSin
'
    If bModSin Then
        ' Modulazione sinusoidale:
        Seno_FM = Amp1 * Cos(Om1 * t + Mf * Cos(Om2 * t)) + Kcc
'
    Else
        ' Modulazione casuale:
        Y = RandU(-10, 10)
'
        ' Filtro IIR il segnale casuale modulante:
        For J = 1 To NCel_Fr
            W_Fr(0, J) = Y
            Y = 0!
            For L = NK_Fr To 1 Step -1
                W_Fr(0, J) = W_Fr(0, J) - Bc_Fr(L, J) * W_Fr(L, J)
                Y = Y + Ac_Fr(L, J) * W_Fr(L, J)
                W_Fr(L, J) = W_Fr(L - 1, J)
            Next L
            Y = Y + Ac_Fr(0, J) * W_Fr(0, J)
        Next J
'
        Seno_FM = Amp1 * Cos(Om1 * t + Mf * Y) + Kcc
    End If
'
    If bRumore Then
        ' Aggiungo il rumore:
        AmpR = RandU(CSng(-RumoreV), CSng(RumoreV))  ' Rumore uniforme.
        'AmpR = RandN(0!, CSng(RumoreV))              ' Rumore Gaussiano.
        Seno_FM = Seno_FM + AmpR
    End If
'
    ' Limito il valore alla capacita'
    ' del tipo Integer:
    If (Seno_FM < V16Min) Then Seno_FM = V16Min
    If (V16Max < Seno_FM) Then Seno_FM = V16Max
'
    I = I + 1
'
'
'
End Function
Public Function Seno_SW(ByRef I As Long) As Double
'
'   Ritorna i valori corrispondenti ad un
'   segnale sinusoidale campionato a 1/Fs [s]
'   e spazzolato linearmente in frequenza.
'   Usata solo per calibrazione e debug:
'
    Dim IP&, t#, KCal!, AmpR#, Om#, OmF#, OmD#, FreqI#, FreqF#
    Static Amp1#, Kcc#
    Static NsRepPer&, OmI#, OmF_OmI#
    Static RumoreV#, bRumore As Boolean
'
    If (I = 0) Then
        ' Imposto i parametri del segnale:
        KCal = TrovaKCal(CDbl(Fs))
'
        'Amp1 = V16Max       ' Ampiezza della sinusoide; ~3.7 Vi pp.
        'Amp1 = 8711         ' Ampiezza della sinusoide; ~1 Vi pp.
        Amp1 = 1 / KCal     ' Ampiezza della sinusoide; 2 Vi pp.
        Kcc = 0#            ' Componente continua.
'
        'NsRepPer = 2 * Fs   ' Periodo di spazzolamento; 2 s.
        NsRepPer = 2 ^ CLng(Ceil(Log(2 * Fs) / Log2))
'
        FreqI = 1000#       ' Frequenza iniziale della sinusoide [Hz].
        FreqF = 2000#       ' Frequenza finale della sinusoide [Hz].
        OmI = PI2 * FreqI / Fs
        OmF = PI2 * FreqF / Fs
        OmD = (OmF - OmI)
        OmF_OmI = OmD / (2# * (NsRepPer - 1))
'
        'bRumore = True      ' Flag di rumore additivo abilitato.
        RumoreV = Amp1 / 5  ' Componente di rumore.
    End If
'
    ' Spazzolamento di frequenza:
    IP = I Mod NsRepPer
    Om = (OmI + OmF_OmI * IP) * IP
'
    Seno_SW = Amp1 * Sin(Om) + Kcc
'
    If bRumore Then
        ' Aggiungo il rumore:
        AmpR = RandU(CSng(-RumoreV), CSng(RumoreV))  ' Rumore uniforme.
        'AmpR = RandN(0!, CSng(RumoreV))              ' Rumore Gaussiano.
        Seno_SW = Seno_SW + AmpR
    End If
'
    ' Limito il valore alla capacita'
    ' del tipo Integer:
    If (Seno_SW < V16Min) Then Seno_SW = V16Min
    If (V16Max < Seno_SW) Then Seno_SW = V16Max
'
    I = I + 1
'
'
'
End Function
Public Function Impulso(ByRef I As Long) As Double
'
'   Ritorna i valori corrispondenti ad un impulso
'   che si ripete ogni Tint [s] (ImpNC campioni).
'   Usata solo per calibrazione e debug:
'
    Dim KCal!, Tint#
    Static ImpNC&, Amp1#
'
    If (I = 0) Then
        KCal = TrovaKCal(CDbl(Fs))
'
        Tint = 0.5          ' Intervallo fra gli impulsi [s].
        ImpNC = Tint * Fs   ' Intervallo fra gli impulsi [campioni].
        Amp1 = 1# / KCal    ' Ampiezza dell' impulso [DigVal].
    End If
'
    If ((I Mod ImpNC) = 0) Then
        Impulso = Amp1
    Else
        Impulso = 0#
    End If
'
    I = I + 1
'
'
'
End Function
Public Function Seno1(ByRef I As Long) As Double
'
'   Ritorna i valori corrispondenti ad un
'   segnale sinusoidale campionato a 1 / Fs [s].
'   Usata solo per calibrazione e debug:
'
    Dim t#, Fs0&, KCal!, AmpR#, Freq1#, Freq2#
    Static FsSin#
    Static Kcc#, Amp1#, Amp2#, Om1#, Om2#, RumoreV#, Fase#
    Static bRumore As Boolean, bSomma As Boolean
'
    If (I = 0) Then
        ' Imposto i parametri del segnale:
        FsSin = Fs      ' Frequenza di campionamento [Hz].
        KCal = TrovaKCal(FsSin)
'
        ' Componente continua:
        'Kcc = 1 / KCal  ' [DigVal].
'
        ' 1 sinusoide:
        Amp1 = 1 / KCal             ' Ampiezza [DigVal].
        'Amp1 = Sqr2 * 0.7746 / KCal ' Ampiezza [DigVal].
        'Amp1 = Sqr2 * 0.975 / KCal  ' Ampiezza [DigVal].
        'Amp1 = Sqr2 / KCal          ' Ampiezza [DigVal].
        Freq1 = 5#               ' Frequenza [Hz].
'
        ' 2 sinusoide:
        'Amp2 = 1 / KCal             ' Ampiezza [DigVal].
        'Freq2 = Fs / 2              ' Frequenza [Hz].
        Freq2 = 1500#               ' Frequenza [Hz].
'
        Om1 = PI2 * Freq1
        Om2 = PI2 * Freq2
'
        'bRumore = True      ' Flag di rumore additivo abilitato.
        RumoreV = Amp1 / 2  ' Componente di rumore.
'
        Fase = PI_2         ' Fase iniziale delle sinusoidi [rad].
'
        bSomma = True      ' Flag di somma/prodotto delle due sinusoidi.
'
        ' Solo per avere frequenze coincidenti con quelle calcolate.
        ' Trovo la riga di spettro piu'
        ' vicina alla frequenza Freq1:
'        Fs0 = MIN0(CLng(Freq1 / FRis), NFRQ)
'        ' ... e ne ricalcolo la frequenza:
'        Freq1 = DMAX1(FMin, CDbl(Fs0) * FRis)
'        ' Faccio lo stesso con Freq2:
'        Fs0 = MIN0(CLng(Freq2 / FRis), NFRQ)
'        ' ... e ne ricalcolo la frequenza:
'        Freq2 = DMAX1(FMin, CDbl(Fs0) * FRis)
    End If
'
    t = I / FsSin
'
    If bSomma Then
        Seno1 = Amp1 * Sin(Om1 * t + Fase)
        Seno1 = Seno1 + Amp2 * Sin(Om2 * t + Fase)
    Else
        Seno1 = Amp1 * Sin(Om1 * t + Fase)
        Seno1 = Seno1 * Amp2 * Sin(Om2 * t + Fase)
    End If
    Seno1 = Seno1 + Kcc
'
    If bRumore Then
        ' Aggiungo il rumore:
        AmpR = RandU(CSng(-RumoreV), CSng(RumoreV))  ' Rumore uniforme.
        'AmpR = RandN(0!, CSng(RumoreV))              ' Rumore Gaussiano.
        Seno1 = Seno1 + AmpR
    End If
'
    ' Limito il valore alla capacita'
    ' del tipo Integer:
    If (Seno1 < V16Min) Then Seno1 = V16Min
    If (V16Max < Seno1) Then Seno1 = V16Max
'
    I = I + 1
'
'
'
End Function
Public Function Seno2(ByRef I As Long) As Double
'
'   Ritorna i valori corrispondenti ad un
'   segnale sinusoidale campionato a 1/Fs [s].
'   Usata solo per calibrazione e debug:
'
    Dim t#, AmpR#, Freq1#, Freq2#
    Static FsSin#, KCal!
    Static Amp1#, Amp2#, Om1#, Om2#, Fase#, Kcc#
    Static RumoreV#, bRumore As Boolean
'
    If (I = 0) Then
        ' Imposto i parametri del segnale:
        FsSin = Fs      ' Frequenza di campionamento [Hz].
        KCal = TrovaKCal(FsSin)
'
        ' 1 sinusoide:
        'Amp1 = V16Max       ' Ampiezza della 1 sinusoide; ~3.7 Vi pp.
        'Amp1 = 8711         ' Ampiezza della 1 sinusoide; ~1 Vi pp.
        Amp1 = 1 / KCal     ' Ampiezza della 1 sinusoide; 2 Vi pp.
        Freq1 = 1000#       ' Frequenza della 1 sinusoide [Hz].
'
        ' 2 sinusoide:
        Amp2 = 8711         ' Ampiezza della 2 sinusoide.
        Freq2 = 1100#       ' Frequenza della 2 sinusoide [Hz].
'
        Fase = 0#           ' Fase iniziale delle sinusoidi.
        Kcc = 0#            ' Componente continua.
'
        bRumore = False      ' Flag di rumore additivo abilitato.
        RumoreV = 1 / KCal  ' Componente di rumore.
'
        Om1 = PI2 * Freq1
        Om2 = PI2 * Freq2
    End If
'
    t = I / FsSin
    Seno2 = Amp1 * Sin(Om1 * t + Fase) + Kcc
    'Seno2 = Seno2 + Amp2 * Sin(Om2 * T + Fase)
'
    ' Eventuali trasformazioni:
    'Seno2 = Sgn(Seno2) / KCal ' Onda quadra, ampiezza = 2 Vi pp.
    'Seno2 = Abs(Seno2)
'    If (Seno2 < 0) Then
'        Seno2 = -1000 * Log(1 - Seno2)
'    ElseIf (0 < Seno2) Then
'        Seno2 = 1000 * Log(1 + Seno2)
'    Else
'        Seno2 = 0
'    End If
'
    If bRumore Then
        ' Aggiungo il rumore:
        AmpR = RandU(CSng(-RumoreV), CSng(RumoreV))  ' Rumore uniforme.
        'AmpR = RandN(0!, CSng(RumoreV))              ' Rumore Gaussiano.
        Seno2 = Seno2 + AmpR
    End If
'
    ' Limito il valore alla capacita'
    ' del tipo Integer:
    If (Seno2 < V16Min) Then Seno2 = V16Min
    If (V16Max < Seno2) Then Seno2 = V16Max
'
    I = I + 1
'
'
'
End Function
Public Sub Ruota(ByVal X0 As Double, ByVal Y0 As Double, ByVal Rot As Double, _
    ByVal CRx As Double, ByVal CRy As Double, _
    ByRef Xr As Double, ByRef Yr As Double)
'
'   Routine per la rotazione di un punto:
'
'   X0, Y0:     coordinate del punto da ruotare.
'   Rot:        rotazione del punto in [rad].
'   CRx, CRy:   coordinate del centro di rotazione.
'   Xr, Yr:     coordinate finali del punto ruotato.
'
    ' Rotazione:
    Xr = (X0 - CRx) * Cos(Rot) - (Y0 - CRy) * Sin(Rot) + CRx
    Yr = (X0 - CRx) * Sin(Rot) + (Y0 - CRy) * Cos(Rot) + CRy
'
'
'
End Sub
Public Function MODULO(AA As Double, PP As Double) As Double
'
'   Implementa la funzione MODULO(a, p) del FORTRAN:
'
    MODULO = AA - Int(AA / PP) * PP
'
'
'
End Function
Public Function ResMouseAreaPB(Optional ByVal picB As PictureBox = Nothing, _
    Optional ByVal X1 As Single, Optional ByVal Y1 As Single, _
    Optional ByVal X2 As Single, Optional ByVal Y2 As Single) As Long
'
'   Restringe l' area d' azione del puntatore del Mouse, nel PictureBox picB,
'   al rettangolo con vertici X1, Y1, e X2, Y2.  Le coordinate sono relative a
'   picB ed in unita' picB.ScaleMode; la chiamata senza argomenti libera il Mouse.
'   Prima di chiamare questa routine, per restringere l' area d' azione del Mouse,
'   accertarsi che il picB abbia preso il "Focus", eventualmente con:
'    picB.SetFocus
'    DoEvents
'
'   Rev. 08/09/2006.
'
    Dim Point1 As POINTAPI, Point2 As POINTAPI
    Dim RisArea As RECT
'
    If (picB Is Nothing) Then
        ' Libero il Mouse:
        ResMouseAreaPB = ClipCursorClear(0)
'
    Else
        ' Converto le coordinate in Pixels:
        Point1.X = picB.ScaleX(X1 - picB.ScaleLeft, picB.ScaleMode, vbPixels)
        Point1.Y = picB.ScaleY(Y1 - picB.ScaleTop, picB.ScaleMode, vbPixels)
        Point2.X = picB.ScaleX(X2 - picB.ScaleLeft, picB.ScaleMode, vbPixels)
        Point2.Y = picB.ScaleY(Y2 - picB.ScaleTop, picB.ScaleMode, vbPixels)
'
        ' Sistemo, nell' ordine richiesto, i vertici
        ' del rettangolo di escursione permessa:
        If (Point2.X < Point1.X) Then ISWAP Point2.X, Point1.X
        If (Point2.Y < Point1.Y) Then ISWAP Point2.Y, Point1.Y
'
        ' Converto le coordinate da riferimento PicB
        ' a riferimento Screen:
        ClientToScreen picB.hWnd, Point1
        ClientToScreen picB.hWnd, Point2
'
        RisArea.Left = Point1.X
        RisArea.Top = Point1.Y
        RisArea.Right = Point2.X
        RisArea.Bottom = Point2.Y
        ResMouseAreaPB = ClipCursorRect(RisArea)
    End If
'
'
'
End Function
Public Function CreaRegioneRett(ByVal picB As PictureBox, _
    ByVal X1 As Single, ByVal Y1 As Single, _
    ByVal X2 As Single, ByVal Y2 As Single) As Long
'
'   Ritorna l' Handle di una Region rettangolare, nel PictureBox PicB,
'   con vertici X1, Y1, e X2, Y2.
'   Le coordinate sono relative a PicB ed in unita' PicB.ScaleMode.
'
'   Vers. 02/02/2008.
'
    Dim PxX1&, PxY1&, PxX2&, PxY2&
'
    ' Converto le coordinate in Pixels:
    PxX1 = picB.ScaleX(X1 - picB.ScaleLeft, picB.ScaleMode, vbPixels)
    PxY1 = picB.ScaleY(Y1 - picB.ScaleTop, picB.ScaleMode, vbPixels)
    PxX2 = picB.ScaleX(X2 - picB.ScaleLeft, picB.ScaleMode, vbPixels)
    PxY2 = picB.ScaleY(Y2 - picB.ScaleTop, picB.ScaleMode, vbPixels)
'
    ' Sistemo, nell' ordine richiesto,
    ' i vertici del rettangolo:
    If (PxX2 < PxX1) Then ISWAP PxX2, PxX1
    If (PxY2 < PxY1) Then ISWAP PxY2, PxY1
'
    CreaRegioneRett = CreateRectRgn(PxX1, PxY1, PxX2, PxY2)
'
'
'
End Function
Public Function CreaRettangolo(ByVal picB As PictureBox, _
    ByVal X1 As Single, ByVal Y1 As Single, _
    ByVal X2 As Single, ByVal Y2 As Single) As RECT
'
'   Ritorna il rettangolo, nel PictureBox PicB, con vertici X1, Y1, e X2, Y2.
'   Le coordinate sono relative a PicB ed in unita' PicB.ScaleMode.
'
'   Vers. 09/02/2008.
'
    Dim PxX1&, PxY1&, PxX2&, PxY2&
'
    ' Converto le coordinate in Pixels:
    PxX1 = picB.ScaleX(X1 - picB.ScaleLeft, picB.ScaleMode, vbPixels)
    PxY1 = picB.ScaleY(Y1 - picB.ScaleTop, picB.ScaleMode, vbPixels)
    PxX2 = picB.ScaleX(X2 - picB.ScaleLeft, picB.ScaleMode, vbPixels)
    PxY2 = picB.ScaleY(Y2 - picB.ScaleTop, picB.ScaleMode, vbPixels)
'
    ' Sistemo, nell' ordine richiesto,
    ' i vertici del rettangolo:
    If (PxX2 < PxX1) Then ISWAP PxX2, PxX1
    If (PxY2 < PxY1) Then ISWAP PxY2, PxY1
'
    CreaRettangolo.Left = PxX1
    CreaRettangolo.Top = PxY1
    CreaRettangolo.Right = PxX2
    CreaRettangolo.Bottom = PxY2
'
'
'
End Function
Public Function CreaRegioneCirc(ByVal picB As PictureBox, _
    ByVal X1 As Single, ByVal Y1 As Single, ByVal Raggio As Long) As Long
'
'   Ritorna l' Handle di una Region circolare, nel PictureBox PicB,
'   con centro X1, Y1 e raggio Raggio.
'   Le coordinate del centro sono relative a PicB ed in unita' PicB.ScaleMode;
'   la dimensione del raggio e' in Pixels.
'
'   Vers. 03/02/2008.
'
    Dim PxX1&, PxY1&
'
    ' Converto le coordinate del centro in Pixels:
    PxX1 = picB.ScaleX(X1 - picB.ScaleLeft, picB.ScaleMode, vbPixels)
    PxY1 = picB.ScaleY(Y1 - picB.ScaleTop, picB.ScaleMode, vbPixels)
'
    CreaRegioneCirc = CreateEllipticRgn(PxX1 - Raggio, PxY1 - Raggio, _
                                        PxX1 + Raggio, PxY1 + Raggio)
'
'
'
End Function
Public Function CreaRegionePoli(picB As PictureBox, _
    ParamArray PoliVert() As Variant) As Long
'
'   Ritorna l' Handle di una Region poligonale, nel PictureBox PicB, con vertici:
'    X1 = PoliVert(J1), Y1 = PoliVert(J1 + 1)
'    .. = ............, .....................
'    Xn = PoliVert(J2 - 1), Yn = PoliVert(J2).
'
'   Le coordinate dei vertici sono relative a PicB ed in unita' PicB.ScaleMode.
'
'   Vers. 03/02/2008.
'
    Dim J&, J1&, J2&, Nv&
    Dim PoliV() As POINTAPI
'
    J1 = LBound(PoliVert)
    J2 = UBound(PoliVert)
    ReDim PoliV(1 To (J2 - J1 + 1) / 2)
'
    Nv = 0
    For J = J1 To J2 - 1 Step 2
        Nv = Nv + 1
'
        ' Converto le coordinate dei vertici in Pixels:
        PoliV(Nv).X = picB.ScaleX(PoliVert(J) - picB.ScaleLeft, picB.ScaleMode, vbPixels)
        PoliV(Nv).Y = picB.ScaleY(PoliVert(J + 1) - picB.ScaleTop, picB.ScaleMode, vbPixels)
    Next J
'
    CreaRegionePoli = CreatePolygonRgn(PoliV(1), Nv, ALTERNATE)
'
'
'
End Function
Public Function LinTrasf(ByVal X As Double, _
    ByVal X1 As Double, ByVal Y1 As Double, _
    ByVal X2 As Double, ByVal Y2 As Double) As Double
'
'   Trasformazione lineare:
'    Y  = A * X  + B
'   con:
'    Y1 = A * X1 + B
'    Y2 = A * X2 + B
'
'   La funzione ritorna il valore Y:
'
    LinTrasf = ((Y2 - Y1) * X + (X2 * Y1 - X1 * Y2)) / (X2 - X1)
'
'
'
End Function
Public Sub RGB_R_G_B(ByVal RGB_I As Long, _
    ByRef rc As Long, ByRef Gc As Long, ByRef Bc As Long)
'
'   Scompone il colore RGB_I nelle sue componenti:
'
    rc = RGB_I And &HFF             ' Rosso.
    Gc = (RGB_I \ &H100) And &HFF   ' Verde.
    Bc = (RGB_I \ &H10000) And &HFF ' Blu.
'
'
'
End Sub
Public Function GetIniString(ByVal FileINI$, ByVal Section$, ByVal Key$, _
    Optional ByVal DefaultString$) As String
'
'
    Dim BUF$, e&
    Const LBF& = 255
'
    On Error GoTo GetIniString_ERR
'
    BUF$ = Space$(LBF)
'
    e = GetPrivateProfileString(Section$, Key$, DefaultString$, BUF$, LBF, FileINI$)
    GetIniString = Left$(BUF$, e)
'
'
GetIniString_ERR:
    If (Err.Number <> 0) Then
        Dim M$
        M$ = "Sezione [" & Section$ & "] nel File " & FileINI$ & vbNewLine
        M$ = M$ & "non esistente o di formato non valido." & vbNewLine
        M$ = M$ & vbNewLine & vbNewLine
        M$ = M$ & "Errore " & Str$(Err.Number) & vbNewLine
        M$ = M$ & Err.Description
        MsgBox M$, vbCritical, " modUtilita: GetIniString"
'
        GetIniString = ""
    End If
'
'
'
End Function
Public Sub LeggiFilesRecentiINI(ByVal FileINI$, ByVal Sezione$, _
    ByVal mnuRecenti As Object, Optional ByVal MAXFIL As Long = 5, _
    Optional ByVal bVerificaFE As Boolean = True)
'
'   Legge i files recenti dal file FileINI$ e li aggiunge al menu mnuRecenti().
'   Se bVerificaFE = True verifica anche l' esistenza dei files da aggiungere:
'
    Dim I&, FileRec$
'
    For I = MAXFIL To 1 Step -1
        FileRec$ = GetIniString(FileINI$, Sezione$, Str$(I), "")
        If (FileRec$ <> "") Then
            If bVerificaFE Then
                If FileExists(FileRec$) Then AggiornaFilesRecenti mnuRecenti, FileRec$
            Else
                AggiornaFilesRecenti mnuRecenti, FileRec$
            End If
        End If
    Next I
'
'
'
End Sub
Public Sub LeggiPosizioneFormINI(ByVal FileINI$, ByVal frmF As Form, _
    ByRef frmF_Left As Long, ByRef frmF_Top As Long, _
    Optional ByRef frmF_Width As Long, Optional ByRef frmF_Height As Long, _
    Optional ByVal bFullScreen As Boolean = False)
'
'   Legge la posizione iniziale [e le dimensioni] del Form frmF memorizzate
'   sul file FileINI$.  bFullScreen, se True, indica che per default il Form
'   deve essere posizionato e dimensionato a pieno schermo.
'
'   Da usare nell' evento frmF_Load:
'
    If FileExists(FileINI$) Then
        frmF_Left = GetIniString(FileINI$, "Posizione Forms:", _
                                 frmF.Name & "_Left", _
                                 IIf(bFullScreen, 0, RandU(5, 4500)))
        frmF_Top = GetIniString(FileINI$, "Posizione Forms:", _
                                 frmF.Name & "_Top", _
                                 IIf(bFullScreen, 0, RandU(5, 4500)))
'
        frmF_Width = GetIniString(FileINI$, "Posizione Forms:", _
                                  frmF.Name & "_Width", _
                                  IIf(bFullScreen, Screen.Width, frmF.Width))
        frmF_Height = GetIniString(FileINI$, "Posizione Forms:", _
                                   frmF.Name & "_Height", _
                                   IIf(bFullScreen, Screen.Height, frmF.Height))
    Else
        frmF_Left = IIf(bFullScreen, 0, RandU(5, 4500))
        frmF_Top = IIf(bFullScreen, 0, RandU(5, 4500))
'
        frmF_Width = IIf(bFullScreen, Screen.Width, frmF.Width)
        frmF_Height = IIf(bFullScreen, Screen.Height, frmF.Height)
    End If
'
    If ((Screen.Width - 4) < frmF_Width) Then frmF_Width = Screen.Width - 4
    If ((Screen.Height - 4) < frmF_Height) Then frmF_Height = Screen.Height - 4
'
'
'
End Sub
Public Function TabellaColori_3(ByVal ITC As Long, Optional ByRef NCol As Long) As Long()
'
'   Ritorna un vettore contenente NCol colori in formato RGB
'   con dimensione (0 To NCol - 1).
'   ITC:    tabella richiesta:
'           1 = due colori, grigio e bianco.
'           2 = 256 toni di grigio, dal nero al bianco.
'           3 = 16 colori, dal blu al rosso.
'           4 = 256 colori, dal blu al rosso.
'           5 = 1280 colori, dal viola al rosso.
'           6 = 1792 colori, dal nero al bianco.
'
    Dim C&, C1&, C2&
    Dim r&, g&, B&, TCol&()
'
    Select Case ITC
    Case 1
        ' Prepara la tabella a 2 colori:
        NCol = 2
        ReDim TCol(0 To NCol - 1) As Long ' Tabella dei colori.
'
        TCol(0) = &H808080 ' Grigio.
        TCol(1) = vbWhite
'
    Case 2
        ' Prepara la tabella a 256 toni di grigio:
        NCol = 256
        ReDim TCol(0 To NCol - 1) As Long ' Tabella dei colori.
'
        For C = 0 To 255
            TCol(C) = RGB(C, C, C)
        Next C
'
    Case 3
        ' Prepara la tabella a 16 colori:
        NCol = 16
        ReDim TCol(0 To NCol - 1) As Long ' Tabella dei colori.
'
        For C = 0 To 15
            r = 255 * (Sqr(C) / Sqr(15))
            If (C < 8) Then
                g = CLng(255 * (Sqr(C) / Sqr(7)))
            Else
                g = CLng(255 * (Sqr(15 - C) / Sqr(7)))
            End If
            B = 255 * (1! - Sqr(C) / Sqr(15))
'
            TCol(C) = RGB(r, g, B)
        Next C
'
    Case 4
        ' Prepara la tabella a 256 colori:
        NCol = 256
        ReDim TCol(0 To NCol - 1) As Long ' Tabella dei colori.
'
        For C = 0 To 255
            r = 255 * (Sqr(C) / Sqr(255))
            If (C < 128) Then
                g = CLng(255 * (Sqr(C) / Sqr(127)))
            Else
                g = CLng(255 * (Sqr(255 - C) / Sqr(127)))
            End If
            B = 255 * (1! - Sqr(C) / Sqr(255))
'
            TCol(C) = RGB(r, g, B)
        Next C
'
    Case 5
        ' Prepara la tabella a 1280 colori:
        NCol = 1280
        ReDim TCol(0 To NCol - 1) As Long ' Tabella dei colori.
'
        C = 0
        For C1 = 0 To 4
            For C2 = 0 To 255
                r = Switch(C1 = 0, 255 - C2, _
                           C1 = 1, 0, _
                           C1 = 2, 0, _
                           C1 = 3, C2, _
                           C1 = 4, 255)
                g = Switch(C1 = 0, 0, _
                           C1 = 1, C2, _
                           C1 = 2, 255, _
                           C1 = 3, 255, _
                           C1 = 4, 255 - C2)
                B = Switch(C1 = 0, 255, _
                           C1 = 1, 255, _
                           C1 = 2, 255 - C2, _
                           C1 = 3, 0, _
                           C1 = 4, 0)
'
                TCol(C) = RGB(r, g, B)
                C = C + 1
            Next C2
        Next C1
'
    Case 6
        ' Prepara la tabella a 1792 colori:
        NCol = 1792
        ReDim TCol(0 To NCol - 1) As Long ' Tabella dei colori.
'
        C = 0
        For C1 = 0 To 6
            For C2 = 0 To 255
                r = Switch(C1 = 0, 0, _
                           C1 = 1, 0, _
                           C1 = 2, 0, _
                           C1 = 3, C2, _
                           C1 = 4, 255, _
                           C1 = 5, 255, _
                           C1 = 6, 255)
                g = Switch(C1 = 0, C2, _
                           C1 = 1, 255, _
                           C1 = 2, 255 - C2, _
                           C1 = 3, 0, _
                           C1 = 4, 0, _
                           C1 = 5, C2, _
                           C1 = 6, 255)
                B = Switch(C1 = 0, 0, _
                           C1 = 1, C2, _
                           C1 = 2, 255, _
                           C1 = 3, 255, _
                           C1 = 4, 255 - C2, _
                           C1 = 5, 0, _
                           C1 = 6, C2)
'
                TCol(C) = RGB(r, g, B)
                C = C + 1
            Next C2
        Next C1
    End Select
'
    TabellaColori_3 = TCol()
'
'
'
End Function
Public Function TabellaColori_2(ByVal ITC As Long, Optional ByRef NCol As Long) As Long()
'
'   Ritorna un vettore contenente NCol colori in formato RGB
'   con dimensione (0 To NCol - 1).
'   ITC:    tabella richiesta:
'           1 = due colori, bianco e grigio.
'           2 = 256 toni di grigio, dal nero al bianco.
'           3 = 16 colori, dal blu al rosso.
'           4 = 256 colori, dal blu al rosso.
'           5 = 1280 colori, dal viola al rosso.
'           6 = 1792 colori, dal nero al bianco.
'
    Dim C&, C1&, C2&
    Dim r&, g&, B&, TCol&()
'
    Select Case ITC
    Case 1
        ' Prepara la tabella a 2 colori:
        NCol = 2
        ReDim TCol(0 To NCol - 1) As Long ' Tabella dei colori.
'
        TCol(0) = vbWhite
        TCol(1) = &H808080 ' Grigio.
'
    Case 2
        ' Prepara la tabella a 256 toni di grigio:
        NCol = 256
        ReDim TCol(0 To NCol - 1) As Long ' Tabella dei colori.
'
        For C = 0 To 255
            TCol(C) = RGB(C, C, C)
        Next C
'
    Case 3
        ' Prepara la tabella a 16 colori:
        NCol = 16
        ReDim TCol(0 To NCol - 1) As Long ' Tabella dei colori.
'
        For C = 0 To 15
            r = 255 * (Sqr(C) / Sqr(15))
            If (C < 8) Then
                g = CLng(255 * (Sqr(C) / Sqr(7)))
            Else
                g = CLng(255 * (Sqr(15 - C) / Sqr(7)))
            End If
            B = 255 * (1! - Sqr(C) / Sqr(15))
'
            TCol(C) = RGB(r, g, B)
        Next C
'
    Case 4
        ' Prepara la tabella a 256 colori:
        NCol = 256
        ReDim TCol(0 To NCol - 1) As Long ' Tabella dei colori.
'
        For C = 0 To 255
            r = 255 * (Sqr(C) / Sqr(255))
            If (C < 128) Then
                g = CLng(255 * (Sqr(C) / Sqr(127)))
            Else
                g = CLng(255 * (Sqr(255 - C) / Sqr(127)))
            End If
            B = 255 * (1! - Sqr(C) / Sqr(255))
'
            TCol(C) = RGB(r, g, B)
        Next C
'
    Case 5
        ' Prepara la tabella a 1280 colori:
        NCol = 1280
        ReDim TCol(0 To NCol - 1) As Long ' Tabella dei colori.
'
        C = 0
        For C1 = 0 To 4
            For C2 = 0 To 255
                r = Switch(C1 = 0, 255 - C2, _
                           C1 = 1, 0, _
                           C1 = 2, 0, _
                           C1 = 3, C2, _
                           C1 = 4, 255)
                g = Switch(C1 = 0, 0, _
                           C1 = 1, C2, _
                           C1 = 2, 255, _
                           C1 = 3, 255, _
                           C1 = 4, 255 - C2)
                B = Switch(C1 = 0, 255, _
                           C1 = 1, 255, _
                           C1 = 2, 255 - C2, _
                           C1 = 3, 0, _
                           C1 = 4, 0)
'
                TCol(C) = RGB(r, g, B)
                C = C + 1
            Next C2
        Next C1
'
    Case 6
        ' Prepara la tabella a 1792 colori:
        NCol = 1792
        ReDim TCol(0 To NCol - 1) As Long ' Tabella dei colori.
'
        C = 0
        For C1 = 0 To 6
            For C2 = 0 To 255
                r = Switch(C1 = 0, C2, _
                           C1 = 1, 255 - C2, _
                           C1 = 2, 0, _
                           C1 = 3, 0, _
                           C1 = 4, C2, _
                           C1 = 5, 255, _
                           C1 = 6, 255)
                g = Switch(C1 = 0, 0, _
                           C1 = 1, 0, _
                           C1 = 2, C2, _
                           C1 = 3, 255, _
                           C1 = 4, 255, _
                           C1 = 5, 255 - C2, _
                           C1 = 6, C2)
                B = Switch(C1 = 0, C2, _
                           C1 = 1, 255, _
                           C1 = 2, 255, _
                           C1 = 3, 255 - C2, _
                           C1 = 4, 0, _
                           C1 = 5, 0, _
                           C1 = 6, C2)
'
                TCol(C) = RGB(r, g, B)
                C = C + 1
            Next C2
        Next C1
    End Select
'
    TabellaColori_2 = TCol()
'
'
'
End Function
Public Function TabellaColori_1(ByVal ITC As Long, Optional ByRef NCol As Long) As Long()
'
'   Ritorna un vettore contenente NCol colori in formato RGB
'   con dimensione (0 To NCol - 1).
'   ITC:    tabella richiesta:
'           1 = due colori, bianco e grigio.
'           2 = 256 toni di grigio, dal nero al bianco.
'           3 = 16 colori, dal blu al rosso.
'           4 = 256 colori, dal blu al rosso.
'           5 = 1280 colori, dal viola al rosso.
'           6 = 1792 colori, dal bianco al nero.
'
    Dim C&, C1&, C2&
    Dim r&, g&, B&, TCol&()
'
    Select Case ITC
    Case 1
        ' Prepara la tabella a 2 colori:
        NCol = 2
        ReDim TCol(0 To NCol - 1) As Long ' Tabella dei colori.
'
        TCol(0) = vbWhite
        TCol(1) = &H808080 ' Grigio.
'
    Case 2
        ' Prepara la tabella a 256 toni di grigio:
        NCol = 256
        ReDim TCol(0 To NCol - 1) As Long ' Tabella dei colori.
'
        For C = 0 To 255
            TCol(C) = RGB(C, C, C)
        Next C
'
    Case 3
        ' Prepara la tabella a 16 colori:
        NCol = 16
        ReDim TCol(0 To NCol - 1) As Long ' Tabella dei colori.
'
        For C = 0 To 15
            r = 255 * (Sqr(C) / Sqr(15))
            If (C < 8) Then
                g = CLng(255 * (Sqr(C) / Sqr(7)))
            Else
                g = CLng(255 * (Sqr(15 - C) / Sqr(7)))
            End If
            B = 255 * (1! - Sqr(C) / Sqr(15))
'
            TCol(C) = RGB(r, g, B)
        Next C
'
    Case 4
        ' Prepara la tabella a 256 colori:
        NCol = 256
        ReDim TCol(0 To NCol - 1) As Long ' Tabella dei colori.
'
        For C = 0 To 255
            r = 255 * (Sqr(C) / Sqr(255))
            If (C < 128) Then
                g = CLng(255 * (Sqr(C) / Sqr(127)))
            Else
                g = CLng(255 * (Sqr(255 - C) / Sqr(127)))
            End If
            B = 255 * (1! - Sqr(C) / Sqr(255))
'
            TCol(C) = RGB(r, g, B)
        Next C
'
    Case 5
        ' Prepara la tabella a 1280 colori:
        NCol = 1280
        ReDim TCol(0 To NCol - 1) As Long ' Tabella dei colori.
'
        C = 0
        For C1 = 0 To 4
            For C2 = 0 To 255
                r = Switch(C1 = 0, 255 - C2, _
                           C1 = 1, 0, _
                           C1 = 2, 0, _
                           C1 = 3, C2, _
                           C1 = 4, 255)
                g = Switch(C1 = 0, 0, _
                           C1 = 1, C2, _
                           C1 = 2, 255, _
                           C1 = 3, 255, _
                           C1 = 4, 255 - C2)
                B = Switch(C1 = 0, 255, _
                           C1 = 1, 255, _
                           C1 = 2, 255 - C2, _
                           C1 = 3, 0, _
                           C1 = 4, 0)
'
                TCol(C) = RGB(r, g, B)
                C = C + 1
            Next C2
        Next C1
'
    Case 6
        ' Prepara la tabella a 1792 colori:
        NCol = 1792
        ReDim TCol(0 To NCol - 1) As Long ' Tabella dei colori.
'
        C = 0
        For C1 = 0 To 6
            For C2 = 0 To 255
                r = Switch(C1 = 0, 255, _
                           C1 = 1, 255 - C2, _
                           C1 = 2, 0, _
                           C1 = 3, 0, _
                           C1 = 4, C2, _
                           C1 = 5, 255, _
                           C1 = 6, 255 - C2)
                g = Switch(C1 = 0, 255 - C2, _
                           C1 = 1, 0, _
                           C1 = 2, C2, _
                           C1 = 3, 255, _
                           C1 = 4, 255, _
                           C1 = 5, 255 - C2, _
                           C1 = 6, 0)
                B = Switch(C1 = 0, 255, _
                           C1 = 1, 255, _
                           C1 = 2, 255, _
                           C1 = 3, 255 - C2, _
                           C1 = 4, 0, _
                           C1 = 5, 0, _
                           C1 = 6, 0)
'
                TCol(C) = RGB(r, g, B)
                C = C + 1
            Next C2
        Next C1
    End Select
'
    TabellaColori_1 = TCol()
'
'
'
End Function
Public Sub Stat_V(dVal() As Double, _
    Optional ByRef dVMin As Double, Optional ByRef dVMax As Double, _
    Optional ByRef dVMedio As Double, Optional ByRef dDevStd As Double, _
    Optional ByRef lNVal As Long, Optional ByRef dSVal As Double)
'
'   Calcola alcuni valori statistici dei
'   dati contenuti nel vettore dVal():
'
    Dim I&, dSValQ#, M$
'
    On Error GoTo Stat_V_ERR
'
    lNVal = UBound(dVal) - LBound(dVal) + 1
    If (lNVal < 2) Then Err.Raise 5
'
    dVMin = dVal(LBound(dVal))
    dVMax = dVal(LBound(dVal))
    dSVal = dVMin
    dSValQ = dVMin * dVMin
'
    For I = LBound(dVal) + 1 To UBound(dVal)
        If (dVal(I) < dVMin) Then dVMin = dVal(I)
        If (dVMax < dVal(I)) Then dVMax = dVal(I)
        dSVal = dSVal + dVal(I)
        dSValQ = dSValQ + dVal(I) * dVal(I)
    Next I
'
    dVMedio = dSVal / CDbl(lNVal)
    dDevStd = CDbl(lNVal) * dSValQ - dSVal * dSVal
    dDevStd = Sqr(dDevStd / (CDbl(lNVal) * (CDbl(lNVal - 1))))
'
'
Stat_V_ERR:
    If (Err.Number <> 0) Then
        M$ = "Errore " & Str$(Err.Number) & vbNewLine
        M$ = M$ & Err.Description & vbNewLine & vbNewLine
        If (lNVal < 2) Then M$ = M$ & "Il File dei dati contiene meno di 2 valori."
        MsgBox M$, vbCritical, " modUtilita: Stat_V"
    End If
'
'
'
End Sub
Public Sub Swap(ByRef vN1 As Variant, ByRef vN2 As Variant)
'
'
    Dim vTn As Variant
'
    vTn = vN1
    vN1 = vN2
    vN2 = vTn
'
'
'
End Sub
Public Function Quadro(ByVal objFoglio As Object, _
    ByVal X0 As Double, ByVal Y0 As Double, ByVal Xn As Double, ByVal Yn As Double, _
    Optional ByVal FormatVX$ = "#0.0##", Optional ByVal FormatVY$ = "#0.0##", _
    Optional ByVal bMaPrX As Boolean = False, Optional ByVal bMaPrY As Boolean = False, _
    Optional ByVal Npx As Long = 1, _
    Optional ByRef PxN_X As Single, Optional ByRef PxN_Y As Single, _
    Optional ByVal Titolo$ = "", _
    Optional ByVal UnitaX$ = "", Optional ByVal UnitaY$ = "", _
    Optional ByVal bAutoRed As Boolean = False, _
    Optional ByVal bAutoScX As Boolean = True, _
    Optional ByVal bAutoScY As Boolean = True, _
    Optional ByRef SxMin As Single, Optional ByRef SyMin As Single, _
    Optional ByRef SxMax As Single, Optional ByRef SyMax As Single, _
    Optional ByRef QxMin As Single, Optional ByRef QyMin As Single, _
    Optional ByRef QxMax As Single, Optional ByRef QyMax As Single, _
    Optional ByVal ColRif As Long = vbGreen, Optional ByVal ColFgl As Long = vbBlack, _
    Optional ByVal ColTit As Long = vbRed, _
    Optional ByVal bGriglia As Boolean = True, _
    Optional ByVal Font$ = "MS Sans Serif", _
    Optional ByRef UnitaX_x As Single, Optional ByRef UnitaX_y As Single, _
    Optional ByRef UnitaY_x As Single, Optional ByRef UnitaY_y As Single) As Boolean
'
'   Routine, di uso generale, per la scalatura di un foglio
'   adatto a rappresentare un grafico y = f(x).
'
'    Parametri in ingresso:
'     objFoglio: Form o PictureBox da scalare.
'     X0:        valore minimo di ascissa da rappresentare.
'     Y0:        valore minimo di ordinata da rappresentare.
'     Xn:        valore massimo di ascissa da rappresentare.
'                Deve essere X0 <= Xn.
'     Yn:        valore massimo di ordinata da rappresentare.
'                Deve essere Y0 <= Yn.
'     FormatVX$: stringa di formato dei valori sull' asse X.
'     FormatVY$: stringa di formato dei valori sull' asse Y.
'                Se la stringa di formato e' " ", i rispettivi
'                valori di X o Y non vengono scritti.
'     bMaPrX:    se True i ripettivi valori degli assi X e Y vengono scritti
'     bMaPrY:    (se richiesti) in formato Mantissa + Prefisso; se questi
'                flags sono usati, le rispettive stringhe di formato devono
'                seguire le regole date in Sub FormatPrf.
'     Npx:       N di Pixels di cui si vuole conoscere
'                larghezza ed altezza in [vbUser].
'     Titolo$:   titolo del grafico.
'     UnitaX$:   unita' (o titolo) dell' asse X.
'     UnitaY$:   unita' (o titolo) dell' asse Y.
'     bAutoRed:  stato di objFoglio.AutoRedraw dopo il disegno del quadro.
'     bAutoScX:  se True la spaziatura dell' asse X viene calcolata in
'                sequenza 1, 2, 2.5 e 5; se False viene usato l' intervallo
'                X0 - Xn diviso in 10 parti.
'     bAutoScY:  come bAutoScX ma per l' asse Y.
'     ColRif:    colore degli assi, dei valori e delle griglie di riferimento.
'     ColFgl:    colore di sfondo di objFoglio.
'     ColTit:    colore del titolo.
'     bGriglia:  se True viene disegnata la griglia di riferimento;
'                se False viene fatta solo la scalatura di objFoglio.
'     Font$:     Font dei valori sugli assi e del titolo.
'
'    Parametri in uscita:
'     SxMin:     valore minimo di ascissa della griglia di riferimento.
'     SyMin:     valore minimo di ordinata  "      "    "      "
'     SxMax:     valore massimo di ascissa  "      "    "      "
'     SyMax:     valore massimo di ordinata "      "    "      "
'     QxMin:     valore minimo di ascissa del quadro.
'     QyMin:     valore minimo di ordinata del quadro.
'     QxMax:     valore massimo di ascissa del quadro.
'     QyMax:     valore massimo di ordinata del quadro.
'     PxN_X:     larghezza in [vbUser] ed
'     PxN_Y:     altezza in [vbUser] di Npx Pixels.
'     UnitaX_x:  coordinate _x e _y di scrittura
'     UnitaX_y:  delle unita' di misura degli assi
'     UnitaY_x:  per poter usare, da routine chiamante,
'     UnitaY_y:  il Font desiderato (e.g. Symbol).
'
'    Funzioni esterne richieste:
'     Ceil, FormatPrf, Log10.
'
'   Rev. 26/08/2006.
'   Rev. 21/10/2006.
'   Rev. 29/04/2007.
'   Rev. 17/02/2008.
'   Rev. 05/05/2008.
'   Rev. 01/07/2008.
'   Rev. 05/01/2009.
'
    Dim I&, XI#, D_X#, rrx#, YI#, D_Y#, rry#
    Dim Txt$, TW!, TxtSx!, TxtDx!, TxtDxU!, Mantissa$, Prefisso$, nEsp&
'
    Const nEspMinY& = -12   ' Se bMaPrY = True i valori con esponente
                            ' minore di nEspMinY verranno scritti come zero.
'
    On Error GoTo Quadro_ERR
'
    ' Verifico la correttezza delle scale:
    If (Xn < X0) Then Err.Raise 1001, "Quadro", "Errore di scala X."
    If (Yn < Y0) Then Err.Raise 1001, "Quadro", "Errore di scala Y."
'
'-- Calcolo il passo di grigliatura degli assi. ----------------------------------------
'
    Dim DYMin#
    'Const ScRis& = 3                ' La risoluzione delle scale e' 10 ^ -ScRis (default).
    Const ScRis& = 9                ' La risoluzione delle scale e' 10 ^ -ScRis (per AudioCardDSP).
    Const ScMin# = 10 ^ (1 - ScRis) ' Ampiezza min. delle scale X e Y.
'
    ' Imposto una scala minima
    ' per l' asse X:
    If ((Xn - X0) < ScMin) Then
        X0 = X0 - ScMin / 2#
        Xn = Xn + ScMin / 2#
    End If
'
    If bAutoScX Then
        ' Calcolo la spaziatura dei valori scritti
        ' sull' asse X: la sequenza e' 1, 2, 2.5 e 5:
        D_X = Xn - X0
        rrx = 10# ^ Ceil(Log(D_X / 20#) / Log10)
        Do While D_X / rrx < 5#
            rrx = rrx / 2#
        Loop
        If (10# < (D_X / rrx)) Then rrx = rrx * 2#
        X0 = rrx * Int(Round(X0 / rrx, ScRis))
        Xn = rrx * Ceil(Round(Xn / rrx, ScRis))
        D_X = Xn - X0
        SxMin = X0
        SxMax = Xn
'
    Else
        D_X = Xn - X0
        rrx = D_X / 10#
        SxMin = X0
        SxMax = Xn
    End If
'
    ' Imposto una scala minima
    ' per l' asse Y:
    If (FormatVY$ <> " ") Then
        If (Format$(Y0, FormatVY$) = Format$(Yn, FormatVY$)) Then
            DYMin = 0.0001
            Do While Format$(Y0 - DYMin, FormatVY$) = Format$(Yn + DYMin, FormatVY$)
                DYMin = 2# * DYMin
            Loop
'
            Y0 = Y0 - 10# * DYMin
            Yn = Yn + 10# * DYMin
        End If
'
    Else
        If ((Yn - Y0) < ScMin) Then
            Y0 = Y0 - ScMin / 2#
            Yn = Yn + ScMin / 2#
        End If
    End If
'
    If bAutoScY Then
        ' Calcolo la spaziatura dei valori scritti
        ' sull' asse Y: la sequenza e' 1, 2, 2.5 e 5:
        D_Y = Yn - Y0
        rry = 10# ^ Ceil(Log(D_Y / 20#) / Log10)
        Do While D_Y / rry < 5#
            rry = rry / 2#
        Loop
        If (10# < (D_Y / rry)) Then rry = rry * 2#
        Y0 = rry * Int(Round(Y0 / rry, ScRis))
        Yn = rry * Ceil(Round(Yn / rry, ScRis))
        D_Y = Yn - Y0
        SyMin = Y0
        SyMax = Yn
'
    Else
        D_Y = Yn - Y0
        rry = D_Y / 10#
        SyMin = Y0
        SyMax = Yn
    End If
'
'-- Calcolo larghezza ed altezza dei margini. ------------------------------------------
'
    Dim Bl!, Br!, BB!, Bt!, BDen!
    Dim TxWs!, TxWd!, TxHt!, TxHb!
'
    ' Imposto i dati di Font dei valori
    ' degli assi:
    objFoglio.FontName = Font$
    objFoglio.FontSize = 8
    objFoglio.FontBold = False
'
    ' Annullo le scale precedenti:
    objFoglio.ScaleMode = vbPixels
'
    ' Il margine a sinistra deve essere sufficiente
    ' a contenere il valore Y piu' largo:
    If (FormatVY$ <> " ") Then
        If bMaPrY Then
            FormatPrf Y0, Mantissa$, Prefisso$, FormatVY$, nEsp
            Txt$ = Mantissa$ & "PW "
        Else
            Txt$ = Format$(Y0, FormatVY$) & "W"
        End If
        TxWs = objFoglio.TextWidth(Txt$)
'
        If bMaPrY Then
            FormatPrf Yn, Mantissa$, Prefisso$, FormatVY$
            Txt$ = Mantissa$ & "PW "
        Else
            Txt$ = Format$(Yn, FormatVY$) & "W"
        End If
        If (TxWs < objFoglio.TextWidth(Txt$)) Then
            TxWs = objFoglio.TextWidth(Txt$)
        End If
'
    Else
        TxWs = objFoglio.TextWidth("WWW")
    End If
'
    ' Il margine a destra deve essere sufficiente
    ' a contenere il valore Xn e l' etichetta UnitaX$:
    If (FormatVX$ <> " ") Then
        If bMaPrX Then
            FormatPrf Xn, Mantissa$, Prefisso$, FormatVX$
            Txt$ = Mantissa$ & " " & Prefisso$
        Else
            Txt$ = Format$(Xn, FormatVX$)
        End If
        TxWd = (objFoglio.TextWidth(Txt$) / 2!) _
             + objFoglio.TextWidth(UnitaX$ & "W")
'
    Else
        TxWd = objFoglio.TextWidth(UnitaX$ & "W")
    End If
'
    ' I margini a sinistra ed a destra sono:
    BDen = D_X / (objFoglio.ScaleWidth - TxWs - TxWd)
    Bl = TxWs * BDen
    Br = TxWd * BDen
'
    ' Il margine sotto e' 3 volte l' altezza dei valori:
    TxHb = 3! * Abs(objFoglio.TextHeight("H"))
'
    ' Il margine sopra e' 2 volte l' altezza dei valori
    ' piu' l' altezza del titolo:
    objFoglio.FontSize = 12
    TxHt = TxHb + Abs(objFoglio.TextHeight(Titolo$))
'
    ' I margini sopra e sotto sono:
    BDen = D_Y / (Abs(objFoglio.ScaleHeight) + TxHb + TxHt)
    BB = TxHb * BDen
    Bt = TxHt * BDen
'
'-- Imposto la scala e calcolo i valori comuni. ----------------------------------------
'
    ' Imposto i bordi orizzontali
    ' e verticali:
    QxMin = X0 - Bl
    QxMax = X0 + D_X + Br
    QyMin = Y0 - BB
    QyMax = Y0 + D_Y + Bt
'
    ' Imposto la scala di objFoglio:
    objFoglio.Scale (QxMin, QyMax)-(QxMax, QyMin)
'
    ' Calcolo larghezza ed altezza di Npx pixels:
    PxN_X = Abs(objFoglio.ScaleX(Npx, vbPixels, vbUser))
    PxN_Y = Abs(objFoglio.ScaleY(Npx, vbPixels, vbUser))
'
    ' Verifico se e' richiesto il
    ' disegno della griglia:
    If (Not bGriglia) Then GoTo Fine
'
'-- Disegno assi, griglie e scrivo i valori di scala. ----------------------------------
'
    Dim Po4_X!, Po4_Y!, EstAx!, EstAy!
'
    ' La griglia deve essere permanente:
    objFoglio.AutoRedraw = True
'
    objFoglio.Picture = LoadPicture()
    objFoglio.BackColor = ColFgl
'
    ' Calcolo larghezza ed altezza di 4 points:
    Po4_X = objFoglio.ScaleX(4, vbPoints, vbUser)   ' Uso i [Points] perche' voglio dimensioni
    Po4_Y = objFoglio.ScaleY(4, vbPoints, vbUser)   ' proporzionali a quelle dei caratteri.
'
    ' Estremita' degli assi X e Y:
    EstAx = (Xn + QxMax) / 2!
    EstAy = (Yn + QyMax) / 2!
'
    objFoglio.FontSize = 8
    objFoglio.DrawWidth = 1
    objFoglio.DrawMode = vbCopyPen
    objFoglio.ForeColor = ColRif
'
    ' Traccio la griglia verticale:
    objFoglio.DrawStyle = vbDash
    For XI = X0 To Xn + 0.1 * rrx Step rrx
        objFoglio.Line (XI, Y0)-(XI, Yn), ColRif
    Next XI
'
    ' Scrivo i valori dell' asse X:
    UnitaX_y = Y0 + Po4_Y / 2!
    objFoglio.CurrentY = UnitaX_y
    If (FormatVX$ <> " ") Then
        ' Scrivo il valor minimo:
        If bMaPrX Then
            FormatPrf X0, Mantissa$, Prefisso$, FormatVX$
            Txt$ = " " & Mantissa$ & " " & Prefisso$ & " "
        Else
            Txt$ = " " & Format$(X0, FormatVX$) & " "
        End If
        TW = objFoglio.TextWidth(Txt$)
        TxtDx = X0 + TW / 2!
        objFoglio.CurrentX = X0 - TW / 2!
        objFoglio.Print Txt$;
'
        ' Scrivo il valor massimo:
        If bMaPrX Then
            FormatPrf Xn, Mantissa$, Prefisso$, FormatVX$
            Txt$ = " " & Mantissa$ & " " & Prefisso$ & " "
        Else
            Txt$ = " " & Format$(Xn, FormatVX$) & " "
        End If
        TW = objFoglio.TextWidth(Txt$)
        TxtSx = Xn - TW / 2!
        objFoglio.CurrentX = TxtSx
        objFoglio.Print Txt$;
        TxtDxU = objFoglio.CurrentX
'
        For XI = X0 + rrx To Xn - rrx + 0.1 * rrx Step rrx
            If bMaPrX Then
                FormatPrf XI, Mantissa$, Prefisso$, FormatVX$
                Txt$ = " " & Mantissa$ & " " & Prefisso$ & " "
            Else
                Txt$ = " " & Format$(XI, FormatVX$) & " "
            End If
            ' Verifico che il formato scelto non
            ' induca ad errori di rappresentazione
            ' e che le etichette non si sovrappongano:
            TW = objFoglio.TextWidth(Txt$) / 2!
            If (Abs(XI - CDbl(Format$(XI, FormatVX$))) < (rrx / 10#)) _
            And (TxtDx < (XI - TW)) And ((XI + TW) < TxtSx) Then
                TxtDx = XI + TW
                objFoglio.CurrentX = XI - TW
                objFoglio.Print Txt$;
            End If
        Next XI
    End If
'
    ' Traccio l' asse Y:
    If (X0 <= 0#) And (0# <= Xn) Then
        objFoglio.DrawStyle = vbSolid
        objFoglio.Line (0!, Y0)-(0!, EstAy), ColRif
        objFoglio.Line (0!, EstAy)-(-Po4_X / 2!, Po4_Y + EstAy), ColRif
        objFoglio.Line (0!, EstAy)-(Po4_X / 2!, Po4_Y + EstAy), ColRif
    End If
'
    ' Traccio la griglia orizzontale:
    objFoglio.DrawStyle = vbDash
    For YI = Y0 To Yn + 0.1 * rry Step rry
        objFoglio.Line (X0, YI)-(Xn, YI), ColRif
    Next YI
'
    ' Scrivo i valori dell' asse Y:
    If (FormatVY$ <> " ") Then
        For YI = Y0 To Yn + 0.1 * rry Step rry
            objFoglio.Line (X0, YI)-(Xn, YI), ColRif
            If bMaPrY Then
                FormatPrf YI, Mantissa$, Prefisso$, FormatVY$, nEsp
                If (nEspMinY < nEsp) Then
                    Txt$ = " " & Mantissa$ & " " & Prefisso$ & " "
                Else
                    FormatPrf 0, Mantissa$, Prefisso$, FormatVY$, nEsp
                    Txt$ = " " & Mantissa$
                End If
            Else
                Txt$ = " " & Format$(YI, FormatVY$) & " "
            End If
            ' Verifico che il formato scelto non
            ' induca ad errori di rappresentazione:
            If (Abs(YI - CDbl(Format$(YI, FormatVY$))) < (rry / 10#)) Then
                objFoglio.CurrentX = QxMin
                objFoglio.CurrentY = YI - objFoglio.TextHeight(Txt$) / 2!
                objFoglio.Print Txt$;
            End If
        Next YI
    End If
'
    ' Traccio l' asse X:
    If (Y0 <= 0#) And (0# <= Yn) Then
        objFoglio.DrawStyle = vbSolid
        objFoglio.Line (X0, 0!)-(EstAx, 0!), ColRif
        objFoglio.Line (EstAx, 0!)-(EstAx - Po4_X, -Po4_Y / 2!), ColRif
        objFoglio.Line (EstAx, 0!)-(EstAx - Po4_X, Po4_Y / 2!), ColRif
    End If
'
'-- Scrivo il titolo del grafico: ------------------------------------------------------
'
    Dim TitL!, TitT!, TitW!, TitH!, TitoloR$
'
    If (0 < Len(Titolo$)) Then
        objFoglio.FontSize = 12
        objFoglio.FontBold = True
        objFoglio.ForeColor = ColTit
'
        TitoloR$ = Titolo$
        TitW = objFoglio.TextWidth(TitoloR$)
        TitH = objFoglio.TextHeight(TitoloR$)
'
        ' Verifico che il titolo stia tutto
        ' nella larghezza del grafico ...:
        If (TitW <= (Xn - X0)) Then
            TitL = (Xn + X0 - TitW) / 2!
'
        Else
            ' ... e se no lo taglio:
            TitL = X0
            Txt$ = " . . ."
            TitoloR$ = Left$(Titolo$, Int(Len(TitoloR$) _
                          * (Xn - X0 - objFoglio.TextWidth(Txt$)) / TitW))
            If (TitoloR$ <> Titolo$) Then TitoloR$ = TitoloR$ & Txt$
        End If
'
        TitT = QyMax
        ' Cancello l' area su cui andra' scritto il titolo:
        'objFoglio.Line (TitL, TitT)-(TitL + TitW, TitT + TitH), objFoglio.BackColor, BF
        objFoglio.CurrentX = TitL
        objFoglio.CurrentY = TitT
        objFoglio.Print TitoloR$;
    End If
'
'-- Scrivo le unita' degli assi: -------------------------------------------------------
'
    objFoglio.FontSize = 8
    objFoglio.FontBold = False
    objFoglio.ForeColor = ColRif
'
    ' Scrivo l' etichetta dell' asse X:
    ' Etichetta tutta a destra:
    'UnitaX_x = QxMax - objFoglio.TextWidth(UnitaX$ & " ")
    ' Etichetta in centro tra l' ultimo valore ed il bordo a destra:
    UnitaX_x = (TxtDxU + QxMax - objFoglio.TextWidth(UnitaX$)) / 2!
'
    objFoglio.CurrentX = UnitaX_x
    objFoglio.CurrentY = UnitaX_y
    objFoglio.Print UnitaX$;
'
    ' Scrivo l' etichetta dell' asse Y:
    UnitaY_x = QxMin + objFoglio.TextWidth("O")
    UnitaY_y = QyMax + objFoglio.TextHeight("O") / 3
'
    objFoglio.CurrentX = UnitaY_x
    objFoglio.CurrentY = UnitaY_y
    objFoglio.Print UnitaY$;
'
Fine:
    objFoglio.DrawStyle = vbSolid
    objFoglio.AutoRedraw = bAutoRed
'
'
Quadro_ERR:
    Quadro = (Err.Number = 0)
    If (Err.Number <> 0) Then
        Dim M$
        M$ = "Errore " & Str$(Err.Number) & vbNewLine
        M$ = M$ & Err.Description
        MsgBox M$, vbCritical, " modUtilita: Quadro"
    End If
'
'
'
End Function
Public Function ValC2D(ByVal sNum$) As String
'
'   Sostituisce, nella stringa numerica sNum$,
'   la "," con il ".".  Rende cosi' possibile
'   usare la funzione Val su testi che usino la
'   "," come separatore decimale.
'
    ValC2D = Replace(sNum$, ",", ".")
'
'
'
End Function
Public Function Acos(ByVal X As Double) As Double
'
'   Calcola l' ArcoCoseno di x con -1 <= x <= 1.
'   Acos e' in radianti.
'
    If (0# < X) And (X <= 1#) Then
        Acos = Atn(Sqr(1# - X * X) / X)
    ElseIf (-1# <= X) And (X < 0#) Then
        Acos = PI + Atn(Sqr(1# - X * X) / X)
    ElseIf (X = 0#) Then
        Acos = PI_2
    Else
        Err.Raise 5, "Acos Function", "Argomento illegale per Acos"
    End If
'
'
'
End Function
Public Function Asin(ByVal X As Double) As Double
'
'   Calcola l' ArcoSeno di x con -1 <= x <= 1.
'   Asin e' in radianti.
'
    If (Abs(X) < 1#) Then
        Asin = Atn(X / Sqr(1# - X * X))
    ElseIf (X = 1#) Then
        Asin = PI_2
    ElseIf (X = -1#) Then
        Asin = -PI_2
    Else
        Err.Raise 5, "Asin Function", "Argomento illegale per Asin"
    End If
'
'
'
End Function
Public Sub AggiornaFinestrelle(ParamArray Finestrelle() As Variant)
'
'   Aggiorna i valori delle finestrelle di informazione
'   assegnando alle Labels i corrispondenti valori.
'   Il vettore Finestrelle() deve essere organizzato come:
'    Label1, Val1, ..., LabelN, ValN
'
    Dim J&, J1&, J2&
'
    J1 = LBound(Finestrelle)
    J2 = UBound(Finestrelle) - 1
'
    For J = J1 To J2 Step 2
        Finestrelle(J).Caption = Finestrelle(J + 1)
        Finestrelle(J).BackColor = IIf(Len(Finestrelle(J + 1)) = 0, vbButtonFace, ColEvi)
        Finestrelle(J).Refresh
    Next J
'
'
'
End Sub
Public Sub AggiornaFilesRecenti(ByVal mnuRecenti As Object, ByVal FileRec$, _
    Optional ByVal MAXFIL As Long = 5)
'
'   Aggiunge al menu mnuRecenti() il file FileRec$.
'   mnuRecenti e' una voce di menu, con indice:
'   mnuRecenti(0) e' il titolo, i files da memorizzare
'   iniziano dalla posizione mnuRecenti(1).
'   Se FileRec$ e' gia' presente lo sposta al primo posto.
'   MAXFIL e' il numero massimo di files recenti da ricordare:
'   puo' essere diverso a seconda dell' applicazione che usa
'   questa routine (0 < MAXFIL < 10).
'
    Dim I&, J&, FILN&
    Dim a$, bNuovoFile As Boolean
'
    If (FileRec$ = "") Then Exit Sub
'
    FILN = mnuRecenti.UBound
'
    bNuovoFile = True
    For J = 1 To FILN
        a$ = mnuRecenti(J).Caption
        If (UCase$(Right$(a$, Len(a$) - 3)) = UCase$(FileRec$)) Then
            bNuovoFile = False
            Exit For
        End If
    Next J
    If (FILN < J) Then J = FILN
'
    If (FILN < MAXFIL) And bNuovoFile Then
        FILN = FILN + 1
        J = FILN
        Load mnuRecenti(FILN)
        mnuRecenti(FILN).Visible = True
    End If
'
    mnuRecenti(0).Visible = (0 < FILN)
'
    For I = J To 2 Step -1
        a$ = mnuRecenti(I - 1).Caption
        a$ = "&" & Trim$(Str$(I)) & " " & Right$(a$, Len(a$) - 3)
        mnuRecenti(I).Caption = a$
    Next I
'
    mnuRecenti(1).Caption = "&1 " & FileRec$
'
'
'
End Sub
Public Function RandN(ByVal VMedio As Single, ByVal Sigma As Single) As Single
'
'   Ritorna una variabile casuale reale a distribuzione normale.
'   VMedio - 6 * Sigma <= RandN < VMedio + 6 * Sigma:
'
    Dim e!, I&
'
    e = 0!
    For I = 1 To 12
        e = e + Rnd
    Next I
'
    RandN = VMedio + Sigma * (e - 6!)
'
'
'
End Function
Public Sub SalvaFilesRecentiINI(ByVal FileINI$, ByVal Sezione$, _
    ByVal mnuRecenti As Object)
'
'   Salva i files recenti, contenuti nel menu mnuRecenti(), sul file FileINI$:
'
    Dim I&, FileRec$
'
    For I = 1 To mnuRecenti.UBound
        FileRec$ = mnuRecenti(I).Caption
        FileRec$ = Right$(FileRec$, Len(FileRec$) - 3)
        SaveIniString FileINI$, Sezione$, Str$(I), FileRec$
    Next I
'
'
'
End Sub
Public Sub SalvaPosizioneFormINI(ByVal FileINI$, ByVal frmF As Form, _
    Optional ByVal bDimensioni As Boolean = False)
'
'   Salva, sul file FileINI$, la posizione finale del Form frmF.
'   Se bDimensioni = True salva anche le dimensioni.
'
'   Da usare nell' evento frmF_Unload:
'
    If (frmF.WindowState <> vbMinimized) Then
        SaveIniString FileINI$, "Posizione Forms:", frmF.Name & "_Left", frmF.Left
        SaveIniString FileINI$, "Posizione Forms:", frmF.Name & "_Top", frmF.Top
'
        If bDimensioni Then
            SaveIniString FileINI$, "Posizione Forms:", frmF.Name & "_Width", frmF.Width
            SaveIniString FileINI$, "Posizione Forms:", frmF.Name & "_Height", frmF.Height
        End If
    End If
'
'
'
End Sub
Public Function DMAXVAL(dVet() As Double) As Double
'
'   Ritorna il valore massimo contenuto nel vettore dVet().
'   Implementa l' equivalente funzione del FORTRAN.
'
    Dim J&, J1&, J2&, dDMax#
'
    J1 = LBound(dVet)
    J2 = UBound(dVet)
'
    dDMax = dVet(J1)
    For J = J1 + 1 To J2
        If (dDMax < dVet(J)) Then dDMax = dVet(J)
    Next J
'
    DMAXVAL = dDMax
'
'
'
End Function
Public Function MaxFun(dVet() As Double, ByVal J1 As Long, ByVal J2 As Long, _
    ByRef dMaxFun As Double, Optional ByRef IMax As Long) As Boolean
'
'   Trova il massimo dMaxFun della funzione rappresentata dai punti contenuti
'   nel vettore dVet() compresi fra J1 e J2, estremi esclusi; ritorna anche
'   IMax, indice del punto corrispondente al massimo.
'
'   MaxFun ritorna False se nessun massimo e' stato trovato, i.e. se la
'   funzione descritta in dVet() e' una costante o e' monotona crescente
'   o decrescente.
'
'   Deve essere LBound(dVet) <= J1 < J2 <= UBound(dVet) con (J2 - J1) >= 2:
'
'
    Dim J&, K&, bSale As Boolean
'
    dMaxFun = MinDouble
'
    For J = J1 + 1 To J2 - 1
        If (dVet(J - 1) < dVet(J)) Then
            ' La funzione sta' salendo:
            bSale = True
            K = J
        End If
'
        If bSale Then
            If (dVet(J + 1) < dVet(J)) Then
                ' La funzione, raggiunto un massimo
                ' [locale], inizia a scendere:
                bSale = False
'
                If (dMaxFun < dVet(J)) Then
                    ' Questo massimo e' maggiore
                    ' del precedente e lo salvo:
                    dMaxFun = dVet(J)
                    IMax = (K + J) / 2
                End If
            End If
        End If
    Next J
'
    ' Verifico l' esistenza del massimo:
    MaxFun = (MinDouble < dMaxFun)
'
'
'
End Function
Public Function MinFun(dVet() As Double, ByVal J1 As Long, ByVal J2 As Long, _
    ByRef dMinFun As Double, Optional ByRef IMin As Long) As Boolean
'
'   Trova il minimo dMinFun della funzione rappresentata dai punti contenuti
'   nel vettore dVet() compresi fra J1 e J2, estremi esclusi; ritorna anche
'   IMin, indice del punto corrispondente al minimo.
'
'   MinFun ritorna False se nessun minimo e' stato trovato, i.e. se la
'   funzione descritta in dVet() e' una costante o e' monotona crescente
'   o decrescente.
'
'   Deve essere LBound(dVet) <= J1 < J2 <= UBound(dVet) con (J2 - J1) >= 2:
'
'
    Dim J&, K&, bScende As Boolean
'
    dMinFun = MaxDouble
'
    For J = J1 + 1 To J2 - 1
        If (dVet(J) < dVet(J - 1)) Then
            ' La funzione sta' scendendo:
            bScende = True
            K = J
        End If
'
        If bScende Then
            If (dVet(J) < dVet(J + 1)) Then
                ' La funzione, raggiunto un minimo
                ' [locale], inizia a salire:
                bScende = False
'
                If (dVet(J) < dMinFun) Then
                    ' Questo minimo e' minore
                    ' del precedente e lo salvo:
                    dMinFun = dVet(J)
                    IMin = (K + J) / 2
                End If
            End If
        End If
    Next J
'
    ' Verifico l' esistenza del minimo:
    MinFun = (dMinFun < MaxDouble)
'
'
'
End Function
Public Function DMINVAL(dVet() As Double) As Double
'
'   Ritorna il valore minimo contenuto nel vettore dVet().
'   Implementa l' equivalente funzione del FORTRAN.
'
    Dim J&, J1&, J2&, dDMin#
'
    J1 = LBound(dVet)
    J2 = UBound(dVet)
'
    dDMin = dVet(J1)
    For J = J1 + 1 To J2
        If (dVet(J) < dDMin) Then dDMin = dVet(J)
    Next J
'
    DMINVAL = dDMin
'
'
'
End Function
Public Function FloorRound(ByVal X As Double, ByVal NCifre As Long) As Double
'
'   Funzione di arrotondamento, per numeri reali positivi,
'   al valore inferiore a NCifre significative:
'
    Dim ValE$
'
    ValE$ = Format$(X, String(NCifre, "0") & ".###############E+000")
    FloorRound = CDbl(Left$(ValE$, NCifre) & Right$(ValE$, 5))
'
'
'
End Function
Public Function DMIN1(ParamArray vD() As Variant) As Double
'
'   Implementa la funzione DMIN1(D1, D2, ...DN) del FORTRAN:
'
    Dim J&, J1&, J2&, vDMin As Variant
'
    J1 = LBound(vD)
    J2 = UBound(vD)
'
    vDMin = vD(J1)
    For J = J1 + 1 To J2
        If (vD(J) < vDMin) Then vDMin = vD(J)
    Next J
'
    DMIN1 = CDbl(vDMin)
'
'
'
End Function
Public Function LinToLog(ByVal X As Double, Optional ByVal BASE As Double = 10#) As Double
'
'   Trasforma una posizione da Lineare a Logaritmica.
'
    If (0# < X) Then
        LinToLog = Log(X) / Log(BASE)
    Else
        LinToLog = -9999#
    End If
'
'
'
End Function
Public Function dBToLin(ByVal X As Double, Optional ByVal BASE As Double = 20) As Double
'
'   Trasforma i [dB] in valore lineare.
'   dBToLin(0 dB) = 1,  dBToLin(-20 dB) = 0.1
'
    On Error GoTo dBToLin_ERR   ' Gestisce l' eventuale errore di "overflow".
'
    dBToLin = 10# ^ (X / BASE)
'
'
dBToLin_ERR:
'
'
'
End Function
Public Function LinTodB(ByVal X As Double, Optional ByVal BASE As Double = 20) As Double
'
'   Calcola i [dB] corrispondenti al valore lineare X.
'   LinTodB(1) = 0 dB;  LinTodB(0.1) = -20 dB.
'
    If (0# < X) Then
        LinTodB = BASE * Log(X) / Log10
    Else
        LinTodB = -9999#
    End If
'
'
'
End Function
Public Function LogToLin(ByVal X As Double, Optional ByVal BASE As Double = 10#) As Double
'
'   Trasforma una posizione da Logaritmica a Lineare.
'
    On Error GoTo LogToLin_ERR  ' Gestisce l' eventuale errore di "overflow".
'
    LogToLin = BASE ^ X
'
'
LogToLin_ERR:
'
'
'
End Function
Public Function KAscNumReali(ByVal KA As Integer, _
    Optional ByVal bNeg As Boolean = False) As Integer
'
'   Ritorna solo i caratteri validi per un campo
'   contenente un numero reale (anche negativo se
'   viene passato il valore bNeg = True).
'   Tutti gli altri caratteri vengono annullati.
'   Usa le impostazioni locali del separatore decimale.
'   Va' usato nella procedura KeyPress di TextB come:
'   KeyAscii = KAscNumReali(KeyAscii [, bNeg])
'   Questa versione accetta anche numeri in notazione
'   scientifica.
'
    Dim KeyDecimal%, KeyMinus%, KeyE%
    Dim TextB As TextBox    ' Solo per TextBoxes.
    'Dim TextB As Control    ' Anche per Combo, etc...
    Dim SD$, SM$, myKeyDecimal%
'
    Const myKeyMinus% = 45      ' E' il valore effettivamente ritornato
                                ' alla pressione del -;
                                ' vbKeySubtract (= 109)  non funziona.
    GetLocale SD$, SM$          ' Trova le impostazioni locali dei
    myKeyDecimal% = Asc(SD$)    ' separatori decimale e delle migliaia.
'
    Set TextB = Screen.ActiveControl
'
    ' Filtro per il separatore decimale:
    If (InStr(TextB.Text, SD$) = 0 _
    And Not (TextB.SelStart = 0 And Left$(TextB.Text, 1) = "-")) _
    Or TextB.SelText = TextB.Text Then KeyDecimal = myKeyDecimal
'
    ' Filtro per il segno "-":
    If (Left$(TextB.Text, 1) <> "-" Or TextB.SelText = TextB.Text) _
    And bNeg And TextB.SelStart = 0 Then KeyMinus = myKeyMinus
'
    ' Filtro per la notazione scientifica:
    If (0 < TextB.SelStart) Then
        KA = Asc(UCase$(Chr$(KA)))
        If (InStr(TextB.Text, "E") = 0 _
        And Not (TextB.SelStart = 0 Or TextB.SelText = TextB.Text)) _
        And Mid$(TextB.Text, TextB.SelStart, 1) <> "-" Then KeyE = vbKeyE
'
        If Mid$(TextB.Text, TextB.SelStart, 1) = "E" Then KeyMinus = myKeyMinus
'
        If (0 < InStr(TextB.Text, "E")) _
        And (0 <= TextB.SelStart - InStr(TextB.Text, "E")) Then KeyDecimal = 0
    End If
'
    Select Case KA
    Case vbKey0 To vbKey9, KeyDecimal, KeyMinus, vbKeyBack, KeyE
        KAscNumReali = KA
'
    Case Else
        KAscNumReali = 0
    End Select
'
'
'
End Function
Private Sub GetLocale(ByRef DS$, Optional ByRef MS$)
'
'   Trova i separatori decimale e
'   delle migliaia del sistema:
'
    DS$ = "  "
    MS$ = "  "
'
    GetLocaleInfo GetThreadLocale(), LOCALE_SDECIMAL, DS$, Len(DS$)
    GetLocaleInfo GetThreadLocale(), LOCALE_STHOUSAND, MS$, Len(MS$)
'
    DS$ = Left$(DS$, 1)
    MS$ = Left$(MS$, 1)
'
'
'
End Sub
Public Function Ceil(ByVal X As Double) As Double
'
'   Funzione di arrotondamento, per numeri reali,
'   all' intero uguale o immediatamente superiore:
'
    If (X = Int(X)) Then
        Ceil = X
    ElseIf (0# < X) Then
        Ceil = Int(X) + 1#
    ElseIf (X < 0#) Then
        Ceil = Fix(X)
    End If
'
'
'
End Function
Public Function ContainerEnabled(ByVal ctrContainer As Control, _
    ByVal bEnabled As Boolean) As Boolean
'
'   Abilita o disabilita ctrContainer e
'   tutti i controlli al suo interno.
'   La routine e' ricorsiva.
'
    Dim Control As Control
'
    'Exit Function           ' Da usare in IDE, quando non si vogliono interruzioni
                            ' con il "Break on All Errors".
'
    On Error Resume Next    ' Gestisce i controlli senza proprieta' .Enabled
                            ' e quelli senza proprieta' .Container.
'
    ctrContainer.Enabled = bEnabled
'
    For Each Control In ctrContainer.Parent.Controls
        If (Control.Container Is ctrContainer) Then
            If (TypeOf Control Is Frame) _
            Or (TypeOf Control Is PictureBox) Then
                ContainerEnabled Control, bEnabled  ' Ricorsione.
'
            Else
                If (Err.Number = 0) Then Control.Enabled = bEnabled
                Err.Clear
            End If
        End If
    Next Control
'
    ContainerEnabled = (Err.Number = 0)
'
'
'
End Function
Public Function BreakDown(ByVal Full$, Optional ByRef Pname$, _
    Optional ByRef FName$, Optional ByRef Ext$) As Boolean
'
'   Scompone un nome di File completo di Path nelle sue parti:
'   Full$  = Nome completo del File.
'   PName$ = Path del File (con \ finale).
'   FName$ = Nome del File con Estensione.
'   Ext$   = .Estensione del File.
'
'   Se il File non esiste scompone il nome e ritorna False.
'
'   ATTENZIONE: routine modificata rispetto alla versione standard.
'
'   Rev. 13/02/2010
'
    Dim Sloc&, Dot&
'
    BreakDown = FileExists(Full$)
'
    If InStr(Full$, "\") Then
        FName$ = Full$
        Pname$ = ""
        Sloc = InStr(FName$, "\")
        Do While (Sloc <> 0)
            Pname$ = Pname$ & Left$(FName$, Sloc)
            FName$ = Mid$(FName$, Sloc + 1)
            Sloc = InStr(FName$, "\")
        Loop
'
    Else
        Pname$ = ""
        FName$ = Full$
    End If
'
    For Dot = Len(Full$) To Len(Full$) - Len(FName$) + 1 Step -1
        If (Mid$(Full$, Dot, 1) = ".") Then
            Ext$ = Mid$(Full$, Dot)
            Exit Function
        End If
    Next Dot
    Ext$ = ""
'
'
'
End Function
Public Function DATAN2(ByVal Y As Double, ByVal X As Double) As Double
'
'   Ritorna il valore dell' ArcoTangente di y/x
'   come implementata dal FORTRAN.
'   E':    -PI < DATAN2 <= PI.
'
    Select Case X
    Case Is > 0#
        DATAN2 = Atn(Y / X)
'
    Case Is < 0#
        If (0# <= Y) Then
            DATAN2 = Atn(Y / X) + PI
        ElseIf (Y < 0#) Then
            DATAN2 = Atn(Y / X) - PI
        End If
'
    Case Is = 0#
        DATAN2 = Sgn(Y) * PI_2
    End Select
'
'
'
End Function
Public Function Atan2(ByVal Y As Double, ByVal X As Double) As Double
'
'   Ritorna il Valore dell' ArcoTangente di y/x su 4 Quadranti.
'   E':    0 <= Atan2 < 2 * PI.
'
    Select Case X
    Case Is > 0#
        Atan2 = IIf(Y >= 0#, Atn(Y / X), Atn(Y / X) + PI2)
'
    Case Is < 0#
        Atan2 = Atn(Y / X) + PI
'
    Case Is = 0#
        Atan2 = PI * Sgn(Y) / 2#
    End Select
'
'
'
End Function
Public Sub ScrivoCome(ByVal ctrFoglio As Control, ByVal Font$, ByVal Size As Long, _
    Optional ByVal bBold As Boolean = False, Optional ByVal Colore& = vbBlack)
'
'   Imposta le proprieta' di scrittura
'   sul controllo ctrFoglio:
'
    On Error GoTo ScrivoCome_ERR
'
    ctrFoglio.FontName = Font$
    ctrFoglio.FontSize = Size
    ctrFoglio.FontBold = bBold
    ctrFoglio.ForeColor = Colore
'
'
ScrivoCome_ERR:
    If (Err.Number <> 0) Then
        Dim M$
        M$ = "Il controllo " & ctrFoglio.Name & vbNewLine
        M$ = M$ & "non espone le proprieta' richieste." & vbNewLine & vbNewLine
        M$ = M$ & "Errore " & Str$(Err.Number) & vbNewLine
        M$ = M$ & Err.Description
        MsgBox M$, vbCritical, " modUtilita: ScrivoCome"
    End If
'
'
'
End Sub
Public Function TempFile$(Optional ByVal I3C$ = "TMP", _
    Optional ByRef TempPath As String)
'
'   Ritorna il nome di un File temporaneo [da cancellare
'   esplicitamente dopo l' uso].
'   Con I3C$ si possono specificare fino a tre caratteri
'   iniziali per l' identificazione del file:
'
    Dim lRet&, lpBuffer$
    Dim TempFileName As String
'
    lRet = GetTempPath(0, "")
    lpBuffer$ = Space(lRet)
    lRet = GetTempPath(lRet, lpBuffer$)
    TempPath = Left$(lpBuffer$, lRet)
'
    TempFileName = Space(MAX_PATH)
    lRet = GetTempFileName(TempPath, I3C$, 0, TempFileName)
'
    TempFile$ = Trim$(TempFileName)
'
'
'
End Function
Public Function MAX0(ParamArray vD() As Variant) As Long
'
'   Implementa la funzione MAX0(K1, K2, ...KN) del FORTRAN:
'
    Dim J&, J1&, J2&, vDMax As Variant
'
    J1 = LBound(vD)
    J2 = UBound(vD)
'
    vDMax = vD(J1)
    For J = J1 + 1 To J2
        If (vDMax < vD(J)) Then vDMax = vD(J)
    Next J
'
    MAX0 = CLng(vDMax)
'
'
'
End Function
Public Function DMAX1(ParamArray vD() As Variant) As Double
'
'   Implementa la funzione DMAX1(D1, D2, ...DN) del FORTRAN:
'
    Dim J&, J1&, J2&, vDMax As Variant
'
    J1 = LBound(vD)
    J2 = UBound(vD)
'
    vDMax = vD(J1)
    For J = J1 + 1 To J2
        If (vDMax < vD(J)) Then vDMax = vD(J)
    Next J
'
    DMAX1 = CDbl(vDMax)
'
'
'
End Function
Public Function MIN0(ParamArray vD() As Variant) As Long
'
'   Implementa la funzione MIN0(K1, K2, ...KN) del FORTRAN:
'
    Dim J&, J1&, J2&, vDMin As Variant
'
    J1 = LBound(vD)
    J2 = UBound(vD)
'
    vDMin = vD(J1)
    For J = J1 + 1 To J2
        If (vD(J) < vDMin) Then vDMin = vD(J)
    Next J
'
    MIN0 = CLng(vDMin)
'
'
'
End Function
Public Function KAscNumInteri(ByVal KA As Integer, _
    Optional ByVal bNeg As Boolean = False) As Integer
'
'   Ritorna solo i caratteri validi per un campo
'   contenente un numero intero (anche negativo se
'   viene passato il valore bNeg = True).
'   Tutti gli altri caratteri vengono annullati.
'   Va' usato nella procedura KeyPress di TextB come:
'   KeyAscii = KAscNumInteri(KeyAscii [, bNeg])
'
    Dim KeyMinus%
    Dim TextB As TextBox    ' Solo per TextBoxes.
    'Dim TextB As Control    ' Anche per Combo, etc...
'
    Const myKeyMinus% = 45  ' E' il valore effettivamente ritornato
                            ' alla pressione del tasto - ;
                            ' vbKeySubtract (= 109) non funziona.
'
    Set TextB = Screen.ActiveControl
'
    ' Filtro per il segno "-":
    If (Left$(TextB.Text, 1) <> "-" Or TextB.SelText = TextB.Text) _
    And bNeg And TextB.SelStart = 0 Then KeyMinus = myKeyMinus
'
    Select Case KA
    Case vbKey0 To vbKey9, KeyMinus, vbKeyBack
        KAscNumInteri = KA
'
    Case Else
        KAscNumInteri = 0
    End Select
'
'
'
End Function
Public Sub CloseButtonDisable(ByVal frmForm As Form)
'
'
    Dim lRet&
'
    lRet = RemoveMenu(GetSystemMenu(frmForm.hWnd, 0), SC_CLOSE, MF_REMOVE)
'
'
'
End Sub
Public Function FileExists(ByVal FileN$) As Boolean
'
'   Verifica l' esistenza del file FileN$:
'
    Dim res&
'
    On Error Resume Next
'
    res = FileLen(FileN$)
    FileExists = (Err.Number = 0)
    Err.Clear
'
'
'
End Function
Public Function RandU(ByVal V_Min As Single, ByVal V_Max As Single) As Single
'
'   Ritorna una variabile casuale reale a distribuzione uniforme.
'   V_Min <= RandU < V_Max:
'
    RandU = V_Min + (V_Max - V_Min) * Rnd
'
'
'
End Function
Public Function ScreenSaver(ByVal bAbilita As Boolean) As Boolean
'
'   Abilita o disabilita lo ScreenSaver.  La funzione
'   ritorna lo stato dello ScreenSaver prima dell' azione
'   richiesta per poterlo poi, eventualmente, ripristinare.
'
'   Da: MSDN Tip 43: Activating and Deactivating the Screen Saver.
'   e:  How to Disable the Screen Saver Programmatically. Article ID: Q126627
'
    Dim Stato&
'
    ' Legge lo stato corrente dello ScreenSaver:
    SystemParametersInfo SPI_GETSCREENSAVEACTIVE, 0, Stato, 0
    ScreenSaver = CBool(Stato)
'
    ' Imposta lo stato voluto:
    Stato = CLng(bAbilita)
    SystemParametersInfo SPI_SETSCREENSAVEACTIVE, Stato, 0, 0
'
'
'
End Function
Public Function SaveIniString(ByVal FileINI$, ByVal Section$, ByVal Key$, _
    ByVal StringToAdd$) As Boolean
'
'
    Dim lRet&
'
    On Error GoTo SaveIniString_ERR
'
    lRet = WritePrivateProfileString(Section$, Key$, StringToAdd$, FileINI$)
    If (lRet = 0) Then Err.Raise 1001
'
'
SaveIniString_ERR:
    SaveIniString = (Err.Number = 0)
    If (Err.Number <> 0) Then
        Dim M$
        M$ = "Il programma ha trovato una condizione inattesa." & vbNewLine & vbNewLine
        M$ = M$ & "Errore " & Str$(Err.Number) & vbNewLine
        M$ = M$ & Err.Description
        MsgBox M$, vbCritical, " modUtilita: SaveIniString"
    End If
'
'
'
End Function
Public Function IsLoaded(ByVal frmForm As Form) As Boolean
'
'   Ritorna True se il Form frmForm e' gia' caricato in memoria:
'
    Dim I&
'
    For I = 0 To Forms.Count - 1
        If (Forms(I) Is frmForm) Then
            IsLoaded = True
            Exit Function
        End If
    Next I
'
    IsLoaded = False
'
'
'
End Function
Public Function Sequenza5_2_1(ByVal ValI As Double, _
    Optional ByVal bMantissaInSeq As Boolean = False, _
    Optional ByVal ValMin As Double = 0#) As Double
'
'   Ritorna il prossimo valore nella sequenza ... -> 10 -> 5 -> 2 -> 1 -> ...
'   Se bMantissaInSeq = True e ValI e' gia' uno dei numeri della sequenza
'   ritorna lo stesso ValI; se ValI <= ValMin ritorna ValMin:
'
    Dim ValE$, rrM#, rrE#, Seq5_2_1
'
    ValE$ = Format$(ValI, "0.000000E+000")
    rrM = CDbl(Left$(ValE$, 8))
    rrE = CDbl("1" & Right$(ValE$, 5))
'
    Seq5_2_1 = 0
'
    If bMantissaInSeq And ((rrM = 1) Or (rrM = 2) Or (rrM = 5)) Then
       Seq5_2_1 = ValI
'
    ElseIf (1 < rrM) And (rrM <= 2) Then
        Seq5_2_1 = 1 * rrE
    ElseIf (2 < rrM) And (rrM <= 5) Then
        Seq5_2_1 = 2 * rrE
    ElseIf (5 < rrM) And (rrM <= 10) Then
        Seq5_2_1 = 5 * rrE
    ElseIf (rrM = 1) Then
        Seq5_2_1 = 0.5 * rrE
    End If
'
    If (ValMin <= Seq5_2_1) Then
        Sequenza5_2_1 = Seq5_2_1
    Else
        Sequenza5_2_1 = ValMin
    End If
'
'
'
End Function
Public Function Sequenza1_2_5(ByVal ValI As Double, _
    Optional ByVal bMantissaInSeq As Boolean = False, _
    Optional ByVal ValMax As Double = 1E+300) As Double
'
'   Ritorna il prossimo valore nella sequenza ... -> 1 -> 2 -> 5 -> 10 -> ...
'   Se bMantissaInSeq = True e ValI e' gia' uno dei numeri della sequenza
'   ritorna lo stesso ValI; se ValI <= 0 ritorna 1.  Il valore massimo
'   della sequenza e' limitato al valore ValMax:
'
    Dim ValE$, rrM#, rrE#, Seq1_2_5#
'
    ValE$ = Format$(ValI, "0.000000E+000")
    rrM = CDbl(Left$(ValE$, 8))
    rrE = CDbl("1" & Right$(ValE$, 5))
'
    Seq1_2_5 = 1
'
    If bMantissaInSeq And ((rrM = 1) Or (rrM = 2) Or (rrM = 5)) Then
       Seq1_2_5 = ValI
'
    ElseIf (1 <= rrM) And (rrM < 2) Then
        Seq1_2_5 = 2 * rrE
    ElseIf (2 <= rrM) And (rrM < 5) Then
        Seq1_2_5 = 5 * rrE
    ElseIf (5 <= rrM) And (rrM < 10) Then
        Seq1_2_5 = 10 * rrE
    End If
'
    If (Seq1_2_5 <= ValMax) Then
        Sequenza1_2_5 = Seq1_2_5
    Else
        Sequenza1_2_5 = ValMax
    End If
'
'
'
End Function
Public Function Sequenza1_2_4(ByVal ValI As Double, _
    Optional ByVal bValoreInSeq As Boolean = False, _
    Optional ByVal ValMax As Double = 2 ^ 31) As Double
'
'   Ritorna il prossimo valore nella sequenza  2^-M -> ... -> 1 -> 2 -> 4 -> ... -> 2^N.
'   Se bValoreInSeq = True e ValI e' gia' uno dei numeri della sequenza
'   ritorna lo stesso ValI.  Il valore massimo della sequenza e' limitato
'   al valore ValMax:
'
    Dim Log2_ValI#, Seq1_2_4#
'
    Log2_ValI = (Log(ValI) / Log2)
    Log2_ValI = Int(Round(Log2_ValI, 12))
'
    If bValoreInSeq And (ValI = 2 ^ Log2_ValI) Then
       Seq1_2_4 = ValI
'
    Else
        Seq1_2_4 = 2 ^ (Log2_ValI + 1)
    End If
'
    If (Seq1_2_4 <= ValMax) Then
        Sequenza1_2_4 = Seq1_2_4
    Else
        Sequenza1_2_4 = ValMax
    End If
'
'
'
End Function
Public Function Sequenza4_2_1(ByVal ValI As Double, _
    Optional ByVal bValoreInSeq As Boolean = False, _
    Optional ByVal ValMin As Double = 1#) As Double
'
'   Ritorna il prossimo valore nella sequenza 2^N -> ... -> 4 -> 2 -> 1 ... ->  2^-M.
'   Se bValoreInSeq = True e ValI e' gia' uno dei numeri della sequenza
'   ritorna lo stesso ValI.  Il valore minimo della sequenza e' limitato
'   al valore ValMin:
'
    Dim Log2_ValI#, Seq4_2_1#
'
    Log2_ValI = Log(ValI) / Log2
'
    If bValoreInSeq And (ValI = 2 ^ Int(Log2_ValI)) Then
       Seq4_2_1 = ValI
'
    ElseIf (ValI = 2 ^ Int(Log2_ValI)) Then
        Seq4_2_1 = 2 ^ (Int(Log2_ValI) - 1)
'
    Else
        Seq4_2_1 = 2 ^ (Int(Log2_ValI))
    End If
'
    If (ValMin < Seq4_2_1) Then
        Sequenza4_2_1 = Seq4_2_1
    Else
        Sequenza4_2_1 = ValMin
    End If
'
'
'
End Function
Public Function SIGN(ByVal dV As Double, ByVal DS As Double) As Double
'
'   Ritorna il valore assoluto di dV con il segno di dS.
'   Implementa la funzione SIGN del FORTRAN:
'
    If (DS < 0#) Then
        SIGN = -Abs(dV)
    Else
        SIGN = Abs(dV)
    End If
'
'
'
End Function
Public Function SequenzaMeno10(ByVal ValI As Double, _
    Optional ByVal bValoreInSeq As Boolean = False, _
    Optional ByVal ValMin As Double = -1E+300) As Double
'
'   Ritorna il prossimo valore nella sequenza ... +20 -> +10 -> 0 -> -10 -> ...
'   Se ValoreInSeq = True e ValI e' gia' un multiplo intero di 10 ritorna
'   lo stesso ValI.  Il valore minimo della sequenza e' limitato al valore ValMin:
'
    Dim bMultiplo10 As Boolean, SeqMeno10#
'
    bMultiplo10 = ((ValI / 10#) = Int(ValI / 10#))
'
    If bValoreInSeq And bMultiplo10 Then
       SeqMeno10 = ValI
'
    ElseIf bMultiplo10 Then
        SeqMeno10 = ValI - 10#
    Else
        SeqMeno10 = Int(ValI / 10#) * 10#
    End If
'
    If (ValMin <= SeqMeno10) Then
        SequenzaMeno10 = SeqMeno10
    Else
        SequenzaMeno10 = ValMin
    End If
'
'
'
End Function
Public Function SequenzaPiu10(ByVal ValI As Double, _
    Optional ByVal bValoreInSeq As Boolean = False, _
    Optional ByVal ValMax As Double = 1E+300) As Double
'
'   Ritorna il prossimo valore nella sequenza ... -> -10 -> 0 -> +10 -> +20 -> ...
'   Se ValoreInSeq = True e ValI e' gia' un multiplo intero di 10 ritorna
'   lo stesso ValI.  Il valore massimo della sequenza e' limitato al valore ValMax:
'
    Dim bMultiplo10 As Boolean, SeqPiu10#
'
    bMultiplo10 = ((ValI / 10#) = Int(ValI / 10#))
'
    If bValoreInSeq And bMultiplo10 Then
       SeqPiu10 = ValI
'
    ElseIf bMultiplo10 Then
        SeqPiu10 = ValI + 10#
    Else
        SeqPiu10 = Ceil(ValI / 10#) * 10#
    End If
'
    If (SeqPiu10 <= ValMax) Then
        SequenzaPiu10 = SeqPiu10
    Else
        SequenzaPiu10 = ValMax
    End If
'
'
'
End Function
Public Function FormatE$(ByVal vNum As Variant, Optional ByVal strF$ = "0.000E+00")
'
'   Ritorna il valore vNum in formato scientifico ingegneristico
'   (i.e. con esponente multiplo di 3) e conservando il numero di
'   cifre della mantissa di strF$.
'   La stringa di formato strF$ deve definire un formato scientifico
'   ed essere costruita come "0.00[0[0[...]]]E+0[0[0]]" in cui:
'   - la mantissa deve avere solo uno 0 a sinistra del punto decimale
'     ed almeno due zeri (e solo zeri) a destra.
'   - l' esponente deve essere "E+0[0[0]]".
'
'   Rev. 17/06/2007.
'
    Dim Mant$, esp$, EPos&, NCifre&, MEsp&
'
    strF$ = UCase$(strF$)
    EPos = InStr(strF$, "E")
    NCifre = EPos - 1
'
    Mant$ = Left$(strF$, NCifre)
    esp$ = Mid$(strF$, EPos)
'
    MEsp = Val(Mid$(Format$(Abs(vNum), strF$), EPos + 1)) Mod 3 ' -2 <= MEsp <= +2.
'
    If (0 < MEsp) Then
        Mant$ = Left$(String$(MEsp, "0") & Mant$, NCifre)
    ElseIf (MEsp < 0) Then
        Mant$ = Left$(String$(3 + MEsp, "0") & Mant$, NCifre)
    End If
'
    FormatE$ = Format$(vNum, Mant$ & esp$)
'
'
'
End Function
Public Sub FormatPrf(ByVal vNum As Variant, _
    Optional ByRef Mantissa$, Optional ByRef Prefisso$, _
    Optional ByVal strF$ = "0.000E+00", Optional ByRef nEsp As Long)
'
'   Trasforma il valore vNum in formato SI con mantissa e prefisso,
'   i.e. micro (), milli (m), ..., kilo (k), etc... conservando il
'   numero di cifre della mantissa di strF$; ritorna anche il valore
'   nEsp che e' la potenza di 10 corrispondente al prefisso.
'   La stringa di formato strF$ deve definire un formato scientifico
'   ed essere costruita come "0.00[0[0[...]]]E+0[0[0]]" in cui:
'   - la mantissa deve avere solo uno 0 a sinistra del punto decimale
'     ed almeno due zeri (e solo zeri) a destra.
'   - l' esponente deve essere "E+0[0[0]]".
'
'   Nota: accertarsi che il Font usato per scrivere il Prefisso$
'         contenga il carattere "".
'
'   Rev. 17/06/2007.
'   Rev. 06/12/2008.
'
    Dim FTemp$, Mant$, esp$, EPos&, NCifre&, MEsp&
'
    strF$ = UCase$(strF$)
    EPos = InStr(strF$, "E")
    NCifre = EPos - 1
'
    Mant$ = Left$(strF$, NCifre)
    esp$ = Mid$(strF$, EPos)
'
    MEsp = Val(Mid$(Format$(Abs(vNum), strF$), EPos + 1)) Mod 3 ' -2 <= MEsp <= +2.
'
    If (0 < MEsp) Then
        Mant$ = Left$(String$(MEsp, "0") & Mant$, NCifre)
    ElseIf (MEsp < 0) Then
        Mant$ = Left$(String$(3 + MEsp, "0") & Mant$, NCifre)
    End If
'
    FTemp$ = Format$(vNum, Mant$ & esp$)
    EPos = InStr(FTemp$, "E")   ' Da ritrovare, perche' vNum potrebbe essere negativo.
'
    Mantissa$ = Left$(FTemp$, EPos - 1)
'
    nEsp = Val(Mid$(FTemp$, EPos + 1))
'
    Select Case nEsp
    Case -18
        Prefisso$ = "a" ' (atto).
    Case -15
        Prefisso$ = "f" ' (femto).
    Case -12
        Prefisso$ = "p" ' (pico).
    Case -9
        Prefisso$ = "n" ' (nano).
    Case -6
        Prefisso$ = "" ' (micro).
    Case -3
        Prefisso$ = "m" ' (milli).
    Case 0
        Prefisso$ = ""
    Case 3
        Prefisso$ = "k" ' (kilo).
    Case 6
        Prefisso$ = "M" ' (mega).
    Case 9
        Prefisso$ = "G" ' (giga).
    Case 12
        Prefisso$ = "T" ' (tera).
    Case 15
        Prefisso$ = "P" ' (peta).
    Case 18
        Prefisso$ = "E" ' (eka).
'
    Case Else
        Prefisso$ = "E" & nEsp  ' non lo so' :-)).
    End Select
'
'
'
End Sub
Public Function DAVG(ParamArray vD() As Variant) As Double
'
'   Ritorna la media dei valori (vD(1), vD(2), ...vD(N)):
'
    Dim J&, J1&, J2&, dSum As Double
'
    J1 = LBound(vD)
    J2 = UBound(vD)
'
    dSum = 0#
    For J = J1 To J2
        dSum = dSum + CDbl(vD(J))
    Next J
'
    DAVG = dSum / CDbl(J2 - J1 + 1)
'
'
'
End Function
Public Sub ScomponiRGB(ByVal ColRGB As Long, _
    ByRef Red As Long, ByRef Green As Long, ByRef Blue As Long)
'
'   Scompone il colore ColRGB nelle sue
'   componenti Rossa, Verde e Blu:
'
    Red = ColRGB And &HFF
    Green = (ColRGB \ &H100) And &HFF
    Blue = (ColRGB \ &H10000) And &HFF
'
'
'
End Sub

Public Function StepFormatPrf(XVal_I() As Double, Optional ByVal FormatX$ = "0.00E+00", _
    Optional ByVal LenMant As Long = 14) As String
'
'   Ritorna, per essere usata con FormatPrf, una stringa di formato atta
'   a rappresentare come distinti i valori contenuti nel vettore XVal_I().
'
'   XVal_I():   vettore dei valori non necessariamente in sequenza crescente;
'               NON viene modificato.
'   FormatX$:   formato minimo iniziale da provare (deve seguire le regole di FormatPrf).
'   LenMant:    massimo numero di cifre ammesso per la mantissa.
'
'   Vers. 19/02/2010.
'
    Dim I&, I1&, I2&, LenMaxFormatX&, XVal#(), Txt1$, Txt2$, Mantissa$, Prefisso$
'
    ' Limito il numero di cifre della mantissa al massimo permesso dal tipo Double:
    LenMant = MIN0(LenMant, 14)
    ' Calcolo la lunghezza massima ammessa per la stringa di formato:
    LenMaxFormatX = LenMant + Len(Mid$(FormatX$, InStr(UCase$(FormatX$), "E"))) + 1
'
    XVal() = XVal_I()
    I1 = LBound(XVal)
    I2 = UBound(XVal)
'
    QuickSort XVal(), I1, I2    ' Ordino i valori in sequenza crescente.
'
    FormatPrf XVal(I1), Mantissa$, Prefisso$, FormatX$
    Txt1$ = Mantissa$ & Prefisso$
'
    For I = I1 + 1 To I2
        FormatPrf XVal(I), Mantissa$, Prefisso$, FormatX$
        Txt2$ = Mantissa$ & Prefisso$
'
        If (XVal(I - 1) <> XVal(I)) Then
            ' I due valori successivi sono diversi ed ha, quindi,
            ' senso cercare una stringa di formato che li discrimini:
            Do While (Txt1$ = Txt2$) And (Len(FormatX$) < LenMaxFormatX)
                FormatX$ = Left$(FormatX$, 2) & "0" & Mid$(FormatX$, 3)
'
                FormatPrf XVal(I - 1), Mantissa$, Prefisso$, FormatX$
                Txt1$ = Mantissa$ & Prefisso$
                FormatPrf XVal(I), Mantissa$, Prefisso$, FormatX$
                Txt2$ = Mantissa$ & Prefisso$
            Loop
        End If
'
        Txt1$ = Txt2$
    Next I
'
    StepFormatPrf = FormatX$
'
'
'
End Function
